/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadSubcommandException;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$IUuidAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$NoSuchAliasException;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.process.client.ProcessClient;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.ServerVersionCheckException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.PermissionNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class StatusHelper {
    public static FileSystemClientException argSyntax(String string) {
        return StatusHelper.createException(string, 1, null);
    }

    public static FileSystemClientException login(ConnectionInfo connectionInfo, TeamRepositoryException teamRepositoryException) {
        ServerVersionCheckException serverVersionCheckException;
        String string;
        String string2 = string = teamRepositoryException == null ? "" : teamRepositoryException.getLocalizedMessage();
        if (teamRepositoryException instanceof ServerVersionCheckException && ((serverVersionCheckException = (ServerVersionCheckException)teamRepositoryException).getServerVersion().length() > 0 || serverVersionCheckException.getCause() instanceof AuthenticationException)) {
            string = serverVersionCheckException.getServerVersion().length() == 0 ? NLS.bind((String)Messages.StatusHelper_CLIENT_VERSION, (Object[])new String[]{teamRepositoryException.getLocalizedMessage(), serverVersionCheckException.getClientVersion(), serverVersionCheckException.getUri()}) : NLS.bind((String)Messages.StatusHelper_CLIENT_VERSION_SERVER_VERSION, (Object[])new String[]{teamRepositoryException.getLocalizedMessage(), serverVersionCheckException.getServerVersion(), serverVersionCheckException.getClientVersion(), serverVersionCheckException.getUri()});
        }
        String string3 = connectionInfo == null ? NLS.bind((String)Messages.StatusHelper_0, (Object)string) : (connectionInfo.getUsername() != null ? NLS.bind((String)Messages.StatusHelper_1, (Object[])new Object[]{connectionInfo.getURI(), connectionInfo.getUsername(), string}) : NLS.bind((String)Messages.StatusHelper_LoginError, (Object[])new Object[]{connectionInfo.getURI(), string}));
        return StatusHelper.login(string3, teamRepositoryException);
    }

    public static FileSystemClientException login(String string, TeamRepositoryException teamRepositoryException) {
        return StatusHelper.createException(string, 2, teamRepositoryException);
    }

    public static FileSystemClientException login() {
        return StatusHelper.login(null, null);
    }

    public static FileSystemClientException failure(String string, Throwable throwable) {
        return StatusHelper.createException(string, 3, throwable);
    }

    public static FileSystemClientException loadError(String string, ISubcommandDefinition$LoadSubcommandException iSubcommandDefinition$LoadSubcommandException) {
        return StatusHelper.createException(string, 4, iSubcommandDefinition$LoadSubcommandException);
    }

    public static FileSystemClientException misconfiguredLocalFS(String string) {
        return StatusHelper.createException(string, 5, null);
    }

    public static FileSystemClientException collision(String string) {
        return StatusHelper.createException(string, 6, null);
    }

    public static FileSystemClientException internalError(String string) {
        return StatusHelper.createException(string, 7, null);
    }

    public static FileSystemClientException internalError(String string, Exception exception) {
        return StatusHelper.createException(string, 7, exception);
    }

    public static FileSystemClientException outOfSync(String string) {
        return StatusHelper.createException(string, 8, null);
    }

    public static FileSystemClientException ambiguousSelector(String string) {
        return StatusHelper.createException(string, 9, null);
    }

    public static FileSystemClientException conflict(String string) {
        return StatusHelper.createException(string, 11, null);
    }

    public static FileSystemClientException uncheckedInChanges(String string) {
        return StatusHelper.createException(string, 34, null);
    }

    public static FileSystemClientException configurationFailure(String string) {
        return StatusHelper.createException(string, 4, null);
    }

    public static FileSystemClientException moveFailure(String string) {
        return StatusHelper.createException(string, 14, null);
    }

    public static FileSystemClientException staleData(String string) {
        return StatusHelper.createException(string, 15, null);
    }

    public static FileSystemClientException gap(String string) {
        return StatusHelper.createException(string, 16, null);
    }

    public static FileSystemClientException nWayConflict(String string) {
        return StatusHelper.createException(string, 21, null);
    }

    public static FileSystemClientException orphan(String string, ProducesOrphansInConfigurationException producesOrphansInConfigurationException) {
        return StatusHelper.createException(string, 22, (Throwable)producesOrphansInConfigurationException);
    }

    public static FileSystemClientException processFailure(String string, TeamOperationCanceledException teamOperationCanceledException, IndentingPrintStream indentingPrintStream) {
        StatusHelper.handleProcessError(new IProcessReport[]{teamOperationCanceledException.getReport()}, indentingPrintStream);
        return StatusHelper.createException(string, 17, null);
    }

    public static FileSystemClientException itemNotFound(String string) {
        return StatusHelper.createException(string, 25, null);
    }

    public static FileSystemClientException initialConnectionTimeout(long l) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_INITIAL_CONNECTION_TIMEOUT, (Object)l), 31, null);
    }

    public static FileSystemClientException ioException(String string) {
        return StatusHelper.createException(string, 35, null);
    }

    private static void handleProcessError(IProcessReport[] iProcessReportArray, IndentingPrintStream indentingPrintStream) {
        boolean bl = StatusHelper.writeOperationReport(false, iProcessReportArray, indentingPrintStream, Messages.StatusHelper_NO_REPORTS, Messages.StatusHelper_PROCESS_REPORTS);
        if (bl) {
            indentingPrintStream.println(Messages.StatusHelper_10);
        }
    }

    private static boolean writeOperationReport(boolean bl, IProcessReport iProcessReport, IndentingPrintStream indentingPrintStream) {
        IProcessReport[] iProcessReportArray;
        Object object;
        boolean bl2 = false;
        indentingPrintStream = indentingPrintStream.indent();
        indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_3, (Object)iProcessReport.getName()));
        if (bl) {
            if (iProcessReport instanceof IOperationReport) {
                object = (IOperationReport)iProcessReport;
                indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_OPERATION_ID, (Object)object.getOperationId()));
            } else if (iProcessReport instanceof IParticipantReport) {
                object = (IParticipantReport)iProcessReport;
                indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_PARTICIPANT_ID, (Object)object.getParticipantIdentifier()));
            }
            indentingPrintStream.println(NLS.bind((String)Messages.StatusHelper_DESCRIPTION, (Object)iProcessReport.getDescription()));
        }
        if (iProcessReport.getInfos().length == 0) {
            if (bl) {
                indentingPrintStream.println(Messages.StatusHelper_4);
            }
        } else {
            object = indentingPrintStream.indent();
            IReportInfo[] iReportInfoArray = iProcessReport.getInfos();
            int n = iReportInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                iProcessReportArray = iReportInfoArray[n2];
                if (bl) {
                    ((IndentingPrintStream)object).println(NLS.bind((String)Messages.StatusHelper_7, (Object)iProcessReportArray.getIdentifier(), (Object)iProcessReportArray.getDescription()));
                } else {
                    ((IndentingPrintStream)object).println(iProcessReportArray.getDescription());
                }
                if (iProcessReportArray.getDescription().contains(Messages.StatusHelper_5)) {
                    bl2 = true;
                }
                ++n2;
            }
        }
        object = new HashSet();
        iProcessReportArray = iProcessReport.getNestedReports();
        Collections.addAll((Collection)object, iProcessReportArray);
        IOperationReport[] iOperationReportArray = iProcessReport.getOperationReports();
        bl2 |= StatusHelper.writeOperationReport(bl, (IProcessReport[])iOperationReportArray, indentingPrintStream, Messages.StatusHelper_8, Messages.StatusHelper_OPERATION_REPORTS_HEADER);
        IOperationReport[] iOperationReportArray2 = iOperationReportArray;
        int n = iOperationReportArray.length;
        int n3 = 0;
        while (n3 < n) {
            IOperationReport iOperationReport = iOperationReportArray2[n3];
            object.remove(iOperationReport);
            ++n3;
        }
        if (iProcessReport instanceof IOperationReport) {
            IOperationReport iOperationReport = (IOperationReport)iProcessReport;
            IParticipantReport[] iParticipantReportArray = iOperationReport.getParticipantReports();
            bl2 |= StatusHelper.writeOperationReport(bl, (IProcessReport[])iParticipantReportArray, indentingPrintStream, Messages.StatusHelper_6, Messages.StatusHelper_PARTICIPANT_REPORTS_HEADER);
            IParticipantReport[] iParticipantReportArray2 = iParticipantReportArray;
            int n4 = iParticipantReportArray.length;
            int n5 = 0;
            while (n5 < n4) {
                IParticipantReport iParticipantReport = iParticipantReportArray2[n5];
                object.remove(iParticipantReport);
                ++n5;
            }
        }
        if (object.size() < iProcessReportArray.length) {
            iProcessReportArray = object.toArray(new IProcessReport[object.size()]);
        }
        return bl2 |= StatusHelper.writeOperationReport(bl, iProcessReportArray, indentingPrintStream, Messages.StatusHelper_NO_CHILD_REPORTS, Messages.StatusHelper_9);
    }

    private static boolean writeOperationReport(boolean bl, IProcessReport[] iProcessReportArray, IndentingPrintStream indentingPrintStream, String string, String string2) {
        ArrayList<IProcessReport> arrayList = new ArrayList<IProcessReport>(iProcessReportArray.length);
        IProcessReport[] iProcessReportArray2 = iProcessReportArray;
        int n = iProcessReportArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessReport iProcessReport = iProcessReportArray2[n2];
            if (iProcessReport.getSeverity() == 4 || iProcessReport.getSeverity() == 2) {
                arrayList.add(iProcessReport);
            }
            ++n2;
        }
        boolean bl2 = false;
        if (arrayList.size() == 0) {
            if (bl) {
                indentingPrintStream.println(string);
            }
        } else {
            indentingPrintStream.println(string2);
            for (IProcessReport iProcessReport : arrayList) {
                bl2 |= StatusHelper.writeOperationReport(bl, iProcessReport, indentingPrintStream);
            }
        }
        return bl2;
    }

    public static FileSystemClientException createException(String string, int n, Throwable throwable) {
        return new CLIFileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.cli.core", n, string, throwable));
    }

    public static FileSystemClientException internalError(String string, Collection collection) {
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.cli.core", 7, string, null);
        for (FileSystemClientException fileSystemClientException : collection) {
            multiStatus.add((IStatus)new Status(4, "com.ibm.team.filesystem.cli.core", 7, fileSystemClientException.getMessage(), (Throwable)fileSystemClientException));
        }
        return new CLIFileSystemClientException((IStatus)multiStatus);
    }

    public static FileSystemClientException permissionFailure(TeamRepositoryException teamRepositoryException, IndentingPrintStream indentingPrintStream) {
        IOperationReport[] iOperationReportArray = ProcessClient.getOperationAdviceManager().getReports();
        if (iOperationReportArray == null || iOperationReportArray.length == 0) {
            return StatusHelper.failure(teamRepositoryException.getLocalizedMessage(), teamRepositoryException);
        }
        StatusHelper.handleProcessError((IProcessReport[])iOperationReportArray, indentingPrintStream);
        return StatusHelper.createException(teamRepositoryException.getLocalizedMessage(), 18, null);
    }

    public static FileSystemClientException malformedInput(String string) {
        return StatusHelper.createException(string, 20, null);
    }

    public static FileSystemClientException disallowed(String string) {
        return StatusHelper.createException(string, 19, null);
    }

    public static FileSystemClientException cfaInUse(URL uRL) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_11, (Object)uRL.toExternalForm()), 27, null);
    }

    public static FileSystemClientException cfaInUse(String string) {
        return StatusHelper.createException(string, 27, null);
    }

    public static FileSystemClientException preferencesNotCleared(File file) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_13, (Object)file.toString()), 27, null);
    }

    public static FileSystemClientException misconfiguredRemoteFS(String string) {
        return StatusHelper.createException(string, 28, null);
    }

    public static FileSystemClientException licenseDisallowed(LicenseNotGrantedException licenseNotGrantedException) {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_12, (Object)licenseNotGrantedException.getMessage()), 29, (Throwable)licenseNotGrantedException);
    }

    public static FileSystemClientException inappropriateArgument(String string) {
        return StatusHelper.createException(string, 30, null);
    }

    public static FileSystemClientException propertiesUnavailable(String string) {
        return StatusHelper.createException(string, 33, null);
    }

    public static FileSystemClientException repositoryTimeout() {
        return StatusHelper.createException(NLS.bind((String)Messages.StatusHelper_REPOSITORY_TIMEOUT, (Object)(ClientConfiguration.getDefaultConfigDirectory() + File.separator + "preferences.properties"), (Object)"repository.timeout"), 32, null);
    }

    public static FileSystemClientException wrap(String string, TeamRepositoryException teamRepositoryException, IndentingPrintStream indentingPrintStream) {
        if (teamRepositoryException instanceof PermissionDeniedException || teamRepositoryException instanceof TeamOperationCanceledException || teamRepositoryException instanceof PermissionNotGrantedException) {
            return StatusHelper.permissionFailure(teamRepositoryException, indentingPrintStream);
        }
        if (teamRepositoryException instanceof LicenseNotGrantedException) {
            return StatusHelper.licenseDisallowed((LicenseNotGrantedException)teamRepositoryException);
        }
        if (teamRepositoryException.getCause() instanceof SocketTimeoutException) {
            return StatusHelper.repositoryTimeout();
        }
        if (teamRepositoryException instanceof ItemNotFoundException) {
            ItemNotFoundException itemNotFoundException = (ItemNotFoundException)((Object)teamRepositoryException);
            if (itemNotFoundException.getData() != null) {
                IItemHandle iItemHandle = (IItemHandle)itemNotFoundException.getData();
                IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias = null;
                try {
                    iUuidAliasRegistry$IUuidAlias = CommandLineCore.getConfig().getAliasRegistry().findAliasByUuid(iItemHandle.getItemId());
                }
                catch (IUuidAliasRegistry$NoSuchAliasException iUuidAliasRegistry$NoSuchAliasException) {}
                if (iUuidAliasRegistry$IUuidAlias == null) {
                    return StatusHelper.itemNotFound(NLS.bind((String)Messages.StatusHelper_ITEM_NOT_FOUND_WITH_UUID, (Object)iItemHandle.getItemId().getUuidValue()));
                }
                return StatusHelper.itemNotFound(NLS.bind((String)Messages.StatusHelper_ITEM_NOT_FOUND_WITH_ALIAS_UUID, (Object)iUuidAliasRegistry$IUuidAlias.getMonicker(), (Object)iUuidAliasRegistry$IUuidAlias.getUuid().getUuidValue()));
            }
            return StatusHelper.itemNotFound(Messages.StatusHelper_ITEM_NOT_FOUND);
        }
        Throwable throwable = teamRepositoryException;
        while (((Throwable)throwable).getCause() != null) {
            throwable = ((Throwable)throwable).getCause();
        }
        if (throwable instanceof IOException) {
            return StatusHelper.ioException(string);
        }
        return StatusHelper.failure(string, teamRepositoryException);
    }

    public static FileSystemClientException wrap(String string, FileSystemClientException fileSystemClientException, IndentingPrintStream indentingPrintStream) {
        Throwable throwable = fileSystemClientException;
        while (((Throwable)throwable).getCause() != null) {
            throwable = ((Throwable)throwable).getCause();
        }
        if (throwable instanceof TeamRepositoryException) {
            return StatusHelper.wrap(string, (TeamRepositoryException)throwable, indentingPrintStream);
        }
        return StatusHelper.failure(string, fileSystemClientException);
    }

    public static boolean isLoginError(FileSystemClientException fileSystemClientException) {
        return "com.ibm.team.filesystem.cli.core".equals(fileSystemClientException.getStatus().getPlugin()) && fileSystemClientException.getStatus().getCode() == 2;
    }
}

