/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ITypedPreferenceRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$IUuidAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$NoSuchAliasException;
import com.ibm.team.filesystem.cli.core.util.ChattyRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView$IRepoView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$1;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$AmbiguousSelectorException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$SelectorException$Type;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$TripListener;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$UnmatchedSelectorException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.cli.core.util.WorkspaceComponentGrouping;
import com.ibm.team.filesystem.cli.core.util.datastructures.ItemMap;
import com.ibm.team.filesystem.cli.core.util.datastructures.ItemMap$Entry;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CompareInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineSetUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentFlowUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import com.ibm.team.workitem.common.internal.model.query.BaseWorkItemQueryModel;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public abstract class RepoUtil {
    public static int getMaxResultsOption(ICommandLine iCommandLine) throws FileSystemClientException {
        int n = 10;
        if (iCommandLine.hasOption(CommonOptions.OPT_MAXRESULTS)) {
            String string = iCommandLine.getOption(CommonOptions.OPT_MAXRESULTS);
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_MaxResultNumberFormatException, (Object)string));
            }
            if (n <= 0) {
                throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_MaxResultNumberFormatException, (Object)string));
            }
        }
        return n;
    }

    public static ITeamRepository loginUrlArgAnc(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        Object object2;
        ICopyFileAreaView iCopyFileAreaView;
        ICommandLine iCommandLine = iClientConfiguration.getSubcommandCommandLine();
        if (iCommandLine.hasOption(CommonOptions.OPT_URI)) {
            return RepoUtil.login(iClientConfiguration, iClientConfiguration.getConnectionInfo(iCommandLine.getOption(CommonOptions.OPT_URI)));
        }
        try {
            iCopyFileAreaView = SubcommandUtil.getAffectedComponentsAndShares(iClientConfiguration);
        }
        catch (FileSystemClientException fileSystemClientException) {
            throw (Throwable)StatusHelper.failure("Unexpected exception", fileSystemClientException);
        }
        Collection collection = iCopyFileAreaView.getLoadedWorkspaces();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : collection) {
            hashSet.add(object2.getURI());
        }
        if (hashSet.size() != 1) {
            object2 = new StringBuilder();
            for (String string : hashSet) {
                ((StringBuilder)object2).append(string);
                ((StringBuilder)object2).append('\n');
            }
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_99, (Object)((StringBuilder)object2).toString()));
        }
        if (!$assertionsDisabled && hashSet.size() != 1) {
            throw (Throwable)((Object)new AssertionError());
        }
        object2 = (String)hashSet.iterator().next();
        ConnectionInfo connectionInfo = iClientConfiguration.getConnectionInfo((String)object2);
        return RepoUtil.login(iClientConfiguration, connectionInfo);
    }

    public static ITeamRepository login(IClientConfiguration iClientConfiguration, ConnectionInfo connectionInfo) throws FileSystemClientException {
        IContributor iContributor;
        if (connectionInfo.getUsername() == null) {
            throw (Throwable)new IllegalArgumentException(Messages.RepoUtil_1);
        }
        if (connectionInfo.getPassword() == null) {
            throw (Throwable)new IllegalArgumentException(Messages.RepoUtil_2);
        }
        if (!TeamPlatform.isStarted()) {
            TeamPlatform.startup();
        }
        ITeamRepository iTeamRepository = null;
        try {
            iTeamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(connectionInfo.getURI());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_3, (Object)connectionInfo.getURI()));
        }
        RepoUtil.configureProxy(iClientConfiguration, iTeamRepository);
        if (IClientConfiguration.DEBUG_TRIPS) {
            iClientConfiguration.addApplicationEndListener(new RepoUtil$TripListener(iTeamRepository));
        }
        if ((iContributor = iTeamRepository.loggedInContributor()) != null) {
            if (connectionInfo.getUsername().equals(iContributor.getUserId())) {
                return iTeamRepository;
            }
            throw (Throwable)StatusHelper.login(NLS.bind((String)Messages.RepoUtil_ALREADY_LOGGED_IN, (Object[])new String[]{connectionInfo.getURI(), connectionInfo.getUsername(), iContributor.getUserId(), iClientConfiguration.getContext().getAppName()}), null);
        }
        iTeamRepository.registerLoginHandler((ITeamRepository.ILoginHandler)new RepoUtil$1(connectionInfo));
        RepoUtil.configureRepo(iClientConfiguration, iTeamRepository);
        try {
            iTeamRepository.login(null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.login(connectionInfo, teamRepositoryException);
        }
        if (!iTeamRepository.loggedIn()) {
            throw (Throwable)StatusHelper.failure(Messages.RepoUtil_4, null);
        }
        return iTeamRepository;
    }

    protected static void configureProxy(IClientConfiguration iClientConfiguration, ITeamRepository iTeamRepository) throws FileSystemClientException {
        String string;
        String string2;
        Object object;
        try {
            object = new URI(iTeamRepository.getRepositoryURI());
            string2 = ((URI)object).getScheme().toLowerCase();
            string = ((URI)object).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_3, (Object)iTeamRepository.getRepositoryURI()));
        }
        object = iClientConfiguration.getContext().environment();
        String string3 = (String)object.get("no_proxy");
        String string4 = (String)object.get(String.valueOf(string2) + "_proxy");
        if (string4 != null && string4.length() != 0) {
            RepoUtil.configureProxy(iClientConfiguration, string4, iTeamRepository, string2, string, string3);
            return;
        }
        string4 = (String)object.get("all_proxy");
        if (string4 != null && string4.length() != 0) {
            RepoUtil.configureProxy(iClientConfiguration, string4, iTeamRepository, string2, string, string3);
            return;
        }
        iTeamRepository.setProxy(null, -1, null, null);
    }

    protected static void configureProxy(IClientConfiguration iClientConfiguration, String string, ITeamRepository iTeamRepository, String string2, String string3, String string4) throws FileSystemClientException {
        int n;
        int n2;
        URI uRI;
        try {
            uRI = new URI(string);
            if (uRI.getScheme() != null && uRI.getHost() == null) {
                uRI = new URI(String.valueOf(string2) + "://" + string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_5, (Object)string));
        }
        if (uRI.getHost() == null || uRI.getHost().length() == 0 || uRI.getRawFragment() != null || uRI.getRawPath() != null && uRI.getRawPath().length() != 0 || uRI.getRawQuery() != null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_5, (Object)string));
        }
        if (uRI.getScheme() != null && !uRI.getScheme().equalsIgnoreCase(string2)) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.RepoUtil_7, (Object)uRI.getScheme(), (Object)string2));
        }
        if (string4 != null) {
            n2 = 0;
            int n3 = string4.length();
            int n4 = string3.length();
            while (n2 < n3) {
                String string5;
                n = string4.indexOf(44, n2);
                if (n == -1) {
                    string5 = string4.substring(n2);
                    n2 = n3;
                } else {
                    string5 = string4.substring(n2, n);
                    n2 = n + 1;
                }
                string5 = string5.trim();
                int n5 = string5.length();
                if (n5 == 0 || !string3.regionMatches(true, n4 - n5, string5, 0, n5) || n5 != n4 && string3.charAt(n4 - n5 - 1) != '.') continue;
                iTeamRepository.setProxy(null, -1, null, null);
                return;
            }
        }
        if (uRI.getPort() == -1) {
            try {
                n2 = new URI(string2, uRI.getRawUserInfo(), uRI.getHost(), -1, null, null, null).toURL().getDefaultPort();
                if (n2 != -1) {
                    uRI = new URI(string2, uRI.getRawUserInfo(), uRI.getHost(), n2, null, null, null);
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw (Throwable)new IllegalStateException(malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw (Throwable)new IllegalStateException(uRISyntaxException);
            }
        }
        String string6 = null;
        String string7 = "";
        String string8 = uRI.getRawUserInfo();
        if (string8 != null) {
            n = string8.indexOf(58);
            if (n != -1) {
                string6 = RepoUtil.decode(string8.substring(0, n));
                string7 = RepoUtil.decode(string8.substring(n + 1));
            } else {
                string6 = RepoUtil.decode(string8);
            }
        }
        iTeamRepository.setProxy(uRI.getHost(), uRI.getPort(), string6, string7);
    }

    protected static String decode(String string) {
        try {
            return URLDecoder.decode(string.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (Throwable)new IllegalStateException(unsupportedEncodingException);
        }
    }

    private static void configureRepo(IClientConfiguration iClientConfiguration, ITeamRepository iTeamRepository) {
        ClientConfiguration clientConfiguration = (ClientConfiguration)iClientConfiguration;
        ITypedPreferenceRegistry iTypedPreferenceRegistry = clientConfiguration.getPersistentPreferences();
        int n = iTypedPreferenceRegistry.getConnectionTimeout();
        if (n != -1) {
            iTeamRepository.setConnectionTimeout(n);
        }
        int n2 = iTypedPreferenceRegistry.getContentTransferThreads();
        n2 = Math.max(1, Math.min(50, n2));
        SCMPlatform.setMaxContentThreads((int)n2);
    }

    public static List componentComplement(IFlowNodeConnection iFlowNodeConnection, Collection collection, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        LinkedList linkedList = new LinkedList();
        try {
            List list = iFlowNodeConnection.getComponents();
            linkedList.addAll(list);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_6, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        block2: for (List list : collection) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                IComponentHandle iComponentHandle = (IComponentHandle)iterator.next();
                if (!list.sameItemId((IItemHandle)iComponentHandle)) continue;
                iterator.remove();
                continue block2;
            }
        }
        return linkedList;
    }

    public static Map findNamedComponents(List list, ITeamRepository iTeamRepository, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<UUID, Object> hashMap2 = new HashMap<UUID, Object>();
        for (Object object4 : list) {
            object3 = RepoUtil.lookupUuid((String)object4);
            if (object3 == null) continue;
            hashMap2.put((UUID)object3, object4);
        }
        if (!hashMap2.isEmpty()) {
            try {
                Object object52;
                Object object4;
                object4 = new ArrayList();
                for (Object object52 : hashMap2.keySet()) {
                    object2 = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)object52, null);
                    object4.add(object2);
                }
                object52 = iTeamRepository.itemManager().fetchCompleteItems((List)object4, 0, null);
                object2 = object52.iterator();
                while (object2.hasNext()) {
                    object3 = (IComponent)object2.next();
                    if (object3 == null) continue;
                    object = (String)hashMap2.get(object3.getItemId());
                    hashMap.put(object, object3);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_CannotGetComponent, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
        }
        for (Object object4 : list) {
            object3 = IComponentSearchCriteria.FACTORY.newInstance();
            object3.setExactName((String)object4);
            try {
                Object object6;
                List list2;
                object2 = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findComponents((IComponentSearchCriteria)object3, Integer.MAX_VALUE, null);
                object = (IComponent)hashMap.get(object4);
                if (object == null) {
                    if (object2.isEmpty()) {
                        throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.COMPONENT, (String)object4, Collections.EMPTY_LIST);
                    }
                    list2 = iTeamRepository.itemManager().fetchCompleteItems((List)object2, 0, null);
                    if (list2.size() == 1) {
                        hashMap.put(object4, (IComponent)list2.get(0));
                        continue;
                    }
                    throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.COMPONENT, (String)object4, list2, list2);
                }
                if (object2.isEmpty()) continue;
                list2 = iTeamRepository.itemManager().fetchCompleteItems((List)object2, 0, null);
                boolean bl = true;
                if (list2.size() == 1 && (object6 = (IComponent)list2.get(0)).getItemId().equals((Object)object.getItemId())) {
                    bl = false;
                }
                if (!bl) continue;
                object6 = new ArrayList();
                object6.addAll(list2);
                object6.add(object);
                throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.COMPONENT, (String)object4, (List)object6, (List)object6);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_9, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
        }
        return hashMap;
    }

    public static IBaselineSetHandle findNamedSnapshot(String string, ITeamRepository iTeamRepository, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        List list;
        IItem iItem;
        IBaselineSetSearchCriteria iBaselineSetSearchCriteria;
        UUID uUID = RepoUtil.lookupUuid(string);
        IBaselineSetSearchCriteria iBaselineSetSearchCriteria2 = null;
        if (uUID != null) {
            iBaselineSetSearchCriteria = (IBaselineSetHandle)IBaselineSet.ITEM_TYPE.createItemHandle((Object)iTeamRepository, uUID, null);
            try {
                iItem = iTeamRepository.itemManager().fetchCompleteItem((IItemHandle)iBaselineSetSearchCriteria, 0, null);
                if (iItem instanceof IBaselineSet) {
                    iBaselineSetSearchCriteria2 = iBaselineSetSearchCriteria;
                }
            }
            catch (ItemNotFoundException itemNotFoundException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_CannotGetSnapshot, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
        }
        iBaselineSetSearchCriteria = IBaselineSetSearchCriteria.FACTORY.newInstance();
        iBaselineSetSearchCriteria.setExactName(string);
        iItem = new ArrayList();
        try {
            list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findBaselineSets(iBaselineSetSearchCriteria, Integer.MAX_VALUE, null);
            iItem.addAll(list);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_9, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        if (iBaselineSetSearchCriteria2 != null) {
            iItem.add(iBaselineSetSearchCriteria2);
        }
        if (iItem.size() == 0) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.SNAPSHOT, string, Collections.EMPTY_LIST);
        }
        if (iItem.size() > 1) {
            try {
                list = iTeamRepository.itemManager().fetchPartialItems((List)iItem, 0, (Collection)Collections.singletonList(IBaselineSet.NAME_PROPERTY), null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_ExcessSnapshots, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.SNAPSHOT, string, list, list);
        }
        return (IBaselineSetHandle)iItem.get(0);
    }

    public static IWorkspace findNamedWorkspace(String string, boolean bl, boolean bl2, ITeamRepository iTeamRepository, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        ArrayList<IWorkspace> arrayList;
        IWorkspaceSearchCriteria iWorkspaceSearchCriteria;
        UUID uUID = RepoUtil.lookupUuid(string);
        ArrayList<IWorkspaceSearchCriteria> arrayList2 = new ArrayList<IWorkspaceSearchCriteria>();
        if (uUID != null) {
            iWorkspaceSearchCriteria = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(uUID, null);
            arrayList2.add(iWorkspaceSearchCriteria);
        }
        iWorkspaceSearchCriteria = IWorkspaceSearchCriteria.FACTORY.newInstance().setExactName(string);
        if (bl && bl2) {
            iWorkspaceSearchCriteria.setKind(3);
        } else if (bl && !bl2) {
            iWorkspaceSearchCriteria.setKind(2);
        } else if (!bl && bl2) {
            iWorkspaceSearchCriteria.setKind(1);
        } else {
            throw (Throwable)new IllegalArgumentException(Messages.RepoUtil_8);
        }
        try {
            arrayList = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findWorkspaces(iWorkspaceSearchCriteria, Integer.MAX_VALUE, null);
            arrayList2.addAll((Collection)arrayList);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_9, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        arrayList = new ArrayList<IWorkspace>();
        if (arrayList2.size() > 0) {
            try {
                List list = iTeamRepository.itemManager().fetchCompleteItems((List)arrayList2, 0, null);
                for (IItem iItem : list) {
                    if (iItem == null || !(iItem instanceof IWorkspace)) continue;
                    IWorkspace iWorkspace = (IWorkspace)iItem;
                    if (iWorkspace.isStream()) {
                        if (!bl2) continue;
                        arrayList.add(iWorkspace);
                        continue;
                    }
                    if (!bl) continue;
                    arrayList.add(iWorkspace);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_10, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
        }
        if (arrayList.size() == 0) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.WORKSPACE, string, Collections.EMPTY_LIST);
        }
        if (arrayList.size() > 1) {
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.WORKSPACE, string, arrayList, arrayList);
        }
        return (IWorkspace)arrayList.get(0);
    }

    public static UUID lookupUuid(String string) {
        try {
            IClientConfiguration iClientConfiguration = CommandLineCore.getConfig();
            if (iClientConfiguration != null) {
                IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias = iClientConfiguration.getAliasRegistry().findAliasByName(string);
                return iUuidAliasRegistry$IUuidAlias.getUuid();
            }
        }
        catch (IUuidAliasRegistry$NoSuchAliasException iUuidAliasRegistry$NoSuchAliasException) {}
        try {
            return UUID.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static IWorkspaceConnection findNamedWorkspaceConnection(String string, boolean bl, boolean bl2, ITeamRepository iTeamRepository, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        IWorkspace iWorkspace = RepoUtil.findNamedWorkspace(string, bl, bl2, iTeamRepository, iClientConfiguration);
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
        try {
            return iWorkspaceManager.getWorkspaceConnection((IWorkspaceHandle)iWorkspace, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_11, (Object)string), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
    }

    public static List findNamedVersionables(IClientConfiguration iClientConfiguration, IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, boolean bl, List list, boolean bl2, boolean bl3, boolean bl4, String string, String string2) throws FileSystemClientException {
        ArrayList<SiloedItemId> arrayList = null;
        if (bl) {
            List list2;
            if (iComponentHandle == null) {
                throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_REMOTE_PATH_REQUIRES_COMPONENT);
            }
            try {
                list2 = RepoUtil.findNamedVersionables(list, iComponentHandle, iWorkspaceConnection, bl2, bl3, bl4, iClientConfiguration);
            }
            catch (RepoUtil$UnmatchedSelectorException repoUtil$UnmatchedSelectorException) {
                SubcommandUtil.displaySelectorException(repoUtil$UnmatchedSelectorException, iClientConfiguration);
                throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_FILE_PATH_NOT_FOUND, (Object)repoUtil$UnmatchedSelectorException.getSelector()));
            }
            catch (RepoUtil$AmbiguousSelectorException repoUtil$AmbiguousSelectorException) {
                SubcommandUtil.displaySelectorException(repoUtil$AmbiguousSelectorException, iClientConfiguration);
                throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_FILE_SELECTOR_MATCHES_MULTIPLE, (Object)repoUtil$AmbiguousSelectorException.getSelector()));
            }
            arrayList = new ArrayList<SiloedItemId>(list.size());
            for (IVersionableHandle iVersionableHandle : list2) {
                arrayList.add(SiloedItemId.create((IVersionableHandle)iVersionableHandle, (IComponentHandle)iComponentHandle));
            }
        } else {
            arrayList = RepoUtil.findNamedVersionables(iClientConfiguration, iComponentHandle, list, string, string2);
        }
        return arrayList;
    }

    public static List findNamedVersionables(IClientConfiguration iClientConfiguration, IComponentHandle iComponentHandle, List list, String string, String string2) throws FileSystemClientException {
        ArrayList<SiloedItemId> arrayList = new ArrayList<SiloedItemId>(list.size());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        List list2 = RepoUtil.findNamedShareables(iClientConfiguration, list, string, string2);
        for (IShareable object : list2) {
            IVersionableHandle iVersionableHandle = object.getVersionable(null);
            SiloedItemId siloedItemId = null;
            if (iVersionableHandle != null) {
                if (iComponentHandle != null) {
                    siloedItemId = SiloedItemId.create((IVersionableHandle)iVersionableHandle, (IComponentHandle)iComponentHandle);
                    arrayList.add(siloedItemId);
                } else {
                    IShare iShare = object.getShare(null);
                    if (iShare != null) {
                        IComponentHandle iComponentHandle2 = iShare.getSharingDescriptor().getComponent();
                        siloedItemId = SiloedItemId.create((IVersionableHandle)iVersionableHandle, (IComponentHandle)iComponentHandle2);
                        arrayList.add(siloedItemId);
                    }
                }
            }
            if (siloedItemId != null) continue;
            arrayList2.add(NLS.bind((String)Messages.RepoUtil_FILE_PATH_NOT_SHARED, (Object)object.getFullPath().toString()));
        }
        if (!arrayList2.isEmpty()) {
            for (String string3 : arrayList2) {
                iClientConfiguration.getContext().stderr().println(string3);
            }
            throw (Throwable)StatusHelper.inappropriateArgument(Messages.RepoUtil_FILE_NOT_SHARED);
        }
        return arrayList;
    }

    public static List findNamedShareables(IClientConfiguration iClientConfiguration, List list, String string, String string2) throws FileSystemClientException {
        ResourceType resourceType;
        ArrayList<IShareable> arrayList = new ArrayList<IShareable>(list.size());
        List list2 = SubcommandUtil.makeAbsolutePaths(iClientConfiguration, list);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (IPath object : list2) {
            resourceType = PathUtils.getResourceType((IPath)object, (IProgressMonitor)((IProgressMonitor)TempHelper.MONITOR));
            if (resourceType == ResourceType.FOLDER) {
                arrayList3.add(NLS.bind((String)string, (Object)object.toOSString()));
                continue;
            }
            if (resourceType != null) continue;
            arrayList2.add(NLS.bind((String)Messages.RepoUtil_FILE_PATH_DOES_NOT_EXIST, (Object)object.toOSString()));
        }
        if (!arrayList2.isEmpty() || !arrayList3.isEmpty()) {
            Collections.sort((List)arrayList2);
            Collections.sort((List)arrayList3);
            for (String string3 : arrayList3) {
                iClientConfiguration.getContext().stderr().println(string3);
            }
            for (String string4 : arrayList2) {
                iClientConfiguration.getContext().stderr().println(string4);
            }
            if (!arrayList2.isEmpty()) {
                throw (Throwable)StatusHelper.disallowed(Messages.RepoUtil_FILES_DOES_NOT_EXIST);
            }
            throw (Throwable)StatusHelper.inappropriateArgument(string2);
        }
        for (IPath iPath : list2) {
            resourceType = SubcommandUtil.findSandboxContaining(iPath);
            IShareable iShareable = resourceType.findShareable(SubcommandUtil.makeRelativeToCFARoot(resourceType.getRoot(), iPath), ResourceType.FILE);
            arrayList.add(iShareable);
        }
        return arrayList;
    }

    public static List findNamedVersionables(List list, IComponentHandle iComponentHandle, IWorkspaceConnection iWorkspaceConnection, boolean bl, boolean bl2, boolean bl3, IClientConfiguration iClientConfiguration) throws RepoUtil$UnmatchedSelectorException, FileSystemClientException, RepoUtil$AmbiguousSelectorException {
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        IConfiguration iConfiguration = null;
        IFolderHandle iFolderHandle = null;
        try {
            iConfiguration = iWorkspaceConnection.configuration(iComponentHandle);
            iFolderHandle = iConfiguration.rootFolderHandle(null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(null, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        ArrayList<IItemType> arrayList = new ArrayList<IItemType>();
        if (bl) {
            arrayList.add(IFileItem.ITEM_TYPE);
        }
        if (bl2) {
            arrayList.add(IFolder.ITEM_TYPE);
        }
        if (bl3) {
            arrayList.add(ISymbolicLink.ITEM_TYPE);
        }
        ArrayList<IVersionableHandle> arrayList2 = new ArrayList<IVersionableHandle>();
        for (String string : list) {
            IVersionableHandle iVersionableHandle;
            IItemType iItemType2;
            UUID uUID = RepoUtil.lookupUuid(string);
            IVersionable iVersionable = null;
            if (uUID != null) {
                for (IItemType iItemType2 : arrayList) {
                    iVersionable = RepoUtil.findItem(iWorkspaceConnection, iConfiguration, uUID, iItemType2, iClientConfiguration);
                    if (iVersionable != null) break;
                }
            }
            iItemType2 = null;
            try {
                iVersionableHandle = iConfiguration.resolvePath(iFolderHandle, new Path(string).segments(), null);
                if (iVersionableHandle != null && !iVersionableHandle.sameItemId((IItemHandle)iVersionable)) {
                    iItemType2 = iConfiguration.fetchCompleteItem(iVersionableHandle, null);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(null, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
            iVersionableHandle = null;
            if (iItemType2 == null && iVersionable != null) {
                iVersionableHandle = iVersionable;
            } else if (iItemType2 != null && iVersionable == null) {
                iVersionableHandle = iItemType2;
            } else if (iItemType2 != null && iVersionable != null) {
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                arrayList3.add(iVersionable);
                arrayList3.add(iItemType2);
                throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.VERSIONABLE, string, arrayList3, arrayList3);
            }
            if (iVersionableHandle == null) {
                if (uUID != null && arrayList.size() > 0) {
                    iVersionableHandle = (IVersionableHandle)((IItemType)arrayList.get(0)).createItemHandle((Object)iWorkspaceConnection.teamRepository(), uUID, null);
                }
                if (iVersionableHandle != null) {
                    arrayList2.add(iVersionableHandle);
                    continue;
                }
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.VERSIONABLE, string, null);
            }
            if (arrayList.contains(iVersionableHandle.getItemType())) {
                arrayList2.add(iVersionableHandle);
                continue;
            }
            throw (Throwable)StatusHelper.inappropriateArgument(NLS.bind((String)Messages.RepoUtil_UNEXPECTED_ITEM_TYPE, (Object)iVersionableHandle.getItemType().getName()));
        }
        return arrayList2;
    }

    private static IVersionable findItem(IWorkspaceConnection iWorkspaceConnection, IConfiguration iConfiguration, UUID uUID, IItemType iItemType, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        IVersionable iVersionable = null;
        try {
            IVersionable iVersionable2;
            IVersionableHandle iVersionableHandle = (IVersionableHandle)iItemType.createItemHandle((Object)iWorkspaceConnection.teamRepository(), uUID, null);
            iVersionable = iVersionable2 = iConfiguration.fetchCompleteItem(iVersionableHandle, null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(null, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        return iVersionable;
    }

    public static List findNamedComponents(List list, boolean bl, IWorkspaceConnection iWorkspaceConnection, ITeamRepository iTeamRepository, boolean bl2, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        List list2;
        LinkedList<IComponent> linkedList;
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            linkedList = iWorkspaceConnection.getComponents();
            list2 = iTeamRepository.itemManager().fetchPartialItems((List)linkedList, 0, (Collection)Collections.singletonList(IComponent.NAME_PROPERTY), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_14, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        linkedList = new LinkedList<IComponent>();
        int n = 0;
        while (n < list.size()) {
            String string = (String)list.get(n);
            IComponent iComponent = RepoUtil.findNamedComponent(string, list2, false);
            if (iComponent == null && bl2) {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.COMPONENT, string, list2);
            }
            linkedList.add(iComponent);
            ++n;
        }
        if (bl) {
            for (IComponent iComponent : list2) {
                if (linkedList.contains(iComponent)) continue;
                linkedList.add(iComponent);
            }
        }
        return linkedList;
    }

    public static IComponent findNamedComponent(String string, List list, boolean bl) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        UUID uUID = RepoUtil.lookupUuid(string);
        int n = 0;
        ArrayList<IComponent> arrayList = new ArrayList<IComponent>(1);
        for (IComponent iComponent : list) {
            if (!iComponent.getName().equals(string) && !iComponent.getItemId().equals((Object)uUID)) continue;
            ++n;
            arrayList.add(iComponent);
        }
        if (arrayList.size() == 1) {
            return (IComponent)arrayList.get(0);
        }
        if (arrayList.size() > 1) {
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.COMPONENT, string, list, arrayList);
        }
        if (bl) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.COMPONENT, string, list);
        }
        return null;
    }

    public static List pruneToNamedChangeSets(IWorkspaceConnection iWorkspaceConnection, List list, Collection collection, Set set, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException {
        List<String> list2;
        Object object4;
        String string2;
        Object object2;
        if (list == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (set == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(list);
        Object object3 = linkedList.iterator();
        while (object3.hasNext()) {
            object2 = (IChangeSetHandle)object3.next();
            for (String string2 : collection) {
                if (!RepoUtil.uuidMatchesSelector(object2.getItemId(), string2)) continue;
                object3.remove();
                arrayList.add(object2);
                set.add(string2);
            }
        }
        if (arrayList.size() == collection.size()) {
            return arrayList;
        }
        try {
            object3 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems((List)linkedList, 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_16, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            string2 = (IChangeSet)object2.next();
            for (Object object4 : collection) {
                if (!((String)object4).equals(string2.getComment())) continue;
                object2.remove();
                arrayList.add(string2);
                set.add(object4);
            }
        }
        linkedList = null;
        if (object3.size() == 0) {
            return arrayList;
        }
        object2 = new ItemMap();
        object4 = object3.iterator();
        while (object4.hasNext()) {
            string2 = (IChangeSet)object4.next();
            list2 = (List)((ItemMap)object2).get(string2.getComponent());
            if (list2 == null) {
                list2 = new LinkedList<String>();
                ((ItemMap)object2).put(string2.getComponent(), list2);
            }
            list2.add(string2);
        }
        block9: for (String string2 : collection) {
            list2 = ((ItemMap)object2).iterator();
            while (list2.hasNext()) {
                ItemMap$Entry itemMap$Entry = (ItemMap$Entry)list2.next();
                LinkedList linkedList2 = new LinkedList();
                boolean bl = false;
                try {
                    bl = RepoUtil.findNamedChangeSetByWorkItem(iWorkspaceConnection, string2, (List)itemMap$Entry.getValue(), linkedList2, iClientConfiguration);
                }
                catch (RepoUtil$SelectorException repoUtil$SelectorException) {
                    continue;
                }
                if (!bl) continue;
                set.add(string2);
                arrayList.addAll(linkedList2);
                list2.remove();
                continue block9;
            }
        }
        if (set.size() != collection.size()) {
            object2 = new HashSet();
            object2.addAll(collection);
            object2.removeAll(set);
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, (Collection)object2, null);
        }
        return arrayList;
    }

    private static boolean uuidMatchesSelector(UUID uUID, String string) {
        UUID uUID2 = RepoUtil.lookupUuid(string);
        return uUID2 != null && uUID.equals((Object)uUID2);
    }

    public static IBaselineHandle findNamedBaseline(ITeamRepository iTeamRepository, IComponentHandle iComponentHandle, String string, IClientConfiguration iClientConfiguration) throws RepoUtil$AmbiguousSelectorException, RepoUtil$UnmatchedSelectorException, FileSystemClientException {
        UUID uUID = RepoUtil.lookupUuid(string);
        try {
            Object object;
            IBaselineSearchCriteria iBaselineSearchCriteria;
            if (uUID != null) {
                iBaselineSearchCriteria = (IBaselineHandle)IBaseline.ITEM_TYPE.createItemHandle(uUID, null);
                object = iTeamRepository.itemManager().fetchCompleteItem((IItemHandle)iBaselineSearchCriteria, 0, null);
                if (object instanceof IBaselineHandle) {
                    return (IBaselineHandle)object;
                }
            }
            iBaselineSearchCriteria = IBaselineSearchCriteria.FACTORY.newInstance().setExactName(string);
            iBaselineSearchCriteria.setComponentRequired(iComponentHandle);
            object = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findBaselines(iBaselineSearchCriteria, 100, null);
            if (object.size() == 1) {
                return (IBaselineHandle)object.get(0);
            }
            if (object.size() == 0) {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.BASELINE, string, Collections.EMPTY_LIST);
            }
            List list = iTeamRepository.itemManager().fetchCompleteItems((List)object, 0, null);
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.BASELINE, string, list, list);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_BASELINE_SELECTOR_TRE, (Object)string), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
    }

    public static List findBaseline(ITeamRepository iTeamRepository, IComponentHandle iComponentHandle, String string) throws TeamRepositoryException {
        UUID uUID = RepoUtil.lookupUuid(string);
        IBaselineSearchCriteria iBaselineSearchCriteria = IBaselineSearchCriteria.FACTORY.newInstance().setComponentRequired(iComponentHandle);
        List list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findBaselines(iBaselineSearchCriteria, Integer.MAX_VALUE, null);
        List list2 = iTeamRepository.itemManager().fetchPartialItems(list, 0, (Collection)Collections.singleton(IBaseline.NAME_PROPERTY), null);
        ArrayList<IBaseline> arrayList = new ArrayList<IBaseline>();
        for (IBaseline iBaseline : list2) {
            if (uUID != null) {
                if (!iBaseline.getItemId().equals((Object)uUID)) break;
                arrayList.add(iBaseline);
                break;
            }
            if (!iBaseline.getName().equals(string)) continue;
            arrayList.add(iBaseline);
        }
        return arrayList;
    }

    public static IChangeSetHandle findNamedChangeSet(ITeamRepository iTeamRepository, String string, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        UUID uUID = RepoUtil.lookupUuid(string);
        if (uUID == null) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, Collections.EMPTY_LIST);
        }
        IChangeSetHandle iChangeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle(uUID, null);
        try {
            IItem iItem = iTeamRepository.itemManager().fetchCompleteItem((IItemHandle)iChangeSetHandle, 0, null);
            if (!IChangeSet.ITEM_TYPE.equals(iItem.getItemType())) {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, Collections.EMPTY_LIST);
            }
            return (IChangeSetHandle)iItem;
        }
        catch (ItemNotFoundException itemNotFoundException) {
            throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, Collections.EMPTY_LIST);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_10, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static IChangeSetHandle findNamedChangeSet(IWorkspaceConnection var0, IComponentHandle var1_1, String var2_2, IClientConfiguration var3_3) throws RepoUtil$UnmatchedSelectorException, FileSystemClientException, RepoUtil$AmbiguousSelectorException {
        block16: {
            var4_4 = RepoUtil.lookupUuid(var2_2);
            try {
                var6_5 = var0.changeHistory(var1_1).recent(null);
            }
            catch (TeamRepositoryException var7_6) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_18, var7_6, new IndentingPrintStream(var3_3.getContext().stderr()));
            }
            var5_9 = new LinkedList<IChangeSetHandle>();
            for (Object var7_7 : var6_5) {
                var5_9.add(var7_7.changeSet());
            }
            if (var5_9.size() < 1) {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, var2_2, Collections.EMPTY_LIST);
            }
            try {
                var6_5 = var0.teamRepository().itemManager().fetchPartialItems((List)var5_9, 0, (Collection)Collections.singletonList(IChangeSet.COMMENT_PROPERTY), null);
            }
            catch (TeamRepositoryException var7_8) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_19, var7_8, new IndentingPrintStream(var3_3.getContext().stderr()));
            }
            var7_7 = new LinkedList<E>();
            for (IChangeSet var8_10 : var6_5) {
                if (var8_10.getItemId().equals((Object)var4_4)) {
                    var7_7.add(var8_10);
                    continue;
                }
                if (!var2_2.equals(var8_10.getComment())) continue;
                var7_7.add(var8_10);
            }
            try {
                RepoUtil.findNamedChangeSetByWorkItem(var0, var2_2, var6_5, (List)var7_7, var3_3);
                break block16;
            }
            catch (RepoUtil$UnmatchedSelectorException v0) {
                break block16;
            }
            catch (RepoUtil$AmbiguousSelectorException var8_11) {
                ** for (var9_12 : var8_11.getMatched())
            }
lbl-1000:
            // 1 sources

            {
                var7_7.add((IChangeSet)var9_12);
                continue;
            }
        }
        switch (var7_7.size()) {
            case 0: {
                throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, var2_2, var6_5);
            }
            case 1: {
                return (IChangeSetHandle)var7_7.get(0);
            }
        }
        throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.CHANGESET, var2_2, var6_5, (List)var7_7);
    }

    /*
     * Unable to fully structure code
     */
    public static List findNamedChangeSetsForWorkspace(IWorkspaceConnection var0, String var1_1, IClientConfiguration var2_2) throws TeamRepositoryException, FileSystemClientException {
        var3_3 = var0.getComponents();
        var4_4 = new LinkedList<IChangeSetHandle>();
        block3: for (IComponentHandle var5_6 : var3_3) {
            try {
                var7_7 = RepoUtil.findNamedChangeSet(var0, var5_6, var1_1, var2_2);
                var4_4.add(var7_7);
                continue;
            }
            catch (RepoUtil$UnmatchedSelectorException v0) {
                continue;
            }
            catch (RepoUtil$AmbiguousSelectorException var7_8) {
                ** for (var8_9 : var7_8.getMatched())
            }
lbl-1000:
            // 1 sources

            {
                var4_4.add((IChangeSetHandle)var8_9);
                continue;
lbl16:
                // 1 sources

            }
        }
        return var4_4;
    }

    public static List findChangeSummariesByPath(IClientConfiguration iClientConfiguration, IWorkspaceConnection iWorkspaceConnection, String string, boolean bl) throws TeamRepositoryException, FileSystemClientException {
        Object object2;
        List list;
        IWorkspaceHandle iWorkspaceHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)iWorkspaceConnection);
        Collection collection = null;
        if (iWorkspaceHandle != null) {
            collection = iWorkspaceConnection.getFlowTable().getComponentScopes((IFlowNodeHandle)iWorkspaceHandle);
        }
        LinkedList<CompareInput> linkedList = new LinkedList<CompareInput>();
        if (collection == null || collection.isEmpty()) {
            try {
                list = iWorkspaceConnection.teamRepository().itemManager().fetchPartialItems(iWorkspaceConnection.getComponents(), 0, (Collection)Collections.singletonList(IComponent.NAME_PROPERTY), null);
                for (Object object2 : list) {
                    linkedList.add(new CompareInput((Object)iWorkspaceConnection, (Object)RepoUtil.getCurrentCollaboration(iWorkspaceConnection, (IComponentHandle)object2), Collections.singletonList(object2)));
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_58, (Object)iWorkspaceConnection.getName()), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
        } else {
            linkedList.add(new CompareInput((Object)iWorkspaceConnection, (Object)iWorkspaceHandle, (List)new ArrayList(collection)));
        }
        list = SubcommandUtil.makePath(iClientConfiguration, string);
        if (list != null) {
            list = list.makeAbsolute();
        }
        object2 = new LinkedList();
        for (CompareInput compareInput : linkedList) {
            IComponentSyncModel iComponentSyncModel = ComponentBaselineSetUtil.create((CompareInput)compareInput, (int)-1, null);
            try {
                IComponentSyncContext[] iComponentSyncContextArray;
                iComponentSyncModel.refresh(true, null);
                IComponentSyncContext[] iComponentSyncContextArray2 = iComponentSyncContextArray = iComponentSyncModel.getComponentSyncContexts();
                int n = iComponentSyncContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IComponentSyncContext iComponentSyncContext = iComponentSyncContextArray2[n2];
                    List list2 = iComponentSyncContext.getOutgoingActivitySource().getActivities();
                    for (IRemoteActivity iRemoteActivity : list2) {
                        if (bl && !iComponentSyncContext.isActive(iRemoteActivity)) continue;
                        List list3 = iRemoteActivity.getChanges();
                        for (IRemoteChangeSummary iRemoteChangeSummary : list3) {
                            Path path;
                            Path path2 = path = iRemoteChangeSummary.getChange().kind() == 16 ? new Path(iRemoteChangeSummary.getBeforePath()) : new Path(iRemoteChangeSummary.getAfterPath());
                            if (!path.equals((Object)list)) continue;
                            object2.add(iRemoteChangeSummary);
                        }
                    }
                    ++n2;
                }
            }
            finally {
                iComponentSyncModel.dispose();
            }
        }
        return (List)object2;
    }

    public static Map findChangesByPath(IClientConfiguration iClientConfiguration, IWorkspaceConnection iWorkspaceConnection, String string) throws TeamRepositoryException, FileSystemClientException {
        List list = RepoUtil.findChangeSummariesByPath(iClientConfiguration, iWorkspaceConnection, string, true);
        HashMap<IChangeSetHandle, LinkedList<IChange>> hashMap = new HashMap<IChangeSetHandle, LinkedList<IChange>>();
        for (IRemoteChangeSummary iRemoteChangeSummary : list) {
            IChangeSetHandle iChangeSetHandle = iRemoteChangeSummary.getActivity().getChangeSetHandle();
            LinkedList<IChange> linkedList = (LinkedList<IChange>)hashMap.get(iChangeSetHandle);
            if (linkedList == null) {
                linkedList = new LinkedList<IChange>();
                hashMap.put(iChangeSetHandle, linkedList);
            }
            linkedList.add(iRemoteChangeSummary.getChange());
        }
        return hashMap;
    }

    public static IWorkspaceHandle getCurrentCollaboration(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        IWorkspaceHandle iWorkspaceHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)iWorkspaceConnection, (IComponentHandle)iComponentHandle);
        if (iWorkspaceHandle != null) {
            return iWorkspaceHandle;
        }
        iWorkspaceHandle = ComponentFlowUtil.getCurrentCollaboration((IWorkspaceConnection)iWorkspaceConnection);
        if (iWorkspaceHandle != null) {
            return iWorkspaceHandle;
        }
        return FlowUtils.getDefaultFlowTarget((IWorkspaceConnection)iWorkspaceConnection);
    }

    public static Map getWorkItemsForChangeSets(ITeamRepository iTeamRepository, List list, List list2, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        Object object;
        Object object22;
        Object object322;
        List list3;
        try {
            list3 = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getChangeSetLinkSummary((Collection)list2, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_22, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        HashMap<UUID, IWorkItem> hashMap = new HashMap<UUID, IWorkItem>();
        HashMap<UUID, LinkedList<UUID>> hashMap2 = new HashMap<UUID, LinkedList<UUID>>();
        Cloneable cloneable = new ArrayList();
        for (IChangeSetLinkSummary object42 : list3) {
            cloneable.addAll(object42.getLinks());
        }
        try {
            iTeamRepository.itemManager().fetchCompleteItems((List)((Object)cloneable), 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_23, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        LinkedList<IWorkItemHandle> linkedList = new LinkedList<IWorkItemHandle>();
        for (Object object322 : list3) {
            try {
                object22 = iTeamRepository.itemManager().fetchCompleteItems(object322.getLinks(), 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_24, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
            Iterator iterator = object22.iterator();
            while (iterator.hasNext()) {
                ILink iLink = (ILink)iterator.next();
                Object object3 = iLink.getTargetRef().resolve();
                if (!(object3 instanceof IWorkItemHandle)) {
                    throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.RepoUtil_25, (Object)object3.getClass().getName()));
                }
                IWorkItemHandle iWorkItemHandle = (IWorkItemHandle)object3;
                linkedList.add(iWorkItemHandle);
                UUID uUID = object322.getChangeSet().getItemId();
                LinkedList<UUID> linkedList2 = (LinkedList<UUID>)hashMap2.get(uUID);
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<UUID>();
                    hashMap2.put(uUID, linkedList2);
                }
                linkedList2.add(iWorkItemHandle.getItemId());
            }
        }
        try {
            object322 = iTeamRepository.itemManager().fetchPartialItems((List)linkedList, 0, (Collection)list, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_26, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        object22 = object322.iterator();
        while (object22.hasNext()) {
            object = (IWorkItem)object22.next();
            hashMap.put(object.getItemId(), (IWorkItem)object);
        }
        cloneable = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            object = new ArrayList(((List)entry.getValue()).size());
            for (Object object22 : (List)entry.getValue()) {
                object.add((IWorkItem)hashMap.get(object22));
            }
            cloneable.put((UUID)entry.getKey(), object);
        }
        return (Map)((Object)cloneable);
    }

    public static boolean findNamedChangeSetByWorkItem(IWorkspaceConnection iWorkspaceConnection, String string, List list, List list2, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$AmbiguousSelectorException, RepoUtil$UnmatchedSelectorException {
        List list3;
        List list4;
        Object object2;
        List list5;
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (n <= 0) {
            return false;
        }
        try {
            list5 = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository()).getChangeSetLinkSummary((Collection)list, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_28, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        HashMap<UUID, LinkedList<UUID>> hashMap = new HashMap<UUID, LinkedList<UUID>>();
        IWorkItem iWorkItem2 = new ArrayList();
        for (Object object2 : list5) {
            iWorkItem2.addAll(object2.getLinks());
        }
        try {
            iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems((List)iWorkItem2, 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_29, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        object2 = new LinkedList();
        for (Object object3 : list5) {
            try {
                list4 = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(object3.getLinks(), 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_30, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
            for (Object object4 : list4) {
                Iterator iterator = object4.getTargetRef().resolve();
                if (!(iterator instanceof IWorkItemHandle)) {
                    throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.RepoUtil_31, (Object)iterator.getClass().getName()));
                }
                IWorkItemHandle iWorkItemHandle = (IWorkItemHandle)iterator;
                object2.add(iWorkItemHandle);
                LinkedList<UUID> linkedList = (LinkedList<UUID>)hashMap.get(iWorkItemHandle.getItemId());
                if (linkedList == null) {
                    linkedList = new LinkedList<UUID>();
                    hashMap.put(iWorkItemHandle.getItemId(), linkedList);
                }
                linkedList.add(object3.getChangeSet().getItemId());
            }
        }
        try {
            list3 = RepoUtil.fetchItems(iWorkspaceConnection.teamRepository(), (List)object2);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_32, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        for (IWorkItem iWorkItem2 : list3) {
            Object object4;
            Object object3;
            if (iWorkItem2.getId() != n) continue;
            object3 = (List)hashMap.get(iWorkItem2.getItemId());
            ArrayList arrayList = new ArrayList(object3.size());
            object4 = object3.iterator();
            while (object4.hasNext()) {
                list4 = (UUID)object4.next();
                for (IChangeSet iChangeSet : list) {
                    if (!list4.equals(iChangeSet.getItemId())) continue;
                    arrayList.add(iChangeSet);
                }
            }
            switch (arrayList.size()) {
                case 0: {
                    throw (Throwable)StatusHelper.internalError(Messages.RepoUtil_33);
                }
                case 1: {
                    list2.add((IChangeSet)arrayList.get(0));
                    return true;
                }
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, list, arrayList);
        }
        throw (Throwable)new RepoUtil$UnmatchedSelectorException(RepoUtil$SelectorException$Type.CHANGESET, string, null);
    }

    public static IChangeSetHandle createChangeSet(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle, String string, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        IChangeSetHandle iChangeSetHandle;
        try {
            iChangeSetHandle = iWorkspaceConnection.createChangeSet(iComponentHandle, string, true, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_41, (Object)iComponentHandle.getItemId()), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        try {
            iWorkspaceConnection.setCurrentChangeSet(iChangeSetHandle, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_42, (Object)iWorkspaceConnection.getName()), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        return iChangeSetHandle;
    }

    public static IComponent createComponentOnWorkspace(IWorkspaceConnection iWorkspaceConnection, String string, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        IComponent iComponent;
        ITeamRepository iTeamRepository = iWorkspaceConnection.teamRepository();
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
        try {
            iComponent = iWorkspaceManager.createComponent(string, (IAuditableHandle)iTeamRepository.loggedInContributor(), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_0, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        try {
            iWorkspaceConnection.addComponent((IComponentHandle)iComponent, false, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_97, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        return iComponent;
    }

    public static InputStream findContentFor(ITeamRepository iTeamRepository, IPath iPath, IFileItemHandle iFileItemHandle, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        IFileItem iFileItem;
        if (iFileItemHandle == null) {
            return null;
        }
        StateId stateId = new StateId((IItemHandle)iFileItemHandle);
        try {
            iFileItem = (IFileItem)RepoFetcher.fetchItem((ITeamRepository)iTeamRepository, (StateId)stateId, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_44, (Object)iPath, (Object)stateId.getItemUUID().getUuidValue()), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        try {
            return FileSystemCore.getContentManager((ITeamRepository)iTeamRepository).retrieveContentStream((IFileItemHandle)iFileItem, iFileItem.getContent(), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_45, (Object)iPath, (Object)stateId.getItemUUID().getUuidValue()), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
    }

    public static void transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[32000];
        try {
            int n = inputStream.read(byArray);
            while (n > -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
    }

    public static IWorkspaceHandle findAcceptCollaborationFor(IWorkspaceConnection iWorkspaceConnection, IComponentHandle iComponentHandle) {
        IFlowTable iFlowTable = iWorkspaceConnection.getFlowTable();
        IFlowEntry iFlowEntry = iFlowTable.getCurrentDeliverFlow(iComponentHandle);
        if (iFlowEntry == null) {
            iFlowEntry = iFlowTable.getCurrentAcceptFlow();
        }
        if (iFlowEntry == null) {
            iFlowEntry = iFlowTable.getDefaultAcceptFlow();
        }
        if (iFlowEntry == null) {
            return null;
        }
        return (IWorkspaceHandle)iFlowEntry.getFlowNode();
    }

    public static Collection findWorkspaceComponentGroupings(IWorkspaceConnection iWorkspaceConnection, ISandbox iSandbox, IPath iPath, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        Map map = SubcommandUtil.getAffectedShareRoots(iSandbox, iPath);
        HashMap<String, WorkspaceComponentGrouping> hashMap = new HashMap<String, WorkspaceComponentGrouping>();
        for (Map.Entry entry : map.entrySet()) {
            ISharingDescriptor iSharingDescriptor = ((IShare)entry.getKey()).getSharingDescriptor();
            String string = iSharingDescriptor.getRepositoryUri();
            WorkspaceComponentGrouping workspaceComponentGrouping = (WorkspaceComponentGrouping)hashMap.get(string);
            if (workspaceComponentGrouping == null) {
                IWorkspaceConnection iWorkspaceConnection2;
                if (!iSharingDescriptor.associatedWithWorkspace()) {
                    throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.RepoUtil_46, (Object)iSharingDescriptor.getRepositoryUri(), (Object)iSharingDescriptor.getConnectionName()));
                }
                IContextHandle iContextHandle = iSharingDescriptor.getConnectionHandle();
                try {
                    iWorkspaceConnection2 = SCMPlatform.getWorkspaceManager((ITeamRepository)iWorkspaceConnection.teamRepository()).getWorkspaceConnection((IWorkspaceHandle)iContextHandle, null);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_47, (Object)iWorkspaceConnection.teamRepository().getRepositoryURI(), (Object)iSharingDescriptor.getConnectionName()), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
                }
                LinkedList linkedList = new LinkedList();
                workspaceComponentGrouping = new WorkspaceComponentGrouping(iWorkspaceConnection2, linkedList, iClientConfiguration);
                hashMap.put(string, workspaceComponentGrouping);
            }
            workspaceComponentGrouping.addComponent(iSharingDescriptor.getComponent());
        }
        return hashMap.values();
    }

    public static Map groupChangeSetsByComponent(IWorkspaceConnection iWorkspaceConnection, List list, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        List list2;
        try {
            list2 = iWorkspaceConnection.teamRepository().itemManager().fetchPartialItems(list, 0, (Collection)Collections.singletonList(IChangeSet.COMPONENT_PROPERTY), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_49, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        HashMap<ItemId, LinkedList<IChangeSet>> hashMap = new HashMap<ItemId, LinkedList<IChangeSet>>();
        for (IChangeSet iChangeSet : list2) {
            ItemId itemId = new ItemId((IItemHandle)iChangeSet.getComponent());
            LinkedList<IChangeSet> linkedList = (LinkedList<IChangeSet>)hashMap.get(itemId);
            if (linkedList == null) {
                linkedList = new LinkedList<IChangeSet>();
                hashMap.put(itemId, linkedList);
            }
            linkedList.add(iChangeSet);
        }
        return hashMap;
    }

    public static Map groupShareablesByWorkspaceConnection(IClientConfiguration iClientConfiguration, List list) throws FileSystemClientException {
        ChattyRepoRunnable chattyRepoRunnable = new ChattyRepoRunnable(iClientConfiguration);
        HashMap<IWorkspaceConnection, ArrayList<IShareable>> hashMap = new HashMap<IWorkspaceConnection, ArrayList<IShareable>>();
        HashMap<UUID, IWorkspaceConnection> hashMap2 = new HashMap<UUID, IWorkspaceConnection>();
        for (IShareable iShareable : list) {
            IShare iShare = iShareable.getShare(null);
            if (iShare == null) {
                throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandUtil_10, (Object)iShareable.getLocalPath()));
            }
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            IContextHandle iContextHandle = iSharingDescriptor.getConnectionHandle();
            if (iContextHandle instanceof IWorkspaceHandle) {
                ArrayList<IShareable> arrayList;
                IWorkspaceHandle iWorkspaceHandle = (IWorkspaceHandle)iContextHandle;
                IWorkspaceConnection iWorkspaceConnection = (IWorkspaceConnection)hashMap2.get(iWorkspaceHandle.getItemId());
                if (iWorkspaceConnection == null) {
                    iWorkspaceConnection = chattyRepoRunnable.connect(iSharingDescriptor.getRepositoryUri(), iWorkspaceHandle);
                    if (chattyRepoRunnable.hadLoginFailure) {
                        throw (Throwable)StatusHelper.login();
                    }
                    hashMap2.put(iWorkspaceHandle.getItemId(), iWorkspaceConnection);
                }
                if ((arrayList = (ArrayList<IShareable>)hashMap.get(iWorkspaceConnection)) == null) {
                    arrayList = new ArrayList<IShareable>();
                    hashMap.put(iWorkspaceConnection, arrayList);
                }
                arrayList.add(iShareable);
                continue;
            }
            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.RepoUtil_WORKSPACE_HANDLE_REQUIRED, (Object)iShare.getPath(), (Object)iContextHandle.toString()));
        }
        return hashMap;
    }

    public static List getWorkspaceConnections(ICopyFileAreaView iCopyFileAreaView, boolean bl) throws FileSystemClientException {
        IClientConfiguration iClientConfiguration = CommandLineCore.getConfig();
        LinkedList<IWorkspaceConnection> linkedList = new LinkedList<IWorkspaceConnection>();
        Collection collection = iCopyFileAreaView.getLoadedWorkspaces();
        try {
            for (ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView : collection) {
                ConnectionInfo connectionInfo = iClientConfiguration.getConnectionInfo(iCopyFileAreaView$IRepoView.getURI());
                ITeamRepository iTeamRepository = RepoUtil.login(iClientConfiguration, connectionInfo);
                IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
                IWorkspaceConnection iWorkspaceConnection = iWorkspaceManager.getWorkspaceConnection(iCopyFileAreaView$IRepoView.getHandle(), null);
                linkedList.add(iWorkspaceConnection);
                iWorkspaceConnection.refresh(null);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_78, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        if (bl) {
            LocalChangeManager.getInstance().refreshChanges(iCopyFileAreaView.getLoadedShares(), ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, null);
        }
        return linkedList;
    }

    public static IWorkspaceConnection findWorkspaceConnection(IClientConfiguration iClientConfiguration, String string, String string2) throws FileSystemClientException {
        IWorkspaceConnection iWorkspaceConnection;
        if (string != null && string2 == null) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_119);
        }
        ITeamRepository iTeamRepository = null;
        if (string == null) {
            iWorkspaceConnection = RepoUtil.findWorkspaceConnectionByCFA(iClientConfiguration);
            if (string2 == null) {
                return iWorkspaceConnection;
            }
            UUID uUID = RepoUtil.lookupUuid(string2);
            IWorkspace iWorkspace = iWorkspaceConnection.getResolvedWorkspace();
            if (uUID != null && iWorkspace.getItemId().equals((Object)uUID) || iWorkspace.getName().equals(string2)) {
                return iWorkspaceConnection;
            }
            iTeamRepository = iWorkspaceConnection.teamRepository();
        } else {
            iTeamRepository = RepoUtil.login(iClientConfiguration, iClientConfiguration.getConnectionInfo(string, CommonOptions.OPT_URI, CommonOptions.OPT_USERNAME, CommonOptions.OPT_PASSWORD));
        }
        try {
            iWorkspaceConnection = RepoUtil.findNamedWorkspace(string2, true, false, iTeamRepository, iClientConfiguration);
        }
        catch (RepoUtil$UnmatchedSelectorException repoUtil$UnmatchedSelectorException) {
            SubcommandUtil.displaySelectorException(repoUtil$UnmatchedSelectorException, iClientConfiguration);
            throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_120, (Object)string2));
        }
        catch (RepoUtil$AmbiguousSelectorException repoUtil$AmbiguousSelectorException) {
            SubcommandUtil.displaySelectorException(repoUtil$AmbiguousSelectorException, iClientConfiguration);
            throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_121, (Object)string2));
        }
        try {
            return SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getWorkspaceConnection((IWorkspaceHandle)iWorkspaceConnection, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoUtil_122, (Object)string2), teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
    }

    public static IWorkspaceConnection findWorkspaceConnectionByCFA(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        ICopyFileAreaView iCopyFileAreaView = SubcommandUtil.getAffectedComponentsAndShares(iClientConfiguration);
        ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView = null;
        Collection collection = iCopyFileAreaView.getLoadedWorkspaces();
        if (collection.size() < 1) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_123);
        }
        if (collection.size() > 1) {
            throw (Throwable)StatusHelper.argSyntax(Messages.RepoUtil_124);
        }
        iCopyFileAreaView$IRepoView = (ICopyFileAreaView$IRepoView)iCopyFileAreaView.getLoadedWorkspaces().iterator().next();
        ITeamRepository iTeamRepository = RepoUtil.login(iClientConfiguration, iClientConfiguration.getConnectionInfo(iCopyFileAreaView$IRepoView.getURI()));
        IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository);
        try {
            return iWorkspaceManager.getWorkspaceConnection(iCopyFileAreaView$IRepoView.getHandle(), null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_125, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
    }

    public static IWorkItemHandle findWorkItem(ITeamRepository iTeamRepository, String string, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$SelectorException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n <= 0) {
            return null;
        }
        return RepoUtil.findWorkitem(iTeamRepository, n, iClientConfiguration);
    }

    public static IWorkItemHandle findWorkitem(ITeamRepository iTeamRepository, int n, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$SelectorException {
        List list;
        Object object = BaseWorkItemQueryModel.WorkItemQueryModel.ROOT;
        IItemQuery iItemQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)object);
        IPredicate iPredicate = object.id()._eq((Number)n);
        iItemQuery.filter(iPredicate);
        try {
            list = SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).findItems(iItemQuery, new Object[0]);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_146, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        if (list.size() == 0) {
            throw (Throwable)StatusHelper.ambiguousSelector(NLS.bind((String)Messages.RepoUtil_167, (Object)n));
        }
        if (list.size() > 1) {
            try {
                object = iTeamRepository.itemManager().fetchCompleteItems(list, 0, null);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_10, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
            }
            throw (Throwable)new RepoUtil$AmbiguousSelectorException(RepoUtil$SelectorException$Type.WORKITEM, Integer.toString(n), (List)object, (List)object);
        }
        return (IWorkItemHandle)list.get(0);
    }

    public static IComponent findNamedComponent(String string, IWorkspaceConnection iWorkspaceConnection, boolean bl, IClientConfiguration iClientConfiguration) throws FileSystemClientException, RepoUtil$UnmatchedSelectorException, RepoUtil$AmbiguousSelectorException {
        List list;
        try {
            list = iWorkspaceConnection.teamRepository().itemManager().fetchCompleteItems(iWorkspaceConnection.getComponents(), 0, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            throw (Throwable)StatusHelper.wrap(Messages.RepoUtil_UNABLE_TO_QUERY_COMPONENT_LIST, teamRepositoryException, new IndentingPrintStream(iClientConfiguration.getContext().stderr()));
        }
        return RepoUtil.findNamedComponent(string, list, bl);
    }

    private static List purgeNullItems(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (Object e : list) {
            if (e == null) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    private static List fetchItems(ITeamRepository iTeamRepository, List list) throws TeamRepositoryException {
        List list2 = iTeamRepository.itemManager().fetchCompleteItems(list, 0, null);
        return RepoUtil.purgeNullItems(list2);
    }
}

