/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.subcommands.IApplicationEndListener;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$TripListener$ClassNameComparator;
import com.ibm.team.filesystem.cli.core.util.RepoUtil$TripListener$MethodNameComparator;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.StringUtil$PaddingInstruction;
import com.ibm.team.filesystem.client.internal.MetronomeModel;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class RepoUtil$TripListener
implements IApplicationEndListener,
IListener {
    private ITeamRepository repo;
    private int methodCount = 0;
    private Map serviceMap;

    public RepoUtil$TripListener(ITeamRepository iTeamRepository) {
        this.repo = iTeamRepository;
        this.serviceMap = new HashMap();
        this.repo.statistics().addGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
        MetronomeModel metronomeModel = MetronomeModel.getInstance();
        metronomeModel.addedRepository(iTeamRepository);
        metronomeModel.resetServiceMethodStats(this.repo.statistics());
    }

    public void run(IClientConfiguration iClientConfiguration) {
        PrintStream printStream = iClientConfiguration.getContext().stderr();
        printStream.println("Service Trip Statistics:");
        IStatistics iStatistics = this.repo.statistics();
        iStatistics.purgeGenericListener((IListener)this);
        MetronomeModel metronomeModel = MetronomeModel.getInstance();
        TreeSet treeSet = new TreeSet(new RepoUtil$TripListener$ClassNameComparator(null));
        treeSet.addAll(this.serviceMap.keySet());
        ArrayList arrayList = new ArrayList(this.serviceMap.size() * 8);
        Collections.addAll(arrayList, "Interface/method", "Calls", "Time");
        long l = 0L;
        for (Class clazz : treeSet) {
            Object object2;
            String string = clazz.getName();
            String string2 = string.substring(string.lastIndexOf(46) + 1);
            int n = 0;
            long l2 = 0L;
            for (Object object2 : (Set)this.serviceMap.get(clazz)) {
                n = (int)((long)n + metronomeModel.getMethodCallCount(iStatistics, clazz, (Method)object2));
                l2 += metronomeModel.getMethodElapsedTime(iStatistics, clazz, (Method)object2);
            }
            l += l2;
            Collections.addAll(arrayList, "  " + string2, Integer.toString(n), String.valueOf(l2) + "ms");
            object2 = new TreeSet(new RepoUtil$TripListener$MethodNameComparator());
            ((TreeSet)object2).addAll((Collection)this.serviceMap.get(clazz));
            Iterator iterator = ((TreeSet)object2).iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                Collections.addAll(arrayList, "    " + method.getName(), Long.toString(metronomeModel.getMethodCallCount(iStatistics, clazz, method)), " " + metronomeModel.getMethodElapsedTime(iStatistics, clazz, method) + "ms");
            }
        }
        StringUtil.printTable(new IndentingPrintStream(printStream), new StringUtil$PaddingInstruction[]{StringUtil$PaddingInstruction.LEFT_WITH_ALTERNATING_DOTS, StringUtil$PaddingInstruction.RIGHT_WITH_SPACE, StringUtil$PaddingInstruction.RIGHT_WITH_SPACE}, arrayList.toArray(new String[arrayList.size()]));
        printStream.println("-- Total time in service calls: " + l + "ms");
    }

    public void handleEvents(List list) {
        for (Object e : list) {
            IPropertyChangeEvent iPropertyChangeEvent = (IPropertyChangeEvent)e;
            Object object = iPropertyChangeEvent.getObject();
            if (!(object instanceof Method)) continue;
            Method method = (Method)object;
            Class<?> clazz = method.getDeclaringClass();
            if (!this.serviceMap.containsKey(clazz)) {
                this.serviceMap.put(clazz, new HashSet());
                ++this.methodCount;
            }
            ((Set)this.serviceMap.get(clazz)).add(method);
        }
    }
}

