/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.util;

import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.CopyFileAreaView$1;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView$IRepoRunnable;
import com.ibm.team.filesystem.cli.core.util.ICopyFileAreaView$IRepoView;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class CopyFileAreaView
implements ICopyFileAreaView {
    private final IClientConfiguration config;
    private final ISandbox root;
    private final IPath cwd;
    private final boolean isScoped;
    private final Map comp2share;
    private final Map ws2comp;
    private IShare[] allShares = null;

    protected CopyFileAreaView(IClientConfiguration iClientConfiguration, ISandbox iSandbox, IPath iPath, boolean bl, Map map, Map map2, IShare[] iShareArray) {
        this.config = iClientConfiguration;
        this.root = iSandbox;
        this.cwd = iPath;
        this.isScoped = bl;
        this.ws2comp = map;
        this.comp2share = map2;
        this.allShares = iShareArray;
    }

    public ISandbox getRoot() {
        return this.root;
    }

    public boolean isScoped() {
        return this.isScoped;
    }

    public Iterable getLoadedShares(ItemId itemId) {
        return (Iterable)this.comp2share.get(itemId);
    }

    public Collection getLoadedWorkspaces() {
        return this.ws2comp.keySet();
    }

    public Collection getLoadedComponents(ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView) {
        return (Collection)this.ws2comp.get(iCopyFileAreaView$IRepoView);
    }

    public IShare[] getLoadedShares() {
        if (this.allShares == null) {
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : this.comp2share.entrySet()) {
                hashSet.addAll((Collection)entry.getValue());
            }
            this.allShares = hashSet.toArray(new IShare[hashSet.size()]);
        }
        return this.allShares;
    }

    public IShare[] getLoadedShares(ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView, ItemId itemId) {
        Collection collection = (Collection)this.comp2share.get(itemId);
        return collection.toArray(new IShare[collection.size()]);
    }

    public void runOnEachRepo(ICopyFileAreaView$IRepoRunnable iCopyFileAreaView$IRepoRunnable, IClientConfiguration iClientConfiguration, IOptionKey iOptionKey, IOptionKey iOptionKey2) throws FileSystemClientException {
        LinkedList linkedList = new LinkedList();
        Collection collection = this.getLoadedWorkspaces();
        for (ICopyFileAreaView$IRepoView iCopyFileAreaView$IRepoView : collection) {
            IWorkspaceConnection iWorkspaceConnection = iCopyFileAreaView$IRepoRunnable.connect(iCopyFileAreaView$IRepoView.getURI(), iCopyFileAreaView$IRepoView.getHandle());
            if (iWorkspaceConnection == null) continue;
            iCopyFileAreaView$IRepoRunnable.run(this, iCopyFileAreaView$IRepoView, iWorkspaceConnection);
        }
        if (linkedList.size() > 0) {
            throw (Throwable)StatusHelper.internalError(Messages.CopyFileAreaView_0, linkedList);
        }
    }

    public IShareable findShareable(String string) throws FileSystemClientException {
        IPath iPath = SubcommandUtil.makeAbsolutePath(this.config, string);
        return FileSystemCore.getSharingManager().findShareable(iPath, iPath.toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE);
    }

    public List findActiveChangesetsModifying(List list) throws FileSystemClientException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ISharingDescriptor iSharingDescriptor;
        Object object52;
        ArrayList<IComponentHandle> arrayList = new ArrayList<IComponentHandle>(list.size());
        ArrayList<IWorkspaceConnection> arrayList2 = new ArrayList<IWorkspaceConnection>(list.size());
        HashMap<UUID, IWorkspaceConnection> hashMap = new HashMap<UUID, IWorkspaceConnection>();
        for (Object object52 : list) {
            IShare iShare = object52.getShare(null);
            if (iShare == null) {
                arrayList.add(null);
                arrayList2.add(null);
                continue;
            }
            iSharingDescriptor = iShare.getSharingDescriptor();
            if (!iSharingDescriptor.associatedWithWorkspace()) {
                throw (Throwable)StatusHelper.disallowed(Messages.CopyFileAreaView_2);
            }
            arrayList.add(iSharingDescriptor.getComponent());
            object4 = (IWorkspaceHandle)iSharingDescriptor.getConnectionHandle();
            object3 = (IWorkspaceConnection)hashMap.get(object4.getItemId());
            if (object3 == null) {
                object2 = this.config.getConnectionInfo(iSharingDescriptor.getRepositoryUri());
                object = RepoUtil.login(this.config, (ConnectionInfo)object2);
                IWorkspaceManager iWorkspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)object);
                try {
                    object3 = iWorkspaceManager.getWorkspaceConnection((IWorkspaceHandle)object4, null);
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    throw (Throwable)StatusHelper.wrap(NLS.bind((String)Messages.RepoRunnable_0, (Object)((ConnectionInfo)object2).getURI(), (Object)((ConnectionInfo)object2).getUsername()), teamRepositoryException, new IndentingPrintStream(this.config.getContext().stderr()));
                }
                hashMap.put(object4.getItemId(), (IWorkspaceConnection)object3);
            }
            arrayList2.add((IWorkspaceConnection)object3);
            if ($assertionsDisabled || arrayList.size() == arrayList2.size()) continue;
            throw (Throwable)((Object)new AssertionError());
        }
        if (!$assertionsDisabled && arrayList.size() != list.size()) {
            throw (Throwable)((Object)new AssertionError());
        }
        if (!$assertionsDisabled && arrayList2.size() != list.size()) {
            throw (Throwable)((Object)new AssertionError());
        }
        object52 = new ArrayList(list.size());
        HashMap hashMap2 = new HashMap();
        int n = 0;
        while (n < list.size()) {
            block17: {
                if (arrayList2.get(n) == null) {
                    object52.add(null);
                } else {
                    iSharingDescriptor = ((IWorkspaceConnection)arrayList2.get(n)).getContextHandle().getItemId();
                    object4 = (List)hashMap2.get(iSharingDescriptor);
                    if (object4 == null) {
                        object3 = ((IWorkspaceConnection)arrayList2.get(n)).activeChangeSets();
                        try {
                            object4 = ((IWorkspaceConnection)arrayList2.get(n)).teamRepository().itemManager().fetchCompleteItems((List)object3, 0, null);
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            throw (Throwable)StatusHelper.wrap(Messages.CopyFileAreaView_4, teamRepositoryException, new IndentingPrintStream(this.config.getContext().stderr()));
                        }
                        hashMap2.put(iSharingDescriptor, object4);
                    }
                    object2 = object4.iterator();
                    while (object2.hasNext()) {
                        object3 = (IChangeSet)object2.next();
                        object = object3.changes();
                        int n2 = n;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            IChange iChange = (IChange)iterator.next();
                            if (!iChange.item().sameItemId((IItemHandle)((IShareable)list.get(n)).getVersionable(null))) continue;
                            object52.add(new CopyFileAreaView$1(this, (IChangeSet)object3, arrayList2, n2));
                            break block17;
                        }
                    }
                    object52.add(null);
                }
            }
            ++n;
        }
        if (!$assertionsDisabled && object52.size() != list.size()) {
            throw (Throwable)((Object)new AssertionError());
        }
        return (List)object52;
    }
}

