/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal.subcommands;

import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionCmd
implements ISubcommand,
IOptionSource {
    @Override
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.VersionCmd_0);
        return options.addOption(CommonOptions.OPT_VERSION, CommonOptions.OPT_VERSION_HELP);
    }

    @Override
    public void run(IClientConfiguration config) throws FileSystemClientException {
        HashMap<String, ArrayList<ISubcommandDefinition>> grouped = new HashMap<String, ArrayList<ISubcommandDefinition>>();
        for (ISubcommandDefinition defn : config.getSubcommandDefinitions()) {
            ArrayList<ISubcommandDefinition> list = (ArrayList<ISubcommandDefinition>)grouped.get(defn.getModuleName());
            if (list == null) {
                list = new ArrayList<ISubcommandDefinition>();
                grouped.put(defn.getModuleName(), list);
            }
            list.add(defn);
        }
        boolean writtenOut = false;
        for (Map.Entry entry : grouped.entrySet()) {
            if (writtenOut) {
                config.getContext().stdout().println();
            }
            writtenOut = true;
            this.showVersion((String)entry.getKey(), (List)entry.getValue(), config);
        }
    }

    private void showVersion(String bundleName, List<ISubcommandDefinition> defns, IClientConfiguration config) {
        Bundle bundle = Platform.getBundle((String)bundleName);
        String version = Messages.VersionCmd_2;
        Dictionary headers = bundle.getHeaders();
        Enumeration i = headers.keys();
        while (i.hasMoreElements()) {
            String candidate = (String)i.nextElement();
            if (!"bundle-version".equals(candidate.toLowerCase())) continue;
            version = (String)headers.get(candidate);
            break;
        }
        config.getContext().stdout().println(NLS.bind((String)Messages.VersionCmd_3, (Object)bundle.getSymbolicName(), (Object)version));
        StringBuffer buf = new StringBuffer();
        for (ISubcommandDefinition defn : defns) {
            if (buf.length() > 0) {
                buf.append(Messages.VersionCmd_4);
            }
            for (ISubcommandDefinition ancestor : defn.getAncestors()) {
                buf.append(ancestor.getFullSubcommandName());
                buf.append('/');
            }
            buf.append(defn.getFullSubcommandName());
        }
        config.getContext().stdout().println("  " + NLS.bind((String)Messages.VersionCmd_5, (Object)buf));
    }
}

