/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal.subcommands;

import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.PositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.subcommands.HelpCmd$NamedOptionComparator;
import com.ibm.team.filesystem.cli.core.internal.subcommands.HelpCmd$SubcommandNameCompator;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadOptionsException;
import com.ibm.team.filesystem.cli.core.util.IndentingPrintStream;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class HelpCmd
implements ISubcommand,
IOptionSource {
    public static final String NO_HELP_STRING = Messages.HelpCmd_0;
    public static PositionalOptionDefinition OPT_SUBCOMMAND_NAME = new PositionalOptionDefinition("subcmd", 0, -1);
    public static NamedOptionDefinition OPT_ALL = new NamedOptionDefinition(null, "all", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.setLongHelp(Messages.HelpCmd_1);
        options.addOption(OPT_SUBCOMMAND_NAME, Messages.HelpCmd_2).addOption(OPT_ALL, Messages.HelpCmd_3);
        return options;
    }

    public void run(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        ICommandLine iCommandLine = iClientConfiguration.getSubcommandCommandLine();
        if (iCommandLine != null && iCommandLine.hasOption(OPT_ALL)) {
            this.showAllSubcommands(iClientConfiguration);
        } else if (iCommandLine == null || !iCommandLine.hasOption(OPT_SUBCOMMAND_NAME)) {
            this.showSubcommandListing(iClientConfiguration);
        } else {
            this.showSubCommand(iCommandLine.getOptions(OPT_SUBCOMMAND_NAME), iClientConfiguration);
        }
    }

    private void showSubcommandListing(IClientConfiguration iClientConfiguration) {
        Options options = iClientConfiguration.getCommandLine().getDefinition();
        iClientConfiguration.getContext().stdout().print(NLS.bind((String)Messages.HelpCmd_4, (Object)iClientConfiguration.getContext().getAppName()));
        this.showUsage(options, iClientConfiguration);
        iClientConfiguration.getContext().stdout().println();
        ArrayList arrayList = new ArrayList(iClientConfiguration.getSubcommandDefinitions());
        Collections.sort(arrayList, new HelpCmd$SubcommandNameCompator());
        IndentingPrintStream indentingPrintStream = new IndentingPrintStream(iClientConfiguration.getContext().stdout());
        indentingPrintStream.println(Messages.HelpCmd_5);
        indentingPrintStream = indentingPrintStream.indent();
        for (ISubcommandDefinition iSubcommandDefinition : arrayList) {
            if (!iSubcommandDefinition.showInHelpListing() || iSubcommandDefinition.getParentId() != null) continue;
            indentingPrintStream.println(NLS.bind((String)Messages.HelpCmd_6, (Object)iSubcommandDefinition.getFullSubcommandName(), (Object)iSubcommandDefinition.getShortHelp()));
            if (!iSubcommandDefinition.isParent()) continue;
            IndentingPrintStream indentingPrintStream2 = indentingPrintStream.indent();
            ArrayList arrayList2 = new ArrayList(iSubcommandDefinition.getChildren());
            Collections.sort(arrayList2, new HelpCmd$SubcommandNameCompator());
            StringBuffer stringBuffer = new StringBuffer();
            for (ISubcommandDefinition iSubcommandDefinition2 : arrayList2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(Messages.HelpCmd_7);
                }
                stringBuffer.append(iSubcommandDefinition2.getFullSubcommandName());
            }
            indentingPrintStream2.println(String.valueOf(Messages.HelpCmd_8) + stringBuffer);
        }
    }

    private void showUsage(Options options, IClientConfiguration iClientConfiguration) {
        Object object2;
        IndentingPrintStream indentingPrintStream = new IndentingPrintStream(iClientConfiguration.getContext().stdout());
        if (options.getNamedOptions().size() > 0) {
            indentingPrintStream.print(Messages.HelpCmd_29);
        }
        for (Object object2 : options.getPositionalOptions()) {
            boolean bl;
            boolean bl2 = bl = object2.getMinCount() > 0;
            if (bl) {
                indentingPrintStream.print("<");
            } else {
                indentingPrintStream.print("[");
            }
            indentingPrintStream.print(object2.getName());
            if (object2.getMaxCount() == -1) {
                indentingPrintStream.print("...");
            }
            if (bl) {
                indentingPrintStream.print(">");
            } else {
                indentingPrintStream.print("]");
            }
            indentingPrintStream.print(" ");
        }
        indentingPrintStream.println();
        object2 = indentingPrintStream.indent();
        int n = 0;
        for (IPositionalOptionDefinition iPositionalOptionDefinition : options.getPositionalOptions()) {
            n = Math.max(n, iPositionalOptionDefinition.getName().length());
        }
        for (IPositionalOptionDefinition iPositionalOptionDefinition : options.getPositionalOptions()) {
            ((IndentingPrintStream)object2).println(StringUtil.pad(iPositionalOptionDefinition.getName(), n) + NLS.bind((String)Messages.HelpCmd_30, (Object)options.getHelpFor(iPositionalOptionDefinition.getId())));
        }
        if (options.getNamedOptions().size() > 0) {
            indentingPrintStream.println();
            indentingPrintStream.print(Messages.HelpCmd_31);
            indentingPrintStream.println();
        }
        indentingPrintStream = indentingPrintStream.indent();
        object2 = new HashMap<Object, StringBuffer>();
        n = 0;
        ArrayList arrayList = new ArrayList(options.getNamedOptions());
        Collections.sort(arrayList, new HelpCmd$NamedOptionComparator(null));
        for (Object object3 : arrayList) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (object3.getShortOpt() != null) {
                stringBuffer.append("-" + object3.getShortOpt());
                bl = true;
            }
            if (object3.getLongOpt() != null) {
                if (bl) {
                    stringBuffer.append(" ");
                }
                if (bl) {
                    stringBuffer.append("[");
                }
                stringBuffer.append("--" + object3.getLongOpt());
                if (bl) {
                    stringBuffer.append("]");
                }
            }
            if (object3.getArgCount() == -1) {
                stringBuffer.append(" ...");
            } else {
                int n2 = object3.getArgCount();
                while (n2 > 0) {
                    stringBuffer.append(Messages.HelpCmd_32);
                    --n2;
                }
            }
            ((HashMap)object2).put(object3, stringBuffer);
            n = Math.max(n, stringBuffer.length());
        }
        n += 2;
        for (Object object3 : arrayList) {
            indentingPrintStream.printIndent();
            indentingPrintStream.print(NLS.bind((String)Messages.HelpCmd_33, (Object)StringUtil.pad((CharSequence)((HashMap)object2).get(object3), n), (Object)options.getHelpFor(object3.getId())));
            indentingPrintStream.println();
        }
    }

    private void showAllSubcommands(IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        Collection collection = iClientConfiguration.getSubcommandDefinitions();
        LinkedList<FileSystemClientException> linkedList = new LinkedList<FileSystemClientException>();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (ISubcommandDefinition iSubcommandDefinition : collection) {
            if (!iSubcommandDefinition.showInHelpListing()) continue;
            if (!bl) {
                iClientConfiguration.getContext().stdout().println();
                iClientConfiguration.getContext().stdout().println();
            }
            bl = false;
            try {
                this.showSubcommand(iClientConfiguration, Collections.singletonList(iSubcommandDefinition.getFullSubcommandName()), iSubcommandDefinition);
            }
            catch (FileSystemClientException fileSystemClientException) {
                iClientConfiguration.getContext().stderr().println(NLS.bind((String)Messages.HelpCmd_9, (Object)iSubcommandDefinition.getFullSubcommandName()));
                linkedList.add(fileSystemClientException);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(Messages.HelpCmd_10);
                }
                stringBuffer.append(iSubcommandDefinition.getFullSubcommandName());
            }
        }
        if (linkedList.size() > 0) {
            throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.HelpCmd_11, (Object)stringBuffer.toString()), linkedList);
        }
    }

    private void showSubCommand(List list, IClientConfiguration iClientConfiguration) throws FileSystemClientException {
        String string = (String)list.get(0);
        ISubcommandDefinition iSubcommandDefinition = iClientConfiguration.getSubcommandDefinition();
        ISubcommandDefinition iSubcommandDefinition2 = iSubcommandDefinition.getLoader().loadToplevel(string);
        if (iSubcommandDefinition2 == null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_12, (Object)string));
        }
        if (iSubcommandDefinition2.getParentId() != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (ISubcommandDefinition iSubcommandDefinition3 : iSubcommandDefinition2.getAncestors()) {
                stringBuffer.append(iSubcommandDefinition3.getFullSubcommandName());
                stringBuffer.append(Messages.HelpCmd_13);
            }
            stringBuffer.append(string);
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_14, (Object[])new Object[]{string, iClientConfiguration.getContext().getAppName(), stringBuffer}));
        }
        ISubcommandDefinition iSubcommandDefinition4 = iSubcommandDefinition2;
        int n = 1;
        while (n < list.size()) {
            try {
                iSubcommandDefinition4 = iSubcommandDefinition2.getChild((String)list.get(n));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.HelpCmd_15, list.get(n)));
            }
            ++n;
        }
        this.showSubcommand(iClientConfiguration, list, iSubcommandDefinition4);
    }

    private void showSubcommand(IClientConfiguration iClientConfiguration, List list, ISubcommandDefinition iSubcommandDefinition) throws FileSystemClientException {
        ArrayList arrayList;
        String[] stringArray;
        Options options;
        String string = (String)list.get(list.size() - 1);
        try {
            options = iSubcommandDefinition.getOptions();
        }
        catch (ISubcommandDefinition$LoadOptionsException iSubcommandDefinition$LoadOptionsException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.HelpCmd_16, (Object)string, (Object)iSubcommandDefinition$LoadOptionsException.getCause().getMessage()), iSubcommandDefinition$LoadOptionsException);
        }
        catch (ConflictingOptionException conflictingOptionException) {
            throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.HelpCmd_17, (Object)string, (Object)conflictingOptionException.getMessage()), conflictingOptionException);
        }
        Object object = iSubcommandDefinition.getAncestors();
        iClientConfiguration.getContext().stdout().print(Messages.HelpCmd_19);
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            stringArray = (String[])object2.next();
            iClientConfiguration.getContext().stdout().print(String.valueOf(stringArray.getFullSubcommandName()) + Messages.HelpCmd_20);
        }
        iClientConfiguration.getContext().stdout().print(iSubcommandDefinition.getFullSubcommandName());
        iClientConfiguration.getContext().stdout().println();
        object = options.getLongHelp();
        if (object == null) {
            iClientConfiguration.getContext().stdout().println(NO_HELP_STRING);
        } else {
            iClientConfiguration.getContext().stdout().println((String)object);
        }
        iClientConfiguration.getContext().stdout().println();
        stringArray = iSubcommandDefinition.getAliases();
        if (stringArray.length > 0) {
            iClientConfiguration.getContext().stdout().print(Messages.HelpCmd_21);
            boolean bl = false;
            Object object3 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                arrayList = object3[n2];
                if (bl) {
                    iClientConfiguration.getContext().stdout().print(Messages.HelpCmd_22);
                }
                bl = true;
                iClientConfiguration.getContext().stdout().print((String)((Object)arrayList));
                ++n2;
            }
            iClientConfiguration.getContext().stdout().println();
            iClientConfiguration.getContext().stdout().println();
        }
        iClientConfiguration.getContext().stdout().print(NLS.bind((String)Messages.HelpCmd_23, (Object)iClientConfiguration.getContext().getAppName()));
        object2 = iSubcommandDefinition.getAncestors();
        object2.add(iSubcommandDefinition);
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            arrayList = (ISubcommandDefinition)iterator.next();
            iClientConfiguration.getContext().stdout().print(String.valueOf(arrayList.getFullSubcommandName()) + Messages.HelpCmd_24);
        }
        if (iSubcommandDefinition.isParent()) {
            arrayList = new ArrayList(iSubcommandDefinition.getChildren());
            Collections.sort(arrayList, new HelpCmd$SubcommandNameCompator());
            iClientConfiguration.getContext().stdout().print('<');
            boolean bl = false;
            for (ISubcommandDefinition iSubcommandDefinition2 : arrayList) {
                if (bl) {
                    iClientConfiguration.getContext().stdout().print('|');
                }
                bl = true;
                iClientConfiguration.getContext().stdout().print(iSubcommandDefinition2.getFullSubcommandName());
            }
            iClientConfiguration.getContext().stdout().println(Messages.HelpCmd_25);
            iClientConfiguration.getContext().stdout().println(Messages.HelpCmd_26);
            IndentingPrintStream indentingPrintStream = new IndentingPrintStream(iClientConfiguration.getContext().stdout()).indent();
            for (Object object3 : arrayList) {
                indentingPrintStream.println(NLS.bind((String)Messages.HelpCmd_27, (Object)object3.getFullSubcommandName(), (Object)object3.getShortHelp()));
            }
            iClientConfiguration.getContext().stdout().println(NLS.bind((String)Messages.HelpCmd_28, (Object)iClientConfiguration.getContext().getAppName(), (Object)iSubcommandDefinition.getFullSubcommandName()));
        } else {
            this.showUsage(options, iClientConfiguration);
        }
    }
}

