/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal.aliases;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.aliases.AliasComparator;
import com.ibm.team.filesystem.cli.core.internal.aliases.AliasLoader;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAlias;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAliasRegistry$1;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$IUuidAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry$NoSuchAliasException;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.repository.common.UUID;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class UuidAliasRegistry
implements IUuidAliasRegistry {
    public static char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static int WIDTH = 4;
    public static char UNUSABLE_CHAR = (char)45;
    private int cacheSize = 3000;
    private int maxCacheSize;
    private final File file;
    private long lastAllocated = (long)Math.pow(ALPHABET.length, WIDTH - 1);
    private long lastRun;
    private long lowestLastRun = Long.MAX_VALUE;
    private boolean loaded = false;
    private HashMap uuidMap = new HashMap();
    private HashMap nameMap = new HashMap();
    private final SortedSet sorted = new TreeSet(new AliasComparator());
    private FilesystemLock lock = null;
    private static final String ALIASES_FILE_LOCK = "aliases.lck";
    private static final long LOCK_WAIT = 20000L;
    private long aliasFileLastModTime = 0L;
    private long aliasesGeneratedInCurrentRun = 0L;

    static {
        if (!$assertionsDisabled && new String(ALPHABET).contains(new String(new char[]{UNUSABLE_CHAR}))) {
            throw (Throwable)((Object)new AssertionError());
        }
    }

    public UuidAliasRegistry(File file, int n) {
        this.file = file;
        this.setCacheSize(n);
        if (file != null) {
            this.lock = new FilesystemLock(new File(file.getParentFile(), ALIASES_FILE_LOCK));
        }
    }

    public IUuidAliasRegistry$IUuidAlias findAliasByUuid(String string) throws IUuidAliasRegistry$NoSuchAliasException {
        return this.findAliasByUuid(UUID.valueOf((String)string));
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
        this.maxCacheSize = (int)Math.pow(ALPHABET.length, WIDTH);
    }

    public long getLastAllocated() {
        return this.lastAllocated;
    }

    public void setLastAllocated(long l) {
        this.lastAllocated = l;
    }

    public void setLastRun(long l) {
        this.lastRun = l + 1L;
    }

    static /* synthetic */ long access$0(UuidAliasRegistry uuidAliasRegistry) {
        return uuidAliasRegistry.lastRun;
    }

    static /* synthetic */ long access$1(UuidAliasRegistry uuidAliasRegistry) {
        return uuidAliasRegistry.lowestLastRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard(IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias) {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            if (!this.lock.acquire(20000L, null)) {
                throw (Throwable)new IllegalStateException("Could not acquire lock");
            }
            try {
                this.load();
                IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias2 = (IUuidAliasRegistry$IUuidAlias)this.uuidMap.remove(iUuidAliasRegistry$IUuidAlias.getUuid());
                IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias3 = (IUuidAliasRegistry$IUuidAlias)this.nameMap.remove(iUuidAliasRegistry$IUuidAlias.getMonicker());
                boolean bl = this.sorted.remove(iUuidAliasRegistry$IUuidAlias);
                if (iUuidAliasRegistry$IUuidAlias2 != null || iUuidAliasRegistry$IUuidAlias3 != null || bl) {
                    this.save();
                }
            }
            finally {
                this.lock.release(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        if (this.loaded && this.file.lastModified() != this.aliasFileLastModTime) {
            this.loaded = false;
        }
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            try {
                AliasLoader.load(this, this.file);
                this.aliasFileLastModTime = this.file.lastModified();
            }
            catch (IOException iOException) {
                this.aliasFileLastModTime = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Iterator iterator = this.sorted.iterator();
        int n = this.getCacheSize();
        UuidAliasRegistry$1 uuidAliasRegistry$1 = new UuidAliasRegistry$1(this, n, iterator);
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            try {
                long l = this.lastRun < 0L ? Long.MAX_VALUE - this.lowestLastRun : this.lastRun;
                AliasLoader.save(uuidAliasRegistry$1, this.lastAllocated, l, this.file);
                this.aliasFileLastModTime = this.file.lastModified();
            }
            catch (IOException iOException) {
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((int)2, (String)NLS.bind((String)Messages.RepositoryRegistry_8, (Object)"aliases"), (Throwable)iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUuidAliasRegistry$IUuidAlias createAliasFor(UUID uUID, String string, long l, boolean bl) {
        if (this.lastRun < 0L) {
            if (l < 0L) {
                l = Long.MAX_VALUE;
            } else {
                this.lowestLastRun = Math.min(this.lowestLastRun, l);
            }
        }
        UuidAlias uuidAlias = new UuidAlias(string, uUID, l);
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            if (!$assertionsDisabled && this.uuidMap.containsKey(uUID)) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && this.nameMap.containsKey(string)) {
                throw (Throwable)((Object)new AssertionError());
            }
            this.uuidMap.put(uUID, uuidAlias);
            this.nameMap.put(string, uuidAlias);
            this.sorted.add(uuidAlias);
            if (!$assertionsDisabled && this.uuidMap.size() != this.sorted.size()) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && this.nameMap.size() != this.sorted.size()) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (bl) {
                this.save();
                ++this.aliasesGeneratedInCurrentRun;
            }
        }
        return uuidAlias;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IUuidAliasRegistry$IUuidAlias createAliasFor(UUID uUID) {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            block13: {
                if (!this.lock.acquire(20000L, null)) {
                    throw (Throwable)new IllegalStateException("Could not acquire lock");
                }
                this.load();
                if (this.uuidMap.containsKey(uUID)) {
                    throw (Throwable)new IllegalArgumentException("Monicker for " + uUID.getUuidValue() + " already exists: " + ((UuidAlias)this.uuidMap.get(uUID)).getMonicker());
                }
                if (this.aliasesGeneratedInCurrentRun < 1000L) break block13;
                UuidAlias uuidAlias = (UuidAlias)this.createAliasFor(uUID, StringUtil.pad(new StringBuffer(), WIDTH, UNUSABLE_CHAR).toString(), this.lastRun, false);
                uuidAlias.persist = false;
                UuidAlias uuidAlias2 = uuidAlias;
                this.lock.release(null);
                return uuidAlias2;
            }
            if (this.sorted.size() >= this.maxCacheSize) {
                int n = 0;
                while (n < this.cacheSize) {
                    IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias = (IUuidAliasRegistry$IUuidAlias)this.sorted.last();
                    this.uuidMap.remove(iUuidAliasRegistry$IUuidAlias.getUuid());
                    this.nameMap.remove(iUuidAliasRegistry$IUuidAlias.getMonicker());
                    this.sorted.remove(iUuidAliasRegistry$IUuidAlias);
                    ++n;
                }
                LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((int)2, (String)"Alias limit has been reached. Old/unused aliases will be reused/recycled", null));
            }
            String string = null;
            long l = (long)Math.pow(ALPHABET.length, WIDTH);
            int n = 0;
            while ((long)n < l) {
                string = this.generateAlias();
                if (!this.nameMap.containsKey(string)) break;
                ++n;
            }
            IUuidAliasRegistry$IUuidAlias iUuidAliasRegistry$IUuidAlias = this.createAliasFor(uUID, string, this.lastRun, true);
            return iUuidAliasRegistry$IUuidAlias;
            {
                finally {
                    this.lock.release(null);
                }
            }
        }
    }

    private String generateAlias() {
        long l = this.lastAllocated++ % (long)Math.pow(ALPHABET.length, WIDTH);
        int n = WIDTH - 1;
        char[] cArray = new char[WIDTH];
        int n2 = n;
        while (n2 >= 0) {
            long l2 = (long)Math.pow(ALPHABET.length, n2);
            cArray[n - n2] = ALPHABET[(int)(l / l2)];
            l %= l2;
            --n2;
        }
        if (this.lastAllocated == Long.MAX_VALUE) {
            this.lastAllocated = 1000L;
        }
        return new String(cArray);
    }

    /*
     * Loose catch block
     */
    public IUuidAliasRegistry$IUuidAlias findAliasByName(String string) throws IUuidAliasRegistry$NoSuchAliasException {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            if (!this.lock.isAcquired() && !this.lock.acquire(20000L, null)) {
                throw (Throwable)new IllegalStateException("Could not acquire lock");
            }
            this.load();
            UuidAlias uuidAlias = (UuidAlias)this.nameMap.get(string);
            if (uuidAlias == null) {
                throw (Throwable)new IUuidAliasRegistry$NoSuchAliasException();
            }
            this.increment(uuidAlias);
            UuidAlias uuidAlias2 = uuidAlias;
            this.lock.release(null);
            return uuidAlias2;
            {
                catch (Throwable throwable) {
                    this.lock.release(null);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(UuidAlias uuidAlias) {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            long l;
            long l2 = l = this.lastRun < 0L ? 0L : this.lastRun;
            if (uuidAlias.lastRun != l) {
                this.sorted.remove(uuidAlias);
                uuidAlias.lastRun = l;
                this.sorted.add(uuidAlias);
                this.save();
            }
        }
    }

    /*
     * Loose catch block
     */
    public IUuidAliasRegistry$IUuidAlias findAliasByUuid(UUID uUID) throws IUuidAliasRegistry$NoSuchAliasException {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            if (!this.lock.acquire(20000L, null)) {
                throw (Throwable)new IllegalStateException("Could not acquire lock");
            }
            this.load();
            UuidAlias uuidAlias = (UuidAlias)this.uuidMap.get(uUID);
            if (uuidAlias == null) {
                throw (Throwable)new IUuidAliasRegistry$NoSuchAliasException();
            }
            this.increment(uuidAlias);
            UuidAlias uuidAlias2 = uuidAlias;
            this.lock.release(null);
            return uuidAlias2;
            {
                catch (Throwable throwable) {
                    this.lock.release(null);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAliasCount() {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            this.load();
            return this.sorted.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSet getSorted() {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            this.load();
            return this.sorted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAlias(String string) {
        SortedSet sortedSet = this.sorted;
        synchronized (sortedSet) {
            this.load();
            return this.nameMap.containsKey(string);
        }
    }
}

