/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.IExecutionContext;
import com.ibm.team.filesystem.cli.core.cliparser.CLIParser;
import com.ibm.team.filesystem.cli.core.cliparser.HaltingPositionalOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.NamedOptionDefinition;
import com.ibm.team.filesystem.cli.core.cliparser.OptionKey;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ArgumentOverflowException;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ArgumentUnderflowException;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.MalformedCommandLineException;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.MalformedOptException;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.UnknownOptionException;
import com.ibm.team.filesystem.cli.core.internal.Activator;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration$ShowPolicy;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$PathPair;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLauncher$InternalErrorException;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLoader;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadOptionsException;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadSubcommandException;
import com.ibm.team.filesystem.cli.core.util.LocalAppDataMigrator;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class SubcommandLauncher {
    private static final String SUBCOMMAND_HELP = "help";
    private static final String SUBCOMMAND_VERSION = "version";
    public static NamedOptionDefinition OPT_HELP = new NamedOptionDefinition("h", "help", 0);
    public static final IOptionKey OPT_DISALLOW_INTERACTION = new OptionKey("non-interactive");
    public static final IOptionKey OPT_CONFIG_LOCATION = new OptionKey("config");
    public static final IOptionKey OPT_DRY_RUN = new OptionKey("dry-run");
    public static final IOptionKey OPT_NO_MASK = new OptionKey("no-mask");
    public static HaltingPositionalOptionDefinition OPT_SUBCOMMAND_NAME = new HaltingPositionalOptionDefinition("subcmd", 0, 1);
    public static final int UNINITIALIZED_RETURN_CODE = -1;
    public static final IOptionKey OPT_SHOW_UUID = new OptionKey("show-uuid");
    public static final IOptionKey OPT_SHOW_ALIAS = new OptionKey("show-alias");
    private static final String PROP_SHOW_ERRORS = "scm.show.own.errors";
    private final String subcommandGroup;
    private SubcommandLoader loader;
    private static PrintStream err;
    private int returnValue = -1;
    private static String[] ALWAYS_VALUES;
    private static String[] NEVER_VALUES;

    static {
        ALWAYS_VALUES = new String[]{"y", "yes"};
        NEVER_VALUES = new String[]{"n", "no"};
    }

    public SubcommandLauncher(String string, PrintStream printStream) {
        this.subcommandGroup = string;
        err = printStream;
    }

    public int run(IExecutionContext iExecutionContext, IApplicationContext iApplicationContext, IProgressMonitor iProgressMonitor) throws Exception {
        if (IClientConfiguration.DEBUG_TIMING) {
            SubcommandUtil.printDebugTiming("Entering Application.start()", iExecutionContext.stdout());
        }
        try {
            this.doStart(iExecutionContext, iApplicationContext, iProgressMonitor);
            if (!$assertionsDisabled && this.returnValue == -1) {
                throw (Throwable)((Object)new AssertionError());
            }
            int n = this.returnValue;
            return n;
        }
        catch (SubcommandLauncher$InternalErrorException subcommandLauncher$InternalErrorException) {
            int n = this.returnValue;
            return n;
        }
        catch (Exception exception) {
            err.println(Messages.Application_0);
            exception.printStackTrace(iExecutionContext.stderr());
            throw (Throwable)exception;
        }
        catch (Throwable throwable) {
            err.println(Messages.Application_0);
            throwable.printStackTrace(iExecutionContext.stderr());
            throw (Throwable)new RuntimeException(throwable);
        }
        finally {
            String string;
            if (Activator.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)"com.ibm.team.filesystem.cli.core/debug/output")) && (string = System.getProperty("eclipse.exitdata")) != null) {
                err.println(string);
            }
        }
    }

    public void doStart(IExecutionContext iExecutionContext, IApplicationContext iApplicationContext, IProgressMonitor iProgressMonitor) throws SubcommandLauncher$InternalErrorException {
        ISubcommand iSubcommand;
        SubcommandDefinition$PathPair subcommandDefinition$PathPair;
        FileSystemCore.UserConfigDir userConfigDir;
        Object object;
        ISubcommandDefinition iSubcommandDefinition;
        ICommandLine iCommandLine = null;
        String string = null;
        this.loader = SubcommandLoader.getScope(this.subcommandGroup, iExecutionContext.stderr());
        HardcodedPermissionUtils hardcodedPermissionUtils = new HardcodedPermissionUtils(PlatformDetector.LauncherType.CLI, iExecutionContext.environment());
        try {
            iCommandLine = this.parseCommandLine(iExecutionContext);
            string = iCommandLine.getOption(OPT_SUBCOMMAND_NAME, null);
        }
        catch (UnknownOptionException unknownOptionException) {
            throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_36, NLS.bind((String)Messages.Application_4, (Object)unknownOptionException.getOption()));
        }
        catch (ArgumentUnderflowException argumentUnderflowException) {
            this.showHelp(iExecutionContext, hardcodedPermissionUtils, null);
            throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_28, Messages.Application_5);
        }
        catch (MalformedOptException malformedOptException) {
            throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_29, NLS.bind((String)Messages.Application_6, (Object)malformedOptException.getOption()));
        }
        catch (MalformedCommandLineException malformedCommandLineException) {
            malformedCommandLineException.printStackTrace(iExecutionContext.stderr());
            throw (Throwable)this.complain(iExecutionContext, 7, Messages.Application_30, malformedCommandLineException.getLocalizedMessage());
        }
        catch (ConflictingOptionException conflictingOptionException) {
            conflictingOptionException.printStackTrace(iExecutionContext.stderr());
            throw (Throwable)this.complain(iExecutionContext, 7, Messages.Application_31, conflictingOptionException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(iExecutionContext.stderr());
            throw (Throwable)this.complain(iExecutionContext, 7, Messages.Application_57, iOException.getLocalizedMessage());
        }
        if (string == null) {
            if (iCommandLine.hasOption(CommonOptions.OPT_VERSION)) {
                string = SUBCOMMAND_VERSION;
            } else if (iCommandLine.hasOption(OPT_HELP)) {
                string = SUBCOMMAND_HELP;
            } else {
                this.showHelp(iExecutionContext, hardcodedPermissionUtils, iCommandLine);
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_32, NLS.bind((String)Messages.Application_7, (Object)CommonOptions.OPT_VERSION.getName(), (Object)OPT_HELP.getName()));
            }
        }
        if ((iSubcommandDefinition = this.loader.loadToplevel(string)) == null) {
            this.showHelp(iExecutionContext, hardcodedPermissionUtils, iCommandLine);
            throw (Throwable)this.complain(iExecutionContext, 12, Messages.Application_33, NLS.bind((String)Messages.Application_8, (Object)string));
        }
        List list = iCommandLine.getUnconsumedArgs();
        LinkedList<ISubcommandDefinition> linkedList = new LinkedList<ISubcommandDefinition>();
        while (iSubcommandDefinition.isParent()) {
            linkedList.add(iSubcommandDefinition);
            if (list.size() < 1) {
                object = SubcommandUtil.getExecutionString(iSubcommandDefinition);
                throw (Throwable)this.complain(iExecutionContext, 1, NLS.bind((String)Messages.Application_49, (Object)object), NLS.bind((String)Messages.Application_50, (Object)iExecutionContext.getAppName(), (Object)object));
            }
            object = (String)list.remove(0);
            try {
                iSubcommandDefinition = iSubcommandDefinition.getChild((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_52, NLS.bind((String)Messages.Application_51, (Object[])new Object[]{object, iExecutionContext.getAppName(), SubcommandUtil.getExecutionString(iSubcommandDefinition)}));
            }
            if (iSubcommandDefinition != null) continue;
            throw (Throwable)this.complain(iExecutionContext, 12, Messages.Application_33, NLS.bind((String)Messages.Application_9, (Object)object));
        }
        object = null;
        if (iCommandLine != null) {
            try {
                object = this.parseSubCommandLine(iSubcommandDefinition, iCommandLine.getUnconsumedArgs());
            }
            catch (ISubcommandDefinition$LoadOptionsException iSubcommandDefinition$LoadOptionsException) {
                throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.Application_35, (Object)string), iSubcommandDefinition$LoadOptionsException.getCause().getLocalizedMessage());
            }
            catch (ArgumentOverflowException argumentOverflowException) {
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_36, NLS.bind((String)Messages.Application_11, (Object)string, (Object)argumentOverflowException.getExtraArgument()));
            }
            catch (ArgumentUnderflowException argumentUnderflowException) {
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_36, NLS.bind((String)Messages.Application_12, (Object)string, (Object)StringUtil.listToString(argumentUnderflowException.getMissingArguments())));
            }
            catch (UnknownOptionException unknownOptionException) {
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_36, NLS.bind((String)Messages.Application_13, (Object)string, (Object)unknownOptionException.getOption()));
            }
            catch (MalformedOptException malformedOptException) {
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_36, NLS.bind((String)Messages.Application_14, (Object)malformedOptException.getOption()));
            }
            catch (MalformedCommandLineException malformedCommandLineException) {
                throw (Throwable)this.complain(iExecutionContext, 1, Messages.Application_36, malformedCommandLineException.getLocalizedMessage());
            }
            catch (ConflictingOptionException conflictingOptionException) {
                conflictingOptionException.printStackTrace(iExecutionContext.stderr());
                throw (Throwable)this.complain(iExecutionContext, 7, NLS.bind((String)Messages.Application_41, (Object)string), conflictingOptionException.getLocalizedMessage());
            }
        }
        try {
            userConfigDir = this.findConfigDirectory(iCommandLine);
        }
        catch (FileSystemClientException fileSystemClientException) {
            fileSystemClientException.printStackTrace(iExecutionContext.stderr());
            throw (Throwable)this.complain(iExecutionContext, 4, "Could not initialize preferences", fileSystemClientException.getLocalizedMessage());
        }
        if (userConfigDir.isUsingLocalAppData()) {
            LocalAppDataMigrator.migrate(userConfigDir);
        }
        this.secureConfigLocation(iExecutionContext, hardcodedPermissionUtils, userConfigDir.getConfigDirAsFile(), iCommandLine);
        try {
            subcommandDefinition$PathPair = ((SubcommandDefinition)iSubcommandDefinition).initialize(iExecutionContext, userConfigDir, iCommandLine, (ICommandLine)object);
        }
        catch (FileSystemClientException fileSystemClientException) {
            throw (Throwable)this.complain(iExecutionContext, fileSystemClientException.getStatus().getCode(), Messages.Application_42, fileSystemClientException.getLocalizedMessage());
        }
        try {
            iSubcommand = iSubcommandDefinition.loadSubcommand();
        }
        catch (ISubcommandDefinition$LoadSubcommandException iSubcommandDefinition$LoadSubcommandException) {
            throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.Application_43, (Object)iSubcommandDefinition$LoadSubcommandException.getSubcommand()), iSubcommandDefinition$LoadSubcommandException.getLocalizedMessage());
        }
        if (IClientConfiguration.DEBUG_TIMING) {
            SubcommandUtil.printDebugTiming(NLS.bind((String)Messages.Application_16, (Object)iExecutionContext.getAppName()), iExecutionContext.stdout());
        }
        this.run(iExecutionContext, iApplicationContext, hardcodedPermissionUtils, iSubcommandDefinition, subcommandDefinition$PathPair, linkedList, iCommandLine, (ICommandLine)object, iSubcommand);
        if (IClientConfiguration.DEBUG_TIMING) {
            SubcommandUtil.printDebugTiming(NLS.bind((String)Messages.Application_17, (Object)iExecutionContext.getAppName()), iExecutionContext.stdout());
        }
    }

    private void secureConfigLocation(IExecutionContext iExecutionContext, HardcodedPermissionUtils hardcodedPermissionUtils, File file, ICommandLine iCommandLine) throws SubcommandLauncher$InternalErrorException {
        try {
            hardcodedPermissionUtils.mkRoot(file.getCanonicalPath());
        }
        catch (IPermissionUtil.CannotCreateException cannotCreateException) {
            throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.SubcommandLauncher_COULD_NOT_CREATE_DIRECTORY, (Object)file.getName()), NLS.bind((String)Messages.SubcommandLauncher_COULD_NOT_CREATE_DIRECTORY_FULL_STRING, (Object)file.toString()));
        }
        catch (IPermissionUtil.CannotModifyException cannotModifyException) {
            throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.SubcommandLauncher_COULD_NOT_SECURE_DIRECTORY, (Object)file.getName()), NLS.bind((String)Messages.SubcommandLauncher_COULD_NOT_SET_PERMISSIONS_ON_DIRECTORY, (Object)file.toString()));
        }
        catch (IPermissionUtil.PermissionUtilsException permissionUtilsException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)permissionUtilsException));
            throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.SubcommandLauncher_ERROR_SECURING_DIRECTORY, (Object)file.getName()), NLS.bind((String)Messages.SubcommandLauncher_ERROR_SECURING_DIRECTORY_LONG, (Object)file.toString(), (Object)permissionUtilsException.getLocalizedMessage()));
        }
        catch (InterruptedException interruptedException) {
            throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.SubcommandLauncher_INTERRUPTION_SECURING_DIRECTORY, (Object)file.getName()), NLS.bind((String)Messages.SubcommandLauncher_INTERRUPTION_SECURING_DIRECTORY_LONG, (Object)file.toString()));
        }
        catch (IOException iOException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)iOException));
            throw (Throwable)this.complain(iExecutionContext, 4, NLS.bind((String)Messages.SubcommandLauncher_EXCEPTION_SECURING_DIRECTORY, (Object)file.getName()), NLS.bind((String)Messages.SubcommandLauncher_EXCEPTION_SECURING_DIRECTORY_WITH_MESSAGE, (Object)file.toString(), (Object)iOException.getLocalizedMessage()));
        }
    }

    private FileSystemCore.UserConfigDir findConfigDirectory(ICommandLine iCommandLine) throws FileSystemClientException {
        String string = null;
        if (iCommandLine != null && iCommandLine.hasOption(OPT_CONFIG_LOCATION)) {
            string = iCommandLine.getOption(OPT_CONFIG_LOCATION);
        }
        return SubcommandUtil.getConfigRoot(string);
    }

    private SubcommandLauncher$InternalErrorException complain(IExecutionContext iExecutionContext, int n, String string, String string2) {
        return this.complain(iExecutionContext, n, string, string2, true);
    }

    public void stop() {
    }

    private ICommandLine parseCommandLine(IExecutionContext iExecutionContext) throws MalformedCommandLineException, ConflictingOptionException, IOException {
        Object object;
        Options options = new Options(true);
        options.addOption(OPT_DRY_RUN, "n", "dry-run", Messages.Application_18, 0);
        options.addOption(OPT_DISALLOW_INTERACTION, null, "non-interactive", Messages.Application_19, 0);
        options.addOption(OPT_CONFIG_LOCATION, null, "config", Messages.Application_20, 1);
        options.addOption(OPT_NO_MASK, null, "no-mask", Messages.Application_NO_MASK_HELP, 0);
        Object[] objectArray = new Object[]{ALWAYS_VALUES[0], ALWAYS_VALUES[1], NEVER_VALUES[0], NEVER_VALUES[1]};
        options.addOption(OPT_SHOW_UUID, "u", "show-uuid", NLS.bind((String)Messages.Application_55, (Object[])objectArray), 1);
        options.addOption(OPT_SHOW_ALIAS, "a", "show-alias", NLS.bind((String)Messages.Application_56, (Object[])objectArray), 1);
        options.addOption(CommonOptions.OPT_VERSION, CommonOptions.OPT_VERSION_HELP);
        options.addOption(OPT_SUBCOMMAND_NAME, Messages.Application_21);
        options.addOption(OPT_HELP, Messages.Application_22);
        String[] stringArray = iExecutionContext.arguments();
        Map map = iExecutionContext.environment();
        String string = (String)map.get("JAZZSCM_FORCE_GLOBBING");
        boolean bl = "1".equals(string);
        if (System.getProperty("os.name").toLowerCase().contains("windows") || bl) {
            object = (String)map.get("GLOBIGNORE");
            String[] stringArray2 = null;
            if (object != null) {
                stringArray2 = ((String)object).split(";");
            }
            List list = CLIParser.expandWildCardArgs(stringArray, stringArray2, iExecutionContext);
            stringArray = list.toArray(new String[list.size()]);
        }
        object = new CLIParser(options, stringArray);
        return ((CLIParser)object).parse();
    }

    private ICommandLine parseSubCommandLine(ISubcommandDefinition iSubcommandDefinition, List list) throws MalformedCommandLineException, ISubcommandDefinition$LoadOptionsException, ConflictingOptionException {
        Options options = iSubcommandDefinition.getOptions();
        return new CLIParser(options, list).parse();
    }

    /*
     * Exception decompiling
     */
    private void run(IExecutionContext var1_1, IApplicationContext var2_2, HardcodedPermissionUtils var3_3, ISubcommandDefinition var4_4, SubcommandDefinition$PathPair var5_5, LinkedList var6_6, ICommandLine var7_7, ICommandLine var8_8, ISubcommand var9_9) throws SubcommandLauncher$InternalErrorException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ClientConfiguration$ShowPolicy computeShowPolicy(IExecutionContext iExecutionContext, ICommandLine iCommandLine, IOptionKey iOptionKey, ClientConfiguration$ShowPolicy clientConfiguration$ShowPolicy) throws SubcommandLauncher$InternalErrorException {
        String string;
        if (!iCommandLine.hasOption(iOptionKey)) {
            return clientConfiguration$ShowPolicy;
        }
        String string2 = iCommandLine.getOption(iOptionKey);
        String[] stringArray = ALWAYS_VALUES;
        int n = ALWAYS_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            if (string.equals(string2)) {
                return ClientConfiguration$ShowPolicy.ALWAYS;
            }
            ++n2;
        }
        stringArray = NEVER_VALUES;
        n = NEVER_VALUES.length;
        n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            if (string.equals(string2)) {
                return ClientConfiguration$ShowPolicy.NEVER;
            }
            ++n2;
        }
        throw (Throwable)this.complain(iExecutionContext, 1, NLS.bind((String)Messages.Application_53, (Object)iCommandLine.getDefinition().getOption(iOptionKey).getName()), NLS.bind((String)Messages.Application_54, (Object[])new Object[]{ALWAYS_VALUES[0], ALWAYS_VALUES[1], NEVER_VALUES[0], NEVER_VALUES[1]}));
    }

    private void showHelp(IExecutionContext iExecutionContext, HardcodedPermissionUtils hardcodedPermissionUtils, ICommandLine iCommandLine) throws SubcommandLauncher$InternalErrorException {
        ISubcommandDefinition iSubcommandDefinition = this.loader.loadToplevel(SUBCOMMAND_HELP);
        ISubcommand iSubcommand = null;
        try {
            iSubcommand = iSubcommandDefinition.loadSubcommand();
        }
        catch (ISubcommandDefinition$LoadSubcommandException iSubcommandDefinition$LoadSubcommandException) {
            throw (Throwable)this.complain(iExecutionContext, 7, NLS.bind((String)Messages.Application_45, (Object)SubcommandUtil.getExecutionString(iSubcommandDefinition)), iSubcommandDefinition$LoadSubcommandException.getLocalizedMessage());
        }
        if (iSubcommand == null) {
            throw (Throwable)this.complain(iExecutionContext, 7, Messages.Application_46, Messages.Application_47);
        }
        this.run(iExecutionContext, null, hardcodedPermissionUtils, iSubcommandDefinition, null, null, iCommandLine, null, iSubcommand);
    }

    private SubcommandLauncher$InternalErrorException complain(IExecutionContext iExecutionContext, int n, String string, String string2, boolean bl) {
        this.returnValue = n;
        if (bl) {
            if (System.getProperty(PROP_SHOW_ERRORS) != null) {
                err.println(NLS.bind((String)Messages.ERROR_TITLE1, (Object)string));
                err.println(string2);
            } else {
                iExecutionContext.setTerminatingError(string, string2);
            }
        }
        return new SubcommandLauncher$InternalErrorException(null);
    }

    private static void writeChildStatuses(IExecutionContext iExecutionContext, MultiStatus multiStatus) {
        IStatus[] iStatusArray = multiStatus.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus iStatus = iStatusArray[n2];
            if (iStatus.getException() == null) {
                err.println(NLS.bind((String)Messages.Application_26, (Object)iStatus.getMessage()));
            } else {
                iStatus.getException().printStackTrace(iExecutionContext.stderr());
            }
            err.println();
            err.println();
            if (iStatus.isMultiStatus()) {
                SubcommandLauncher.writeChildStatuses(iExecutionContext, (MultiStatus)iStatus);
            }
            ++n2;
        }
    }
}

