/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.IExecutionContext;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.Options;
import com.ibm.team.filesystem.cli.core.cliparser.exceptions.ConflictingOptionException;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$$Cold;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$PathPair;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$Policy;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLoader;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IOptionSource;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadOptionsException;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition$LoadSubcommandException;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.SharingManager;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

class SubcommandDefinition
implements ISubcommandDefinition {
    IConfigurationElement ext;
    private final SubcommandLoader loader;
    private String name = null;
    private String shortHelp = null;
    private PrintStream printStream;
    private static final String PREFERENCES_RCP_CORE_PREFS = ".metadata/.plugins/org.eclipse.core.runtime/.settings/com.ibm.team.filesystem.rcp.core.prefs";
    private static volatile Pattern SCOPE_SPLITTER = null;

    public SubcommandDefinition(SubcommandLoader subcommandLoader, IConfigurationElement iConfigurationElement, PrintStream printStream) {
        this.loader = subcommandLoader;
        this.ext = iConfigurationElement;
        this.printStream = printStream;
    }

    private String getAttr(String string) {
        return this.getAttr(string, true);
    }

    private String getAttr(String string, boolean bl) {
        String string2 = this.ext.getAttribute(string);
        if (bl && string2 == null) {
            this.printStream.println(NLS.bind((String)Messages.SubcommandDefinition_0, (Object)string));
        }
        return string2;
    }

    public String getFullSubcommandName() {
        if (this.name == null) {
            this.name = this.getAttr("name");
        }
        return this.name;
    }

    public String getShortHelp() {
        if (this.shortHelp == null) {
            this.shortHelp = this.getAttr("shortHelp");
        }
        return this.shortHelp;
    }

    public String getLongHelp() {
        return this.ext.getAttribute("longHelp");
    }

    public String getOptionsClass() {
        return this.ext.getAttribute("options");
    }

    public Options getOptions() throws ISubcommandDefinition$LoadOptionsException, ConflictingOptionException {
        Object object;
        Options options = null;
        boolean bl = true;
        if (this.getOptionsClass() == null) {
            options = new Options(false);
        } else {
            try {
                object = (IOptionSource)this.ext.createExecutableExtension("options");
            }
            catch (CoreException coreException) {
                throw (Throwable)new ISubcommandDefinition$LoadOptionsException(this.name, coreException);
            }
            options = object.getOptions();
            bl = false;
        }
        object = this.getLongHelp();
        if (!$assertionsDisabled && bl && object == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Extension point for subcommand \"" + this.getId() + "\" does not set options class or long help.")));
        }
        if (object != null) {
            options.setLongHelp((String)object);
        }
        return options;
    }

    protected SubcommandDefinition$Policy getInitPolicy() throws FileSystemClientException {
        String string = this.getAttr("initpolicy");
        if ("none".equals(string)) {
            return SubcommandDefinition$Policy.NONE;
        }
        if ("ancestor".equals(string)) {
            return SubcommandDefinition$Policy.ANCESTOR;
        }
        if ("argument".equals(string)) {
            return SubcommandDefinition$Policy.ARGUMENT;
        }
        if ("argument/ancestor".equals(string)) {
            return SubcommandDefinition$Policy.ARG_ANC;
        }
        if ("uri/argument/ancestor".equals(string)) {
            return SubcommandDefinition$Policy.URI_ARG_ANC;
        }
        if ("scratch".equals(string)) {
            return SubcommandDefinition$Policy.SCRATCH;
        }
        if ("argument-create".equals(string)) {
            return SubcommandDefinition$Policy.ARGUMENT_CREATE;
        }
        throw (Throwable)StatusHelper.internalError(NLS.bind((String)Messages.SubcommandDefinition_1, (Object[])new Object[]{this.getFullSubcommandName(), this.ext.getContributor().getName(), string}));
    }

    public ISubcommand loadSubcommand() throws ISubcommandDefinition$LoadSubcommandException {
        block3: {
            try {
                if (this.getSubcommandName() != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                throw (Throwable)new ISubcommandDefinition$LoadSubcommandException(this.name, coreException);
            }
        }
        return (ISubcommand)this.ext.createExecutableExtension("class");
    }

    public String getSubcommandName() {
        return this.ext.getAttribute("class");
    }

    public String getModuleName() {
        return this.ext.getContributor().getName();
    }

    public String getId() {
        return this.getAttr("id", false);
    }

    public String getParentId() {
        return this.getAttr("parent", false);
    }

    public ISubcommandDefinition getParent() {
        String string = this.getParentId();
        if (string == null) {
            return null;
        }
        Collection collection = this.loader.getAllDefinitions();
        if (string != null) {
            for (ISubcommandDefinition iSubcommandDefinition : collection) {
                if (!string.equals(iSubcommandDefinition.getId())) continue;
                return iSubcommandDefinition;
            }
        }
        throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.SubcommandDefinition_11, (Object)string));
    }

    public boolean isParent() {
        return this.ext.getAttribute("class") == null;
    }

    public Collection getChildren() {
        if (!this.isParent()) {
            throw (Throwable)new IllegalArgumentException(Messages.SubcommandDefinition_13);
        }
        return this.loader.getChildSubcommands(this);
    }

    public boolean showInHelpListing() {
        return this.ext.getAttribute("hideFromHelp") == null;
    }

    public static boolean inGroup(IConfigurationElement iConfigurationElement, String string) {
        Collection collection = SubcommandDefinition.getScopes(iConfigurationElement);
        return collection.contains(string);
    }

    public static Collection getScopes(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("scope");
        if (string == null || string.trim().length() == 0) {
            return Collections.singleton("default");
        }
        Pattern pattern = SCOPE_SPLITTER;
        if (SCOPE_SPLITTER == null) {
            pattern = SCOPE_SPLITTER = Pattern.compile("\\s+");
        }
        ArrayList<String> arrayList = new ArrayList<String>(5);
        String[] stringArray = pattern.split(string);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            arrayList.add(string2);
            ++n2;
        }
        return arrayList;
    }

    public SubcommandLoader getLoader() {
        return this.loader;
    }

    public SubcommandDefinition$PathPair initialize(IExecutionContext iExecutionContext, FileSystemCore.UserConfigDir userConfigDir, ICommandLine iCommandLine, ICommandLine iCommandLine2) throws FileSystemClientException {
        boolean bl;
        File file;
        File file2;
        block29: {
            File file3;
            Object object;
            SubcommandDefinition$Policy subcommandDefinition$Policy = this.getInitPolicy();
            String string = iCommandLine2.getOption(CommonOptions.OPT_DIRECTORY, null);
            file2 = null;
            file = null;
            boolean bl2 = false;
            bl = false;
            switch (subcommandDefinition$Policy) {
                case NONE: {
                    return new SubcommandDefinition$PathPair(null, null, false, null);
                }
                case ANCESTOR: {
                    object = iExecutionContext.getCurrentWorkingDirectory();
                    file2 = SubcommandUtil.findAncestorCFARoot((String)object);
                    if (file2 == null) {
                        throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_2, (Object)object));
                    }
                    file = new File(iExecutionContext.getCurrentWorkingDirectory());
                    bl2 = true;
                    break;
                }
                case ARGUMENT: 
                case ARGUMENT_CREATE: {
                    if (string == null) {
                        this.verifyArg(iCommandLine2);
                        throw (Throwable)StatusHelper.argSyntax(Messages.SubcommandDefinition_3);
                    }
                    file = SubcommandUtil.canonicalize(new File(iExecutionContext.getCurrentWorkingDirectory()));
                    file2 = new File(SubcommandUtil.canonicalize(iExecutionContext.getCurrentWorkingDirectory()));
                    if (subcommandDefinition$Policy == SubcommandDefinition$Policy.ARGUMENT_CREATE) {
                        file3 = SubcommandUtil.findAncestorCFARoot(file2.getAbsolutePath());
                        if (file3 == null) {
                            if (file2.exists() || file2.mkdirs()) break;
                            throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_4, (Object)file2.getAbsolutePath()));
                        }
                        if (file2.equals(file3)) break;
                        throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_5, (Object)file3.getAbsolutePath()));
                    }
                    if (file2.exists()) break;
                    throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_6, (Object)string));
                }
                case URI_ARG_ANC: 
                case ARG_ANC: {
                    if (string == null) {
                        file2 = SubcommandUtil.findAncestorCFARoot(iExecutionContext.getCurrentWorkingDirectory());
                        if (file2 == null) {
                            file = file2 = userConfigDir.getConfigDirAsFile();
                            bl = true;
                            break;
                        }
                        bl2 = true;
                        file = SubcommandUtil.canonicalize(new File(iExecutionContext.getCurrentWorkingDirectory()));
                        break;
                    }
                    file2 = SubcommandUtil.findNamedAncestorCFARoot(iExecutionContext.getCurrentWorkingDirectory());
                    file = SubcommandUtil.canonicalize(new File(iExecutionContext.getCurrentWorkingDirectory()));
                    if (!file.exists()) {
                        throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.SubcommandDefinition_8, (Object)file.getAbsolutePath()));
                    }
                    bl2 = true;
                    break;
                }
                case SCRATCH: {
                    file = file2 = userConfigDir.getConfigDirAsFile();
                    bl = true;
                }
            }
            Assert.isNotNull(file2);
            object = file2;
            if (bl) {
                file3 = null;
                if (iExecutionContext.getDaemon() != null) {
                    file3 = SubcommandUtil.getEclipseWorkspaceRoot();
                } else {
                    File file4 = new File(file2, "scratch");
                    file4.mkdirs();
                    int n = 0;
                    while (n < 10) {
                        File file5 = new File(file4, Integer.toString(n));
                        try {
                            SubcommandUtil.initializeEclipseWorkspaceRoot(file5);
                            file3 = file5;
                            break;
                        }
                        catch (FileSystemClientException fileSystemClientException) {
                            if (fileSystemClientException.getStatus().getCode() != 27) {
                                throw (Throwable)fileSystemClientException;
                            }
                            ++n;
                        }
                    }
                    if (file3 == null) {
                        throw (Throwable)StatusHelper.cfaInUse(NLS.bind((String)Messages.SCRATCH_UNAVAILABLE10, (Object)file2.getAbsolutePath()));
                    }
                    SubcommandDefinition.clearPreferences(file3);
                }
                file = file2 = file3;
            } else if (iExecutionContext.getDaemon() == null) {
                SubcommandUtil.initializeEclipseWorkspaceRoot(file2);
            } else if (file2 == null) {
                file2 = SubcommandUtil.getEclipseWorkspaceRoot();
            }
            if (bl2) {
                try {
                    SharingManager.getInstance().register((ISandbox)new Sandbox((IPath)new Path(((File)object).getAbsolutePath())), true, null);
                }
                catch (FileSystemClientException fileSystemClientException) {
                    if (fileSystemClientException.getStatus().getCode() != 209) break block29;
                    throw (Throwable)StatusHelper.cfaInUse(NLS.bind((String)Messages.SubcommandDefinition_ALREADY_LOCKED, (Object)((File)object).getAbsolutePath()));
                }
            }
        }
        return new SubcommandDefinition$PathPair(file2, file, bl, null);
    }

    private static void clearPreferences(File file) throws FileSystemClientException {
        SubcommandDefinition$$Cold.clearPreferences(file);
    }

    private void verifyArg(ICommandLine iCommandLine) throws FileSystemClientException {
        SubcommandDefinition$$Cold.verifyArg(this, iCommandLine);
    }

    public String[] getAliases() {
        String string = this.getAttr("aliases", false);
        if (string == null) {
            return new String[0];
        }
        return string.split("\\s+");
    }

    public List getAncestors() throws  {
        return SubcommandDefinition$$Cold.getAncestors(this);
    }

    public ISubcommandDefinition getChild(String string) {
        Collection collection = this.loader.getChildSubcommands(this);
        for (ISubcommandDefinition iSubcommandDefinition : collection) {
            if (!string.equals(iSubcommandDefinition.getFullSubcommandName())) continue;
            return iSubcommandDefinition;
        }
        for (ISubcommandDefinition iSubcommandDefinition : collection) {
            String[] stringArray = iSubcommandDefinition.getAliases();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string.equals(string2)) {
                    return iSubcommandDefinition;
                }
                ++n2;
            }
        }
        throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.SubcommandDefinition_12, (Object)string));
    }
}

