/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry$$Cold;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry$MisconfiguredFilesystemRegistryException;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry$RepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRegistry;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RepositoryRegistry
implements IRepositoryRegistry {
    private static final String FILE_FORMAT_MAGIC = "###";
    private static final String FILE_FORMAT_TYPE = "reporeg";
    private static final int FILE_FORMAT_VERSION = 0;
    private static final String FILE_PREAMBLE = "### reporeg 0";
    public static final String REPOSITORIES_FILE_v2 = "repositories.txt";
    public static final String REPOSITORIES_FILE_v1 = "repositories";
    private List records = new LinkedList();
    private boolean loaded = false;
    private static final String REPOSITORIES_FILE_LOCK = "repo.lck";
    private static final long LOCK_WAIT = 20000L;
    private FilesystemLock lock = null;
    private long repoFileLastModTime = 0L;
    private final File recordFile;
    private final IPermissionUtil permUtils;

    public RepositoryRegistry(IPermissionUtil iPermissionUtil, File file) {
        this.permUtils = iPermissionUtil;
        this.recordFile = file;
        if (this.recordFile != null) {
            this.lock = new FilesystemLock(new File(this.recordFile.getParentFile(), REPOSITORIES_FILE_LOCK));
        }
    }

    public RepositoryRegistry(File file) {
        this(null, file);
    }

    private static String getVersionString() {
        return FILE_PREAMBLE;
    }

    private static FileSystemClientException misconfiguredLocalFS(String string) {
        return new RepositoryRegistry$MisconfiguredFilesystemRegistryException(string);
    }

    /*
     * Exception decompiling
     */
    protected void load() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void consumePreamble(String string) throws FileSystemClientException {
        if (!string.startsWith(FILE_FORMAT_MAGIC)) {
            throw (Throwable)new FileSystemClientException((IStatus)new Status(2, "com.ibm.team.filesystem.cli.core", NLS.bind((String)Messages.RepositoryRegistry_4, (Object)FILE_FORMAT_MAGIC, (Object)FILE_FORMAT_TYPE)));
        }
        if (!string.startsWith(RepositoryRegistry.getVersionString())) {
            throw (Throwable)new FileSystemClientException((IStatus)new Status(2, "com.ibm.team.filesystem.cli.core", NLS.bind((String)Messages.RepositoryRegistry_5, (Object)0)));
        }
    }

    protected static void save(IPermissionUtil iPermissionUtil, File file, List list) throws FileSystemClientException {
        if (file == null) {
            return;
        }
        Object object = file.getParentFile();
        try {
            iPermissionUtil.mkRoot(((File)object).getCanonicalPath());
        }
        catch (IPermissionUtil.CannotCreateException cannotCreateException) {
            throw (Throwable)RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_PARENT_CREATE_FAIL, (Object)file.getAbsolutePath()));
        }
        catch (IPermissionUtil.CannotModifyException cannotModifyException) {
            throw (Throwable)RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_PARENT_MODIFY_FAIL, (Object)file.getAbsolutePath()));
        }
        catch (IPermissionUtil.PermissionUtilsException permissionUtilsException) {
            throw (Throwable)RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_PARENT_BLANKET_FAIL, (Object)((File)object).getAbsolutePath()), (Exception)((Object)permissionUtilsException));
        }
        catch (InterruptedException interruptedException) {
            throw (Throwable)RepositoryRegistry.failure("Unexpected interruption", interruptedException);
        }
        catch (IOException iOException) {
            throw (Throwable)RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_CANNOT_FIND_PATH, (Object)((File)object).getPath()), iOException);
        }
        if (file.exists() && file.isDirectory()) {
            file.delete();
        }
        try {
            iPermissionUtil.mkFile(file.getCanonicalPath());
        }
        catch (IPermissionUtil.CannotCreateException cannotCreateException) {
            throw (Throwable)RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_FILE_CREATE_FAIL, (Object)file.getAbsolutePath()));
        }
        catch (IPermissionUtil.CannotModifyException cannotModifyException) {
            throw (Throwable)RepositoryRegistry.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_FILE_MODIFY_FAIL, (Object)file.getAbsolutePath()));
        }
        catch (HardcodedPermissionUtils.MisbehavingScriptException misbehavingScriptException) {
            throw (Throwable)RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_FILE_RETURNCODE_FAIL, (Object)file.getAbsolutePath(), (Object)Integer.toString(misbehavingScriptException.getReturnValue())), null);
        }
        catch (IPermissionUtil.PermissionUtilsException permissionUtilsException) {
            throw (Throwable)RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_FILE_BLANKET_FAIL, (Object)file.getAbsolutePath()), (Exception)((Object)permissionUtilsException));
        }
        catch (InterruptedException interruptedException) {
            throw (Throwable)RepositoryRegistry.failure("Unexpected interruption", interruptedException);
        }
        catch (IOException iOException) {
            throw (Throwable)RepositoryRegistry.failure(NLS.bind((String)Messages.RepositoryRegistry_CANNOT_FIND_PATH, (Object)file.getPath()), iOException);
        }
        object = null;
        BufferedWriter bufferedWriter = null;
        try {
            try {
                object = new FileOutputStream(file);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
                bufferedWriter.write(RepositoryRegistry.getVersionString());
                bufferedWriter.newLine();
                for (IRepositoryRecord iRepositoryRecord : list) {
                    RepositoryRegistry$RepositoryRecord.access$2((RepositoryRegistry$RepositoryRecord)iRepositoryRecord, bufferedWriter);
                    bufferedWriter.newLine();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw (Throwable)StatusHelper.misconfiguredLocalFS(NLS.bind((String)Messages.RepositoryRegistry_7, (Object)file.getAbsolutePath()));
            }
            catch (IOException iOException) {
                throw (Throwable)StatusHelper.failure(NLS.bind((String)Messages.RepositoryRegistry_8, (Object)file.getAbsolutePath()), iOException);
            }
        }
        catch (Throwable throwable) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
        if (object != null) {
            try {
                ((OutputStream)object).close();
            }
            catch (IOException iOException) {}
        }
    }

    private static FileSystemClientException failure(String string, Exception exception) throws  {
        return RepositoryRegistry$$Cold.failure(string, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryRecord getRecordByURL(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        List list = this.records;
        synchronized (list) {
            this.load();
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
            for (IRepositoryRecord iRepositoryRecord : this.records) {
                String string2 = iRepositoryRecord.getUrl();
                if (!string2.endsWith("/")) {
                    string2 = String.valueOf(string2) + "/";
                }
                if (!string.equals(string2)) continue;
                return iRepositoryRecord;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryRecord getRecordByNickname(String string) {
        if (string == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        List list = this.records;
        synchronized (list) {
            this.load();
            for (IRepositoryRecord iRepositoryRecord : this.records) {
                if (!string.equals(iRepositoryRecord.getNickname())) continue;
                return iRepositoryRecord;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryRecord getRecord(String string) {
        IRepositoryRecord iRepositoryRecord = null;
        List list = this.records;
        synchronized (list) {
            iRepositoryRecord = this.getRecordByURL(string);
            if (iRepositoryRecord != null) {
                return iRepositoryRecord;
            }
            return this.getRecordByNickname(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRepositoryRecord addRecord(String string, String string2, String string3, String string4) throws FileSystemClientException {
        RepositoryRegistry$RepositoryRecord repositoryRegistry$RepositoryRecord = null;
        List list = this.records;
        synchronized (list) {
            if (!this.lock.acquire(20000L, null)) {
                throw (Throwable)new IllegalStateException("Could not acquire lock");
            }
            try {
                this.load();
                if (string2 != null && (repositoryRegistry$RepositoryRecord = (RepositoryRegistry$RepositoryRecord)this.getRecordByNickname(string2)) != null) {
                    this.records.remove(repositoryRegistry$RepositoryRecord);
                }
                if ((repositoryRegistry$RepositoryRecord = (RepositoryRegistry$RepositoryRecord)this.getRecordByURL(string)) != null) {
                    this.records.remove(repositoryRegistry$RepositoryRecord);
                }
                repositoryRegistry$RepositoryRecord = new RepositoryRegistry$RepositoryRecord(string, string2, string3, string4);
                this.records.add(repositoryRegistry$RepositoryRecord);
                this.save();
            }
            finally {
                this.lock.release(null);
            }
        }
        return repositoryRegistry$RepositoryRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecord(IRepositoryRecord iRepositoryRecord) throws FileSystemClientException {
        List list = this.records;
        synchronized (list) {
            if (!this.lock.acquire(20000L, null)) {
                throw (Throwable)new IllegalStateException("Could not acquire lock");
            }
            try {
                this.load();
                iRepositoryRecord = (RepositoryRegistry$RepositoryRecord)this.getRecordByURL(iRepositoryRecord.getUrl());
                if (iRepositoryRecord != null) {
                    this.records.remove(iRepositoryRecord);
                    this.save();
                }
            }
            finally {
                this.lock.release(null);
            }
        }
    }

    private void save() throws FileSystemClientException {
        try {
            RepositoryRegistry.save(this.permUtils, this.recordFile, this.records);
            this.repoFileLastModTime = this.recordFile.lastModified();
        }
        catch (FileSystemClientException fileSystemClientException) {
            this.records = null;
            throw (Throwable)fileSystemClientException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        List list = this.records;
        synchronized (list) {
            this.load();
            return this.records.iterator();
        }
    }
}

