/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry$RepositoryRecord;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

class RepositoryRegistry$RepositoryRegistryImporter_v1 {
    private RepositoryRegistry$RepositoryRegistryImporter_v1() {
    }

    private static void runImport(IPermissionUtil iPermissionUtil, File file) {
        try {
            RepositoryRegistry$RepositoryRegistryImporter_v1.runImportSafe(iPermissionUtil, file);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((int)2, (String)Messages.RepositoryRegistry_IMPORT_FAILURE, (Throwable)fileSystemClientException));
        }
        catch (IOException iOException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((int)2, (String)Messages.RepositoryRegistry_IMPORT_FAILURE, (Throwable)iOException));
        }
    }

    private static void runImportSafe(IPermissionUtil iPermissionUtil, File file) throws IOException, FileSystemClientException {
        Object object;
        File file2 = new File(file, "repositories");
        if (!file2.exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
        LinkedList<RepositoryRegistry$RepositoryRecord> linkedList = new LinkedList<RepositoryRegistry$RepositoryRecord>();
        try {
            while ((object = bufferedReader.readLine()) != null) {
                RepositoryRegistry$RepositoryRecord repositoryRegistry$RepositoryRecord;
                if (((String)(object = ((String)object).trim())).startsWith("#") || (repositoryRegistry$RepositoryRecord = RepositoryRegistry$RepositoryRegistryImporter_v1.read((String)object)) == null) continue;
                linkedList.add(repositoryRegistry$RepositoryRecord);
            }
        }
        finally {
            bufferedReader.close();
        }
        object = new File(file, "repositories.txt");
        RepositoryRegistry.save(iPermissionUtil, (File)object, linkedList);
        file2.delete();
    }

    private static RepositoryRegistry$RepositoryRecord read(String string) {
        List list = StringUtil.splitEscaped(string, RepositoryRegistry$RepositoryRecord.access$0(), ',', '\\');
        if (list.size() == 0) {
            return null;
        }
        if (list.size() < 4) {
            return null;
        }
        String string2 = (String)list.get(0);
        String string3 = (String)list.get(1);
        String string4 = (String)list.get(2);
        String string5 = (String)list.get(3);
        if (string2.length() == 0) {
            return null;
        }
        if (string3.length() == 0) {
            string3 = null;
        }
        if (string4.length() == 0) {
            return null;
        }
        if (string5.length() == 0) {
            string5 = null;
        }
        return new RepositoryRegistry$RepositoryRecord(string2, string3, string4, string5);
    }

    static /* synthetic */ void access$0(IPermissionUtil iPermissionUtil, File file) {
        RepositoryRegistry$RepositoryRegistryImporter_v1.runImport(iPermissionUtil, file);
    }
}

