/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class RepositoryRegistry$RepositoryRecord
implements Serializable,
IRepositoryRecord {
    private static final long serialVersionUID = -5376770411269416777L;
    private static final char SEP = ',';
    private static final char ESCAPE_CHAR = '\\';
    private static final Map ESCAPE_MAPPING = new HashMap();
    private final String url;
    private final String nickname;
    private final String username;
    private final String password;

    static {
        ESCAPE_MAPPING.put(Character.valueOf(','), Character.valueOf(','));
        ESCAPE_MAPPING.put(Character.valueOf('\n'), Character.valueOf('n'));
    }

    protected RepositoryRegistry$RepositoryRecord(String string, String string2, String string3, String string4) {
        this.url = string;
        this.nickname = string2;
        this.username = string3;
        this.password = string4;
    }

    public String getUrl() {
        return this.url;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    private void write(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write(StringUtil.escape(this.url, ESCAPE_MAPPING, '\\'));
        bufferedWriter.write(44);
        String string = this.nickname == null ? "" : this.nickname;
        bufferedWriter.write(StringUtil.escape(string, ESCAPE_MAPPING, '\\'));
        bufferedWriter.write(44);
        bufferedWriter.write(StringUtil.escape(this.username, ESCAPE_MAPPING, '\\'));
        bufferedWriter.write(44);
        bufferedWriter.write(RepositoryRegistry$RepositoryRecord.obfuscatePassword(this.password));
    }

    private static RepositoryRegistry$RepositoryRecord read(String string) throws IOException, FileSystemClientException {
        List list = StringUtil.splitEscaped(string, ESCAPE_MAPPING, ',', '\\');
        if (list.size() == 0) {
            return null;
        }
        if (list.size() < 4) {
            throw (Throwable)new IOException(NLS.bind((String)Messages.RepositoryRegistry_0, (Object)list.size(), (Object)string));
        }
        String string2 = (String)list.get(0);
        String string3 = (String)list.get(1);
        String string4 = (String)list.get(2);
        String string5 = (String)list.get(3);
        if (string2.length() == 0) {
            throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor((int)2, (String)NLS.bind((String)Messages.RepositoryRegistry_1, (Object)string), null));
        }
        if (string3.length() == 0) {
            string3 = null;
        }
        if (string4.length() == 0) {
            throw (Throwable)new FileSystemClientException(FileSystemStatus.getStatusFor((int)2, (String)NLS.bind((String)Messages.RepositoryRegistry_2, (Object)string), null));
        }
        String string6 = null;
        if (string5 != null && string5.length() > 0) {
            string6 = RepositoryRegistry$RepositoryRecord.deobfuscatePassword(string5);
        }
        return new RepositoryRegistry$RepositoryRecord(string2, string3, string4, string6);
    }

    private static String obfuscatePassword(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("z");
        stringBuffer.append(string);
        try {
            byte[] byArray = ObfuscationHelper.encrypt((byte[])stringBuffer.toString().getBytes("UTF-8"));
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)unsupportedEncodingException));
            return "";
        }
        catch (GeneralSecurityException generalSecurityException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)generalSecurityException));
            return "";
        }
    }

    private static String deobfuscatePassword(String string) {
        try {
            byte[] byArray = ObfuscationHelper.decrypt((byte[])string.getBytes("UTF-8"));
            String string2 = new String(byArray, "UTF-8");
            if (string2.length() > 0) {
                return string2.substring(1);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)unsupportedEncodingException));
        }
        catch (GeneralSecurityException generalSecurityException) {
            LoggingHelper.log((IStatus)FileSystemStatus.getStatusFor((Throwable)generalSecurityException));
        }
        return null;
    }

    static /* synthetic */ Map access$0() {
        return ESCAPE_MAPPING;
    }

    static /* synthetic */ RepositoryRegistry$RepositoryRecord access$1(String string) throws IOException, FileSystemClientException {
        return RepositoryRegistry$RepositoryRecord.read(string);
    }

    static /* synthetic */ void access$2(RepositoryRegistry$RepositoryRecord repositoryRegistry$RepositoryRecord, BufferedWriter bufferedWriter) throws IOException {
        repositoryRegistry$RepositoryRecord.write(bufferedWriter);
    }
}

