/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.core.internal;

import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.IExecutionContext;
import com.ibm.team.filesystem.cli.core.cliparser.ICommandLine;
import com.ibm.team.filesystem.cli.core.cliparser.IOptionKey;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration$$Cold;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration$1;
import com.ibm.team.filesystem.cli.core.internal.ClientConfiguration$ShowPolicy;
import com.ibm.team.filesystem.cli.core.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.PreferenceRegistry;
import com.ibm.team.filesystem.cli.core.internal.PreferenceRegistry$PreferenceStreamSource;
import com.ibm.team.filesystem.cli.core.internal.RepositoryRegistry;
import com.ibm.team.filesystem.cli.core.internal.SubcommandDefinition$PathPair;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLauncher;
import com.ibm.team.filesystem.cli.core.internal.SubcommandLoader;
import com.ibm.team.filesystem.cli.core.internal.aliases.UuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IApplicationEndListener;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRecord;
import com.ibm.team.filesystem.cli.core.subcommands.IRepositoryRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.ISubcommandDefinition;
import com.ibm.team.filesystem.cli.core.subcommands.ITypedPreferenceRegistry;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil$IAliasOptions;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.HardcodedPermissionUtils;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.utils.IPermissionUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

public class ClientConfiguration
implements IClientConfiguration,
AliasUtil$IAliasOptions {
    public static final String PREFERENCES_FILENAME = "preferences.properties";
    private final SubcommandLoader loader;
    private final IExecutionContext environment;
    private final IApplicationContext context;
    private final ICommandLine args;
    private final List parents;
    private final ICommandLine subargs;
    private final RepositoryRegistry repoReg;
    private final UuidAliasRegistry aliasReg;
    private final boolean isDryRun;
    private File cfaRoot;
    private final File cwd;
    private final boolean runningInScratch;
    private List endListeners;
    private final HashMap cachedConnectInfo = new HashMap();
    private final ISubcommandDefinition defn;
    private final ITypedPreferenceRegistry prefs;
    private ClientConfiguration$ShowPolicy showAlias;
    private ClientConfiguration$ShowPolicy showUuids;

    public static FileSystemCore.UserConfigDir getDefaultConfigDirectory() {
        return FileSystemCore.getUserConfigDir();
    }

    public ClientConfiguration(SubcommandLoader subcommandLoader, IExecutionContext iExecutionContext, IApplicationContext iApplicationContext, HardcodedPermissionUtils hardcodedPermissionUtils, ISubcommandDefinition iSubcommandDefinition, SubcommandDefinition$PathPair subcommandDefinition$PathPair, List list, ICommandLine iCommandLine, ICommandLine iCommandLine2) throws FileSystemClientException {
        this.loader = subcommandLoader;
        this.environment = iExecutionContext;
        this.context = iApplicationContext;
        this.defn = iSubcommandDefinition;
        if (subcommandDefinition$PathPair == null) {
            this.cfaRoot = null;
            this.cwd = null;
            this.runningInScratch = true;
        } else {
            this.cfaRoot = subcommandDefinition$PathPair.cfaRoot;
            if (this.cfaRoot == null) {
                SubcommandUtil.addPropertyChangeListener(new ClientConfiguration$1(this));
            }
            this.cwd = subcommandDefinition$PathPair.cwd;
            this.runningInScratch = subcommandDefinition$PathPair.isScratch;
        }
        this.args = iCommandLine;
        this.subargs = iCommandLine2;
        this.parents = list;
        this.endListeners = new LinkedList();
        File file = this.getConfigDirectory();
        this.repoReg = new RepositoryRegistry((IPermissionUtil)hardcodedPermissionUtils, new File(file, "repositories.txt"));
        this.aliasReg = new UuidAliasRegistry(new File(file, "aliases"), 1000);
        this.isDryRun = iCommandLine == null || iCommandLine.hasOption(SubcommandLauncher.OPT_DRY_RUN);
        this.prefs = new PreferenceRegistry(new PreferenceRegistry$PreferenceStreamSource(new File(this.getConfigDirectory(), PREFERENCES_FILENAME)));
    }

    public File getEclipseWorkspaceRoot() {
        return this.cfaRoot;
    }

    public File getCurrentWorkingDirectory() {
        return this.cwd;
    }

    public Collection getSubcommandDefinitions() {
        return this.loader.getAllDefinitions();
    }

    public ISubcommandDefinition getSubcommandDefinition() {
        return this.defn;
    }

    public IApplicationContext getApplicationContext() {
        return this.context;
    }

    public ICommandLine getSubcommandCommandLine() {
        return this.subargs;
    }

    public IRepositoryRegistry getRepositoryRegistry() {
        return this.repoReg;
    }

    public IUuidAliasRegistry getAliasRegistry() {
        return this.aliasReg;
    }

    public boolean isDryRun() {
        return this.isDryRun;
    }

    public ICommandLine getCommandLine() {
        return this.args;
    }

    public List getParents() {
        return this.parents;
    }

    public void addApplicationEndListener(IApplicationEndListener iApplicationEndListener) {
        this.endListeners.add(iApplicationEndListener);
    }

    public void deallocate() {
        for (IApplicationEndListener iApplicationEndListener : this.endListeners) {
            iApplicationEndListener.run(this);
        }
        CommandLineCore.setConfig(null);
    }

    void setShowUuids(ClientConfiguration$ShowPolicy showPolicy) {
        this.showUuids = showPolicy;
    }

    void setShowAliases(ClientConfiguration$ShowPolicy showPolicy) {
        this.showAlias = showPolicy;
    }

    public AliasUtil$IAliasOptions getAliasConfig() {
        return this;
    }

    public IClientConfiguration getClientConfiguration() {
        return this;
    }

    public boolean showAlias() {
        return this.showAlias == ClientConfiguration$ShowPolicy.ALWAYS;
    }

    public boolean showUuid() {
        return this.showUuids == ClientConfiguration$ShowPolicy.ALWAYS;
    }

    public File getConfigDirectory() throws FileSystemClientException {
        String string = null;
        if (this.args != null && this.args.hasOption(SubcommandLauncher.OPT_CONFIG_LOCATION)) {
            string = this.args.getOption(SubcommandLauncher.OPT_CONFIG_LOCATION);
        }
        return SubcommandUtil.getConfigRoot(string).getConfigDirAsFile();
    }

    public ITypedPreferenceRegistry getPersistentPreferences() {
        return this.prefs;
    }

    public IExecutionContext getContext() {
        return this.environment;
    }

    static /* synthetic */ void access$0(ClientConfiguration clientConfiguration, File file) {
        clientConfiguration.cfaRoot = file;
    }

    public ConnectionInfo getConnectionInfo(String string, IOptionKey iOptionKey, IOptionKey iOptionKey2, IOptionKey iOptionKey3) throws FileSystemClientException {
        IRepositoryRecord iRepositoryRecord = null;
        String string2 = string;
        if (iOptionKey != null && this.subargs.hasOption(iOptionKey)) {
            string2 = this.subargs.getOption(iOptionKey);
        }
        if (string2 == null) {
            throw (Throwable)StatusHelper.argSyntax(Messages.ClientConfiguration_0);
        }
        Object object = this.getRepositoryRegistry();
        iRepositoryRecord = object.getRecordByURL(string2);
        if (iRepositoryRecord == null && (iRepositoryRecord = object.getRecordByNickname(string2)) != null) {
            string2 = iRepositoryRecord.getUrl();
        }
        if ((object = (ConnectionInfo)this.cachedConnectInfo.get(string2)) != null) {
            return object;
        }
        String string3 = null;
        string3 = iOptionKey2 != null && this.subargs.hasOption(iOptionKey2) ? this.subargs.getOption(iOptionKey2) : (iRepositoryRecord == null ? System.getProperty("user.name") : iRepositoryRecord.getUsername());
        if (string3 == null && this.mayInteract()) {
            try {
                string3 = CommandLineCore.getConfig().getContext().getPassword(NLS.bind((String)Messages.ClientConfiguration_1, (Object)string2), this.mayMaskPassword());
            }
            catch (IOException iOException) {
                throw (Throwable)StatusHelper.failure(Messages.ClientConfiguration_2, iOException);
            }
        }
        if (string3 == null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.ClientConfiguration_3, (Object)string2));
        }
        String string4 = null;
        if (iOptionKey3 != null && this.subargs.hasOption(iOptionKey3)) {
            string4 = this.subargs.getOption(iOptionKey3);
        } else if (iRepositoryRecord != null) {
            string4 = iRepositoryRecord.getPassword();
        }
        if (string4 == null && this.mayInteract()) {
            try {
                string4 = this.getContext().getPassword(NLS.bind((String)Messages.ClientConfiguration_4, (Object)string3, (Object)string2), this.mayMaskPassword());
            }
            catch (IOException iOException) {
                throw (Throwable)StatusHelper.failure(Messages.ClientConfiguration_2, iOException);
            }
        }
        if (string4 == null) {
            throw (Throwable)StatusHelper.argSyntax(NLS.bind((String)Messages.ClientConfiguration_6, (Object)string2));
        }
        object = new ConnectionInfo(string2, string3, string4);
        this.cachedConnectInfo.put(string2, object);
        return object;
    }

    public ConnectionInfo getConnectionInfo() throws FileSystemClientException {
        return ClientConfiguration$$Cold.getConnectionInfo(this);
    }

    public ConnectionInfo getConnectionInfo(String string) throws FileSystemClientException {
        return ClientConfiguration$$Cold.getConnectionInfo(this, string);
    }

    public boolean mayInteract() {
        return !this.args.hasOption(SubcommandLauncher.OPT_DISALLOW_INTERACTION);
    }

    public ISandbox[] getSandboxes() {
        if (this.runningInScratch) {
            return new ISandbox[0];
        }
        return new ISandbox[]{new Sandbox((IPath)new Path(this.cfaRoot.getAbsolutePath()))};
    }

    public boolean mayMaskPassword() {
        if (this.args != null && this.args.hasOption(SubcommandLauncher.OPT_NO_MASK)) {
            return false;
        }
        return this.prefs.getMaskPassword();
    }
}

