/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class UnsynchronizedByteArrayOutputStream
extends OutputStream {
    protected byte[] buffer;
    protected int pos;

    public UnsynchronizedByteArrayOutputStream() {
        this(32);
    }

    public UnsynchronizedByteArrayOutputStream(int initialSize) {
        this.allocateBuffer(initialSize);
    }

    protected void allocateBuffer(int size) {
        this.buffer = new byte[size];
    }

    protected void reallocate(int size) {
        byte[] tmp = this.buffer;
        this.allocateBuffer(size);
        System.arraycopy(tmp, 0, this.buffer, 0, this.pos);
    }

    public void write(int b) {
        if (this.pos == this.buffer.length) {
            this.reallocate(Math.max(this.pos * 2, this.pos + 1));
        }
        this.buffer[this.pos++] = (byte)b;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        if (this.buffer.length - this.pos < len) {
            this.reallocate(Math.max(this.pos + len, this.buffer.length * 2));
        }
        System.arraycopy(b, off, this.buffer, this.pos, len);
        this.pos += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.pos);
    }

    public void reset() {
        this.pos = 0;
    }

    public void flush() {
    }

    public void close() {
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[this.pos];
        System.arraycopy(this.buffer, 0, buf, 0, this.pos);
        return buf;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.pos;
    }

    public String toString() {
        return new String(this.buffer, 0, this.pos);
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.pos, charset);
    }
}

