/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.BTree;
import com.ibm.team.internal.repository.rcp.dbhm.BTreeComparator;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentBTreeAllocator;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PersistentBTree
extends BTree {
    public PersistentBTree(int keySize, int blockSize, BTreeComparator cmp, PersistentBTreeAllocator allocator, RAFWrapper raf) throws IOException {
        super(raf, cmp, allocator);
        byte[] data = allocator.getBTreePersistedData();
        if (data.length == 0) {
            this.init(keySize, blockSize, -1L);
        } else {
            DataInputStream in = new DataInputStream(new UnsynchronizedByteArrayInputStream(data));
            keySize = in.readInt();
            blockSize = in.readInt();
            this.root = in.readLong();
            this.init(keySize, blockSize, this.root);
        }
    }

    public void sync() throws IOException {
        super.sync();
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeInt(this.keySize);
        dataOut.writeInt(this.nodeSize);
        dataOut.writeLong(this.root);
        dataOut.close();
        ((PersistentBTreeAllocator)this.allocator).setBTreePersistentData(out.toByteArray());
    }
}

