/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.JobMessages;
import org.eclipse.core.internal.jobs.JobStatus;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class JobManager$$Cold {
    public static long delayFor(JobManager jobManager, int n) {
        switch (n) {
            case 10: {
                return 0L;
            }
            case 20: {
                return 50L;
            }
            case 30: {
                return 100L;
            }
            case 40: {
                return 500L;
            }
            case 50: {
                return 1000L;
            }
        }
        Assert.isTrue((boolean)false, (String)("Job has invalid priority: " + n));
        return 0L;
    }

    public static String printJobName(Job job) {
        if (job instanceof ThreadJob) {
            Job job2 = ((ThreadJob)job).realJob;
            if (job2 != null) {
                return job2.getClass().getName();
            }
            return "ThreadJob on rule: " + job.getRule();
        }
        return job.getClass().getName();
    }

    public static String printState(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 2: {
                return "WAITING";
            }
            case 1: {
                return "SLEEPING";
            }
            case 4: {
                return "RUNNING";
            }
            case 8: {
                return "BLOCKED";
            }
            case 16: {
                return "ABOUT_TO_RUN";
            }
            case 32: {
                return "ABOUT_TO_SCHEDULE";
            }
        }
        return "UNKNOWN";
    }

    public static final void reportBlocked(JobManager jobManager, IProgressMonitor iProgressMonitor, InternalJob internalJob) {
        Status status;
        if (!(iProgressMonitor instanceof IProgressMonitorWithBlocking)) {
            return;
        }
        if (internalJob == null || internalJob instanceof ThreadJob || internalJob.isSystem()) {
            status = new Status(1, "org.eclipse.core.jobs", 1, JobMessages.jobs_blocked0, null);
        } else {
            String string = NLS.bind((String)JobMessages.jobs_blocked1, (Object)internalJob.getName());
            status = new JobStatus(1, (Job)internalJob, string);
        }
        ((IProgressMonitorWithBlocking)iProgressMonitor).setBlocked((IStatus)status);
    }

    public static final void reportUnblocked(JobManager jobManager, IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor instanceof IProgressMonitorWithBlocking) {
            ((IProgressMonitorWithBlocking)iProgressMonitor).clearBlocked();
        }
    }
}

