/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob$$Cold;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ObjectMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class InternalJob
extends PlatformObject
implements Comparable {
    static final int ABOUT_TO_RUN = 16;
    static final int ABOUT_TO_SCHEDULE = 32;
    static final int BLOCKED = 8;
    private static final int M_STATE = 255;
    private static final int M_SYSTEM = 256;
    private static final int M_USER = 512;
    private static final int M_ABOUT_TO_RUN_CANCELED = 1024;
    protected static final JobManager manager = JobManager.getInstance();
    private static int nextJobNumber = 0;
    static final long T_INFINITE = Long.MAX_VALUE;
    static final long T_NONE = -1L;
    private volatile int flags = 0;
    private final int jobNumber = nextJobNumber++;
    private ListenerList listeners = null;
    private IProgressMonitor monitor;
    private String name;
    private InternalJob next;
    private InternalJob previous;
    private int priority = 30;
    private ObjectMap properties;
    private IStatus result;
    private ISchedulingRule schedulingRule;
    private long startTime;
    private long waitQueueStamp = -1L;
    private volatile Thread thread = null;
    static Class class$0;

    protected InternalJob(String string) {
        Assert.isNotNull((Object)string);
        this.name = string;
    }

    protected boolean belongsTo(Object object) {
        return false;
    }

    protected boolean cancel() {
        return manager.cancel(this);
    }

    protected void canceling() {
    }

    protected void done(IStatus iStatus) {
        manager.endJob(this, iStatus, true);
    }

    final ListenerList getListeners() {
        return this.listeners;
    }

    protected String getName() {
        return this.name;
    }

    protected int getPriority() {
        return this.priority;
    }

    final IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    protected IStatus getResult() {
        return this.result;
    }

    protected ISchedulingRule getRule() {
        return this.schedulingRule;
    }

    final long getStartTime() {
        return this.startTime;
    }

    protected int getState() {
        int n = this.flags & 0xFF;
        switch (n) {
            case 8: {
                return 2;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 2;
            }
        }
        return n;
    }

    protected Thread getThread() {
        return this.thread;
    }

    final int internalGetState() {
        return this.flags & 0xFF;
    }

    final void internalSetPriority(int n) {
        this.priority = n;
    }

    final void internalSetRule(ISchedulingRule iSchedulingRule) {
        this.schedulingRule = iSchedulingRule;
    }

    final void internalSetState(int n) {
        this.flags = this.flags & 0xFFFFFF00 | n;
    }

    final boolean isAboutToRunCanceled() {
        return (this.flags & 0x400) != 0;
    }

    protected boolean isBlocking() {
        return manager.isBlocking(this);
    }

    protected boolean isSystem() {
        return (this.flags & 0x100) != 0;
    }

    protected boolean isUser() {
        return (this.flags & 0x200) != 0;
    }

    protected void join() throws InterruptedException {
        manager.join(this);
    }

    final InternalJob next() {
        return this.next;
    }

    final InternalJob previous() {
        return this.previous;
    }

    protected abstract IStatus run(IProgressMonitor var1);

    protected void setName(String string) {
        Assert.isNotNull((Object)string);
        this.name = string;
    }

    final void setNext(InternalJob internalJob) {
        this.next = internalJob;
    }

    final void setPrevious(InternalJob internalJob) {
        this.previous = internalJob;
    }

    protected void setPriority(int n) {
        switch (n) {
            case 10: 
            case 20: 
            case 30: 
            case 40: 
            case 50: {
                manager.setPriority(this, n);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException(String.valueOf(n));
            }
        }
    }

    final void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.monitor = iProgressMonitor;
    }

    final void setResult(IStatus iStatus) {
        this.result = iStatus;
    }

    protected void setRule(ISchedulingRule iSchedulingRule) {
        manager.setRule(this, iSchedulingRule);
    }

    final void setStartTime(long l) {
        this.startTime = l;
    }

    protected void setSystem(boolean bl) {
        if (this.getState() != 0) {
            throw (Throwable)new IllegalStateException();
        }
        this.flags = bl ? this.flags | 0x100 : this.flags & 0xFFFFFEFF;
    }

    protected void setThread(Thread thread) {
        this.thread = thread;
    }

    protected boolean shouldSchedule() {
        return true;
    }

    protected boolean sleep() {
        return manager.sleep(this);
    }

    protected void wakeUp(long l) {
        manager.wakeUp(this, l);
    }

    void setWaitQueueStamp(long l) {
        this.waitQueueStamp = l;
    }

    long getWaitQueueStamp() {
        return this.waitQueueStamp;
    }

    protected void addJobChangeListener(IJobChangeListener iJobChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(1);
        }
        this.listeners.add((Object)iJobChangeListener);
    }

    final void addLast(InternalJob internalJob) {
        InternalJob internalJob2 = this;
        while (internalJob2.previous != null) {
            internalJob2 = internalJob2.previous;
        }
        internalJob2.previous = internalJob;
        internalJob.next = internalJob2;
        internalJob.previous = null;
    }

    public final int compareTo(Object object) {
        return ((InternalJob)object).startTime >= this.startTime ? 1 : -1;
    }

    protected Object getProperty(QualifiedName qualifiedName) {
        ObjectMap objectMap = this.properties;
        if (objectMap == null) {
            return null;
        }
        return objectMap.get(qualifiedName);
    }

    final boolean isConflicting(InternalJob internalJob) {
        ISchedulingRule iSchedulingRule = internalJob.getRule();
        if (this.schedulingRule == null || iSchedulingRule == null) {
            return false;
        }
        Class<?> clazz = this.schedulingRule.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.runtime.jobs.MultiRule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.schedulingRule.isConflicting(iSchedulingRule);
        }
        return iSchedulingRule.isConflicting(this.schedulingRule);
    }

    final InternalJob remove() {
        if (this.next != null) {
            this.next.setPrevious(this.previous);
        }
        if (this.previous != null) {
            this.previous.setNext(this.next);
        }
        this.previous = null;
        this.next = null;
        return this;
    }

    protected void removeJobChangeListener(IJobChangeListener iJobChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove((Object)iJobChangeListener);
        }
    }

    protected void schedule(long l) throws  {
        InternalJob$$Cold.schedule(this, l);
    }

    final void setAboutToRunCanceled(boolean bl) {
        this.flags = bl ? this.flags | 0x400 : this.flags & 0xFFFFFBFF;
    }

    protected void setProgressGroup(IProgressMonitor iProgressMonitor, int n) throws  {
        InternalJob$$Cold.setProgressGroup(this, iProgressMonitor, n);
    }

    protected void setProperty(QualifiedName qualifiedName, Object object) {
        if (object == null) {
            if (this.properties == null) {
                return;
            }
            ObjectMap objectMap = (ObjectMap)this.properties.clone();
            objectMap.remove(qualifiedName);
            this.properties = objectMap.isEmpty() ? null : objectMap;
        } else {
            ObjectMap objectMap = this.properties;
            objectMap = objectMap == null ? new ObjectMap(5) : (ObjectMap)this.properties.clone();
            objectMap.put(qualifiedName, object);
            this.properties = objectMap;
        }
    }

    protected void setUser(boolean bl) {
        if (this.getState() != 0) {
            throw (Throwable)new IllegalStateException();
        }
        this.flags = bl ? this.flags | 0x200 : this.flags & 0xFFFFFDFF;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.jobNumber + ")";
    }
}

