/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.util;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import org.eclipse.jface.viewers.IElementComparer;

public class ItemHandleComparer
implements IElementComparer {
    public boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (a instanceof IItemHandle && b instanceof IItemHandle) {
            IItemHandle handle1 = (IItemHandle)a;
            IItemHandle handle2 = (IItemHandle)b;
            UUID repository1UUID = this.getRepositoryId(handle1);
            UUID repository2UUID = this.getRepositoryId(handle2);
            if (repository1UUID == null) {
                if (repository2UUID == null) {
                    return handle1.sameItemId(handle2);
                }
                return false;
            }
            if (repository2UUID == null) {
                return false;
            }
            return repository1UUID.compareTo((Object)repository2UUID) == 0 && handle1.sameItemId(handle2);
        }
        return a.equals(b);
    }

    private UUID getRepositoryId(IItemHandle handle) {
        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
        if (repository != null) {
            return repository.getId();
        }
        return null;
    }

    public int hashCode(Object element) {
        if (element == null) {
            return 0;
        }
        if (element instanceof IItemHandle) {
            IItemHandle handle = (IItemHandle)element;
            UUID teamRepositoryId = this.getRepositoryId(handle);
            if (teamRepositoryId != null) {
                return handle.getItemId().hashCode() + teamRepositoryId.hashCode();
            }
            return handle.getItemId().hashCode();
        }
        return element.hashCode();
    }
}

