/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.util;

import com.ibm.team.foundation.rcp.ui.internal.util.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class Utils {
    public static final int MAX_VISIBLE_ITEMS_PER_COMBO = 15;

    public static IStatus validateRepository(ITeamRepository repository, boolean showErrorDialog, IProgressMonitor monitor) {
        if (repository.loggedIn() && repository.getErrorState() == 0) {
            return Utils.assessStatus(repository, false, null);
        }
        boolean inUIthread = Display.getCurrent() != null;
        final IStatus status = inUIthread ? Utils.loginFromUIThread(repository) : Utils.loginFromBackgroundThread(repository, monitor);
        if (showErrorDialog && status.getSeverity() == 4) {
            if (inUIthread) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.Utils_VALIDATION_ERROR, (String)status.getMessage());
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.Utils_VALIDATION_ERROR, (String)status.getMessage());
                    }
                });
            }
        }
        return status;
    }

    private static IStatus loginFromUIThread(final ITeamRepository repository) {
        try {
            final IStatus[] status = new IStatus[1];
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    status[0] = Utils.loginFromBackgroundThread(repository, monitor);
                }
            });
            return status[0];
        }
        catch (InvocationTargetException ex) {
            return Utils.assessStatus(repository, false, (Exception)ex.getCause());
        }
        catch (InterruptedException interruptedException) {
            return Utils.assessStatus(repository, true, null);
        }
    }

    private static IStatus loginFromBackgroundThread(ITeamRepository repository, IProgressMonitor monitor) {
        try {
            repository.login(monitor);
            return Utils.assessStatus(repository, false, null);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Utils.assessStatus(repository, true, null);
        }
        catch (TeamRepositoryException e) {
            return Utils.assessStatus(repository, false, (Exception)((Object)e));
        }
    }

    private static IStatus assessStatus(ITeamRepository repository, boolean wasCanceled, Exception x) {
        if (repository.loggedIn() && repository.getErrorState() == 0) {
            return Status.OK_STATUS;
        }
        if (wasCanceled) {
            return Status.CANCEL_STATUS;
        }
        String reason = x != null ? x.getLocalizedMessage() : (repository.getErrorState() == 2 ? Messages.Utils_AUTH_ERROR : Messages.Utils_CON_ERROR);
        String message = NLS.bind((String)Messages.Utils_COULD_NOT_LOGIN, (Object)reason, (Object[])new Object[0]);
        return new Status(4, "com.ibm.team.foundation.rcp.ui", message, (Throwable)x);
    }

    public static String escapeForHTMLTransfer(String string) {
        if (string == null || string.length() == 0 || !SWT.getPlatform().equals("win32")) {
            return string;
        }
        Charset defaultCharset = Charset.defaultCharset();
        if (!defaultCharset.canEncode()) {
            return string;
        }
        CharsetEncoder encoder = defaultCharset.newEncoder();
        if (encoder.canEncode(string)) {
            return string;
        }
        StringBuilder builder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (encoder.canEncode(ch)) {
                builder.append(ch);
            } else {
                builder.append("&#");
                builder.append((int)ch);
                builder.append(";");
            }
            ++n2;
        }
        return builder.toString();
    }
}

