/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.dnd;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class URIReferenceTransferDragSourceListener
extends DragSourceAdapter
implements TransferDragSourceListener {
    private CreateReferencesJob fJob;
    private final ISelectionProvider fProvider;

    public URIReferenceTransferDragSourceListener(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
    }

    protected ISelection convertSelection(ISelection selection) {
        return selection;
    }

    protected URIReference[] createReferences(Object[] elements) {
        Assert.isNotNull((Object)elements);
        ArrayList<URIReference> collection = new ArrayList<URIReference>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)new NullProgressMonitor());
            if (reference != null) {
                collection.add(reference);
            }
            ++n2;
        }
        return collection.toArray(new URIReference[collection.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        this.fJob = null;
    }

    public void dragSetData(DragSourceEvent event) {
        if (URIReferenceTransfer.getInstance().isSupportedType(event.dataType) && this.fJob != null) {
            try {
                this.fJob.join();
            }
            catch (InterruptedException interruptedException) {}
            URIReference[] references = this.fJob.fetchReferences();
            if (references != null && references.length > 0) {
                event.data = references;
            } else {
                event.doit = false;
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fProvider.getSelection();
        if (selection != null) {
            boolean result = this.validateSelection(selection);
            if (result) {
                if (!(selection = this.convertSelection(selection)).isEmpty()) {
                    this.fJob = new CreateReferencesJob(selection);
                    this.fJob.setSystem(true);
                    this.fJob.setPriority(20);
                    this.fJob.schedule();
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        } else {
            event.doit = false;
        }
    }

    public Transfer getTransfer() {
        return URIReferenceTransfer.getInstance();
    }

    protected boolean validateSelection(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        return selection instanceof IStructuredSelection;
    }

    private class CreateReferencesJob
    extends FoundationJob {
        private URIReference[] fReferences;
        private ISelection fSelection;

        public CreateReferencesJob(ISelection selection) {
            super("");
            this.fReferences = null;
            this.fSelection = null;
            this.fSelection = selection;
        }

        private URIReference[] computeReferences(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                return URIReferenceTransferDragSourceListener.this.createReferences(((IStructuredSelection)selection).toArray());
            }
            return null;
        }

        public URIReference[] fetchReferences() {
            URIReference[] references = this.fReferences;
            this.fReferences = null;
            return references;
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            this.fReferences = this.computeReferences(this.fSelection);
            return Status.OK_STATUS;
        }
    }
}

