/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProcessDefinitionImportUtil {
    public static final String NAME_TXT = "name.txt";
    public static final String PROCESS_ID_TXT = "processId.txt";
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    public static final String fgCurrentVersion = "2";

    public static String getProcessId(File baseDir) throws TeamRepositoryException, IOException {
        return ProcessDefinitionImportUtil.getAttribute(baseDir, PROCESS_ID_TXT);
    }

    public static String getName(File baseDir) throws TeamRepositoryException, IOException {
        return ProcessDefinitionImportUtil.getAttribute(baseDir, NAME_TXT);
    }

    private static String getAttribute(File baseDir, String attributeFileName) throws TeamRepositoryException, IOException {
        if (!baseDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.0"), baseDir));
        }
        if (!baseDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.1"), baseDir));
        }
        String versionFile = "version.txt";
        String versionString = ProcessDefinitionImportUtil.createStringFromFile(baseDir, versionFile);
        if (versionString == null || versionString.trim().length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.2"), versionFile));
        }
        ProcessDefinitionImportUtil.assertVersionMatch(versionString, "2");
        return ProcessDefinitionImportUtil.createStringFromFile(baseDir, attributeFileName);
    }

    private static void assertVersionMatch(String importVersion, String currentVersion) throws TeamRepositoryException {
        if (!currentVersion.equals(importVersion)) {
            try {
                float current = Float.parseFloat(currentVersion);
                float imported = Float.parseFloat(importVersion);
                if (imported < current) {
                    throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionImportUtil.23"));
                }
                throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionImportUtil.24"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionImportUtil.25"));
            }
        }
    }

    public static IProcessDefinition createDefinition(File baseDir, String name, String processId, IProcessDefinition definitionToOverwrite, IDefinitionImportContext importContext, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        String specificationFile;
        IContent specification;
        IProcessDefinition definition;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1000);
        if (!baseDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.4"), baseDir));
        }
        if (!baseDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.5"), baseDir));
        }
        String versionFile = "version.txt";
        String versionString = ProcessDefinitionImportUtil.createStringFromFile(baseDir, versionFile);
        if (versionString == null || versionString.trim().length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.6"), versionFile));
        }
        ProcessDefinitionImportUtil.assertVersionMatch(versionString, "2");
        String componentsFile = "components.txt";
        String componentsString = ProcessDefinitionImportUtil.createStringFromFile(baseDir, componentsFile);
        if (componentsString == null || versionString.trim().length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.18"), componentsFile));
        }
        ProcessDefinitionImportUtil.assertValidComponents(componentsString, importContext);
        if (name == null) {
            name = ProcessDefinitionImportUtil.createStringFromFile(baseDir, NAME_TXT);
        }
        if (name == null || name.length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.8"), NAME_TXT));
        }
        if (processId == null) {
            processId = ProcessDefinitionImportUtil.createStringFromFile(baseDir, PROCESS_ID_TXT);
        }
        if (processId == null || processId.length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.9"), PROCESS_ID_TXT));
        }
        String contentPath = ProcessDefinitionImportUtil.createStringFromFile(baseDir, "contentURL.txt");
        String summary = ProcessDefinitionImportUtil.createStringFromFile(baseDir, "summary.txt");
        if (definitionToOverwrite != null) {
            definition = (IProcessDefinition)definitionToOverwrite.getWorkingCopy();
        } else {
            definition = (IProcessDefinition)IProcessDefinition.ITEM_TYPE.createItem();
            definition.setProcessId(processId);
        }
        definition.setName(name);
        definition.setProcessContentPath(contentPath);
        definition.getDescription().setSummary(summary);
        IContent description = importContext.createTextContentFromFile(baseDir, "description.txt", (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        if (description != null) {
            definition.getDescription().setDetails(description);
        }
        if ((specification = importContext.createTextContentFromFile(baseDir, specificationFile = "specification.txt", (IProgressMonitor)new SubProgressMonitor(monitor, 100))) == null) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.10"), specificationFile));
        }
        definition.getProcessData().put("com.ibm.team.internal.process.compiled.xml", specification);
        String stateFile = "state.txt";
        IContent state = importContext.createTextContentFromFile(baseDir, stateFile, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        if (state == null) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.11"), stateFile));
        }
        definition.getProcessData().put("com.ibm.team.internal.process.state.xml", state);
        ArrayList<IProcessDefinition> itemsToSave = new ArrayList<IProcessDefinition>();
        itemsToSave.add(definition);
        ProcessDefinitionImportUtil.addAttachments(definition, baseDir, importContext, itemsToSave, (IProgressMonitor)new SubProgressMonitor(monitor, 750));
        IProcessItem[] saved = importContext.saveProcessItems(itemsToSave.toArray(new IProcessItem[itemsToSave.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        return (IProcessDefinition)saved[0];
    }

    private static void assertValidComponents(String componentsString, IDefinitionImportContext importContext) throws TeamRepositoryException {
        Map exportedComponents = ProcessDefinitionImportUtil.loadComponentsFromString(componentsString);
        Map currentComponents = ProcessDefinitionImportUtil.loadComponents(importContext);
        Set currentEntries = currentComponents.entrySet();
        for (Map.Entry currentEntry : currentEntries) {
            Object currentKey = currentEntry.getKey();
            String currentValue = (String)currentEntry.getValue();
            String exportedValue = (String)exportedComponents.get(currentKey);
            if (exportedValue == null) continue;
            ProcessDefinitionImportUtil.assertVersionMatch(exportedValue, currentValue);
        }
    }

    private static Map loadComponents(IDefinitionImportContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        IExtension[] extensions = context.getComponentExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("component".equals(element.getName())) {
                    IConfigurationElement[] models = element.getChildren("model");
                    int k = 0;
                    while (k < models.length) {
                        IConfigurationElement model = models[k];
                        String componentURI = model.getAttribute("uri");
                        String componentVersion = model.getAttribute("version");
                        if (componentURI != null && componentVersion != null) {
                            map.put(componentURI, componentVersion);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return map;
    }

    private static Map loadComponentsFromString(String componentsString) throws TeamRepositoryException {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(componentsString.getBytes("UTF-8")));
            NodeList components = document.getElementsByTagName("component");
            int i = 0;
            while (i < components.getLength()) {
                Element component = (Element)components.item(i);
                String componentURI = component.getAttribute("uri");
                if (componentURI == null) {
                    throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionImportUtil.21"));
                }
                String componentVersion = component.getAttribute("version");
                if (componentVersion == null) {
                    throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionImportUtil.22"));
                }
                map.put(componentURI, componentVersion);
                ++i;
            }
            return map;
        }
        catch (SAXException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static void addAttachments(IProcessDefinition definition, File baseDir, IDefinitionImportContext importContext, List attachments, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        definition.setAttachments(new IProcessAttachment[0]);
        File attachmentDir = new File(baseDir, "attachments");
        if (attachmentDir.exists() && attachmentDir.isDirectory()) {
            int fileKilos;
            String attachmentsFile = "attachments.txt";
            String attachmentsDescriptor = ProcessDefinitionImportUtil.createStringFromFile(baseDir, attachmentsFile);
            if (attachmentsDescriptor == null) {
                throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.12"), attachmentsFile));
            }
            ArrayList<String> attachmentPaths = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new StringReader(attachmentsDescriptor));
            String path = reader.readLine();
            while (path != null) {
                attachmentPaths.add(path);
                path = reader.readLine();
            }
            ArrayList attachmentFiles = new ArrayList();
            ProcessDefinitionImportUtil.findFiles(attachmentDir, attachmentFiles);
            int totalKiloBytes = 0;
            for (File file : attachmentFiles) {
                fileKilos = (int)Math.ceil((double)file.length() / 1000.0);
                if (Integer.MAX_VALUE - (totalKiloBytes + fileKilos) > 0) {
                    totalKiloBytes += fileKilos;
                    continue;
                }
                totalKiloBytes = Integer.MAX_VALUE;
            }
            monitor.beginTask("", totalKiloBytes);
            for (File file : attachmentFiles) {
                int index;
                fileKilos = (int)Math.ceil((double)file.length() / 1000.0);
                IProcessAttachment attachment = (IProcessAttachment)IProcessAttachment.ITEM_TYPE.createItem();
                Path fileName = new Path(file.getName());
                try {
                    index = Integer.parseInt(fileName.removeFileExtension().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (index >= attachmentPaths.size()) {
                    throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.13"), attachmentsFile, file.getName()));
                }
                String attachmentPath = (String)attachmentPaths.get(index);
                if (attachmentPath == null || attachmentPath.length() == 0) {
                    throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.14"), attachmentsFile, file.getName()));
                }
                attachment.setPath(attachmentPath);
                IContent content = importContext.createBinaryContentFromFile(file, (IProgressMonitor)new SubProgressMonitor(monitor, fileKilos));
                attachment.setContent(content);
                definition.addAttachment(attachment);
                attachment.setProcessContainer(definition);
                attachments.add(attachment);
            }
        }
    }

    private static void findFiles(File baseDir, List foundFiles) {
        File[] files = baseDir.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isFile()) {
                foundFiles.add(file);
            } else if (file.isDirectory()) {
                ProcessDefinitionImportUtil.findFiles(file, foundFiles);
            }
            ++i;
        }
    }

    public static final String createStringFromFile(File baseDir, String fileName) throws IOException {
        File file = new File(baseDir, fileName);
        if (!file.exists()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        try {
            char[] chars = new char[512];
            int read = reader.read(chars);
            while (read > 0) {
                buffer.append(chars, 0, read);
                read = reader.read(chars);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public static void unzip(File zipFileLocation, File destination, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        destination.mkdirs();
        ZipFile zip = new ZipFile(zipFileLocation);
        monitor.beginTask(NLS.bind(Messages.getCommonString("ProcessDefinitionImportUtil.15"), zip.getName()), zip.size());
        try {
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                monitor.worked(1);
                ZipEntry current = e.nextElement();
                File entryFile = new File(destination, current.getName());
                if (current.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                if (entryFile.exists()) continue;
                entryFile.getParentFile().mkdirs();
                FileOutputStream output = new FileOutputStream(entryFile);
                InputStream input = zip.getInputStream(current);
                ProcessDefinitionImportUtil.transferStreams(input, output);
            }
        }
        finally {
            monitor.done();
            zip.close();
        }
    }

    private static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        block27: {
            byte[] buffer = new byte[8192];
            try {
                while (true) {
                    int bytesRead = -1;
                    bytesRead = source.read(buffer);
                    if (bytesRead != -1) {
                        destination.write(buffer, 0, bytesRead);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                block25: {
                    try {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {
                            try {
                                destination.close();
                            }
                            catch (IOException iOException2) {}
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            destination.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException3) {}
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static interface IDefinitionImportContext {
        public IContent createTextContentFromFile(File var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

        public IContent createBinaryContentFromFile(File var1, IProgressMonitor var2) throws TeamRepositoryException, IOException;

        public IProcessItem[] saveProcessItems(IProcessItem[] var1, IProgressMonitor var2) throws TeamRepositoryException;

        public IExtension[] getComponentExtensions();
    }
}

