/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PermissionPath {
    public static final String PATH_SEPARATOR = "~#_~#";
    public static final String PATH_DELIMITER = ":~_:~";
    private List<String> fSegments = Collections.synchronizedList(new ArrayList());

    public PermissionPath(String path) {
        if (path != null) {
            if ((path = path.trim()).startsWith(PATH_SEPARATOR)) {
                path = path.substring(PATH_SEPARATOR.length());
            }
            if (path.endsWith(PATH_SEPARATOR)) {
                path = path.substring(0, path.length() - PATH_SEPARATOR.length());
            }
            String[] segments = path.split(PATH_SEPARATOR);
            int i = 0;
            while (i < segments.length) {
                String segment = segments[i].trim();
                if (segment.length() > 0) {
                    this.fSegments.add(segment);
                }
                ++i;
            }
        }
    }

    public PermissionPath() {
    }

    public PermissionPath append(String segment) {
        if (segment != null && (segment = segment.trim()).length() > 0) {
            this.fSegments.add(segment);
        }
        return new PermissionPath(this.toString());
    }

    public String toString() {
        StringBuffer path = new StringBuffer();
        Iterator<String> iter = this.fSegments.iterator();
        while (iter.hasNext()) {
            path.append((Object)iter.next());
            if (!iter.hasNext()) continue;
            path.append(PATH_SEPARATOR);
        }
        return path.toString();
    }

    public String[] segments() {
        return this.fSegments.toArray(new String[this.fSegments.size()]);
    }

    public int segmentCount() {
        return this.fSegments.size();
    }

    public PermissionPath removeFirstSegments(int numSegments) {
        int i = 0;
        while (i < numSegments) {
            if (this.fSegments.size() > 0) {
                this.fSegments.remove(0);
            }
            ++i;
        }
        return new PermissionPath(this.toString());
    }

    public String segment(int index) {
        if (index > -1 && index < this.fSegments.size()) {
            return this.fSegments.get(index);
        }
        return null;
    }

    public String lastSegment() {
        if (this.fSegments.size() > 0) {
            return this.segment(this.fSegments.size() - 1);
        }
        return null;
    }
}

