/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.customization;

import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.ProcessModelChange;
import com.ibm.team.process.internal.common.model.customization.Messages;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationElement;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.RoleDefinitions;
import com.ibm.team.process.internal.common.util.PermissionPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IRegion;

public class WriteableTeamCustomizationModel
extends TeamCustomizationModel {
    private boolean fNewCustomization = false;

    public WriteableTeamCustomizationModel() {
        this.setIsReadOnly(false);
    }

    public void setNewCustomization(boolean newCustomization) {
        this.assertNotReadOnly();
        this.fNewCustomization = newCustomization;
    }

    public boolean isNewCustomization() {
        return this.fNewCustomization;
    }

    public ProcessModelChange[] grantIterationPermissions(String notUsed, PermissionPath iterationPath, String roleId, PermissionPath[] paths) {
        this.assertNotReadOnly();
        TeamCustomizationElement teamCustomization = (TeamCustomizationElement)this.getTeamConfiguration();
        return this.grantIterationPermissions(iterationPath, roleId, paths, teamCustomization);
    }

    public ProcessModelChange[] grantTeamConfigurationPermissions(String roleId, PermissionPath[] paths) {
        this.assertNotReadOnly();
        ProcessModelChange[] changes = super.grantTeamConfigurationPermissions(roleId, paths);
        if (this.isNewCustomization()) {
            FindReplaceDocumentAdapter find = new FindReplaceDocumentAdapter(this.getCurrentDocument());
            try {
                IRegion found = find.find(0, "<permissions>", true, false, false, false);
                IRegion found2 = find.find(0, "</permissions>", true, false, false, false);
                this.getCurrentDocument().replace(found.getOffset(), found2.getOffset() - found.getOffset() + found2.getLength(), changes[0].getXMLSourceChange());
            }
            catch (BadLocationException badLocationException) {}
            changes = new ProcessModelChange[]{new ProcessModelChange(0, 0, this.getCurrentDocument().get())};
        }
        return changes;
    }

    public ProcessModelChange[] revokeIterationPermissions(String notUsed, PermissionPath iterationPath, String roleId, PermissionPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        TeamCustomizationElement teamCustomization = (TeamCustomizationElement)this.getTeamConfiguration();
        return this.revokeIterationPermissions(iterationPath, roleId, paths, teamCustomization, clearOverride);
    }

    public ProcessModelChange[] changeDevelopmentLineOperation(String developmentLineId, String roleId, String operationId, boolean isFinal, String explanation) {
        throw new IllegalStateException(Messages.getCommonString("TeamCustomizationModel.0"));
    }

    public static String getDefaultXML() {
        String lineDelimiter = System.getProperty("line.separator");
        String expectedXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + lineDelimiter + "<team-customization xmlns=\"http://com.ibm.team.process\">" + lineDelimiter + "\t<permissions>" + lineDelimiter + "\t</permissions>" + lineDelimiter + "\t<behavior>" + lineDelimiter + "\t</behavior>" + lineDelimiter + "</team-customization>" + lineDelimiter;
        return expectedXML;
    }

    public ProcessModelChange[] addRoleDefinitions(String[] roleIds, String[] names, String[] descriptions, boolean[] singleCardinality) {
        this.assertNotReadOnly();
        TeamCustomizationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        return this.createRoleDefinitions(roleIds, names, descriptions, singleCardinality, roleDefinitionsElement);
    }

    public ProcessModelChange[] removeRoleDefinitions(String[] roleIds) {
        this.assertNotReadOnly();
        TeamCustomizationElement root = this.getRoot();
        RoleDefinitions roleDefinitionsElement = root.getRoleDefinitionsElement();
        return this.removeRoleDefinitions(roleIds, roleDefinitionsElement);
    }

    protected ProcessModelChange generateChangesForNewRoleDefinitions(RoleDefinitions roleDefinitions) {
        if (this.isNewCustomization()) {
            AbstractElement parent = roleDefinitions.getParentElement();
            int startOffset = parent.getStartTagEndOffset();
            String changedXML = String.valueOf(this.getLineDelimiter()) + '\t' + roleDefinitions.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter());
            FindReplaceDocumentAdapter find = new FindReplaceDocumentAdapter(this.getCurrentDocument());
            try {
                IRegion found = find.find(0, "http://com.ibm.team.process\">", true, false, false, false);
                this.getCurrentDocument().replace(found.getOffset() + found.getLength(), 0, changedXML);
            }
            catch (BadLocationException badLocationException) {}
            return new ProcessModelChange(0, 0, this.getCurrentDocument().get());
        }
        return super.generateChangesForNewRoleDefinitions(roleDefinitions);
    }
}

