/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model;

import com.ibm.team.process.common.IIterationConfiguration;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.process.internal.common.ITeamConfiguration;
import com.ibm.team.process.internal.common.model.AbstractElement;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.IIterationParent;
import com.ibm.team.process.internal.common.model.Messages;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.ProcessModelChange;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationElement;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.IPermissionActionParent;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsRoleElement;
import com.ibm.team.process.internal.common.model.settings.RoleDefinition;
import com.ibm.team.process.internal.common.model.settings.RoleDefinitions;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.InitializationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.rest.PermissionDTO;
import com.ibm.team.process.internal.common.util.PermissionPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractModel
extends AbstractElement {
    public static final String EMPTY = "";
    private Exception fException = null;
    protected ModelGenerator fModelGenerator = null;
    private IDocument fCurrentDocument;
    private PermissionDTO[] fProjectPermissions;
    private PermissionDTO[] fTeamPermissions;
    private boolean fIsReadOnly = true;

    protected AbstractModel() {
        super(null, null, EMPTY, null);
    }

    public Exception initialize(String xmlData) {
        if (this.fModelGenerator == null) {
            if (xmlData != null && xmlData.trim().length() > 0) {
                try {
                    this.fModelGenerator = this.createModelGenerator();
                    if (this.fModelGenerator.getDirective(ElementBuilderDirectives.COMPUTE_ELEMENT_OFFSETS) != null) {
                        this.fCurrentDocument = new Document(xmlData);
                    }
                    this.fModelGenerator.generate(xmlData);
                }
                catch (RuntimeException e) {
                    this.fException = e;
                }
            }
            return this.fException;
        }
        this.fException = new Exception(Messages.getCommonString("AbstractModel.1"));
        return this.fException;
    }

    public Exception initialize(IDocument xmlDocument) {
        if (this.fModelGenerator == null) {
            this.fCurrentDocument = xmlDocument;
            String xmlData = xmlDocument.get();
            if (xmlData != null && xmlData.trim().length() > 0) {
                try {
                    this.fModelGenerator = this.createModelGenerator();
                    this.fModelGenerator.generate(xmlData);
                }
                catch (RuntimeException e) {
                    this.fException = e;
                }
            }
            return this.fException;
        }
        this.fException = new Exception(Messages.getCommonString("AbstractModel.2"));
        return this.fException;
    }

    protected ModelGenerator createModelGenerator() {
        return new ModelGenerator(this);
    }

    public abstract AbstractElementBuilder getRootBuilder();

    public void dispose() {
        this.fCurrentDocument = null;
        this.clearChildElements();
    }

    public void warning(Exception x) {
    }

    public void error(Exception x) {
        this.fException = x;
    }

    public void fatalError(Exception x) {
        this.fException = x;
    }

    public static String serializeDocument(org.w3c.dom.Document doc) throws TransformerException, IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("indent-number", new Integer(4));
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        StreamResult outputTarget = new StreamResult(new OutputStreamWriter((OutputStream)s, "UTF-8"));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public IDocument getCurrentDocument() {
        return this.fCurrentDocument;
    }

    public ITeamConfiguration getTeamConfiguration() {
        AbstractElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return ((ProcessSpecificationElement)root).getTeamConfiguration();
        }
        return null;
    }

    public abstract AbstractElement getRoot();

    public IRole[] getRoleDefinitions() {
        AbstractElement root = this.getRoot();
        if (root instanceof ProcessSpecificationElement) {
            return ((ProcessSpecificationElement)root).getRoleDefinitions();
        }
        if (root instanceof TeamCustomizationElement) {
            return ((TeamCustomizationElement)root).getRoleDefinitions();
        }
        return new IRole[0];
    }

    protected ProcessModelChange[] revokePermissions(String roleId, PermissionPath[] paths, boolean clearOverride, PermissionsElement permissions) {
        ProcessModelChange[] changes = new ProcessModelChange[paths.length];
        int i = 0;
        while (i < paths.length) {
            PermissionPath path = paths[i];
            String operationId = path.segments()[0];
            String actionPath = null;
            if (path.segmentCount() > 1) {
                actionPath = path.removeFirstSegments(1).toString();
            }
            changes[i] = this.revokePermission(roleId, operationId, actionPath, clearOverride, permissions);
            ++i;
        }
        return changes;
    }

    private ProcessModelChange revokePermission(String roleId, String operationId, String actionPath, boolean clearOverride, PermissionsElement permissions) {
        if (permissions == null) {
            return null;
        }
        PermissionsRoleElement roleElement = permissions.getRoleElement(roleId);
        if (roleElement == null) {
            return null;
        }
        AbstractElement changedElement = null;
        OperationPermissionsConfiguration operation = roleElement.getOperation(operationId);
        if (operation == null) {
            return null;
        }
        if (actionPath == null) {
            if (operation.isFinal() && !clearOverride) {
                operation.clearChildElements();
                changedElement = operation;
            } else {
                roleElement.removeOperation(operation.getId());
                if (roleElement.getOperations().length == 0) {
                    permissions.removeRoleElement(roleElement.getId());
                    changedElement = permissions;
                } else {
                    changedElement = roleElement;
                }
            }
        } else {
            PermissionPath path = new PermissionPath(actionPath);
            changedElement = this.removeAction(path, operation, null);
        }
        if (changedElement != null) {
            String changedXML = changedElement.toXML(this.computeLineIndent(this.getCurrentDocument(), changedElement.getParentElement().getStartOffset()), this.getLineDelimiter());
            ProcessModelChange change = new ProcessModelChange(changedElement.getStartOffset(), changedElement.getEndOffset(), changedXML);
            return change;
        }
        return null;
    }

    private List getPermittedActions(AbstractElement element) {
        String operationId = this.getOperationId(element);
        String id = EMPTY;
        id = element instanceof PermissionActionElement ? ((PermissionActionElement)element).getId() : ((OperationPermissionsConfiguration)element).getId();
        boolean isProjectPermission = this.isProjectPermission(element);
        PermissionDTO[] permissions = isProjectPermission ? this.fProjectPermissions : this.fTeamPermissions;
        PermissionDTO operationPermissionDTO = null;
        int i = 0;
        while (i < permissions.length) {
            PermissionDTO category = permissions[i];
            operationPermissionDTO = this.getPermissionDTO(operationId, category);
            if (operationPermissionDTO != null) break;
            ++i;
        }
        if (operationPermissionDTO != null) {
            if (id.equals(operationId)) {
                return operationPermissionDTO.getItems();
            }
            PermissionDTO parent = operationPermissionDTO;
            ArrayList<AbstractElement> parents = new ArrayList<AbstractElement>();
            AbstractElement parentElement = element.getParentElement();
            while (!(parentElement instanceof OperationPermissionsConfiguration)) {
                parents.add(parentElement);
                parentElement = parentElement.getParentElement();
            }
            int i2 = parents.size() - 1;
            while (i2 > -1) {
                parentElement = (AbstractElement)parents.get(i2);
                String parentElementId = parentElement instanceof PermissionActionElement ? ((PermissionActionElement)parentElement).getId() : ((OperationPermissionsConfiguration)parentElement).getId();
                parent = this.getPermissionDTO(parentElementId, parent);
                --i2;
            }
            PermissionDTO permissionDTO = this.getPermissionDTO(id, parent);
            if (permissionDTO != null) {
                return permissionDTO.getItems();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isProjectPermission(AbstractElement element) {
        AbstractElement parent = element.getParentElement();
        if (parent instanceof ProjectConfigurationElement) {
            return true;
        }
        if (parent instanceof TeamConfigurationElement) {
            return false;
        }
        if (parent instanceof TeamCustomizationElement) {
            return false;
        }
        return this.isProjectPermission(parent);
    }

    private PermissionDTO getPermissionDTO(String id, PermissionDTO parent) {
        if (parent == null) {
            return null;
        }
        Iterator children = parent.getItems().iterator();
        PermissionDTO permissionDTO = null;
        while (children.hasNext()) {
            PermissionDTO permission = (PermissionDTO)children.next();
            String permissionId = new PermissionPath(permission.getId()).lastSegment();
            if (!permissionId.equals(id)) continue;
            permissionDTO = permission;
            break;
        }
        return permissionDTO;
    }

    private AbstractElement removeAction(PermissionPath actionPath, IPermissionActionParent parent, AbstractElement changedElement) {
        if (parent == null) {
            return null;
        }
        String actionId = actionPath.segment(0);
        if (actionPath.segmentCount() == 1) {
            if (!actionId.equals("any") && parent.getAction("any") != null) {
                parent.clearChildElements();
                this.createPermittedActions((AbstractElement)((Object)parent));
                if (changedElement == null) {
                    changedElement = (AbstractElement)((Object)parent);
                }
            }
            if (parent.removeAction(actionId) != null && changedElement == null && (changedElement = this.cleanupHierarchy((AbstractElement)((Object)parent))) == null) {
                changedElement = (AbstractElement)((Object)parent);
            }
            return changedElement;
        }
        if (parent.getAction("any") != null) {
            parent.clearChildElements();
            this.createPermittedActions((AbstractElement)((Object)parent));
            if (parent.getStartOffset() != -1) {
                changedElement = (AbstractElement)((Object)parent);
            }
        }
        return this.removeAction(actionPath.removeFirstSegments(1), parent.getAction(actionId), changedElement);
    }

    private void createPermittedActions(AbstractElement parent) {
        List permittedActions = this.getPermittedActions(parent);
        for (PermissionDTO action : permittedActions) {
            String permissionId = new PermissionPath(action.getId()).lastSegment();
            PermissionActionElement createdAction = this.createPermissionAction(parent, permissionId);
            if (action.getItems().size() <= 0) continue;
            this.createAnyPermissionAction(createdAction);
        }
    }

    private AbstractElement cleanupHierarchy(AbstractElement element) {
        PermissionsRoleElement roleElement;
        AbstractElement parentElement = element.getParentElement();
        if (element instanceof IPermissionActionParent) {
            IPermissionActionParent actionParent = (IPermissionActionParent)((Object)element);
            if (actionParent.getActions().length == 0) {
                AbstractElement changedElement;
                if (parentElement instanceof PermissionsRoleElement) {
                    OperationPermissionsConfiguration operation = (OperationPermissionsConfiguration)element;
                    if (!operation.isFinal()) {
                        ((PermissionsRoleElement)parentElement).removeOperation(actionParent.getId());
                    }
                } else {
                    ((IPermissionActionParent)((Object)parentElement)).removeAction(actionParent.getId());
                }
                if ((changedElement = this.cleanupHierarchy(parentElement)) == null) {
                    changedElement = parentElement;
                }
                return changedElement;
            }
        } else if (element instanceof PermissionsRoleElement && (roleElement = (PermissionsRoleElement)element).getOperations().length == 0) {
            ((PermissionsElement)parentElement).removeRoleElement(roleElement.getId());
            return parentElement;
        }
        return null;
    }

    public ProcessModelChange[] revokeTeamConfigurationPermissions(String roleId, PermissionPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        if (teamConfiguration == null) {
            return new ProcessModelChange[1];
        }
        PermissionsElement permissions = teamConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] grantTeamConfigurationPermissions(String roleId, PermissionPath[] paths) {
        this.assertNotReadOnly();
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        if (this instanceof TeamCustomizationModel) {
            return this.grantConfigurationPermissions(roleId, paths, (AbstractElement)((Object)teamConfiguration), teamConfiguration.getPermissions());
        }
        boolean newConfiguration = false;
        if (teamConfiguration == null) {
            teamConfiguration = this.createTeamConfigurationElement(this.getRoot());
            newConfiguration = true;
        }
        ProcessModelChange[] changes = this.grantConfigurationPermissions(roleId, paths, (AbstractElement)((Object)teamConfiguration), teamConfiguration.getPermissions());
        if (newConfiguration) {
            changes = this.generateChangesForNewTeamConfiguration((TeamConfigurationElement)teamConfiguration);
        }
        return changes;
    }

    protected ProcessModelChange[] grantConfigurationPermissions(String roleId, PermissionPath[] paths, AbstractElement configuration, PermissionsElement permissions) {
        boolean newPermissions = false;
        if (permissions == null) {
            permissions = this.createPermissionsElement(configuration);
            this.createRoleElement(roleId, permissions);
            newPermissions = true;
        }
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (newPermissions) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    public ProcessModelChange[] grantDevelopmentLinePermissions(String developmentLineId, String roleId, PermissionPath[] paths) {
        PermissionsElement permissions;
        this.assertNotReadOnly();
        DevelopmentLineConfiguration developmentLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        boolean newDevLine = false;
        if (developmentLineConfiguration == null) {
            newDevLine = true;
            developmentLineConfiguration = this.createDevelopmentLineConfiguration(developmentLineId, (TeamConfigurationElement)this.getTeamConfiguration());
            permissions = this.createPermissionsElement(developmentLineConfiguration);
            this.createRoleElement(roleId, permissions);
        }
        permissions = developmentLineConfiguration.getPermissions();
        boolean newPermissions = false;
        if (permissions == null) {
            permissions = this.createPermissionsElement(developmentLineConfiguration);
            this.createRoleElement(roleId, permissions);
            newPermissions = true;
        }
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (newDevLine) {
            changes = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration);
        } else if (newPermissions) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    public ProcessModelChange[] grantIterationTypePermissions(String iterationTypeId, String roleId, PermissionPath[] paths) {
        this.assertNotReadOnly();
        IterationTypeConfiguration[] iterationTypeConfigurations = this.getIterationTypeConfigurations(iterationTypeId, roleId);
        IterationTypeConfiguration newIterationTypeConfiguration = iterationTypeConfigurations[0];
        IterationTypeConfiguration iterationTypeConfiguration = iterationTypeConfigurations[1];
        PermissionsElement permissions = this.getPermissions(iterationTypeConfiguration, roleId);
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (newIterationTypeConfiguration != null) {
            changes = this.generateChangesForNewIterationType(newIterationTypeConfiguration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    private ProcessModelChange[] generateChangesForNewDevelopmentLine(DevelopmentLineConfiguration developmentLineConfiguration) {
        AbstractElement[] developmentLineConfigurations = ((TeamConfigurationElement)this.getTeamConfiguration()).getDevelopmentLineConfigurations();
        return this.generateChangesForNewElement(developmentLineConfiguration, developmentLineConfigurations);
    }

    private ProcessModelChange[] generateChangesForNewIterationType(IterationTypeConfiguration iterationTypeConfiguration) {
        AbstractElement[] iterationTypeConfigurations = this.getTeamConfiguration().getIterationTypeConfigurations();
        return this.generateChangesForNewElement(iterationTypeConfiguration, iterationTypeConfigurations);
    }

    private ProcessModelChange[] generateChangesForNewElement(AbstractElement newElement, AbstractElement[] siblings) {
        int startOffset;
        boolean atTheEnd = false;
        if (siblings.length > 1) {
            startOffset = siblings[siblings.length - 2].getEndOffset();
        } else {
            atTheEnd = true;
            startOffset = this.computeEndTagStartOffset((ModelElement)((Object)this.getTeamConfiguration()));
        }
        String changedXML = newElement.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter());
        if (atTheEnd) {
            changedXML = "\t" + changedXML;
        }
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, changedXML);
        return new ProcessModelChange[]{change};
    }

    protected ProcessModelChange[] generateChangesForNewIteration(IterationConfiguration iterationConfiguration) {
        int startOffset;
        boolean atTheEnd = false;
        AbstractElement parentConfiguration = iterationConfiguration.getParentElement();
        IIterationConfiguration[] iterationConfigurations = parentConfiguration instanceof DevelopmentLineConfiguration ? ((DevelopmentLineConfiguration)parentConfiguration).getIterations() : (parentConfiguration instanceof TeamCustomizationElement ? ((TeamCustomizationElement)parentConfiguration).getIterationConfigurations() : ((IterationConfiguration)parentConfiguration).getChildIterations());
        if (iterationConfigurations.length > 1) {
            startOffset = ((ModelElement)((Object)iterationConfigurations[iterationConfigurations.length - 2])).getEndOffset();
        } else {
            atTheEnd = true;
            startOffset = this.computeEndTagStartOffset(parentConfiguration);
        }
        String changedXML = iterationConfiguration.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter());
        if (atTheEnd) {
            changedXML = "\t" + changedXML;
        }
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, changedXML);
        return new ProcessModelChange[]{change};
    }

    protected ProcessModelChange[] generateChangesForNewPermissions(PermissionsElement permissions) {
        AbstractElement parentConfiguration = permissions.getParentElement();
        if (parentConfiguration instanceof ProjectConfigurationElement) {
            return this.generateChangesForNewProjectConfigurationPermissions(permissions, (ProjectConfigurationElement)parentConfiguration);
        }
        int startOffset = parentConfiguration.getStartTagEndOffset() + 1;
        StringBuilder sb = new StringBuilder("\n");
        permissions.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter(), sb);
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, sb.toString());
        return new ProcessModelChange[]{change};
    }

    protected ProcessModelChange[] generateChangesForNewTeamConfiguration(TeamConfigurationElement teamConfiguration) {
        AbstractElement parent = teamConfiguration.getParentElement();
        int startOffset = parent.getStartTagEndOffset() + 1;
        StringBuilder sb = new StringBuilder("\n");
        teamConfiguration.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter(), sb);
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, sb.toString());
        return new ProcessModelChange[]{change};
    }

    private ProcessModelChange[] generateChangesForNewProjectConfigurationPermissions(PermissionsElement permissions, ProjectConfigurationElement parentElement) {
        int startOffset;
        InitializationElement initializationElement = parentElement.getInitialization();
        StringBuilder changedXML = new StringBuilder();
        if (initializationElement == null) {
            startOffset = parentElement.getStartTagEndOffset() + 1;
            changedXML.append("\n");
            permissions.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter(), changedXML);
        } else {
            startOffset = initializationElement.getEndOffset() + 1;
            permissions.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter(), changedXML);
        }
        ProcessModelChange change = new ProcessModelChange(startOffset, startOffset, changedXML.toString());
        return new ProcessModelChange[]{change};
    }

    public ProcessModelChange[] grantIterationPermissions(String developmentLineId, PermissionPath iterationPath, String roleId, PermissionPath[] paths) {
        this.assertNotReadOnly();
        DevelopmentLineConfiguration developmentLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        boolean newDevLine = false;
        if (developmentLineConfiguration == null) {
            newDevLine = true;
            developmentLineConfiguration = this.createDevelopmentLineConfiguration(developmentLineId, (TeamConfigurationElement)this.getTeamConfiguration());
        }
        ProcessModelChange[] changes = this.grantIterationPermissions(iterationPath, roleId, paths, developmentLineConfiguration);
        if (newDevLine) {
            changes = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration);
        }
        return changes;
    }

    protected ProcessModelChange[] grantIterationPermissions(PermissionPath iterationPath, String roleId, PermissionPath[] paths, IIterationParent iterationParent) {
        IterationConfiguration[] configurations = this.getIterationConfigurations(iterationParent, iterationPath.segments());
        IterationConfiguration newIteration = configurations[0];
        IterationConfiguration iterationConfiguration = configurations[1];
        PermissionsElement permissions = this.getPermissions(iterationConfiguration, roleId);
        ProcessModelChange[] changes = this.grantPermissions(roleId, paths, permissions);
        if (newIteration != null) {
            changes = this.generateChangesForNewIteration(newIteration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    public ProcessModelChange[] grantIterationPermissions(String developmentLineId, String iterationId, String roleId, PermissionPath[] paths) {
        this.assertNotReadOnly();
        return this.grantIterationPermissions(developmentLineId, new PermissionPath(iterationId), roleId, paths);
    }

    protected IterationConfiguration createIterationConfiguration(String iterationId, AbstractElement parentConfiguration) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, iterationId);
        IterationConfiguration iteration = new IterationConfiguration(parentConfiguration, parentConfiguration.getNamespaceURI(), "iteration", attributes);
        parentConfiguration.addChildElement(iteration);
        return iteration;
    }

    private int computeEndTagStartOffset(ModelElement element) {
        IDocument document = this.getCurrentDocument();
        try {
            int endTagStartOffset = element.getEndOffset() - 1;
            char ch = document.getChar(endTagStartOffset);
            while (ch != '<') {
                ch = document.getChar(--endTagStartOffset);
            }
            return endTagStartOffset;
        }
        catch (BadLocationException badLocationException) {
            return element.getStartTagEndOffset() + 1;
        }
    }

    public ProcessModelChange[] revokeDevelopmentLinePermissions(String developmentLineId, String roleId, PermissionPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        DevelopmentLineConfiguration devLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        if (devLineConfiguration == null) {
            return new ProcessModelChange[1];
        }
        PermissionsElement permissions = devLineConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] revokeIterationTypePermissions(String iterationTypeId, String roleId, PermissionPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        IterationTypeConfiguration iterationTypeConfiguration = this.getIterationTypeConfiguration(iterationTypeId);
        if (iterationTypeConfiguration == null) {
            return new ProcessModelChange[1];
        }
        PermissionsElement permissions = iterationTypeConfiguration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] revokeIterationPermissions(String developmentLineId, PermissionPath iterationPath, String roleId, PermissionPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        DevelopmentLineConfiguration devLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        return this.revokeIterationPermissions(iterationPath, roleId, paths, devLineConfiguration, clearOverride);
    }

    protected ProcessModelChange[] revokeIterationPermissions(PermissionPath iterationPath, String roleId, PermissionPath[] paths, IIterationParent iterationParent, boolean clearOverride) {
        if (iterationParent == null) {
            return new ProcessModelChange[1];
        }
        String[] iterationIds = iterationPath.segments();
        IterationConfiguration iteration = iterationParent.getIterationConfiguration(iterationIds[0]);
        if (iteration == null) {
            return new ProcessModelChange[1];
        }
        int i = 1;
        while (i < iterationIds.length) {
            String iterationId = iterationIds[i];
            if ((iteration = iteration.getIteration(iterationId)) == null) {
                return new ProcessModelChange[1];
            }
            ++i;
        }
        PermissionsElement permissions = iteration.getPermissions();
        return this.revokePermissions(roleId, paths, clearOverride, permissions);
    }

    public ProcessModelChange[] revokeIterationPermissions(String developmentLineId, String iterationId, String roleId, PermissionPath[] paths, boolean clearOverride) {
        this.assertNotReadOnly();
        return this.revokeIterationPermissions(developmentLineId, new PermissionPath(iterationId), roleId, paths, clearOverride);
    }

    protected DevelopmentLineConfiguration getDevelopmentLineConfiguration(String developmentLineId) {
        if (this instanceof TeamCustomizationModel) {
            return null;
        }
        TeamConfigurationElement teamConfiguration = (TeamConfigurationElement)this.getTeamConfiguration();
        return teamConfiguration.getDevelopmentLineConfiguration(developmentLineId);
    }

    private IterationTypeConfiguration getIterationTypeConfiguration(String iterationTypeId) {
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        return teamConfiguration.getIterationTypeConfiguration(iterationTypeId);
    }

    protected ProcessModelChange[] grantPermissions(String roleId, PermissionPath[] paths, PermissionsElement permissions) {
        ProcessModelChange[] changes = new ProcessModelChange[paths.length];
        int i = 0;
        while (i < paths.length) {
            PermissionPath path = paths[i];
            String operationId = path.segments()[0];
            String actionPath = null;
            if (path.segmentCount() > 1) {
                actionPath = path.removeFirstSegments(1).toString();
            }
            changes[i] = this.grantPermission(roleId, operationId, actionPath, permissions);
            ++i;
        }
        return changes;
    }

    private ProcessModelChange grantPermission(String roleId, String operationId, String actionPath, PermissionsElement permissions) {
        OperationPermissionsConfiguration operation;
        PermissionsRoleElement roleElement = permissions.getRoleElement(roleId);
        if (roleElement == null) {
            roleElement = this.createRoleElement(roleId, permissions);
            if (actionPath == null || actionPath.equals("any")) {
                this.createOperationPermissionConfigurationWithAnyPermissionAction(roleElement, operationId);
            } else {
                OperationPermissionsConfiguration operation2 = this.createOperationPermissionsConfiguration(roleElement, operationId);
                this.createPermissionActions(operation2, actionPath);
            }
            int parentStartOffset = permissions.getParentElement().getStartOffset();
            String changedXML = permissions.toXML(this.computeLineIndent(this.getCurrentDocument(), parentStartOffset), this.getLineDelimiter());
            ProcessModelChange change = new ProcessModelChange(permissions.getStartOffset(), permissions.getEndOffset(), changedXML);
            return change;
        }
        AbstractElement changedElement = null;
        if (actionPath == null || actionPath.equals("any")) {
            operation = roleElement.getOperation(operationId);
            if (operation == null) {
                this.createOperationPermissionConfigurationWithAnyPermissionAction(roleElement, operationId);
                changedElement = roleElement;
            } else {
                this.createAnyPermissionAction(operation);
                changedElement = operation;
            }
        } else {
            operation = roleElement.getOperation(operationId);
            if (operation == null) {
                operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
                this.createPermissionActions(operation, actionPath);
                changedElement = roleElement;
            } else {
                PermissionPath path = new PermissionPath(actionPath);
                String actionId = path.segment(0);
                PermissionActionElement action = operation.getAction(actionId);
                if (action == null) {
                    action = operation.getAction("any");
                    if (action == null) {
                        this.createPermissionActions(operation, actionPath);
                        changedElement = operation;
                    }
                } else if (path.segmentCount() > 1) {
                    String[] segments = path.segments();
                    int i = 1;
                    while (i < segments.length) {
                        actionId = segments[i];
                        boolean isAnyAction = actionId.equals("any");
                        PermissionActionElement childAction = action.getAction(actionId);
                        if (childAction == null) {
                            childAction = action.getAction("any");
                            if (childAction == null) {
                                if (isAnyAction) {
                                    action.clearChildElements();
                                }
                                if ((changedElement = this.createPermissionActions(action, path.removeFirstSegments(i).toString())) == null) {
                                    changedElement = action;
                                }
                            }
                            break;
                        }
                        action = childAction;
                        ++i;
                    }
                } else if (action.getChildElements().size() > 1 || action.getAction("any") == null) {
                    this.createAnyPermissionAction(action);
                    changedElement = action;
                }
            }
        }
        if (changedElement != null) {
            String changedXML = changedElement.toXML(this.computeLineIndent(this.getCurrentDocument(), changedElement.getParentElement().getStartOffset()), this.getLineDelimiter());
            ProcessModelChange change = new ProcessModelChange(changedElement.getStartOffset(), changedElement.getEndOffset(), changedXML);
            return change;
        }
        return null;
    }

    protected String getLineDelimiter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.getCurrentDocument());
    }

    protected String computeLineIndent(IDocument document, int offset) {
        String indent = EMPTY;
        try {
            int lineOffset = document.getLineOffset(document.getLineOfOffset(offset));
            indent = document.get(lineOffset, offset - lineOffset);
            if (indent.trim().length() != 0) {
                indent = EMPTY;
            }
        }
        catch (BadLocationException badLocationException) {}
        indent = String.valueOf(indent) + "\t";
        return indent;
    }

    protected TeamConfigurationElement createTeamConfigurationElement(AbstractElement parent) {
        TeamConfigurationElement teamConfigurationElement = new TeamConfigurationElement(parent, parent.getNamespaceURI(), "team-configuration", null);
        parent.addChildElement(teamConfigurationElement);
        return teamConfigurationElement;
    }

    protected PermissionsElement createPermissionsElement(AbstractElement permissionsParent) {
        PermissionsElement permissions = new PermissionsElement(permissionsParent, permissionsParent.getNamespaceURI(), "permissions", null);
        permissionsParent.addChildElement(permissions);
        return permissions;
    }

    protected PermissionsRoleElement createRoleElement(String roleId, PermissionsElement permissions) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, roleId);
        PermissionsRoleElement roleElement = new PermissionsRoleElement(permissions, permissions.getNamespaceURI(), "role", attributes);
        permissions.addChildElement(roleElement);
        return roleElement;
    }

    private DevelopmentLineConfiguration createDevelopmentLineConfiguration(String developmentLineId, TeamConfigurationElement teamConfiguration) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, developmentLineId);
        DevelopmentLineConfiguration developmentLine = new DevelopmentLineConfiguration(teamConfiguration, teamConfiguration.getNamespaceURI(), "timeline", attributes);
        teamConfiguration.addChildElement(developmentLine);
        return developmentLine;
    }

    private IterationTypeConfiguration createIterationTypeConfiguration(String iterationTypeId, ITeamConfiguration teamConfiguration) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, iterationTypeId);
        IterationTypeConfiguration iterationTypeConfiguration = new IterationTypeConfiguration((AbstractElement)((Object)teamConfiguration), teamConfiguration.getNamespaceURI(), "iteration-type", attributes);
        teamConfiguration.addChildElement(iterationTypeConfiguration);
        return iterationTypeConfiguration;
    }

    private OperationPermissionsConfiguration createOperationPermissionConfigurationWithAnyPermissionAction(AbstractElement parent, String operationId) {
        OperationPermissionsConfiguration anyConfig = this.createOperationPermissionsConfiguration(parent, operationId);
        this.createAnyPermissionAction(anyConfig);
        return anyConfig;
    }

    private OperationPermissionsConfiguration createOperationPermissionsConfiguration(AbstractElement parent, String operationId) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, operationId);
        String name = this.getOperationName(parent);
        OperationPermissionsConfiguration anyConfig = new OperationPermissionsConfiguration(parent, parent.getNamespaceURI(), name, attributes);
        parent.addChildElement(anyConfig);
        return anyConfig;
    }

    private String getOperationName(AbstractElement parent) {
        AbstractElement configuration = parent.getParentElement().getParentElement();
        if (configuration instanceof ProjectConfigurationElement) {
            return "project-operation";
        }
        return "operation";
    }

    private void createAnyPermissionAction(AbstractElement parent) {
        parent.clearChildElements();
        this.createPermissionAction(parent, "any");
    }

    private AbstractElement createPermissionActions(AbstractElement parent, String actionPath) {
        AbstractElement changedElement;
        PermissionPath path = new PermissionPath(actionPath);
        String[] actionIds = path.segments();
        PermissionActionElement parentAction = this.createPermissionAction(parent, actionIds[0]);
        int i = 1;
        while (i < actionIds.length) {
            parentAction = this.createPermissionAction(parentAction, actionIds[i]);
            ++i;
        }
        List permittedActions = this.getPermittedActions(parentAction);
        if (permittedActions.size() > 0) {
            this.createAnyPermissionAction(parentAction);
        }
        if ((changedElement = this.injectAnyActionsAsRequiredInHierarchy(parentAction, null)) != null) {
            return changedElement;
        }
        return null;
    }

    private AbstractElement injectAnyActionsAsRequiredInHierarchy(AbstractElement parentAction, AbstractElement changedElement) {
        AbstractElement parentElement = parentAction.getParentElement();
        List permittedActions = this.getPermittedActions(parentElement);
        List childElements = parentElement.getChildElements();
        if (permittedActions.size() == childElements.size()) {
            boolean allChildrenGranted = true;
            for (PermissionActionElement childAction : childElements) {
                if (childAction.getAction("any") != null || this.getPermittedActions(childAction).isEmpty()) continue;
                allChildrenGranted = false;
                break;
            }
            if (allChildrenGranted) {
                this.createAnyPermissionAction(parentElement);
                changedElement = parentElement;
            }
        }
        if (!(parentElement instanceof OperationPermissionsConfiguration)) {
            return this.injectAnyActionsAsRequiredInHierarchy(parentElement, changedElement);
        }
        return changedElement;
    }

    private String getOperationId(AbstractElement element) {
        if (element instanceof OperationPermissionsConfiguration) {
            return ((OperationPermissionsConfiguration)element).getId();
        }
        return this.getOperationId(element.getParentElement());
    }

    private PermissionActionElement createPermissionAction(AbstractElement parent, String actionId) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "id", "id", EMPTY, actionId);
        PermissionActionElement permissionActionElement = new PermissionActionElement(parent, parent.getNamespaceURI(), "action", attributes);
        parent.addChildElement(permissionActionElement);
        return permissionActionElement;
    }

    public void setProjectPermissions(PermissionDTO[] permissions) {
        this.fProjectPermissions = permissions;
    }

    public void setTeamPermissions(PermissionDTO[] permissions) {
        this.fTeamPermissions = permissions;
    }

    public ProcessModelChange[] changeTeamConfigurationOperation(String roleId, String operationId, Boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        ITeamConfiguration teamConfiguration = this.getTeamConfiguration();
        boolean newConfiguration = false;
        if (teamConfiguration == null) {
            teamConfiguration = this.createTeamConfigurationElement(this.getRoot());
            newConfiguration = true;
        }
        ProcessModelChange[] changes = this.changeOperation(roleId, operationId, isFinal, explanation, (AbstractElement)((Object)teamConfiguration), teamConfiguration.getPermissions());
        if (newConfiguration) {
            changes = this.generateChangesForNewTeamConfiguration((TeamConfigurationElement)teamConfiguration);
        }
        return changes;
    }

    public ProcessModelChange[] changeDevelopmentLineOperation(String developmentLineId, String roleId, String operationId, Boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        DevelopmentLineConfiguration developmentLineConfiguration = this.getDevelopmentLineConfiguration(developmentLineId);
        boolean newDevLine = false;
        if (developmentLineConfiguration == null) {
            newDevLine = true;
            developmentLineConfiguration = this.createDevelopmentLineConfiguration(developmentLineId, (TeamConfigurationElement)this.getTeamConfiguration());
        }
        ProcessModelChange[] changes = this.changeOperation(roleId, operationId, isFinal, explanation, developmentLineConfiguration, developmentLineConfiguration.getPermissions());
        if (newDevLine) {
            changes = this.generateChangesForNewDevelopmentLine(developmentLineConfiguration);
        }
        return changes;
    }

    public ProcessModelChange[] changeIterationTypeOperation(String iterationTypeId, String roleId, String operationId, Boolean isFinal, String explanation) {
        this.assertNotReadOnly();
        IterationTypeConfiguration[] iterationTypeConfigurations = this.getIterationTypeConfigurations(iterationTypeId, roleId);
        IterationTypeConfiguration newIterationTypeConfiguration = iterationTypeConfigurations[0];
        IterationTypeConfiguration iterationTypeConfiguration = iterationTypeConfigurations[1];
        PermissionsElement permissions = this.getPermissions(iterationTypeConfiguration, roleId);
        ProcessModelChange[] changes = this.changeOperation(roleId, operationId, isFinal, explanation, iterationTypeConfiguration, iterationTypeConfiguration.getPermissions());
        if (newIterationTypeConfiguration != null) {
            changes = this.generateChangesForNewIterationType(newIterationTypeConfiguration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    private IterationTypeConfiguration[] getIterationTypeConfigurations(String iterationTypeId, String roleId) {
        IterationTypeConfiguration iterationTypeConfiguration = this.getIterationTypeConfiguration(iterationTypeId);
        IterationTypeConfiguration newIterationType = null;
        if (iterationTypeConfiguration == null) {
            newIterationType = iterationTypeConfiguration = this.createIterationTypeConfiguration(iterationTypeId, this.getTeamConfiguration());
            PermissionsElement permissions = this.createPermissionsElement(iterationTypeConfiguration);
            this.createRoleElement(roleId, permissions);
        }
        return new IterationTypeConfiguration[]{newIterationType, iterationTypeConfiguration};
    }

    private PermissionsElement getPermissions(IterationTypeConfiguration iterationTypeConfiguration, String roleId) {
        PermissionsElement permissions = iterationTypeConfiguration.getPermissions();
        if (permissions == null) {
            permissions = this.createPermissionsElement(iterationTypeConfiguration);
            this.createRoleElement(roleId, permissions);
        }
        return permissions;
    }

    public ProcessModelChange[] changeIterationOperation(String developmentLineId, PermissionPath iterationPath, String roleId, String operationId, Boolean isFinal, String explanation) {
        OperationPermissionsConfiguration operation;
        AbstractElement parentElement;
        this.assertNotReadOnly();
        boolean newDevLine = false;
        String[] iterationIds = iterationPath.segments();
        if (this instanceof ProcessSpecificationModel) {
            parentElement = this.getDevelopmentLineConfiguration(developmentLineId);
            if (parentElement == null && this instanceof ProcessSpecificationModel) {
                newDevLine = true;
                parentElement = this.createDevelopmentLineConfiguration(developmentLineId, (TeamConfigurationElement)this.getTeamConfiguration());
            }
        } else {
            parentElement = this.getRoot();
        }
        IterationConfiguration[] configurations = this.getIterationConfigurations((IIterationParent)((Object)parentElement), iterationIds);
        IterationConfiguration newIteration = configurations[0];
        IterationConfiguration iterationConfiguration = configurations[1];
        PermissionsElement permissions = this.getPermissions(iterationConfiguration, roleId);
        AbstractElement changedElement = null;
        PermissionsRoleElement roleElement = permissions.getRoleElement(roleId);
        if (roleElement == null) {
            roleElement = this.createRoleElement(roleId, permissions);
            if (changedElement == null) {
                changedElement = permissions;
            }
        }
        if ((operation = roleElement.getOperation(operationId)) == null) {
            operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
            if (changedElement == null) {
                changedElement = roleElement;
            }
        }
        if (isFinal != null && operation.isFinal() != isFinal.booleanValue()) {
            operation.setIsFinal(isFinal);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (explanation != null && !explanation.equals(operation.getDescription())) {
            operation.setDescription(explanation);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (changedElement == null) {
            return new ProcessModelChange[1];
        }
        String changedXML = changedElement.toXML(this.computeLineIndent(this.getCurrentDocument(), changedElement.getParentElement().getStartOffset()), this.getLineDelimiter());
        ProcessModelChange change = new ProcessModelChange(changedElement.getStartOffset(), changedElement.getEndOffset(), changedXML);
        ProcessModelChange[] changes = new ProcessModelChange[]{change};
        if (newDevLine) {
            changes = this.generateChangesForNewDevelopmentLine((DevelopmentLineConfiguration)parentElement);
        } else if (newIteration != null) {
            changes = this.generateChangesForNewIteration(newIteration);
        } else if (permissions.isGeneratedPermission()) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    private PermissionsElement getPermissions(IterationConfiguration iterationConfiguration, String roleId) {
        PermissionsElement permissions = iterationConfiguration.getPermissions();
        if (permissions == null) {
            permissions = this.createPermissionsElement(iterationConfiguration);
            this.createRoleElement(roleId, permissions);
        }
        return permissions;
    }

    private IterationConfiguration[] getIterationConfigurations(IIterationParent parentElement, String[] iterationIds) {
        IterationConfiguration newIterationConfiguration = null;
        IterationConfiguration iterationConfiguration = parentElement.getIterationConfiguration(iterationIds[0]);
        if (iterationConfiguration == null) {
            newIterationConfiguration = iterationConfiguration = this.createIterationConfiguration(iterationIds[0], (AbstractElement)((Object)parentElement));
        }
        int i = 1;
        while (i < iterationIds.length) {
            IterationConfiguration parentIteration = iterationConfiguration;
            String iterationId = iterationIds[i];
            if ((iterationConfiguration = parentIteration.getIteration(iterationId)) == null) {
                iterationConfiguration = this.createIterationConfiguration(iterationId, parentIteration);
                if (newIterationConfiguration == null) {
                    newIterationConfiguration = iterationConfiguration;
                }
            }
            ++i;
        }
        return new IterationConfiguration[]{newIterationConfiguration, iterationConfiguration};
    }

    protected ProcessModelChange[] changeOperation(String roleId, String operationId, Boolean isFinal, String explanation, AbstractElement parentElement, PermissionsElement permissions) {
        OperationPermissionsConfiguration operation;
        PermissionsRoleElement roleElement;
        AbstractElement changedElement = null;
        boolean newPermissions = false;
        if (permissions == null) {
            permissions = this.createPermissionsElement(parentElement);
            changedElement = parentElement;
            newPermissions = true;
        }
        if ((roleElement = permissions.getRoleElement(roleId)) == null) {
            roleElement = this.createRoleElement(roleId, permissions);
            if (changedElement == null) {
                changedElement = permissions;
            }
        }
        if ((operation = roleElement.getOperation(operationId)) == null) {
            operation = this.createOperationPermissionsConfiguration(roleElement, operationId);
            if (changedElement == null) {
                changedElement = roleElement;
            }
        }
        if (isFinal != null && operation.isFinal() != isFinal.booleanValue()) {
            operation.setIsFinal(isFinal);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (explanation != null && !explanation.equals(operation.getDescription())) {
            operation.setDescription(explanation);
            if (changedElement == null) {
                changedElement = operation;
            }
        }
        if (changedElement == null) {
            return new ProcessModelChange[1];
        }
        String changedXML = changedElement.toXML(this.computeLineIndent(this.getCurrentDocument(), changedElement.getParentElement().getStartOffset()), this.getLineDelimiter());
        ProcessModelChange change = new ProcessModelChange(changedElement.getStartOffset(), changedElement.getEndOffset(), changedXML);
        ProcessModelChange[] changes = new ProcessModelChange[]{change};
        if (newPermissions) {
            changes = this.generateChangesForNewPermissions(permissions);
        }
        return changes;
    }

    protected void setIsReadOnly(boolean isReadOnly) {
        this.fIsReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.fIsReadOnly;
    }

    protected void assertNotReadOnly() {
        if (this.isReadOnly()) {
            throw new IllegalStateException(Messages.getCommonString("AbstractModel.0"));
        }
    }

    protected ProcessModelChange[] createRoleDefinitions(String[] roleIds, String[] names, String[] descriptions, boolean[] singleCardinality, RoleDefinitions roleDefinitionsElement) {
        this.assertNotReadOnly();
        ProcessModelChange[] changes = new ProcessModelChange[roleIds.length];
        if (roleDefinitionsElement == null) {
            roleDefinitionsElement = this.createRoleDefinitionsElement(this.getRoot());
        }
        int i = 0;
        while (i < roleIds.length) {
            String roleId = roleIds[i];
            IRole[] roleDefinitions = roleDefinitionsElement.getRoleDefinitions();
            IRole existingRole = this.getRole(roleId, roleDefinitions);
            if (existingRole == null) {
                String name = EMPTY;
                if (names.length > 0) {
                    name = names[i];
                }
                String description = EMPTY;
                if (descriptions.length > 0) {
                    description = descriptions[i];
                }
                boolean single = false;
                if (singleCardinality.length > 0) {
                    single = singleCardinality[i];
                }
                this.createRoleDefinition(roleId, name, description, single, roleDefinitionsElement);
                if (roleDefinitionsElement.getStartOffset() == -1) {
                    changes[i] = this.generateChangesForNewRoleDefinitions(roleDefinitionsElement);
                } else {
                    String changedXML = roleDefinitionsElement.toXML(this.computeLineIndent(this.getCurrentDocument(), roleDefinitionsElement.getStartOffset()), this.getLineDelimiter());
                    changes[i] = new ProcessModelChange(roleDefinitionsElement.getStartOffset(), roleDefinitionsElement.getEndOffset(), changedXML);
                }
            } else {
                changes[i] = null;
            }
            ++i;
        }
        return changes;
    }

    protected ProcessModelChange generateChangesForNewRoleDefinitions(RoleDefinitions roleDefinitions) {
        AbstractElement parent = roleDefinitions.getParentElement();
        int startOffset = parent.getStartTagEndOffset() + 1;
        String changedXML = String.valueOf(this.getLineDelimiter()) + '\t' + roleDefinitions.toXML(this.computeLineIndent(this.getCurrentDocument(), startOffset), this.getLineDelimiter());
        return new ProcessModelChange(startOffset, startOffset, changedXML);
    }

    private IRole getRole(String roleId, IRole[] roleDefinitions) {
        int i = 0;
        while (i < roleDefinitions.length) {
            IRole role = roleDefinitions[i];
            if (role.getId().equals(roleId)) {
                return role;
            }
            ++i;
        }
        return null;
    }

    private RoleDefinitions createRoleDefinitionsElement(AbstractElement parent) {
        RoleDefinitions roleDefinitions = new RoleDefinitions(parent, parent.getNamespaceURI(), "role-definitions", null);
        parent.addChildElement(roleDefinitions);
        return roleDefinitions;
    }

    private RoleDefinition createRoleDefinition(String roleId, String name, String description, boolean singleCardinality, RoleDefinitions roleDefinitions) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(EMPTY, "role-id", "role-id", EMPTY, roleId);
        String stringCardinality = "single";
        if (!singleCardinality) {
            stringCardinality = "many";
        }
        attributes.addAttribute(EMPTY, "cardinality", "cardinality", EMPTY, stringCardinality);
        attributes.addAttribute(EMPTY, "description", "description", EMPTY, description);
        attributes.addAttribute(EMPTY, "name", "name", EMPTY, name);
        RoleDefinition roleDefinition = new RoleDefinition(roleDefinitions, roleDefinitions.getNamespaceURI(), "role-definition", attributes);
        roleDefinitions.addChildElement(roleDefinition);
        return roleDefinition;
    }

    protected ProcessModelChange[] removeRoleDefinitions(String[] roleIds, RoleDefinitions roleDefinitionsElement) {
        boolean changed = false;
        if (roleDefinitionsElement != null) {
            int i = 0;
            while (i < roleIds.length) {
                String roleId = roleIds[i];
                if (roleDefinitionsElement.removeRoleDefinition(roleId) != null) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                String changedXML = roleDefinitionsElement.toXML(this.computeLineIndent(this.getCurrentDocument(), roleDefinitionsElement.getStartOffset()), this.getLineDelimiter());
                return new ProcessModelChange[]{new ProcessModelChange(roleDefinitionsElement.getStartOffset(), roleDefinitionsElement.getEndOffset(), changedXML)};
            }
        }
        return new ProcessModelChange[1];
    }
}

