/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.advice.runtime;

import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class OperationRegistry
extends ExtensionRegistryReader {
    private static final String TAG_STATIC_OPERATION = "projectOperation";
    private static final String TAG_OPERATION = "operation";
    private static final String ATTR_OPERATION_ID = "id";
    private Map<String, IConfigurationElement> fOperationExtensions;

    public OperationRegistry(String pluginID, String extensionPoint) {
        super(pluginID, extensionPoint);
    }

    protected void initialize() {
        this.fOperationExtensions = new HashMap<String, IConfigurationElement>();
        super.initialize();
    }

    protected synchronized Object handleExtensionAdded(IConfigurationElement element) {
        String id;
        String name = element.getName();
        if ((name.equals(TAG_OPERATION) || name.equals(TAG_STATIC_OPERATION)) && (id = element.getAttribute(ATTR_OPERATION_ID)) != null) {
            this.fOperationExtensions.put(id, element);
        }
        return null;
    }

    protected synchronized boolean handleExtensionRemoved(IConfigurationElement element) {
        String id;
        String name = element.getName();
        if ((name.equals(TAG_OPERATION) || name.equals(TAG_STATIC_OPERATION)) && (id = element.getAttribute(ATTR_OPERATION_ID)) != null) {
            this.fOperationExtensions.remove(id);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConfigurationElement getConfigurationPointElement(String operationIdentifier) {
        this.start();
        OperationRegistry operationRegistry = this;
        synchronized (operationRegistry) {
            return this.fOperationExtensions.get(operationIdentifier);
        }
    }
}

