/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.app;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.app.Activator;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.eclipse.equinox.internal.app.EclipseAppContainer;
import org.eclipse.equinox.internal.app.EclipseAppDescriptor;
import org.eclipse.equinox.internal.app.EclipseAppHandle$$Cold;
import org.eclipse.equinox.internal.app.EclipseAppHandle$1;
import org.eclipse.equinox.internal.app.IBranding;
import org.eclipse.equinox.internal.app.Messages;
import org.eclipse.osgi.service.runnable.ApplicationRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;

public class EclipseAppHandle
extends ApplicationHandle
implements ApplicationRunnable,
IApplicationContext {
    private static final int FLAG_STARTING = 1;
    private static final int FLAG_ACTIVE = 2;
    private static final int FLAG_STOPPING = 4;
    private static final int FLAG_STOPPED = 8;
    private static final String STARTING = "org.eclipse.equinox.app.starting";
    private static final String STOPPED = "org.eclipse.equinox.app.stopped";
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private volatile ServiceRegistration handleRegistration;
    private int status = 1;
    private final Map arguments;
    private Object application;
    private final Boolean defaultAppInstance;
    private Object result;
    private boolean setResult = false;
    private final boolean[] registrationLock = new boolean[]{true};
    static Class class$0;
    static Class class$1;

    EclipseAppHandle(String string, Map map, EclipseAppDescriptor eclipseAppDescriptor) {
        super(string, eclipseAppDescriptor);
        this.defaultAppInstance = map == null || map.get("eclipse.application.default") == null ? Boolean.FALSE : (Boolean)map.remove("eclipse.application.default");
        this.arguments = map == null ? (Map)new HashMap(2) : (Map)new HashMap(map);
    }

    public synchronized String getState() {
        switch (this.status) {
            case 1: {
                return STARTING;
            }
            case 2: {
                return "RUNNING";
            }
            case 4: {
                return "STOPPING";
            }
        }
        if (this.getServiceRegistration() == null) {
            throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.application_error_state_stopped, (Object)this.getInstanceId()));
        }
        return STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setServiceRegistration(ServiceRegistration serviceRegistration) {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            this.handleRegistration = serviceRegistration;
            this.registrationLock[0] = serviceRegistration != null;
            this.registrationLock.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistration getServiceRegistration() {
        boolean[] blArray = this.registrationLock;
        synchronized (this.registrationLock) {
            if (this.handleRegistration == null && this.registrationLock[0]) {
                try {
                    this.registrationLock.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.handleRegistration;
        }
    }

    Dictionary getServiceProperties() {
        Hashtable hashtable = new Hashtable(6);
        ((Dictionary)hashtable).put("service.pid", this.getInstanceId());
        ((Dictionary)hashtable).put("application.state", this.getState());
        ((Dictionary)hashtable).put("application.descriptor", this.getApplicationDescriptor().getApplicationId());
        ((Dictionary)hashtable).put("eclipse.application.type", ((EclipseAppDescriptor)this.getApplicationDescriptor()).getThreadTypeString());
        if (this.defaultAppInstance.booleanValue()) {
            ((Dictionary)hashtable).put("eclipse.application.default", this.defaultAppInstance);
        }
        return hashtable;
    }

    private synchronized void setAppStatus(int n) {
        if (this.status == n) {
            return;
        }
        if ((n & 1) != 0) {
            throw (Throwable)new IllegalArgumentException("Cannot set app status to starting");
        }
        if ((n & 4) != 0 && (this.status & 0xC) != 0) {
            return;
        }
        this.status = n;
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration == null) {
            return;
        }
        serviceRegistration.setProperties(this.getServiceProperties());
        if ((this.status & 8) != 0) {
            ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().unlock(this);
            serviceRegistration.unregister();
            this.setServiceRegistration(null);
        }
    }

    public Map getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(Object object) throws Exception {
        Object object2;
        block21: {
            if (object != null) {
                this.arguments.put("application.args", object);
            } else {
                object = this.arguments.get("application.args");
                if (object == null) {
                    object = CommandLineArgs.getApplicationArgs();
                    this.arguments.put("application.args", object);
                }
            }
            object2 = null;
            try {
                Object object3;
                EclipseAppHandle eclipseAppHandle = this;
                synchronized (eclipseAppHandle) {
                    if ((this.status & 5) == 0) {
                        throw (Throwable)new ApplicationException(3, NLS.bind((String)Messages.application_instance_stopped, (Object)this.getInstanceId()));
                    }
                    object3 = this.application = this.getConfiguration().createExecutableExtension("run");
                    this.notifyAll();
                }
                if (object3 instanceof IApplication) {
                    object2 = ((IApplication)object3).start(this);
                    break block21;
                }
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw (Throwable)new NoClassDefFoundError(((Throwable)classNotFoundException).getMessage());
                    }
                }
                classArray[0] = clazz;
                object2 = EclipseAppContainer.callMethodWithException(object3, "run", classArray, new Object[]{object});
            }
            catch (Throwable throwable) {
                EclipseAppHandle eclipseAppHandle = this;
                synchronized (eclipseAppHandle) {
                    this.result = object2;
                    this.setResult = true;
                    this.application = null;
                    this.notifyAll();
                    this.setAppStatus(4);
                    this.setAppStatus(8);
                }
                throw throwable;
            }
        }
        EclipseAppHandle eclipseAppHandle = this;
        synchronized (eclipseAppHandle) {
            this.result = object2;
            this.setResult = true;
            this.application = null;
            this.notifyAll();
            this.setAppStatus(4);
            this.setAppStatus(8);
        }
        if (this.isDefault()) {
            int n = object2 instanceof Integer ? (Integer)object2 : 0;
            Activator.setProperty(PROP_ECLIPSE_EXITCODE, Integer.toString(n));
        }
        if (Activator.DEBUG) {
            System.out.println(NLS.bind((String)Messages.application_returned, (Object[])new String[]{this.getApplicationDescriptor().getApplicationId(), object2 == null ? "null" : object2.toString()}));
        }
        return object2;
    }

    public void stop() {
        try {
            this.destroy();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private IConfigurationElement getConfiguration() {
        IExtension iExtension = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAppExtension(this.getApplicationDescriptor().getApplicationId());
        if (iExtension == null) {
            throw (Throwable)new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)this.getApplicationDescriptor().getApplicationId(), (Object)((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getAvailableAppsMsg()));
        }
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        if (iConfigurationElementArray.length == 0) {
            throw (Throwable)new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)this.getApplicationDescriptor().getApplicationId()));
        }
        return iConfigurationElementArray[0];
    }

    public String getBrandingName() {
        IBranding iBranding = ((EclipseAppDescriptor)this.getApplicationDescriptor()).getContainerManager().getBranding();
        return iBranding == null ? null : iBranding.getName();
    }

    boolean isDefault() {
        return this.defaultAppInstance;
    }

    protected void destroySpecific() {
        this.setAppStatus(4);
        IApplication iApplication = this.getApplication();
        if (iApplication != null) {
            iApplication.stop();
        }
        this.setAppStatus(8);
    }

    ServiceReference getServiceReference() {
        ServiceRegistration serviceRegistration = this.getServiceRegistration();
        if (serviceRegistration == null) {
            return null;
        }
        try {
            return serviceRegistration.getReference();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public void applicationRunning() {
        this.setAppStatus(2);
        ServiceReference[] serviceReferenceArray = this.getStartupMonitors();
        if (serviceReferenceArray == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new EclipseAppHandle$1(this, serviceReferenceArray));
    }

    private ServiceReference[] getStartupMonitors() throws  {
        return EclipseAppHandle$$Cold.getStartupMonitors(this);
    }

    private synchronized IApplication getApplication() {
        if (this.handleRegistration != null && this.application == null) {
            try {
                this.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return (IApplication)(this.application instanceof IApplication ? this.application : null);
    }

    public String getBrandingApplication() throws  {
        return EclipseAppHandle$$Cold.getBrandingApplication(this);
    }

    public Bundle getBrandingBundle() throws  {
        return EclipseAppHandle$$Cold.getBrandingBundle(this);
    }

    public String getBrandingDescription() throws  {
        return EclipseAppHandle$$Cold.getBrandingDescription(this);
    }

    public String getBrandingId() throws  {
        return EclipseAppHandle$$Cold.getBrandingId(this);
    }

    public String getBrandingProperty(String string) throws  {
        return EclipseAppHandle$$Cold.getBrandingProperty(this, string);
    }

    public synchronized Object waitForResult(int n) {
        if (this.handleRegistration == null && this.application == null) {
            return this.result;
        }
        long l = System.currentTimeMillis();
        long l2 = n;
        while (!this.setResult && l2 > 0L) {
            try {
                this.wait(l2);
            }
            catch (InterruptedException interruptedException) {}
            l2 -= System.currentTimeMillis() - l;
        }
        return this.result;
    }
}

