/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.TreeSet;

public class GenerateShellScript {
    private static String[] requiredPaths = new String[]{"com.ibm.team.filesystem.cli.minimal", "com.ibm.team.filesystem.cli.core", "com.ibm.team.filesystem.client.daemon", "org.eclipse.equinox.common", "com.ibm.team.filesystem.client", "org.eclipse.osgi"};
    private static final String DEFAULT_JAVA_EXECUTABLE = "../../client/eclipse/jdk/jre/bin/java";
    private static boolean DEBUG = false;

    public static void main(String[] args) throws IOException {
        String javaPath;
        if (args.length != 3 && args.length != 4) {
            System.err.println("Require 3 or 4 arguments: path-to-plugins-dir, output-path-directory, filename, optional-java-path");
            System.exit(1);
        }
        File pluginsDir = new File(args[0]).getCanonicalFile();
        File outputPath = new File(args[1]);
        String suffix = args[2];
        String string = javaPath = args.length == 3 ? null : args[3];
        if (!outputPath.exists() || !outputPath.isDirectory()) {
            System.err.println("output-path-directory must be an existing directory");
            System.exit(1);
        }
        String[] pluginPaths = new String[requiredPaths.length];
        int i = 0;
        while (i < requiredPaths.length) {
            final String prefix = requiredPaths[i];
            String[] matches = pluginsDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(prefix);
                }
            });
            TreeSet set = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            Collections.addAll(set, matches);
            pluginPaths[i] = (String)set.last();
            ++i;
        }
        File batchFile = new File(outputPath + File.separator + suffix + ".bat");
        GenerateShellScript.writeBatchFile(javaPath, batchFile, pluginPaths);
        File shellFile = new File(outputPath + File.separator + suffix);
        GenerateShellScript.writeScript(javaPath, shellFile, pluginPaths);
        if (!DEBUG) {
            return;
        }
        String vars = "@echo off\r\nSET PRGPATH=%~dp0\r\nSET SCM_DAEMON_PATH=%PRGPATH%scm.exe\r\n";
        GenerateShellScript.write('\\', ';', "%PRGPATH%", vars, javaPath, batchFile, pluginPaths, "%*");
        vars = "#!/bin/sh\nPRGPATH=\"`dirname \"$0\"`\"\nSCM_DAEMON_PATH=\"${PRGPATH}/scm\"\nexport SCM_DAEMON_PATH\n";
        GenerateShellScript.write('/', ':', "${PRGPATH}", vars, javaPath, shellFile, pluginPaths, "\"$@\"");
    }

    private static void writeBatchFile(String javaPath, File outputPath, String[] pluginPaths) throws IOException {
        FileOutputStream out = new FileOutputStream(outputPath);
        if (javaPath == null) {
            javaPath = "%PRGPATH%/../../client/eclipse/jdk/jre/bin/java";
        }
        if (javaPath.charAt(0) == '/') {
            javaPath = javaPath.substring(1);
        }
        javaPath = javaPath.replace('/', '\\');
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write("@echo off\r\n");
            writer.write("SET PRGPATH=%~dp0\r\n");
            writer.write("SET JAVA=");
            writer.write(javaPath);
            writer.write("\r\n");
            writer.write("SET SCM_DAEMON_PATH=%PRGPATH%scm.exe\r\n");
            writer.write("%JAVA% -Xquickstart -Xshareclasses -classpath \"");
            boolean needsSep = false;
            String[] stringArray = pluginPaths;
            int n = pluginPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                if (needsSep) {
                    writer.write(";");
                }
                needsSep = true;
                writer.write("%PRGPATH%\\plugins\\" + plugin);
                ++n2;
            }
            writer.write("\" com.ibm.team.filesystem.cli.minimal.client.FrontEndClient %*\r\n");
            writer.close();
        }
        finally {
            out.close();
        }
    }

    private static void writeScript(String javaPath, File outputPath, String[] pluginPaths) throws IOException {
        FileOutputStream out = new FileOutputStream(outputPath);
        if (javaPath == null) {
            javaPath = "${PRGPATH}/../../client/eclipse/jdk/jre/bin/java";
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write("#!/bin/sh\n");
            writer.write("PRGPATH=\"`dirname \"$0\"`\"\n");
            writer.write("SCM_DAEMON_PATH=\"${PRGPATH}/scm\"\n");
            writer.write("export SCM_DAEMON_PATH\n");
            writer.write(javaPath);
            writer.write(" -Xquickstart -Xshareclasses -classpath \"");
            boolean needsSep = false;
            String[] stringArray = pluginPaths;
            int n = pluginPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                if (needsSep) {
                    writer.write(":");
                }
                needsSep = true;
                writer.write("${PRGPATH}/plugins/" + plugin);
                ++n2;
            }
            writer.write("\" com.ibm.team.filesystem.cli.minimal.client.FrontEndClient \"$@\"");
            writer.close();
        }
        finally {
            out.close();
        }
    }

    private static void write(char separatorChar, char pathSeparatorChar, String prgPath, String vars, String javaPath, File outputPath, String[] pluginPaths, String forwardVars) throws IOException {
        FileOutputStream out = new FileOutputStream(outputPath);
        if (javaPath == null) {
            javaPath = String.valueOf(prgPath) + separatorChar + DEFAULT_JAVA_EXECUTABLE;
        }
        if ('/' != separatorChar) {
            if (javaPath.charAt(0) == '/') {
                javaPath = javaPath.substring(1);
            }
            javaPath = javaPath.replace('/', separatorChar);
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(vars);
            writer.write(javaPath);
            if (DEBUG) {
                writer.write(" -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000");
            } else {
                writer.write(" -Xquickstart");
            }
            writer.write(" -Xshareclasses -classpath \"");
            boolean needsSep = false;
            String[] stringArray = pluginPaths;
            int n = pluginPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String plugin = stringArray[n2];
                if (needsSep) {
                    writer.write(pathSeparatorChar);
                }
                needsSep = true;
                writer.write(prgPath);
                writer.write("/plugins/");
                writer.write(plugin);
                ++n2;
            }
            writer.write("\" com.ibm.team.filesystem.cli.minimal.client.FrontEndClient ");
            writer.write(forwardVars);
            writer.close();
        }
        finally {
            out.close();
        }
    }
}

