/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.protocol;

import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Reader {
    public static Message readMessage(InputStream in) throws IOException {
        int c;
        ByteArrayOutputStream msgBuf;
        block24: {
            int c2;
            msgBuf = new ByteArrayOutputStream();
            while (true) {
                if ((c2 = in.read()) == -1) {
                    return null;
                }
                if (c2 == 46 || c2 == ProtocolUtil.CRLF[0]) break block24;
                if (c2 < 33 || c2 > 122) break;
                msgBuf.write(c2);
            }
            throw new IOException("Unexpected message character: \"" + (char)c2 + "\" (" + c2 + ")");
        }
        if (msgBuf.size() == 0) {
            return null;
        }
        MessageType type = MessageType.fromWireFormat(msgBuf.toString());
        MessageReadState state = MessageReadState.DONE_FIELD;
        byte[] hexAccumulator = new byte[2];
        ByteArrayOutputStream fieldAccumulator = null;
        ArrayList<byte[]> fields = new ArrayList<byte[]>(type.getCardinality());
        block8: while (true) {
            c = in.read();
            switch (state) {
                case DONE_FIELD: {
                    if (c == ProtocolUtil.CRLF[0]) break block8;
                    if (c == 32) {
                        state = MessageReadState.IN_FIELD_START;
                        continue block8;
                    }
                    throw new IOException("Unexpected byte: " + (byte)c + " (" + c + ") in state " + (Object)((Object)state));
                }
                case IN_FIELD_START: {
                    if (c == 34) {
                        state = MessageReadState.IN_FIELD;
                        fieldAccumulator = new ByteArrayOutputStream();
                        continue block8;
                    }
                    throw new IOException("Unexpected byte: " + (byte)c + " (" + c + ") in state " + (Object)((Object)state));
                }
                case IN_FIELD: {
                    if (c == 34) {
                        state = MessageReadState.DONE_FIELD;
                        assert (fieldAccumulator != null);
                        fields.add(fieldAccumulator.toByteArray());
                        fieldAccumulator = null;
                        continue block8;
                    }
                    if (c == 92) {
                        state = MessageReadState.IN_FIELD_ESCAPE_0;
                        hexAccumulator[0] = 0;
                        hexAccumulator[1] = 0;
                        continue block8;
                    }
                    assert (fieldAccumulator != null);
                    fieldAccumulator.write(c);
                    continue block8;
                }
                case IN_FIELD_ESCAPE_0: {
                    if (c >= 48 && c <= 57) {
                        hexAccumulator[0] = (byte)c;
                        state = MessageReadState.IN_FIELD_ESCAPE_1;
                        continue block8;
                    }
                    if (c >= 97 && c <= 102) {
                        hexAccumulator[0] = (byte)c;
                        state = MessageReadState.IN_FIELD_ESCAPE_1;
                        continue block8;
                    }
                    throw new IOException("Unexpected byte: " + (byte)c + " (" + c + ") in state " + (Object)((Object)state));
                }
                case IN_FIELD_ESCAPE_1: {
                    assert (fieldAccumulator != null);
                    if (c >= 48 && c <= 57) {
                        hexAccumulator[1] = (byte)c;
                        fieldAccumulator.write(Integer.parseInt(new String(hexAccumulator), 16));
                        state = MessageReadState.IN_FIELD;
                        continue block8;
                    }
                    if (c >= 97 && c <= 102) {
                        hexAccumulator[1] = (byte)c;
                        fieldAccumulator.write(Integer.parseInt(new String(hexAccumulator), 16));
                        state = MessageReadState.IN_FIELD;
                        continue block8;
                    }
                    throw new IOException("Unexpected byte: " + (byte)c + " (" + c + ") in state " + (Object)((Object)state));
                }
                default: {
                    continue block8;
                }
            }
            break;
        }
        c = in.read();
        if (c != ProtocolUtil.CRLF[1]) {
            throw new IOException("Failed termination");
        }
        if (fields.size() != type.getCardinality()) {
            throw new IOException("Field cardinality incorrect for " + (Object)((Object)type));
        }
        return new Message(type, (byte[][])fields.toArray((T[])new byte[fields.size()][]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MessageReadState {
        DONE_FIELD,
        IN_FIELD_START,
        IN_FIELD,
        IN_FIELD_ESCAPE_0,
        IN_FIELD_ESCAPE_1;

    }
}

