/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.protocol;

import com.ibm.team.filesystem.cli.minimal.client.HttpSwitchingClient;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProtocolUtil {
    public static final String PROTOCOL_NAME = "vnd.ibm.jazz.cli.minimal-1.0";
    static final byte STRING_DELIM = 34;
    static final byte FIELD_SEPARATOR = 32;
    static final byte MESSAGE_TERMINATOR = 46;
    static byte[] CRLF = new byte[]{13, 10};
    static final byte ESCAPE_CHAR = 92;
    private static final byte[] ESCAPE_ESCAPE = new byte[]{92, 53, 99};
    private static final byte[] ESCAPE_QUOTE = new byte[]{92, 50, 50};
    private static final byte[] ESCAPE_CR = new byte[]{92, 48, 100};
    private static final byte[] ESCAPE_LF = new byte[]{92, 48, 97};

    public static void writeLine(OutputStream out, String toWrite) throws IOException {
        out.write(toWrite.getBytes());
        out.write(CRLF);
    }

    public static void writeHttpBlockTerminator(OutputStream out) throws IOException {
        out.write(CRLF);
    }

    public static String readLine(InputStream in) throws IOException {
        int read;
        StringBuilder b = new StringBuilder();
        boolean inText = true;
        while (true) {
            if ((read = in.read()) == -1) {
                if (b.length() == 0 && inText) {
                    return null;
                }
                throw new IOException("Client closed connection. Received: " + b);
            }
            if (read == 13 && inText) {
                inText = false;
                continue;
            }
            if (read == 10 && !inText) {
                return b.toString();
            }
            if (!inText) break;
            b.append((char)read);
        }
        throw new IOException("Unexpected state/input. State: " + (inText ? "inText" : "!inText") + " input: " + read + "  current line: " + b);
    }

    private static void writeEscaped(OutputStream out, byte[] arg) throws IOException {
        out.write(34);
        byte[] byArray = arg;
        int n = arg.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            switch (b) {
                case 92: {
                    out.write(ESCAPE_ESCAPE);
                    break;
                }
                case 34: {
                    out.write(ESCAPE_QUOTE);
                    break;
                }
                case 13: {
                    out.write(ESCAPE_CR);
                    break;
                }
                case 10: {
                    out.write(ESCAPE_LF);
                    break;
                }
                default: {
                    out.write(b);
                }
            }
            ++n2;
        }
        out.write(34);
    }

    public static void writeMessage(OutputStream out, MessageType msg, byte[] ... args) throws IOException {
        if (args.length != msg.getCardinality()) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream toWrite = new ByteArrayOutputStream();
        toWrite.write(msg.getWireText().getBytes());
        toWrite.write(46);
        byte[][] byArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] arg = byArray[n2];
            toWrite.write(32);
            ProtocolUtil.writeEscaped(toWrite, arg);
            ++n2;
        }
        toWrite.write(CRLF);
        out.write(toWrite.toByteArray());
    }

    public static void writeSubcommandDescription(HttpSwitchingClient.HttpSwitchResult conn, String[] args, Map<String, String> env, String cwd) throws IOException {
        OutputStream out = conn.getOutputStream();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            ProtocolUtil.writeMessage(out, MessageType.ARGUMENT, new byte[][]{arg.getBytes("UTF-8")});
            ++n2;
        }
        for (Map.Entry<String, String> entry : env.entrySet()) {
            ProtocolUtil.writeMessage(out, MessageType.ENVIRONMENT, entry.getKey().getBytes("UTF-8"), entry.getValue().getBytes("UTF-8"));
        }
        ProtocolUtil.writeMessage(out, MessageType.CWD, new byte[][]{cwd.getBytes("UTF-8")});
        ProtocolUtil.writeMessage(out, MessageType.PREAMBLE_DONE, new byte[0][]);
        out.flush();
    }

    public static void writeMessage(OutputStream out, MessageType type, String[] strings) throws IOException {
        byte[][] arrays = new byte[strings.length][];
        int i = 0;
        while (i < strings.length) {
            arrays[i] = strings[i].getBytes();
            ++i;
        }
        ProtocolUtil.writeMessage(out, type, arrays);
    }
}

