/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.client;

import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class HttpSwitchingClient {
    public static HttpSwitchResult negotiate(String host, int port, String key, String path, String targetProtocol) throws ProtocolNegotiationException, IOException {
        Socket s = new Socket(host, port);
        OutputStream out = s.getOutputStream();
        ProtocolUtil.writeLine(out, "GET " + path + " HTTP/1.1");
        ProtocolUtil.writeLine(out, "X-Secret-Key: " + key);
        ProtocolUtil.writeLine(out, "Connection: Upgrade");
        ProtocolUtil.writeLine(out, "Upgrade: " + targetProtocol);
        ProtocolUtil.writeHttpBlockTerminator(out);
        out.flush();
        InputStream in = s.getInputStream();
        int state = 0;
        while (true) {
            String str = ProtocolUtil.readLine(in);
            if (state == 0) {
                if (!str.contains(Integer.toString(ResponseCode.SWITCHING_PROTOCOLS.getCode()))) {
                    throw new ProtocolNegotiationException("Expected protocol switch. Got: " + str);
                }
                state = 1;
                continue;
            }
            if (state == 1) {
                if (!str.startsWith("Upgrade")) continue;
                if (!str.contains(targetProtocol)) {
                    throw new ProtocolNegotiationException("Unexpected upgrade header: " + str);
                }
                state = 2;
                continue;
            }
            if ("".equals(str.trim())) break;
        }
        if (state != 2) {
            throw new ProtocolNegotiationException("Unexpected response termination");
        }
        return new HttpSwitchResult(s, in, out);
    }

    public static class HttpSwitchResult {
        private final Socket socket;
        private final InputStream in;
        private final OutputStream out;

        private HttpSwitchResult(Socket socket, InputStream in, OutputStream out) {
            this.socket = socket;
            this.in = in;
            this.out = out;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public void close() throws IOException {
            this.socket.close();
        }
    }

    public static class ProtocolNegotiationException
    extends Exception {
        private static final long serialVersionUID = -8913782636727288881L;

        public ProtocolNegotiationException(String message) {
            super(message);
        }
    }
}

