/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.minimal.client;

import com.ibm.team.filesystem.cli.core.util.PromptUtil;
import com.ibm.team.filesystem.cli.core.util.StringUtil;
import com.ibm.team.filesystem.cli.minimal.client.HttpSwitchingClient;
import com.ibm.team.filesystem.cli.minimal.client.MessageProtocolException;
import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.cli.minimal.protocol.Reader;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.utils.IDaemonLocation;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrontEndClient {
    public static final String SCM_DAEMON_INACTIVE_TIME_OUT = "SCM_DAEMON_INACTIVE_TIME_OUT";
    public static final String SCM_DAEMON_CONNECTION_TIME_OUT = "SCM_DAEMON_CONNECTION_TIME_OUT";
    public static final String REQUEST_URI = "/com.ibm.team.filesystem.cli.client.internal.daemon.CommandLineClient";
    private final int port;
    private final String secretKey;
    private final String[] args;
    private final Map<String, String> env;
    private final String cwd;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private int exitCode = -1;

    public static int run(String[] args, Map<String, String> env, InputStream in, PrintStream out, PrintStream err) {
        int exit;
        String cwd;
        File config = FrontEndClient.findConfigDirectory(args, env);
        DaemonRegistry registry = config == null ? (DaemonRegistry)DaemonRegistry.getInstance() : new DaemonRegistry(config);
        IDaemonRegistry.IRegistryEntry loc = FrontEndClient.findDaemon((IDaemonRegistry)registry, cwd = FrontEndClient.findEffectiveCwd(args));
        if (loc == null) {
            try {
                loc = FrontEndClient.startNewDaemon(config);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Could not start daemon");
                return 13;
            }
        }
        FrontEndClient fec = new FrontEndClient(loc.getKey(), loc.getPort(), args, System.getenv(), cwd, in, out, err);
        try {
            fec.run();
            exit = fec.exitCode;
        }
        catch (HttpSwitchingClient.ProtocolNegotiationException e) {
            e.printStackTrace();
            exit = 13;
        }
        catch (IOException e) {
            e.printStackTrace();
            exit = 13;
        }
        catch (MessageProtocolException e) {
            e.printStackTrace();
            exit = 13;
        }
        return exit;
    }

    private static IDaemonLocation startNewDaemon(File config) throws IOException {
        String inactivTimeOut;
        String connTimeOut;
        String pathToDaemon = System.getenv("SCM_DAEMON_PATH");
        if (pathToDaemon == null) {
            pathToDaemon = "scm";
        }
        if ((connTimeOut = System.getenv(SCM_DAEMON_CONNECTION_TIME_OUT)) == null) {
            connTimeOut = "120000";
        }
        if ((inactivTimeOut = System.getenv(SCM_DAEMON_INACTIVE_TIME_OUT)) == null) {
            inactivTimeOut = "7200000";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(pathToDaemon, "--config", config.getAbsolutePath(), "daemon", "start", "--connection-timeout", connTimeOut, "--inactive-timeout", inactivTimeOut);
        Process proc = pb.start();
        InputStream in = proc.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String portLine = reader.readLine();
        if (portLine == null) {
            throw FrontEndClient.handleDaemonExecFailure(proc);
        }
        if (portLine.startsWith("Listening for transport dt_socket") && (portLine = reader.readLine()) == null) {
            throw FrontEndClient.handleDaemonExecFailure(proc);
        }
        String keyLine = reader.readLine();
        if (keyLine == null) {
            throw FrontEndClient.handleDaemonExecFailure(proc);
        }
        final String port = portLine.substring("Port: ".length()).trim();
        final String key = keyLine.substring("Key: ".length()).trim();
        return new IDaemonLocation(){

            public String getKey() {
                return key;
            }

            public int getPort() {
                return Integer.parseInt(port);
            }
        };
    }

    private static IOException handleDaemonExecFailure(Process proc) {
        InputStream err = proc.getErrorStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(err));
        System.err.println("Expected coordinates from daemon. Daemon's error: ");
        try {
            String s;
            while ((s = reader.readLine()) != null) {
                System.err.println(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(13);
        return new IOException("Unreachable");
    }

    public static void main(String[] args) {
        System.exit(FrontEndClient.run(args, System.getenv(), System.in, System.out, System.err));
    }

    public FrontEndClient(String secretKey, int port, String[] args, Map<String, String> env, String cwd, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        this.port = port;
        this.secretKey = secretKey;
        this.args = args;
        this.env = env;
        this.cwd = cwd;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public static File findConfigDirectory(String[] args, Map<String, String> env) {
        String path = StringUtil.getPathArgument((String[])args, null, (String)"--config");
        if (path == null) {
            path = FileSystemCore.getUserConfigDir(env).getConfigDir();
        }
        File result = new File(path);
        try {
            result = result.getCanonicalFile();
        }
        catch (IOException iOException) {}
        return result;
    }

    public static String findEffectiveCwd(String[] args) {
        return StringUtil.findEffectiveCwd((String[])args);
    }

    public int run() throws HttpSwitchingClient.ProtocolNegotiationException, IOException, MessageProtocolException {
        HttpSwitchingClient.HttpSwitchResult conn = HttpSwitchingClient.negotiate("localhost", this.port, this.secretKey, REQUEST_URI, "vnd.ibm.jazz.cli.minimal-1.0");
        try {
            Message msg;
            ProtocolUtil.writeSubcommandDescription(conn, this.args, this.env, this.cwd);
            block11: while (true) {
                if ((msg = Reader.readMessage(conn.getInputStream())) == null) {
                    int n = this.exitCode;
                    return n;
                }
                switch (msg.getMessageType()) {
                    case STDOUT: {
                        this.stdout.write(msg.getFields()[0]);
                        this.stdout.flush();
                        continue block11;
                    }
                    case STDERR: {
                        this.stderr.write(msg.getFields()[0]);
                        this.stderr.flush();
                        continue block11;
                    }
                    case PASSWORD_READ: {
                        this.password_read(conn.getOutputStream(), msg);
                        continue block11;
                    }
                    case STDIN_READ: {
                        this.stdin_read(conn.getOutputStream(), msg);
                        continue block11;
                    }
                    case EXIT_CODE: {
                        if (msg.getFields()[0].length != 1) {
                            throw new MessageProtocolException("Require exactly one byte in " + (Object)((Object)MessageType.EXIT_CODE));
                        }
                        this.exitCode = msg.getFields()[0][0];
                        continue block11;
                    }
                }
                break;
            }
            throw new RuntimeException("Unknown message: " + msg);
        }
        finally {
            conn.close();
        }
    }

    private void stdin_read(OutputStream outputStream, Message msg) throws IOException {
        int size = Integer.parseInt(new String(msg.getFields()[0], "UTF-8"));
        byte[] buf = new byte[size];
        int read = System.in.read(buf);
        if (read == -1) {
            ProtocolUtil.writeMessage(outputStream, MessageType.STDIN_CLOSED, new byte[0][]);
        } else {
            ProtocolUtil.writeMessage(outputStream, MessageType.STDIN_RESPONSE, new byte[][]{buf});
        }
        outputStream.flush();
    }

    private void password_read(OutputStream outputStream, Message msg) throws IOException {
        boolean mask = Boolean.parseBoolean(new String(msg.getFields()[1], "UTF-8"));
        String password = PromptUtil.prompt((String)new String(msg.getFields()[0]), (boolean)mask, (InputStream)this.stdin, (PrintStream)this.stdout);
        ProtocolUtil.writeMessage(outputStream, MessageType.PASSWORD_RESPONSE, new byte[][]{password.getBytes()});
        outputStream.flush();
    }

    public static IDaemonRegistry.IRegistryEntry findDaemon(IDaemonRegistry registry, String cwd) {
        Collection entries = registry.listDaemons(null);
        Path cwdPath = new Path(cwd);
        IDaemonRegistry.IRegistryEntry uncommitted = null;
        for (IDaemonRegistry.IRegistryEntry entry : entries) {
            boolean hasSandbox = false;
            IDaemonRegistry.IDaemonSandbox[] iDaemonSandboxArray = entry.getRegisteredSandboxes();
            int n = iDaemonSandboxArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDaemonRegistry.IDaemonSandbox sandbox = iDaemonSandboxArray[n2];
                hasSandbox = true;
                File f = sandbox.getSandboxRoot();
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException iOException) {}
                Path sandboxPath = new Path(f.getAbsolutePath());
                if (sandboxPath.isPrefixOf((IPath)cwdPath)) {
                    return entry;
                }
                ++n2;
            }
            if (hasSandbox) continue;
            uncommitted = entry;
        }
        return uncommitted;
    }
}

