/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemQueryResults<T> {
    private final IQueryService fQueryService;
    private IItemQueryPage fCurrentPage;
    private Iterator<T> fResultIterator;

    public ItemQueryResults(IQueryService queryService, IItemQuery itemQuery, Object[] parameters) throws TeamRepositoryException {
        this(queryService, itemQuery, parameters, 512);
    }

    public ItemQueryResults(IQueryService queryService, IItemQuery itemQuery, Object[] parameters, int pageSize) throws TeamRepositoryException {
        this.fQueryService = queryService;
        this.fCurrentPage = this.fQueryService.queryItems(itemQuery, this.ensureHandlesOnly(parameters), pageSize);
        this.fResultIterator = this.fCurrentPage.getItemHandles().iterator();
    }

    protected Object[] ensureHandlesOnly(Object[] parameters) {
        int i = 0;
        while (i < parameters.length) {
            Object object = parameters[i];
            if (object instanceof IItem) {
                parameters[i] = ((IItem)object).getItemHandle();
            }
            ++i;
        }
        return parameters;
    }

    public boolean hasNext() throws TeamRepositoryException {
        return this.fResultIterator != null && this.fResultIterator.hasNext() || this.fetchNextPage();
    }

    public T next() throws TeamRepositoryException {
        return this.hasNext() ? (T)this.fResultIterator.next() : null;
    }

    private boolean fetchNextPage() throws TeamRepositoryException {
        if (this.fCurrentPage == null) {
            return false;
        }
        if (this.fCurrentPage.hasNext()) {
            this.fCurrentPage = (IItemQueryPage)this.fQueryService.fetchPage(this.fCurrentPage.getToken(), this.fCurrentPage.getNextStartPosition(), this.fCurrentPage.getSize());
            this.fResultIterator = this.fCurrentPage.getItemHandles().iterator();
        } else {
            this.fResultIterator = null;
            this.fCurrentPage = null;
        }
        return this.hasNext();
    }

    public List<T> getAllItems() throws TeamRepositoryException {
        ArrayList<T> result = new ArrayList<T>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }
}

