/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.apt.internal.common.util.DataQueryRowIterator;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataInQuery<Q extends IQueryModel, P> {
    private Q fQueryModel;
    private int fBatchSize;
    private IDataQuery fQuery;
    private List<? extends P> fCurrentValues;
    public static final int MAX_BATCH_SIZE = 25;

    public DataInQuery(Q queryModel) {
        this(queryModel, 25);
    }

    public DataInQuery(Q queryModel, int batchSize) {
        this.fQueryModel = queryModel;
        this.fBatchSize = batchSize;
    }

    protected abstract void select(IDataQuery var1, Q var2);

    protected abstract IPredicate createPredicate(IDataQuery var1, Q var2, List<Object> var3);

    protected abstract void accept(IDataRow var1);

    protected abstract Object getQueryParameter(P var1);

    public void execute(IQueryService service, Collection<? extends P> values) throws TeamRepositoryException {
        try {
            Iterator<List<Object>> valueIterator = values instanceof List ? new ListCurrentValues((List)values, this.fBatchSize).iterator() : new CollectionCurrentValues<P>(values, this.fBatchSize).iterator();
            while (valueIterator.hasNext()) {
                this.fCurrentValues = valueIterator.next();
                this.fQuery = (IDataQuery)IDataQuery.FACTORY.newInstance(this.fQueryModel);
                this.select(this.fQuery, this.fQueryModel);
                ArrayList<Object> parameters = new ArrayList<Object>();
                IPredicate predicate = this.createPredicate(this.fQuery, this.fQueryModel, parameters);
                this.fQuery.filter(predicate);
                DataQueryRowIterator iterator = new DataQueryRowIterator(service, this.fQuery, parameters);
                while (iterator.hasNext()) {
                    this.accept(iterator.next());
                }
            }
        }
        finally {
            this.fQuery = null;
            this.fCurrentValues = null;
        }
    }

    protected void fillParameters(List<Object> parameters) {
        for (P value : this.fCurrentValues) {
            parameters.add(this.getQueryParameter(value));
        }
    }

    protected IItemHandleInputArg[] createItemHandleArgs() {
        IItemHandleInputArg[] args = new IItemHandleInputArg[this.fCurrentValues.size()];
        int i = 0;
        while (i < args.length) {
            args[i] = this.fQuery.newItemHandleArg();
            ++i;
        }
        return args;
    }

    protected IUUIDInputArg[] createUUIDArgs() {
        IUUIDInputArg[] args = new IUUIDInputArg[this.fCurrentValues.size()];
        int i = 0;
        while (i < args.length) {
            args[i] = this.fQuery.newUUIDArg();
            ++i;
        }
        return args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionCurrentValues<P>
    extends CurrentValues<P> {
        private Collection<? extends P> fValues;
        private Iterator<? extends P> fIterator;

        public CollectionCurrentValues(Collection<? extends P> values, int batchSize) {
            super(batchSize);
            this.fValues = values;
            this.fIterator = this.fValues.iterator();
        }

        @Override
        public int totalSize() {
            return this.fValues.size();
        }

        @Override
        public Iterator<List<? extends P>> iterator() {
            return new Iterator<List<? extends P>>(){

                @Override
                public boolean hasNext() {
                    return CollectionCurrentValues.this.fCurrentIndex < CollectionCurrentValues.this.fValues.size();
                }

                @Override
                public List<? extends P> next() {
                    int fCurrentBatchSize = Math.min(CollectionCurrentValues.this.fBatchSize, CollectionCurrentValues.this.fValues.size() - CollectionCurrentValues.this.fCurrentIndex);
                    ArrayList result = new ArrayList(fCurrentBatchSize);
                    int i = 0;
                    while (i < fCurrentBatchSize) {
                        result.add(CollectionCurrentValues.this.fIterator.next());
                        ++i;
                    }
                    CollectionCurrentValues.this.fCurrentIndex += fCurrentBatchSize;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CurrentValues<P>
    implements Iterable<List<? extends P>> {
        protected int fBatchSize;
        protected int fCurrentIndex;
        protected int fCurrentBatchSize;

        public CurrentValues(int batchSize) {
            this.fBatchSize = batchSize;
        }

        public abstract int totalSize();

        public int currentBatchSize() {
            return this.fCurrentBatchSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListCurrentValues<P>
    extends CurrentValues<P> {
        private List<? extends P> fValues;

        public ListCurrentValues(List<? extends P> values, int batchSize) {
            super(batchSize);
            this.fValues = values;
        }

        @Override
        public int totalSize() {
            return this.fValues.size();
        }

        @Override
        public Iterator<List<? extends P>> iterator() {
            return new Iterator<List<? extends P>>(){

                @Override
                public boolean hasNext() {
                    return ListCurrentValues.this.fCurrentIndex < ListCurrentValues.this.fValues.size();
                }

                @Override
                public List<? extends P> next() {
                    ListCurrentValues.this.fCurrentBatchSize = Math.min(ListCurrentValues.this.fBatchSize, ListCurrentValues.this.fValues.size() - ListCurrentValues.this.fCurrentIndex);
                    List result = ListCurrentValues.this.fValues.subList(ListCurrentValues.this.fCurrentIndex, ListCurrentValues.this.fCurrentIndex + ListCurrentValues.this.fCurrentBatchSize);
                    ListCurrentValues.this.fCurrentIndex += ListCurrentValues.this.fCurrentBatchSize;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

