/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;

public abstract class CMode {
    private static final int HANDLE_TYPE = 1;
    private static final int ITEM_TYPE = 2;
    private static final int OTHER_TYPE = 3;
    public static final CMode CURRENT = new CMode("Current"){

        public UUID getUUID(Object element) {
            if (element instanceof IItemHandle) {
                return ((IItemHandle)element).getItemId();
            }
            if (element instanceof IItem) {
                return ((IItem)element).getItemId();
            }
            throw new IllegalArgumentException(NLS.bind((String)"Unsupported key: {0}", (Object)element.getClass().getName(), (Object[])new Object[0]));
        }
    };
    public static final CMode STATE = new CMode("State"){

        public UUID getUUID(Object element) {
            if (element instanceof IItemHandle) {
                return ((IItemHandle)element).getStateId();
            }
            if (element instanceof IItem) {
                return ((IItem)element).getStateId();
            }
            throw new IllegalArgumentException(NLS.bind((String)"Unsupported key: {0}", (Object)element.getClass().getName(), (Object[])new Object[0]));
        }
    };
    public static final CMode CURRENT_HANDLEONLY = new CMode("CurrentHandleOnly"){

        public UUID getUUID(Object element) {
            if (element instanceof IItemHandle) {
                return ((IItemHandle)element).getItemId();
            }
            throw new IllegalArgumentException(NLS.bind((String)"Unsupported key: {0}", (Object)element.getClass().getName(), (Object[])new Object[0]));
        }

        protected int getObjectType(Object object) {
            return object instanceof IItemHandle ? 1 : 3;
        }
    };
    private String fMode;

    CMode(String mode) {
        this.fMode = mode;
    }

    public boolean supportsKeyType(Object element) {
        return element instanceof IItem || element instanceof IItemHandle;
    }

    public abstract UUID getUUID(Object var1);

    public boolean matches(Object element, Object fromCollection) {
        int t2;
        if (element == fromCollection) {
            return true;
        }
        if (element == null) {
            throw new NullPointerException();
        }
        if (fromCollection == null) {
            return false;
        }
        int t1 = this.getObjectType(element);
        if (t1 != (t2 = this.getObjectType(fromCollection))) {
            if (t1 == 1 && t2 == 2) {
                return this.matchesHandleItem((IItemHandle)element, (IItem)fromCollection);
            }
            return false;
        }
        switch (t1) {
            case 1: {
                return this.matchesHandle((IItemHandle)element, (IItemHandle)fromCollection);
            }
            case 2: {
                return this.matchesItem((IItem)element, (IItem)fromCollection);
            }
        }
        return element.equals(fromCollection);
    }

    private boolean matchesHandleItem(IItemHandle element, IItem fromCollection) {
        return this.getUUID(element).equals((Object)this.getUUID(fromCollection));
    }

    private boolean matchesHandle(IItemHandle element, IItemHandle fromCollection) {
        return this.equalsHandle(element, fromCollection);
    }

    private boolean matchesItem(IItem element, IItem fromCollection) {
        return this.equalsItem(element, fromCollection);
    }

    public boolean equals(Object o1, Object o2) {
        int t2;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            throw new NullPointerException();
        }
        if (o2 == null) {
            return false;
        }
        int t1 = this.getObjectType(o1);
        if (t1 != (t2 = this.getObjectType(o2))) {
            return false;
        }
        switch (t1) {
            case 1: {
                return this.equalsHandle((IItemHandle)o1, (IItemHandle)o2);
            }
            case 2: {
                return this.equalsItem((IItem)o1, (IItem)o2);
            }
        }
        return o1.equals(o2);
    }

    private boolean equalsHandle(IItemHandle h1, IItemHandle h2) {
        return this.getUUID(h1).equals((Object)this.getUUID(h2));
    }

    private boolean equalsItem(IItem i1, IItem i2) {
        return i1 == i2;
    }

    public final boolean equals(Object other) {
        return super.equals(other);
    }

    public final int hashCode() {
        return this.fMode.hashCode();
    }

    public String toString() {
        return "Mode: " + this.fMode;
    }

    protected int getObjectType(Object object) {
        if (object instanceof IItem) {
            return 2;
        }
        if (object instanceof IItemHandle) {
            return 1;
        }
        return 3;
    }
}

