/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.util;

import com.ibm.team.apt.internal.common.scripting.IScriptEnvironment;
import com.ibm.team.apt.internal.common.scripting.IScriptObjectProxy;
import com.ibm.team.apt.internal.common.scripting.IScriptRunnable;
import com.ibm.team.apt.internal.common.scripting.annotation.ScriptType;
import com.ibm.team.apt.internal.common.scripting.impl.JavaScriptTypes;
import com.ibm.team.apt.internal.common.scripting.util.IProxyJSType;
import com.ibm.team.apt.internal.common.scripting.util.JSUtils;
import com.ibm.team.apt.internal.common.scripting.util.WrappableScriptableObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory<T extends IProxyJSType> {
    private final Class<T> fType;

    public static <T extends IProxyJSType> Factory<T> create(Class<T> type) {
        return new Factory<T>(type);
    }

    private Factory(Class<T> type) {
        this.fType = type;
    }

    public T newInstance(IScriptEnvironment environment, Object ... args) {
        ScriptInvocationHandler invocationHandler = new ScriptInvocationHandler(environment, this.fType.getAnnotation(ScriptType.class).value(), args);
        IProxyJSType result = (IProxyJSType)Proxy.newProxyInstance(this.fType.getClassLoader(), new Class[]{this.fType}, (InvocationHandler)invocationHandler);
        invocationHandler.getTarget().setWrapped(result);
        return (T)result;
    }

    public class ScriptInvocationHandler
    implements InvocationHandler,
    IScriptObjectProxy {
        private WrappableScriptableObject fTarget;
        private IScriptEnvironment fScriptEnvironment;

        private ScriptInvocationHandler(IScriptEnvironment scriptEnvironment, final String ctor, final Object ... args) {
            this.fScriptEnvironment = scriptEnvironment;
            this.fTarget = this.fScriptEnvironment.execute(new IScriptRunnable<WrappableScriptableObject, RuntimeException>(){

                @Override
                public WrappableScriptableObject run(Context cx, Scriptable scope) throws RuntimeException {
                    return JSUtils.createWrappable(cx, scope, ctor, args);
                }
            });
        }

        public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
            if ("getScriptEnvironment".equals(method.getName())) {
                return this.fScriptEnvironment;
            }
            return this.fScriptEnvironment.execute(new IScriptRunnable<Object, RuntimeException>(){

                @Override
                public Object run(Context cx, Scriptable scope) throws RuntimeException {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    int i = 0;
                    while (i < parameterTypes.length) {
                        args[i] = JavaScriptTypes.getType(parameterTypes[i]).convertToScript(cx, scope, args[i], parameterTypes[i]);
                        ++i;
                    }
                    Object result = ScriptableObject.callMethod((Scriptable)ScriptInvocationHandler.this.fTarget, (String)method.getName(), (Object[])(args != null ? args : ScriptRuntime.emptyArgs));
                    return JavaScriptTypes.getType(method.getReturnType()).convertToJava(cx, scope, result, method.getReturnType());
                }
            });
        }

        public Scriptable getScriptable() {
            return this.fTarget;
        }

        public WrappableScriptableObject getTarget() {
            return this.fTarget;
        }
    }
}

