/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.impl;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.AbstractScriptType;
import com.ibm.team.apt.internal.common.scripting.InstanciationDeniedException;
import com.ibm.team.apt.internal.common.scripting.ScriptException;
import com.ibm.team.apt.internal.common.scripting.annotation.ScriptType;
import com.ibm.team.apt.internal.common.scripting.annotation.WrapType;
import com.ibm.team.apt.internal.common.scripting.impl.ArgumentProvider;
import com.ibm.team.apt.internal.common.scripting.util.JSUtils;
import java.lang.reflect.Constructor;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptTypeConstructor
extends BaseFunction
implements Function {
    private final Class<? extends AbstractScriptType> fScriptType;
    private final Constructor<? extends AbstractScriptType> fConstructor;
    private final ArgumentProvider fConstructorArgumentsProvider;
    private final ScriptableObject fScriptTypePrototype;

    public ScriptTypeConstructor(Context cx, Scriptable scope, Class<? extends AbstractScriptType> scriptType) {
        this(cx, scope, scriptType, null);
    }

    public ScriptTypeConstructor(Context cx, Scriptable scope, Constructor<? extends AbstractScriptType> constructor) {
        this(cx, scope, constructor.getDeclaringClass(), constructor);
    }

    private ScriptTypeConstructor(Context cx, Scriptable scope, Class<? extends AbstractScriptType> scriptType, Constructor<? extends AbstractScriptType> constructor) {
        this.fScriptType = scriptType;
        this.fConstructor = constructor;
        this.fConstructorArgumentsProvider = constructor != null ? ArgumentProvider.create(constructor.getParameterTypes()) : null;
        this.setParentScope(scope);
        this.setPrototype(ScriptableObject.getFunctionPrototype((Scriptable)scope));
        Scriptable superTypePrototype = null;
        Class<? extends AbstractScriptType> superclass = scriptType.getSuperclass();
        while (AbstractScriptType.class != superclass) {
            if (superclass.getAnnotation(ScriptType.class) != null) {
                superTypePrototype = JSUtils.getScriptTypeConstructor(cx, scope, superclass.asSubclass(AbstractScriptType.class)).getScriptTypePrototype();
                break;
            }
            superclass = superclass.getSuperclass();
        }
        if (superTypePrototype == null) {
            superTypePrototype = ScriptTypeConstructor.getObjectPrototype((Scriptable)scope);
        }
        this.fScriptTypePrototype = new NativeObject();
        this.fScriptTypePrototype.defineProperty("constructor", (Object)this, 7);
        this.fScriptTypePrototype.setPrototype(superTypePrototype);
        this.fScriptTypePrototype.setParentScope(this.getParentScope());
    }

    public ScriptableObject getScriptTypePrototype() {
        return this.fScriptTypePrototype;
    }

    public Class<?> getWrapType() {
        WrapType wrapType = this.fScriptType.getAnnotation(WrapType.class);
        return wrapType != null ? wrapType.value() : null;
    }

    public int getArity() {
        return this.fConstructorArgumentsProvider != null ? this.fConstructorArgumentsProvider.getArity() : 0;
    }

    public int getLength() {
        return this.fConstructorArgumentsProvider != null ? this.fConstructorArgumentsProvider.getArity() : 0;
    }

    public String getFunctionName() {
        return "constructor";
    }

    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo((Scriptable)instance, (Scriptable)this.fScriptTypePrototype);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return Undefined.instance;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        if (this.fConstructor == null) {
            throw new InstanciationDeniedException(this.fScriptType);
        }
        try {
            return this.fConstructor.newInstance(this.fConstructorArgumentsProvider.getArguments(cx, scope, args));
        }
        catch (Exception e) {
            APTCommonPlugin.log("Failed to call method", e);
            throw new ScriptException(e.getMessage());
        }
    }
}

