/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.impl;

import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaScriptTypes {
    String{

        @Override
        public String convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return source == null ? null : (source instanceof String ? (String)source : ScriptRuntime.toString((Object)source));
        }
    }
    ,
    Integer{

        @Override
        public Integer convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return source instanceof Integer ? (Integer)source : ScriptRuntime.toInt32((Object)source);
        }

        @Override
        public Object convertToScript(Context cx, Scriptable scope, Object source, Class<?> declaredSourceType) {
            return cx.getWrapFactory().wrap(cx, scope, source, java.lang.Integer.TYPE);
        }
    }
    ,
    Boolean{

        @Override
        public Boolean convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return source instanceof Boolean ? (Boolean)source : java.lang.Boolean.valueOf(ScriptRuntime.toBoolean((Object)source));
        }

        @Override
        public Object convertToScript(Context cx, Scriptable scope, Object source, Class<?> declaredSourceType) {
            return cx.getWrapFactory().wrap(cx, scope, source, java.lang.Boolean.TYPE);
        }
    }
    ,
    Double{

        @Override
        public Double convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return source instanceof Double ? (Double)source : ScriptRuntime.toNumber((Object)source);
        }

        @Override
        public Object convertToScript(Context cx, Scriptable scope, Object source, Class<?> declaredSourceType) {
            return cx.getWrapFactory().wrap(cx, scope, source, java.lang.Double.TYPE);
        }
    }
    ,
    Scriptable{

        public Scriptable convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return ScriptRuntime.toObject((Context)cx, (Scriptable)scope, (Object)source);
        }
    }
    ,
    Generic{

        @Override
        public Object convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return Context.jsToJava((Object)source, targetType);
        }
    }
    ,
    Void{

        @Override
        public Object convertToScript(Context cx, Scriptable scope, Object source, Class<?> declaredSourceType) {
            return Undefined.instance;
        }

        @Override
        public Object convertToJava(Context cx, Scriptable scope, Object source, Class<?> targetType) {
            return null;
        }
    };


    private JavaScriptTypes() {
    }

    public Object convertToScript(Context cx, Scriptable scope, Object source, Class<?> declaredSourceType) {
        if (declaredSourceType != null && Object.class.equals(declaredSourceType) && "undefined".equals(source)) {
            return Undefined.instance;
        }
        if (source instanceof Date) {
            return cx.newObject(scope, "Date", new Object[]{((Date)source).getTime()});
        }
        return cx.getWrapFactory().wrap(cx, scope, source, declaredSourceType);
    }

    public abstract Object convertToJava(Context var1, Scriptable var2, Object var3, Class<?> var4);

    public static JavaScriptTypes getType(Class<?> typeClass) {
        if (typeClass == String.class) {
            return String;
        }
        if (typeClass == Integer.class || typeClass == java.lang.Integer.TYPE) {
            return Integer;
        }
        if (typeClass == Boolean.class || typeClass == java.lang.Boolean.TYPE) {
            return Boolean;
        }
        if (typeClass == Double.class || typeClass == java.lang.Double.TYPE) {
            return Double;
        }
        if (Scriptable.class.isAssignableFrom(typeClass)) {
            return Scriptable;
        }
        if (typeClass == Void.class || typeClass == java.lang.Void.TYPE) {
            return Void;
        }
        return Generic;
    }

    /* synthetic */ JavaScriptTypes(String string, int n, JavaScriptTypes javaScriptTypes) {
        this();
    }
}

