/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.environment;

import com.ibm.team.apt.internal.common.scripting.environment.AbstractLocalizationFeature;
import com.ibm.team.repository.common.FileLocator;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Timestamp;
import org.eclipse.core.runtime.IPath;

public class FileLocalizationFeature
extends AbstractLocalizationFeature {
    private final IPath fRootPath;
    private final String fBundleSymbolicName;

    public FileLocalizationFeature(String bundle, String name, String bundleSymbolicName, IPath rootPath) {
        super(bundle, name);
        this.fBundleSymbolicName = bundleSymbolicName;
        this.fRootPath = rootPath;
    }

    protected String getTranslatedSource(String locale) throws IOException {
        URL url = this.getUrl(locale);
        if (url != null) {
            URLConnection connection = url.openConnection();
            return FileLocalizationFeature.createStringFromInputStream(connection.getInputStream(), connection.getContentEncoding());
        }
        return null;
    }

    protected Timestamp getTranslatedLastModifiedDate(String locale) throws IOException {
        URL url = this.getUrl(locale);
        if (url != null) {
            URLConnection connection = url.openConnection();
            return new Timestamp(connection.getDate());
        }
        return null;
    }

    private URL getUrl(String locale) {
        IPath path = this.fRootPath;
        if (locale != null) {
            path = path.append(locale);
        }
        path = path.append(String.valueOf(this.fName) + ".js");
        URL url = FileLocator.find((String)this.fBundleSymbolicName, (IPath)path, null);
        return url;
    }
}

