/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting.environment;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.scripting.environment.AbstractScriptFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.Locale;

public abstract class AbstractLocalizationFeature
extends AbstractScriptFeature {
    protected static final String NLS_PATH = "nls";
    protected static final String NLS_ROOT = "ROOT";
    protected final String fName;
    protected final String fBundle;

    protected AbstractLocalizationFeature(String bundle, String name) {
        this.fBundle = bundle;
        this.fName = name;
    }

    public String getSource(Locale locale) throws IOException {
        StringBuilder result = new StringBuilder();
        String moduleName = this.fBundle + '.' + NLS_PATH + '.' + this.fName;
        result.append("(function(){\n");
        result.append("var bundle= dojo.provide(\"").append(moduleName).append("\");\n");
        String[] localeParts = this.getLocaleParts(locale);
        result.append("var parentLocaleObject, hash, clazz, loaded;\n");
        int i = 0;
        while (i <= localeParts.length) {
            String localeModuleName = this.getLocaleModuleName(localeParts, i);
            result.append("dojo.provide(\"").append(moduleName).append('.').append(localeModuleName).append("\");\n");
            result.append("loaded= false;\n");
            try {
                String translated = this.getTranslatedSource(this.getLocaleDirectory(localeParts, i));
                if (translated != null) {
                    result.append("try {\n");
                    result.append("\thash= (").append(translated).append(");\n");
                    result.append("\tclazz = function(){};\n");
                    result.append("\tclazz.prototype = parentLocaleObject;\n");
                    result.append("\tbundle['").append(localeModuleName).append("'] = new clazz();\n");
                    result.append("\tfor(var j in hash){ bundle['").append(localeModuleName).append("'][j] = hash[j]; }\n");
                    result.append("\tloaded= true;\n");
                    result.append("} catch (e) {\n");
                    result.append("\tconsole.log(e)\n");
                    result.append("}\n");
                }
            }
            catch (IOException e) {
                APTCommonPlugin.log("Unable to load NLS bundle", e);
            }
            result.append("\n");
            result.append("if(loaded && bundle['").append(localeModuleName).append("']){\n");
            result.append("\tparentLocaleObject = bundle['").append(localeModuleName).append("'];\n");
            result.append("}else{\n");
            result.append("\tbundle['").append(localeModuleName).append("'] = parentLocaleObject;\n");
            result.append("}\n");
            ++i;
        }
        return result.append("})();\n").toString();
    }

    private String[] getLocaleParts(Locale locale) {
        String language = locale.getLanguage().toLowerCase();
        String country = locale.getCountry().toLowerCase();
        String[] localeParts = null;
        localeParts = language.length() != 0 ? (country.length() != 0 ? new String[]{language, country} : new String[]{language}) : new String[]{};
        return localeParts;
    }

    public int getLineNumber() {
        return 1;
    }

    public String getSourceName() {
        return this.fBundle + "-" + this.fName;
    }

    protected Reader getInputReader() throws IOException {
        return new StringReader(this.getSource(Locale.getDefault()));
    }

    public Timestamp getLastModifiedTime(Locale locale) throws IOException {
        String[] localeParts = this.getLocaleParts(locale);
        Timestamp lastModifiedDate = null;
        int i = 0;
        while (i <= localeParts.length) {
            Timestamp timestamp = this.getTranslatedLastModifiedDate(this.getLocaleDirectory(localeParts, i));
            if (lastModifiedDate == null || timestamp != null && timestamp.after(lastModifiedDate)) {
                lastModifiedDate = timestamp;
            }
            ++i;
        }
        return lastModifiedDate;
    }

    protected abstract String getTranslatedSource(String var1) throws IOException;

    protected abstract Timestamp getTranslatedLastModifiedDate(String var1) throws IOException;

    private String getLocaleModuleName(String[] localeParts, int maxIndex) {
        if (maxIndex == 0) {
            return NLS_ROOT;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < maxIndex) {
            result.append(localeParts[i]).append('_');
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }

    private String getLocaleDirectory(String[] localeParts, int maxIndex) {
        if (maxIndex == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < maxIndex) {
            result.append(localeParts[i]).append('-');
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }
}

