/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.scripting;

import com.ibm.team.apt.internal.common.scripting.IScriptEnvironmentContext;
import com.ibm.team.apt.internal.common.scripting.IScriptRunnable;
import com.ibm.team.apt.internal.common.scripting.ScriptEnvironmentSetupException;
import com.ibm.team.apt.internal.common.scripting.impl.ScriptEnvironmentWrapFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IScriptEnvironment {
    public static final ContextFactory fgContextFactory = new ContextFactory();
    public static final CurrentEnvironmentAccessor CURRENT = new CurrentEnvironmentAccessor();

    public <V, E extends Exception> V execute(IScriptRunnable<V, E> var1) throws E, ScriptEnvironmentSetupException;

    public ScriptEnvironmentWrapFactory getWrapFactory();

    public IScriptEnvironmentContext getEnvironmentContext();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CurrentEnvironmentAccessor {
        public static final Object ENVIRONMENT_KEY = new Object();
        public static final Object SCOPE_KEY = new Object();

        public <V, E extends Exception> V execute(IScriptRunnable<V, E> code) throws E {
            Context cx = Context.getCurrentContext();
            if (cx == null) {
                throw new RuntimeException("No currently active script environment");
            }
            Scriptable scope = (Scriptable)cx.getThreadLocal(SCOPE_KEY);
            return code.run(cx, scope);
        }

        public IScriptEnvironment getScriptEnvironment() {
            Context cx = Context.getCurrentContext();
            return cx != null ? (IScriptEnvironment)cx.getThreadLocal(ENVIRONMENT_KEY) : null;
        }

        public <T> T getAdapter(Class<T> type) {
            IScriptEnvironment scriptEnvironment = this.getScriptEnvironment();
            if (scriptEnvironment != null) {
                return type.cast(scriptEnvironment.getEnvironmentContext().get(type));
            }
            return null;
        }
    }
}

