/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.common.APTCommonPlugin;
import com.ibm.team.apt.internal.common.plantype.IAttributeDefinitionDescriptor;
import com.ibm.team.apt.internal.common.plantype.IConfigurationElement;
import com.ibm.team.apt.internal.common.plantype.IFilterDescription;
import com.ibm.team.apt.internal.common.plantype.IGroupModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanCheckDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanItemsDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanModeDescription;
import com.ibm.team.apt.internal.common.plantype.IPlanType;
import com.ibm.team.apt.internal.common.plantype.ISortModeDescription;
import com.ibm.team.apt.internal.common.plantype.IViewModeDescription;
import com.ibm.team.apt.internal.common.process.CompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.ConfigurationElementFactory;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.ICompositeNodeProvider;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.apt.internal.common.process.INodeProvider;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticConfigurationDataRegistry
extends ExtensionRegistryReader<Void>
implements ICompositeNodeProvider,
ICacheEntryState {
    private static final UUID ORIGIN = UUID.generate();
    private static final StaticConfigurationDataRegistry fgInstance = new StaticConfigurationDataRegistry();
    private final Class[] fgSupportedTypes = new Class[]{IPlanType.class, IPlanModeDescription.class, IPlanItemsDescription.class, IViewModeDescription.class, IGroupModeDescription.class, ISortModeDescription.class, IFilterDescription.class, IAttributeDefinitionDescriptor.class, IPlanCheckDescription.class};
    private final Comparator<Class> fgComparator = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private Set<ConfigurationElementNodeProvider> fExtensions = new HashSet<ConfigurationElementNodeProvider>();
    private boolean fDirty = false;
    private UUID fState = UUID.generate();
    private Map<Class<? extends IConfigurationElement>, List<IConfigurationElement>> fRegistry = new HashMap<Class<? extends IConfigurationElement>, List<IConfigurationElement>>();

    public static StaticConfigurationDataRegistry getInstance() {
        return fgInstance;
    }

    private StaticConfigurationDataRegistry() {
        super("com.ibm.team.apt.common", "staticConfigurationData");
        Arrays.sort(this.fgSupportedTypes, this.fgComparator);
    }

    protected Void handleExtensionAdded(org.eclipse.core.runtime.IConfigurationElement element) throws Exception {
        this.fExtensions.add(new ConfigurationElementNodeProvider(element));
        this.fDirty = true;
        this.fState = UUID.generate();
        return null;
    }

    protected void initializeTypes() {
        try {
            this.doInitializeTypes();
        }
        catch (TeamRepositoryException e) {
            APTCommonPlugin.log(e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private synchronized boolean doInitializeTypes() throws TeamRepositoryException {
        if (!this.fDirty) {
            return false;
        }
        this.fRegistry.clear();
        Class[] classArray = this.fgSupportedTypes;
        int n = this.fgSupportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            List instances = ConfigurationElementFactory.allInstances(type, this.getNodeProvider(), (IProgressMonitor)new NullProgressMonitor());
            if (!instances.isEmpty()) {
                List<IConfigurationElement> list = this.fRegistry.get(type);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>(instances.size());
                    this.fRegistry.put(type, list);
                }
                list.addAll(instances);
            }
            ++n2;
        }
        this.fDirty = false;
        return true;
    }

    public synchronized <T extends IConfigurationElement> List<T> getInstances(Class<T> type) {
        this.initializeTypes();
        if (Arrays.binarySearch(this.fgSupportedTypes, type, this.fgComparator) < 0) {
            return Collections.emptyList();
        }
        if (!this.fRegistry.containsKey(type)) {
            return Collections.emptyList();
        }
        List<IConfigurationElement> list = this.fRegistry.get(type);
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>(list.size());
        for (IConfigurationElement t : list) {
            result.add(ConfigurationElementFactory.copy(t));
        }
        return result;
    }

    protected INodeProvider getNodeProvider() {
        return new CompositeNodeProvider(this.getDelegates());
    }

    @Override
    public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getNodeProvider().getNode(identifier, monitor);
    }

    @Override
    public INodeProvider[] getDelegates() {
        return this.fExtensions.toArray(new ConfigurationElementNodeProvider[0]);
    }

    @Override
    public UUID getOrigin() {
        return ORIGIN;
    }

    @Override
    public Object getState() {
        return this.fState;
    }

    private final class ConfigurationElementNodeProvider
    implements INodeProvider {
        private org.eclipse.core.runtime.IConfigurationElement fElement;

        public ConfigurationElementNodeProvider(org.eclipse.core.runtime.IConfigurationElement element) {
            this.fElement = element;
        }

        public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
            if (this.fElement.getAttribute("id").equals(identifier)) {
                return INode.FACTORY.createNode(this.fElement, this, ORIGIN, StaticConfigurationDataRegistry.this.fState);
            }
            return null;
        }

        public boolean equals(Object obj) {
            return this.fElement.equals(obj);
        }

        public int hashCode() {
            return this.fElement.hashCode();
        }
    }
}

