/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common.process;

import com.ibm.team.apt.internal.common.process.ConfigurationElementInvocationHandler;
import com.ibm.team.apt.internal.common.process.ConfigurationElements;
import com.ibm.team.apt.internal.common.process.ICacheEntryState;
import com.ibm.team.apt.internal.common.process.ICachingSupport;
import com.ibm.team.apt.internal.common.process.INode;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationElementCache
implements ICachingSupport {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("com.ibm.team.apt.internal.common.debugConfigurationElementCache", String.valueOf(false)));
    private static final String COLLECTION_PREFIX = "COLLECTION@";
    private static final int MAX_SIZE = 128;
    private final LinkedHashMap<CacheKey, Object> fCache = new LinkedHashMap<CacheKey, Object>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<CacheKey, Object> eldest) {
            boolean full;
            boolean bl = full = this.size() >= 128;
            if (full) {
                if (DEBUG) {
                    System.out.format("FULL - Remove eldest key=(%s:%s)%n", eldest.getKey().fIdentifier, eldest.getKey().fType);
                }
                ConfigurationElementCache.this.deepRemove(eldest.getKey());
            }
            return false;
        }
    };
    private final Map<UUID, Set<CacheKey>> fOrgin2CacheKey = new HashMap<UUID, Set<CacheKey>>();
    private final ReadWriteLock fLock = new ReentrantReadWriteLock();

    public <UnknowType> List<UnknowType> getCollection(String identifier, Class<UnknowType> type) {
        List list = this.get(COLLECTION_PREFIX + identifier, (Class<UnknowType>)List.class);
        if (list == null) {
            return null;
        }
        List result = Collections.checkedList(new ArrayList(), type);
        result.addAll(list);
        return result;
    }

    public <UnknowType> UnknowType get(String identifier, Class<UnknowType> type) {
        Lock readLock = this.fLock.readLock();
        readLock.lock();
        try {
            CacheKey key = CacheKey.queryKey(identifier, type);
            if (!this.fCache.containsKey(key)) {
                if (DEBUG) {
                    System.out.format("FAILED - Entry key=(%s:%s)%n", identifier, type.getName());
                }
                return null;
            }
            if (DEBUG) {
                System.out.format("SUCCESS - Entry key=(%s:%s)%n", identifier, type.getName());
            }
            UnknowType UnknowType = type.cast(this.fCache.get(key));
            return UnknowType;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean contains(String identifier, Class<?> type) {
        Lock readLock = this.fLock.readLock();
        readLock.lock();
        try {
            CacheKey key = CacheKey.queryKey(identifier, type);
            boolean bl = this.fCache.containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public int size() {
        Lock readLock = this.fLock.readLock();
        readLock.lock();
        try {
            int n = this.fCache.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public void clear() {
        Lock writeLock = this.fLock.writeLock();
        writeLock.lock();
        try {
            this.fCache.clear();
            this.fOrgin2CacheKey.clear();
            if (DEBUG) {
                System.out.format("CLEAR - Cache is empty [%d]", this.fCache.size());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void add(ICacheEntryState node, String identifier, Object value) {
        Lock writeLock = this.fLock.writeLock();
        writeLock.lock();
        try {
            CacheKey key = CacheKey.storeKey(identifier, value, node.getOrigin(), node.getState());
            if (DEBUG) {
                System.out.format("ADD - Entry key=(%s:%s) [%d]%n", identifier, key.fType.getName(), this.fCache.size());
            }
            Object removed = this.fCache.put(key, value);
            Set<CacheKey> set = this.fOrgin2CacheKey.get(node.getOrigin());
            if (set == null) {
                set = new HashSet<CacheKey>();
                this.fOrgin2CacheKey.put(node.getOrigin(), set);
            }
            set.add(key);
            if (removed != null && removed != value) {
                Set<CacheKey> dependencies = this.findDependencies(removed);
                if (DEBUG) {
                    System.out.format("\t --> ADD - Removing %d dependend entries%n", dependencies.size());
                }
                for (CacheKey dependend : dependencies) {
                    this.deepRemove(dependend);
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public <UnkownType> void registerCollection(String identifier, Collection<UnkownType> value) {
        Lock writeLock = this.fLock.writeLock();
        writeLock.lock();
        try {
            Iterator<UnkownType> iter = new ArrayList<UnkownType>(value).iterator();
            while (iter.hasNext()) {
                if (this.fCache.values().contains(iter.next())) continue;
                iter.remove();
            }
            CacheKey key = CacheKey.collectionStoreKey(COLLECTION_PREFIX + identifier, value);
            this.fCache.put(key, value);
            if (DEBUG) {
                System.out.format("REGISTER - %s%n", key.getIdentifier());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void validate(UUID origin, IInvalidationStrategy strategy) {
        Lock writeLock = this.fLock.writeLock();
        writeLock.lock();
        try {
            Set<CacheKey> set = this.fOrgin2CacheKey.get(origin);
            if (set == null) {
                return;
            }
            Iterator<CacheKey> iter = set.iterator();
            boolean modification = false;
            while (!modification && iter.hasNext()) {
                CacheKey key = iter.next();
                if (strategy.validate(key.getState())) continue;
                this.deepRemove(key);
                modification = true;
            }
            if (modification) {
                this.validate(origin, strategy);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public boolean knownOrigin(UUID origin) {
        Lock readLock = this.fLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.fOrgin2CacheKey.get(origin) != null && !this.fOrgin2CacheKey.get(origin).isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    private void deepRemove(CacheKey key) {
        if (DEBUG) {
            System.out.format("REMOVE - Entry key=(%s:%s) [%d]%n", key.fIdentifier, key.fType, this.fCache.size());
        }
        Object removed = this.fCache.remove(key);
        if (key.getOrigin() != null && this.fOrgin2CacheKey.containsKey(key.getOrigin())) {
            this.fOrgin2CacheKey.get(key.getOrigin()).remove(key);
        }
        Set<CacheKey> followUpRemovals = this.findDependencies(removed);
        for (CacheKey followUpKey : followUpRemovals) {
            this.deepRemove(followUpKey);
        }
    }

    private Set<CacheKey> findDependencies(Object object) {
        HashSet<CacheKey> dependencies = new HashSet<CacheKey>();
        for (Map.Entry<CacheKey, Object> entry : this.fCache.entrySet()) {
            boolean remove;
            boolean bl = remove = entry.getValue() != null && (this.objectReference(entry.getValue(), object) || this.collectionReference(entry, object));
            if (!remove) continue;
            dependencies.add(entry.getKey());
        }
        return dependencies;
    }

    private boolean objectReference(Object cacheEntry, Object value) {
        ConfigurationElementInvocationHandler handler = ConfigurationElements.getHandler(cacheEntry);
        if (handler == null) {
            return false;
        }
        for (Object object : handler.getValues().values()) {
            if (object == value) {
                return true;
            }
            if (object == null) continue;
            if (object.equals(value)) {
                return true;
            }
            if (!object.getClass().isArray()) continue;
            int length = Array.getLength(object);
            int i = 0;
            while (i < length) {
                Object obj = Array.get(object, i);
                if (obj == value || obj.equals(value)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean collectionReference(Map.Entry<CacheKey, Object> entry, Object object) {
        if (!entry.getKey().getIdentifier().startsWith(COLLECTION_PREFIX)) {
            return false;
        }
        if (!(entry.getValue() instanceof Collection)) {
            return false;
        }
        return ((Collection)entry.getValue()).contains(object);
    }

    @Override
    public INode getNode(String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }

    public static final class CacheKey
    implements ICacheEntryState {
        private final Class fType;
        private final String fIdentifier;
        private final UUID fOrigin;
        private final Object fState;

        static CacheKey queryKey(String identifier, Class type) {
            return new CacheKey(type, identifier, null, null);
        }

        static CacheKey storeKey(String identifier, Object value, UUID orgin, Object state) {
            return new CacheKey(Proxy.isProxyClass(value.getClass()) ? ConfigurationElements.getConfigurationDataType(value) : value.getClass(), identifier, orgin, state);
        }

        static CacheKey collectionStoreKey(String identifier, Object value) {
            return new CacheKey(List.class, identifier, null, null);
        }

        private CacheKey(Class type, String identifier, UUID origin, Object state) {
            this.fIdentifier = identifier;
            this.fType = type;
            this.fOrigin = origin;
            this.fState = state;
        }

        public UUID getOrigin() {
            return this.fOrigin;
        }

        public Object getState() {
            return this.fState;
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public Class getType() {
            return this.fType;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.fIdentifier.hashCode();
            result = 31 * result + this.fType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (!this.fIdentifier.equals(other.fIdentifier)) {
                return false;
            }
            return this.fType.equals(other.fType);
        }
    }

    public static interface IInvalidationStrategy {
        public boolean validate(Object var1);
    }
}

