/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.common;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.common.LegacyHelper;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public interface IStore {
    public static final Factory FACTORY = new Factory();
    public static final String ROOT = "auxiliaryData";
    public static final String TYPE = "store";

    public IMemento getStore(String var1);

    public IMemento getStore(String var1, boolean var2);

    public static class Factory {
        private static final String MY_FOLDER_DATA_ELEMENT = "myFolderData";
        private static final String STRUCTURE_ELEMENT = "structure";
        private static final String MAPPING_ELEMENT = "mapping";
        private static final String FOLDER_ELEMENT = "folder";
        private static final String ITEM_ELEMENT = "item";
        private static final String ID_ATTRIBUTE = "itemId";
        private static final String FOLDER_ID_ATTRIBUTE = "folderId";
        private static final String LABEL_ATTRIBUTE = "label";

        private Factory() {
        }

        public IStore createStore(IIterationPlanRecordHandle planHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                ItemProfile profile = ItemProfile.createProfile((IItemType)IIterationPlanRecord.ITEM_TYPE, (String[])new String[]{IIterationPlanRecord.AUXILIARY_DATA_PROPERTTY});
                IIterationPlanRecord plan = (IIterationPlanRecord)auditableCommon.resolveAuditable((IAuditableHandle)planHandle, profile, (IProgressMonitor)progress.newChild(1));
                IContent content = plan.getAuxiliaryData();
                IStore iStore = this.createStore(content, auditableCommon, (IProgressMonitor)progress.newChild(1));
                return iStore;
            }
            finally {
                progress.done();
            }
        }

        /*
         * Exception decompiling
         */
        public IStore createStore(IContent content, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public IStore createEmptyStore() {
            return new Store(XMLMemento.createWriteRoot((String)IStore.ROOT));
        }

        private String addFolder(JSONObject addTo, IMemento folderMemento, String parentFolderId, SortIndexCounter counter) {
            String folderId = folderMemento.getString(ID_ATTRIBUTE);
            if (folderId != null) {
                JSONObject folder = new JSONObject();
                folder.put((Object)"id", (Object)folderId);
                folder.put((Object)LABEL_ATTRIBUTE, (Object)folderMemento.getString(LABEL_ATTRIBUTE));
                folder.put((Object)"index", (Object)counter.getSortIndex());
                folder.put((Object)"parentId", (Object)parentFolderId);
                addTo.put((Object)folderId, (Object)folder);
            }
            return folderId;
        }

        private void readFolderStructure(IMemento memento, String parentFolderId, SortIndexCounter counter, JSONObject folders, JSONObject sortOrder) {
            IMemento[] iMementoArray = memento.getChildren();
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                String itemId;
                IMemento child = iMementoArray[n2];
                if (FOLDER_ELEMENT.equals(child.getType())) {
                    String folderId = this.addFolder(folders, child, parentFolderId, counter);
                    if (folderId != null) {
                        this.readFolderStructure(child, folderId, counter, folders, sortOrder);
                    }
                } else if (ITEM_ELEMENT.equals(child.getType()) && (itemId = child.getString(ID_ATTRIBUTE)) != null) {
                    JSONObject itemSortEntry = (JSONObject)sortOrder.get((Object)itemId);
                    if (itemSortEntry == null) {
                        itemSortEntry = new JSONObject();
                        sortOrder.put((Object)itemId, (Object)itemSortEntry);
                    }
                    if (parentFolderId != null) {
                        itemSortEntry.put((Object)parentFolderId, (Object)counter.getSortIndex());
                    }
                    this.readFolderStructure(child, parentFolderId, counter, folders, sortOrder);
                }
                ++n2;
            }
        }

        private void readItemMapping(IMemento memento, JSONObject mapping) {
            IMemento[] iMementoArray = memento.getChildren(ITEM_ELEMENT);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento item = iMementoArray[n2];
                String id = item.getString(ID_ATTRIBUTE);
                if (id != null) {
                    mapping.put((Object)id, (Object)item.getString(FOLDER_ID_ATTRIBUTE));
                }
                ++n2;
            }
        }

        private XMLMemento migrateMemento(IMemento auxiliaryData) {
            IMemento myFolderData = auxiliaryData.getChild(MY_FOLDER_DATA_ELEMENT);
            JSONObject folders = new JSONObject();
            JSONObject mapping = new JSONObject();
            JSONObject sortOrder = new JSONObject();
            this.readFolderStructure(myFolderData.getChild(STRUCTURE_ELEMENT), null, new SortIndexCounter(), folders, sortOrder);
            this.readItemMapping(myFolderData.getChild(MAPPING_ELEMENT), mapping);
            JSONObject viewModeStore = new JSONObject();
            JSONObject groupProviderStore = new JSONObject();
            groupProviderStore.put((Object)"folders", (Object)folders);
            groupProviderStore.put((Object)MAPPING_ELEMENT, (Object)mapping);
            JSONObject sortModeStore = new JSONObject();
            sortModeStore.put((Object)"sortIndices", (Object)sortOrder);
            JSONObject storeRoot = new JSONObject();
            storeRoot.put((Object)"viewMode", (Object)viewModeStore);
            storeRoot.put((Object)"groupProvider", (Object)groupProviderStore);
            storeRoot.put((Object)"sortMode", (Object)sortModeStore);
            XMLMemento result = XMLMemento.createWriteRoot((String)IStore.ROOT);
            IMemento planModeData = result.createChild(IStore.TYPE, LegacyHelper.TEAMFOLDER_PLANMODE_ID);
            planModeData.putTextData(String.format("(%s)", storeRoot.toString()));
            return result;
        }

        private static class SortIndexCounter {
            int fIndex = 0;

            private SortIndexCounter() {
            }

            public int getSortIndex() {
                return this.fIndex++;
            }
        }
    }

    public static class Store
    implements IStore {
        private XMLMemento fRoot;

        private Store(XMLMemento root) {
            this.fRoot = root;
        }

        public XMLMemento getRoot() {
            return this.fRoot;
        }

        public XMLMemento getStore() {
            return this.fRoot;
        }

        public IMemento[] getAllStores() {
            return this.fRoot.getChildren(IStore.TYPE);
        }

        public IMemento getStore(String identifier) {
            return this.getStore(identifier, false);
        }

        public IMemento getStore(String identifier, boolean empty) {
            XMLMemento store = this.getSubStore(this.fRoot, identifier);
            if (empty) {
                IMemento[] children;
                IMemento[] iMementoArray = children = store.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    store.removeChildren(child.getType());
                    ++n2;
                }
            }
            return store;
        }

        private XMLMemento getSubStore(XMLMemento memento, String identifier) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren(IStore.TYPE);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                if (child.getID().equals(identifier)) {
                    return (XMLMemento)child;
                }
                ++n2;
            }
            return (XMLMemento)memento.createChild(IStore.TYPE, identifier);
        }

        public String toString() {
            try {
                return this.fRoot.asXMLString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

