/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTUcmView
extends CTView {
    private Map<String, CCaseObjInfo> _compObjInfoCache = new HashMap<String, CCaseObjInfo>();

    CTUcmView(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            String defaultCompVobTag = String.valueOf(this.getPathname(feedback)) + this.provider().getDefaultCompVobTag(feedback);
            String path = CommonUtils.canonicalizePathname(defaultCompVobTag);
            CTLocation crfLocation = CTLocation.createJoinedLocation(CTLocation.Kind.CONTROLLABLE_RESOURCE, path, this.location());
            return new CTControllableFolder((Location)crfLocation, this.provider());
        }
        if (propertyName.equals((Object)Workspace.ACTIVITY_FOLDER_LIST)) {
            return this.getActivityFolderLocation(feedback);
        }
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            return this.getBaselineControlledFolderList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            return this.getControllableResourceHome(feedback);
        }
        if (propertyName.equals((Object)Workspace.STREAM)) {
            return this.getStream(feedback);
        }
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            return this.lookupCurrentActivity(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private CTControllableFolder getControllableResourceHome(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        List<String> componentNames = cc.getRootedComponents(this.getStreamSelector(feedback), feedback);
        if (componentNames.size() == 0) {
            return null;
        }
        CTControllableFolder bcf = this.createBcfFromComponent(componentNames.get(0), feedback);
        return bcf;
    }

    private CCaseObjInfo getComponentObjInfo(String cName, SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo compObjInfo;
        boolean foundInCache = this._compObjInfoCache.containsKey(cName);
        if (!foundInCache) {
            compObjInfo = CCaseObjInfo.getObjInfo(this.provider().getCCaseLib(), cName, feedback);
            this._compObjInfoCache.put(cName, compObjInfo);
        } else {
            compObjInfo = this._compObjInfoCache.get(cName);
        }
        return compObjInfo;
    }

    private CTControllableFolder createBcfFromComponent(String cName, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        CCaseObjInfo compObjInfo = this.getComponentObjInfo(cName, feedback);
        String compUsel = compObjInfo.getUniversalSelector();
        String rootDir = cc.getComponentRootDirPathname(compUsel, this.getViewTag(), feedback);
        CTLocation bcfLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, rootDir);
        return new CTControllableFolder((Location)bcfLoc, p);
    }

    private Object getActivityFolderLocation(SrvcFeedback feedback) {
        CTProvider p = this.provider();
        Folder activityFolder = p.folder((Location)this.location());
        ResourceList result = p.resourceList((Resource[])new Folder[0]);
        result.add((Object)activityFolder);
        return result;
    }

    private Object getBaselineControlledFolderList(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        String streamSelector = this.getStreamSelector(feedback);
        List<String> componentNames = cc.getRootedComponents(streamSelector, feedback);
        ArrayList<CTControllableFolder> result = new ArrayList<CTControllableFolder>();
        for (String cName : componentNames) {
            CTControllableFolder bcf = this.createBcfFromComponent(cName, feedback);
            result.add(bcf);
        }
        return result;
    }

    @Override
    public synchronized String getStreamSelector(SrvcFeedback feedback) throws WvcmException {
        return this.provider().getCCaseLib().getStreamUniversalSelector(this.getViewTag(), feedback);
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            String actName = value == null ? "-none" : ((CTActivity)((Object)value)).getActivityName();
            CCaseLib cc = this.provider().getCCaseLib();
            String oldActivitySelector = cc.getCurrentActivity(this.getViewTag(), feedback);
            cc.setActivity(this.getViewTag(), actName, feedback);
            String newActivitySelector = null;
            if (!actName.equals("-none")) {
                newActivitySelector = cc.getCurrentActivity(this.getViewTag(), feedback);
            }
            if (oldActivitySelector != null && !oldActivitySelector.equals(newActivitySelector) && cc.isActivityOnCQEnabledProject(oldActivitySelector, feedback)) {
                cc.performCQActionOnUCMRecord(oldActivitySelector, feedback);
            }
        } else {
            super.setPropertyFromClient(propertyName, value, initialize, feedback);
        }
    }

    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        List<String> componentNames = cc.getRootedComponents(this.getStreamSelector(feedback), feedback);
        String viewTag = this.getViewTag();
        List<String> componentRoots = cc.getComponentRootDirPathnames(componentNames, viewTag, feedback);
        this.checkinAllHelper(comment, flags, componentRoots, viewTag, feedback);
    }

    public static CTUcmView doCreateGeneratedResource(CTProvider provider, Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTLocation loc = (CTLocation)location;
        String cleanName = CCaseLib.cleanName(loc.getDisplayName());
        PropValue streamValue = updates != null ? updates.get(Workspace.TARGET) : null;
        boolean isolatedTarget = false;
        if (streamValue == null) {
            PropValue propValue = streamValue = updates != null ? updates.get(Workspace.ISOLATED_TARGET) : null;
            if (streamValue != null) {
                isolatedTarget = true;
            }
        }
        CTLocation streamLoc = streamValue != null ? (CTLocation)((Object)streamValue.get_value()) : null;
        String streamLocString = streamLoc != null ? streamLoc.getDisplayName() : null;
        CCaseLib cc = provider.getCCaseLib();
        if (isolatedTarget && streamLocString != null) {
            List<String> components = cc.getRootedComponents(streamLocString, feedback);
            ArrayList<String> foundBls = null;
            if (components.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(NLS.bind((String)Messages.CTProvider_ERROR_NOTHING_IN_FOUNDATION, (Object)streamLocString));
                buffer.append(Messages.CTProvider_ERROR_UNABLE_TO_IMPORT_HISTORY);
                throw new WvcmException(buffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
            }
            foundBls = new ArrayList<String>(components.size());
            for (String component : components) {
                List<String> allBaselines = cc.getAllBaselines(streamLocString, component, feedback);
                String baseline = null;
                baseline = !allBaselines.isEmpty() ? allBaselines.get(0) : cc.getBaselineInFoundation(null, streamLocString, component, feedback);
                if (baseline == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(NLS.bind((String)Messages.CTProvider_ERROR_NO_BASELINE_FOR_STREAM_COMPONENT, (Object)component, (Object)streamLocString));
                    buffer.append(Messages.CTProvider_ERROR_UNABLE_TO_IMPORT_HISTORY);
                    throw new WvcmException(buffer.toString(), WvcmException.ReasonCode.NOT_FOUND);
                }
                foundBls.add(baseline);
            }
            String roStreamName = String.valueOf(ObjSelUtils.getObjSelName(streamLocString)) + "_READ_ONLY";
            try {
                streamLocString = cc.makeStream(streamLocString, false, true, foundBls, roStreamName, feedback);
            }
            catch (WvcmException e) {
                String parentProjectSel = cc.getProjectObjectSelector(streamLocString, feedback);
                if (cc.isSingleStreamProject(parentProjectSel, feedback)) {
                    String vobSelector = ObjSelUtils.getObjSelVobSel(streamLocString);
                    String projectName = "DO_NOT_USE_" + ObjSelUtils.getObjSelName(streamLocString) + "_PROJECT";
                    String projectSel = ObjSelUtils.formatSelector("project", projectName, vobSelector);
                    projectSel = cc.makeProject(projectSel, null, feedback);
                    String intStreamName = "DO_NOT_USE_" + ObjSelUtils.getObjSelName(streamLocString) + "_STREAM";
                    String intStreamSel = cc.makeStream(projectSel, true, foundBls, intStreamName, feedback);
                    streamLocString = cc.makeStream(intStreamSel, false, true, foundBls, roStreamName, feedback);
                }
                throw e;
            }
        }
        String viewTag = cc.makeView(cleanName, streamLocString, feedback);
        CTLocation resultLoc = CTLocation.valueOf(CTLocation.Kind.WORKSPACE, viewTag);
        CTUcmView result = new CTUcmView((Location)resultLoc, provider);
        return result;
    }

    public <T extends SrvcResource> void doMerge(List<T> sourceLocations, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        for (SrvcResource o : sourceLocations) {
            if (o instanceof CTStream) {
                String wsStreamSel;
                CTStream source = (CTStream)o;
                String streamSel = source.location().getDisplayName();
                if (cc.equalObjSels(streamSel, wsStreamSel = this.getStreamSelector(feedback), feedback)) {
                    cc.syncToStreamConfiguration(this.getViewTag(), feedback);
                } else {
                    String wsStreamParentStreamSel = cc.getParentStream(wsStreamSel, feedback);
                    if (!cc.equalObjSels(wsStreamParentStreamSel, streamSel, feedback)) {
                        cc.deliverStream(streamSel, this.getViewTag(), flags, feedback);
                    }
                }
                this.flush(feedback);
                continue;
            }
            throw new IllegalArgumentException("doMerge() source is not a stream");
        }
    }

    private CTStream getStream(SrvcFeedback feedback) throws WvcmException {
        String streamSelector;
        CTLocation streamLoc;
        CTProvider p = this.provider();
        CTStream result = (CTStream)p.lookup((Location)(streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamSelector = this.getStreamSelector(feedback))), feedback);
        if (result == null) {
            result = new CTStream((Location)streamLoc, p);
        }
        return result;
    }

    @Override
    public CTActivity lookupCurrentActivity(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        String activitySelector = p.getCCaseLib().getCurrentActivity(this.getViewTag(), feedback);
        if (activitySelector == null) {
            return null;
        }
        CTLocation activityLoc = CTLocation.valueOf(CTLocation.Kind.ACTIVITY, activitySelector);
        CTActivity result = (CTActivity)p.lookup((Location)activityLoc, feedback);
        if (result == null) {
            result = new CTActivity((Location)activityLoc, p);
        }
        return result;
    }

    @Override
    public void prepareToWrite(String pathname, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String viewTag = this.getViewTag();
        cc.checkoutIgnoreExpectedFailures(viewTag, pathname, this.getStreamSelector(feedback), feedback);
    }

    public String getComponentPathname(CTLocation componentLocation, SrvcFeedback feedback) throws WvcmException {
        CCaseObjInfo compInfo;
        CCaseLib cc = this.provider().getCCaseLib();
        String compSelector = componentLocation.getDisplayName();
        String result = cc.getComponentPathnameFromAnyKindOfName(this.getViewTag(), compSelector, feedback);
        if ((result == null || result.length() == 0) && (compInfo = CCaseObjInfo.getObjInfo(cc, compSelector, feedback)).getMtype().equals("versioned object base")) {
            String extendedName = cc.getExtendedName(this.getViewTag(), compSelector, feedback);
            throw new WvcmException(NLS.bind((String)Messages.CTUcmView_ERROR_INVALID_UCM_COMPONENT, (Object)extendedName), WvcmException.ReasonCode.NOT_FOUND);
        }
        return result;
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        if (sourceList != null && !sourceList.isEmpty()) {
            ArrayList<String> rebaseBaselines = new ArrayList<String>();
            for (T source : sourceList) {
                if (!(source instanceof CTBaseline)) continue;
                CTBaseline baseline = (CTBaseline)((Object)source);
                rebaseBaselines.add(baseline.location().getDisplayName());
            }
            if (!rebaseBaselines.isEmpty()) {
                String rebaseBls = CommonUtils.getCommaSeparatedFromList(rebaseBaselines);
                cc.rebaseStream(this.getViewTag(), this.getStreamSelector(feedback), rebaseBls, feedback);
            }
        }
    }
}

