/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CQTask;
import com.ibm.rational.wvcm.ct.CTActivity;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTBranch;
import com.ibm.rational.wvcm.ct.CTBranchBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTFolderVersion;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTSymbolicLink;
import com.ibm.rational.wvcm.ct.CTSymbolicLinkVersion;
import com.ibm.rational.wvcm.ct.CTTask;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommandProvider;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTProvider
extends SrvcProvider {
    public static final String EMPTY_STRING = new String();
    public static final String TRUE = Boolean.toString(true);
    public static final String FALSE = Boolean.toString(false);
    public static final String DEFAULT_COMPONENT_VOB = EMPTY_STRING;
    public static final PropertyNameList.PropertyName<String> FULLY_QUALIFIED_DISPLAY_NAME = new PropertyNameList.PropertyName("com.ibm.rational.wvcm", "fully-qualified-display-name");
    public static final PropertyNameList.PropertyName<String> STREAM_TREE_NODE_NAME = new PropertyNameList.PropertyName("com.ibm.rational.wvcm", "stream-tree-node-name");
    public static final String BASECC_CHAR = String.valueOf('|');
    private static final String UNRECOGNIZED_OPTION = "Unrecognized option";
    private static final String INIT_COMPLETE = "CTProvider initialization complete";
    private static final String DEFAULT_CQ_DBSET_NAME = "sample_schema_repo";
    private static final String DEFAULT_CQ_USERDB_NAME = "SAMPL";
    private static final String DEFAULT_CQ_LOGIN_NAME = "admin";
    private static final int DEFAULT_FEEDBACK_CMD_MIN_DURATION_MILLISECONDS = 60000;
    public static final String DEFAULT_IGNORE_TASK_CREATION_FAILURE = FALSE;
    Log _log = null;
    private CCaseLib _cc;
    static boolean IS_CACHING_ENABLED = true;
    private Map<String, CTResource> persistentObjectCache = null;

    public CTProvider() {
        super(null);
    }

    public void initialize(Map<String, String> argsArg, ProviderFactory.Callback callback) throws WvcmException {
        String streamPath;
        String pvobTag;
        CTFeedback feedback;
        int feedbackDelayMilliseconds;
        CommandProvider p;
        CommandResult r;
        String viewStgPath;
        HashMap<String, String> args = argsArg == null ? new HashMap<String, String>() : argsArg;
        super.initialize(args, callback);
        this._initArgs.put("com.ibm.rational.wvcm.DISPLAYNAME", "ClearCase");
        if (CTInitArgUtils.getCompVobTag(args) == null) {
            CTInitArgUtils.setCompVobTag(args, DEFAULT_COMPONENT_VOB);
        }
        CTLocation viewLoc = null;
        if (this._initArgs.containsKey(InteropStream.IA_WORKSPACE_PATH)) {
            String viewLocString = (String)this._initArgs.get(InteropStream.IA_WORKSPACE_PATH);
            viewLoc = this.location(viewLocString);
            String viewTag = viewLoc.getViewTag();
            CTInitArgUtils.setViewTag(this._initArgs, viewTag);
        }
        if (CTInitArgUtils.getCQDbsetName(args) == null) {
            CTInitArgUtils.setCQDbsetName(args, DEFAULT_CQ_DBSET_NAME);
        }
        if (CTInitArgUtils.getCQUserdbName(args) == null) {
            CTInitArgUtils.setCQUserdbName(args, DEFAULT_CQ_USERDB_NAME);
        }
        if (CTInitArgUtils.getCQLoginName(args) == null) {
            CTInitArgUtils.setCQLoginName(args, DEFAULT_CQ_LOGIN_NAME);
        }
        if (CTInitArgUtils.getCQUCMRecordAction(args) == null) {
            CTInitArgUtils.setCQUCMRecordAction(args, "");
        }
        CTInitArgUtils.setImportOnly(args, CTInitArgUtils.importOnly(args));
        String locale = Locale.getDefault().toString();
        String storedLocale = CTInitArgUtils.getLocale(args);
        if (storedLocale == null) {
            CTInitArgUtils.setLocale(args, locale);
        } else if (!locale.equals(storedLocale)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_WARN_LOCALE_MISMATCH, (Object)locale, (Object)storedLocale));
        }
        String charset = Charset.defaultCharset().name();
        String storedCharset = (String)args.get(InteropStream.IA_CHARACTER_SET);
        if (storedCharset == null) {
            args.put(InteropStream.IA_CHARACTER_SET, charset);
        } else if (!charset.equals(storedCharset)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_WARN_CHARSET_MISMATCH, (Object)charset, (Object)storedCharset));
        }
        if (args.get(InteropStream.IA_LINE_SEPARATOR) == null) {
            args.put(InteropStream.IA_LINE_SEPARATOR, InteropStream.LineSeparator.LF.name());
        }
        if (args.get(InteropStream.IA_WORKSPACE_LINE_SEPARATOR) == null) {
            args.put(InteropStream.IA_WORKSPACE_LINE_SEPARATOR, InteropStream.LineSeparator.PLATFORM.name());
        }
        if ((viewStgPath = CTInitArgUtils.getStgLoc(this._initArgs)) != null && !ObjSelUtils.isViewStgValid(viewStgPath)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_STORAGE_ERROR, (Object)viewStgPath));
        }
        if (viewStgPath == null) {
            viewStgPath = new String();
        }
        CTInitArgUtils.setDumpEnv(args, CTInitArgUtils.getDumpEnv(args));
        if (CTInitArgUtils.getCheckinComment(args) == null) {
            CTInitArgUtils.setCheckinComment(args, "");
        }
        CTInitArgUtils.setUseTripleSet(args, CTInitArgUtils.useTripleSet(args));
        if (CTInitArgUtils.getHost(args) == null) {
            CTInitArgUtils.setHost(args, CTProvider.getLocalHostname());
        }
        if (CTInitArgUtils.getHpath(args) == null) {
            CTInitArgUtils.setHpath(args, viewStgPath);
        }
        if (CTInitArgUtils.getGpath(args) == null) {
            CTInitArgUtils.setGpath(args, viewStgPath);
        }
        if (!args.containsKey("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION")) {
            args.put("com.ibm.rational.wvcm.LOG_MINIMUM_DURATION", String.valueOf(300000));
        }
        if (!args.containsKey(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE)) {
            args.put(InteropStream.IA_IGNORE_TASK_CREATION_FAILURE, DEFAULT_IGNORE_TASK_CREATION_FAILURE);
        }
        if (CTInitArgUtils.getFeedbackCmdMinDurationValue(args) == null) {
            CTInitArgUtils.setFeedbackCmdMinDurationValue(args, 60000);
        }
        if ((r = (p = new CommandProvider(feedbackDelayMilliseconds = Integer.valueOf(CTInitArgUtils.getFeedbackCmdMinDurationValue(args)).intValue(), this._initArgs)).executeGetResult((SrvcFeedback)(feedback = new CTFeedback(null)), "pwv", "-mvfsroot")).getStat() == 1 && r.getStdErr().contains(UNRECOGNIZED_OPTION)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_CC_VER_ERROR, WvcmException.ReasonCode.FORBIDDEN);
        }
        this._cc = new CCaseLib(p, this._initArgs, this.isCachingEnabled());
        String viewTag = CTInitArgUtils.getViewTag(this._initArgs);
        if (viewTag != null && !this._cc.isViewValid(viewTag, feedback)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_VIEW_ERROR, (Object)viewTag));
        }
        if (!((pvobTag = CTInitArgUtils.getPvobTag(this._initArgs)) != null && pvobTag.length() != 0 || viewLoc == null || viewLoc.getKind().equals((Object)CTLocation.Kind.BASE_CC_VIEW) || (streamPath = (String)this._initArgs.get(InteropStream.IA_OTHER_STREAM_LOCATION)) == null || streamPath.length() == 0)) {
            CTLocation streamLoc = this.location(streamPath);
            pvobTag = ObjSelUtils.getObjSelVobSel(streamLoc.getDisplayName());
            CTInitArgUtils.setPvobTag(this._initArgs, pvobTag);
        }
        if (pvobTag != null && !this._cc.isVobValid(pvobTag, feedback)) {
            CTProvider.printWarning(NLS.bind((String)Messages.CTProvider_INVALID_PVOB_ERROR, (Object)pvobTag));
        }
        this.logDebug(INIT_COMPLETE);
    }

    public static String getLocalHostname() throws WvcmException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new WvcmException(Messages.CTProvider_COULD_NOT_GET_LOCAL_HOSTNAME, null, WvcmException.ReasonCode.FORBIDDEN, (Throwable)e);
        }
    }

    public static void printWarning(String message) {
        System.err.println(message);
    }

    private synchronized Log getLog() {
        if (this._log == null) {
            this._log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
        }
        return this._log;
    }

    public CTFeedback srvcFeedback(Feedback feedback) {
        return new CTFeedback(feedback);
    }

    public void logCreation(String objectName, CTLocation objectLocation) {
        this.logDebug("create `" + objectName + "' with location: " + objectLocation.string());
    }

    public void logInfo(String msg) {
        this.getLog().info((Object)msg);
    }

    public void logDebug(String msg) {
        this.getLog().debug((Object)msg);
    }

    public CCaseLib getCCaseLib() {
        return this._cc;
    }

    public void setCCaseLib(CCaseLib cc) {
        this._cc = cc;
    }

    public CTLocation location(String string) throws WvcmException {
        return CTLocation.valueOf(string);
    }

    public CTResource lookup(Location genericLocation, SrvcFeedback feedback) throws WvcmException {
        if (genericLocation == null) {
            return null;
        }
        CTLocation loc = (CTLocation)genericLocation;
        CTLocation.Kind locKind = loc.getKind();
        CTResource result = null;
        if (this.isCachingEnabled()) {
            if (feedback != null && (result = ((CTFeedback)feedback).lookupCTResourceCache((Location)loc)) != null) {
                this.logDebug("Cache hit on kind: " + (Object)((Object)locKind));
                return result;
            }
            result = this.lookupLocationInPersistentProxyCache(loc);
            if (result != null) {
                if (feedback != null) {
                    ((CTFeedback)feedback).setCTResourceCache((Location)loc, result);
                }
                return result;
            }
        }
        CCaseObjInfo info = null;
        String locationPathname = loc.getDisplayName();
        try {
            if (locKind != null) {
                switch (locKind) {
                    case WORKSPACE: {
                        result = new CTUcmView((Location)loc, this);
                        break;
                    }
                    case CONFIGURATION: {
                        result = new CTWvcmConfiguration((Location)loc, this);
                        break;
                    }
                    case FOLDER: {
                        result = new CTFolder((Location)loc, this);
                        break;
                    }
                    case BRANCH: {
                        result = new CTBranch((Location)loc, this);
                        break;
                    }
                    case BASE_CC_VIEW: {
                        result = new CTBaseCCView((Location)loc, this);
                        break;
                    }
                    case BASE_CC_BASELINE: {
                        result = new CTBranchBaseline((Location)loc, this);
                    }
                }
                if (result != null) {
                    ((CTFeedback)feedback).setCTResourceCache((Location)loc, result);
                    return result;
                }
            }
            info = CCaseObjInfo.lookupObjInfo(this._cc, locationPathname, feedback);
        }
        catch (WvcmException e) {
            if (!WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                throw e;
            }
            this.getCCaseLib().logIgnoredExceptionAsNotAlwaysVisible("CTProvider.lookup", Messages.CCaseLib_IGNORED_EXCEPTION_LOCATION_LOOKUP, (Exception)((Object)e));
            return null;
        }
        return this.createAndCacheCTResource(loc, info, feedback);
    }

    public CTResource createAndCacheCTResource(CTLocation loc, CCaseObjInfo info, SrvcFeedback feedback) {
        if (info == null) {
            return null;
        }
        CTResource result = this.createProxyForLocation(loc, info.getMtype());
        if (result == null) {
            return null;
        }
        result.setObjInfo(info);
        if (feedback != null) {
            ((CTFeedback)feedback).setCTResourceCache((Location)loc, result);
        }
        this.persistProxyIfImmutable(result, feedback);
        return result;
    }

    private CTResource createProxyForLocation(CTLocation loc, String mtype) {
        CTResource result = null;
        if (mtype.equals("activity")) {
            result = loc.hasKind(CTLocation.Kind.TASK) ? new CTTask((Location)loc, this) : (loc.hasKind(CTLocation.Kind.CQTASK) ? new CQTask((Location)loc, this) : new CTActivity((Location)loc, this));
        } else if (mtype.equals("baseline")) {
            result = new CTBaseline((Location)loc, this);
        } else if (mtype.equals("component")) {
            result = new CTComponent((Location)loc, this);
        } else if (mtype.equals("directory version")) {
            result = this.isVersionSelector(loc) ? new CTFolderVersion((Location)loc, this) : new CTControllableFolder((Location)loc, this);
        } else if (loc.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE)) {
            String pathName;
            File folder;
            result = mtype.equals("directory element") ? new CTControllableFolder((Location)loc, this) : (mtype.equals("symbolic link") ? new CTSymbolicLink((Location)loc, this) : (mtype.equals("**null meta type**") ? ((folder = new File(pathName = (pathName = loc.getDisplayName()).startsWith("vob:") ? pathName.substring("vob:".length()) : pathName)).isDirectory() ? new CTControllableFolder((Location)loc, this) : new CTControllableResource((Location)loc, this)) : new CTControllableResource((Location)loc, this)));
        } else if (mtype.equals("stream")) {
            result = new CTStream((Location)loc, this);
        } else if (mtype.equals("version") || mtype.equals("derived object version")) {
            result = this.isVersionSelector(loc) ? new CTVersion((Location)loc, this) : new CTControllableResource((Location)loc, this);
        } else if (mtype.endsWith("element")) {
            result = new CTElement((Location)loc, this);
        } else if (mtype.equals("symbolic link")) {
            result = loc.hasKind(CTLocation.Kind.SYMBOLIC_LINK_VERSION) ? new CTSymbolicLinkVersion((Location)loc, this) : new CTElement((Location)loc, this);
        }
        if (mtype.equals("versioned object base")) {
            result = new CTView((Location)loc, this);
        }
        return result;
    }

    private boolean isVersionSelector(CTLocation loc) {
        return ObjSelUtils.isUniversalSelector(loc.getDisplayName()) || !loc.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE) && loc.getDisplayName().contains("@@");
    }

    public CTLocation rootLocation() {
        return CTLocation._rootLoc;
    }

    public CTLocation relativeRootLocation() {
        return CTLocation._relativeRootLoc;
    }

    public SrvcResource doWriteContent(Location location, InputStream content, String contentIdentifier, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTResource srvcResource = this.lookup(location, feedback);
        if (srvcResource == null) {
            srvcResource = this.doCreateControllableResource(location, updates, updated, feedback.nest(50));
            updates.clear();
        }
        ((CTControllableResource)srvcResource).doWriteContent(content, contentIdentifier, updates, updated, feedback);
        return srvcResource;
    }

    public SrvcResource doCreateGeneratedActivity(Location locationHint, boolean isStream, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        if (isStream) {
            return CTStream.doCreateGeneratedResource(this, (CTLocation)locationHint, updates, updated, feedback);
        }
        return CTActivity.doCreateGeneratedActivity(false, this, (CTLocation)locationHint, updates, updated, feedback);
    }

    public SrvcResource doCreateGeneratedTask(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        return CTTask.doCreateGeneratedActivity(true, this, (CTLocation)location, updates, updated, feedback);
    }

    public SrvcResource doCreateControllableFolder(Location location, SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder result = CTControllableFolder.doCreate(this, location, feedback);
        return result;
    }

    public SrvcResource doCreateControllableSymbolicLink(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTSymbolicLink result = CTSymbolicLink.doCreateSymbolicLink(this, location, updates, updated, feedback);
        return result;
    }

    public CTControllableResource doCreateControllableResource(Location location, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableResource.doCreate(this, location, feedback);
        return result;
    }

    public SrvcResource doFind(Resource query, SrvcFeedback feedback) throws WvcmException {
        if (query instanceof Component) {
            return this.doFindUCMComponent((Component)query, feedback);
        }
        if (query instanceof Version) {
            return this.doFindVersionInWorkspace((Version)query, feedback);
        }
        if (query instanceof Stream) {
            List<SrvcResource> streams = this.doFindStreams((Stream)query, false, feedback);
            if (streams.isEmpty()) {
                return null;
            }
            return streams.get(0);
        }
        if (query instanceof Configuration) {
            return this.doFindConfigurationInView((Configuration)query, feedback);
        }
        if (query instanceof ControllableResource) {
            return this.doFindCRInView((ControllableResource)query, feedback);
        }
        List<SrvcResource> resources = this.doFindResources(query, false, feedback);
        if (resources.isEmpty()) {
            return null;
        }
        return resources.get(0);
    }

    public List<SrvcResource> doFindAll(Resource query, SrvcFeedback feedback) throws WvcmException {
        if (query instanceof Component) {
            return this.singletonListNonNull(this.doFindUCMComponent((Component)query, feedback));
        }
        if (query instanceof Baseline) {
            return this.doFindBaselines((Baseline)query, feedback);
        }
        if (query instanceof Version) {
            return this.singletonListNonNull(this.doFindVersionInWorkspace((Version)query, feedback));
        }
        if (query instanceof Stream) {
            return this.doFindStreams((Stream)query, true, feedback);
        }
        if (query instanceof Configuration) {
            return this.singletonListNonNull(this.doFindConfigurationInView((Configuration)query, feedback));
        }
        if (query instanceof ControllableResource) {
            return this.singletonListNonNull(this.doFindCRInView((ControllableResource)query, feedback));
        }
        return this.doFindResources(query, true, feedback);
    }

    private List<SrvcResource> singletonListNonNull(SrvcResource object) {
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>();
        if (object != null) {
            results.add(object);
        }
        return results;
    }

    private CTVersion doFindVersionInWorkspace(Version query, SrvcFeedback feedback) throws WvcmException {
        ResourceList queryWorkspaceList = query.getInWorkspaceList();
        Workspace workspaceQuery = (Workspace)queryWorkspaceList.get(0);
        CTLocation viewLoc = (CTLocation)workspaceQuery.getPathnameLocation();
        CTView view = new CTView((Location)viewLoc, this);
        VersionHistory vh = query.getVersionHistory();
        Location elemLoc = vh.getPathnameLocation();
        CTElement element = (CTElement)this.lookup(elemLoc, feedback);
        CTVersion result = null;
        if (element != null) {
            CTLocation myCRLoc = element.lookupMyControllableResourceLoc(view, feedback);
            CTControllableResource myCR = (CTControllableResource)this.lookup((Location)myCRLoc, feedback);
            CTLocation verLoc = null;
            if (myCR != null) {
                CTVersion version = (CTVersion)myCR.lookupCurrentVersion(feedback);
                if (version != null) {
                    verLoc = version.location();
                    CTVersion ctResult = (CTVersion)this.createAndCacheCTResource(verLoc, myCR.getObjInfo(feedback), feedback);
                    ctResult.setElemUSel(element.getUniversalSelector(feedback));
                }
            } else if (element.getObjInfo(feedback).getMtype().equals("symbolic link")) {
                verLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, element.location().getDisplayName());
            }
            if (verLoc != null) {
                result = (CTVersion)this.lookup((Location)verLoc, feedback);
            }
        }
        return result;
    }

    private List<SrvcResource> doFindResources(Resource query, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        Object streamTreeNodeNameVal = query.lookupProperty(STREAM_TREE_NODE_NAME);
        if (!(streamTreeNodeNameVal instanceof String)) {
            throw new IllegalArgumentException(STREAM_TREE_NODE_NAME + " specified in query is not a string");
        }
        String streamTreeNodeName = (String)streamTreeNodeNameVal;
        if (streamTreeNodeName.length() == 0) {
            List<String> pvobNames = this._cc.getPvobSelectors(all, feedback);
            for (String pvobName : pvobNames) {
                CTLocation folderLoc = CTLocation.valueOf(CTLocation.Kind.FOLDER, pvobName);
                CTFolder fldr = (CTFolder)this.lookup((Location)folderLoc, feedback);
                result.add(fldr);
            }
        } else {
            CTLocation folderLoc = CTLocation.valueOf(CTLocation.Kind.FOLDER, streamTreeNodeName);
            CTFolder fldr = (CTFolder)this.lookup((Location)folderLoc, feedback);
            result.add(fldr);
        }
        return result;
    }

    private List<SrvcResource> doFindStreams(Stream query, boolean all, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        String querySel = null;
        try {
            querySel = query.getDisplayName();
        }
        catch (WvcmException wvcmException) {}
        if (querySel != null) {
            if (querySel.contains(BASECC_CHAR)) {
                return this.doFindBaseCCStream(querySel, result, feedback);
            }
            String[] streamTokens = this._cc.queryStream(querySel, feedback);
            if (streamTokens == null) {
                return result;
            }
            if (streamTokens.length == 2 && streamTokens[1].equals("read only")) {
                throw new WvcmException(Messages.CTProvider_ERROR_READ_ONLY_STREAMS_NOT_ALLOWED, WvcmException.ReasonCode.FORBIDDEN);
            }
            CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamTokens[0]);
            CTStream stream = (CTStream)this.lookup((Location)streamLoc, feedback);
            result.add(stream);
            return result;
        }
        String pVobTag = this.getDefaultPvobTag();
        String streamFilter = this.getDefaultStreamFilter();
        if (pVobTag == null || streamFilter == null) {
            throw new IllegalStateException("A filtered stream query requires a pvob tag and a stream filter is required");
        }
        List<String> streamNames = this._cc.findStreams(pVobTag, streamFilter, all, feedback);
        for (String streamUsel : streamNames) {
            CTLocation streamLoc = CTLocation.valueOf(CTLocation.Kind.STREAM, streamUsel);
            CTStream stream = (CTStream)this.lookup((Location)streamLoc, feedback);
            result.add(stream);
            if (!all) break;
        }
        return result;
    }

    private List<SrvcResource> doFindBaseCCStream(String querySel, List<SrvcResource> result, SrvcFeedback feedback) throws WvcmException {
        int index = querySel.indexOf(BASECC_CHAR);
        String brtype = null;
        String lbtype = null;
        if (index != -1) {
            brtype = querySel.substring(0, index);
            lbtype = querySel.substring(index + 1, querySel.length());
            if (lbtype.equals("")) {
                lbtype = null;
            }
        }
        if (brtype != null) {
            String brtypeSel = null;
            String lbtypeSel = null;
            if (CTInitArgUtils.importOnly(this.initArgs())) {
                if (lbtype != null) {
                    lbtypeSel = this._cc.validateAndLockLabelType(lbtype, true, feedback);
                }
                if (lbtypeSel != null) {
                    String lbVobTag = ObjSelUtils.getObjSelVobSel(lbtypeSel);
                    brtype = ObjSelUtils.formatSelectorNoKind(this._cc.getMainBranchName(lbVobTag, feedback), lbVobTag);
                    brtypeSel = this._cc.validateAndLockBranchType(brtype, false, feedback);
                }
            } else {
                brtypeSel = this._cc.validateAndLockBranchType(brtype, false, feedback);
                if (lbtype != null) {
                    lbtypeSel = this._cc.validateAndLockLabelType(lbtype, true, feedback);
                }
            }
            CTLocation lbtypeLocation = null;
            CTLocation brtypeLocation = null;
            if (brtypeSel == null) {
                if (lbtypeSel == null) {
                    if (CTInitArgUtils.importOnly(this.initArgs())) {
                        throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_LBTYPE_SELECTOR_NOT_FOUND, (Object)lbtype), null, WvcmException.ReasonCode.NOT_FOUND);
                    }
                    if (lbtype == null) {
                        throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_BRTYPE_SELECTOR_NOT_FOUND, (Object)brtype), null, WvcmException.ReasonCode.NOT_FOUND);
                    }
                    throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_LBTYPE_AND_BRTYPE_SELECTORS_NOT_FOUND, (Object)lbtype, (Object)brtype), null, WvcmException.ReasonCode.NOT_FOUND);
                }
                lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, lbtypeSel);
                CTLocation branchLocation = CTLocation.createBranchLocation(null, lbtypeLocation);
                throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_BRTYPE_SELECTOR_NOT_FOUND, (Object)brtype), WvcmException.ReasonCode.NOT_FOUND);
            }
            brtypeLocation = CTLocation.valueOf(CTLocation.Kind.BRTYPE, brtypeSel);
            if (lbtypeSel == null) {
                if (CTInitArgUtils.importOnly(this.initArgs()) || lbtype != null) {
                    brtypeLocation = CTLocation.valueOf(CTLocation.Kind.BRTYPE, brtypeSel);
                    CTLocation branchLocation = CTLocation.createBranchLocation(brtypeLocation, null);
                    throw new WvcmException(NLS.bind((String)Messages.CTProvider_ERROR_LBTYPE_SELECTOR_NOT_FOUND, (Object)lbtype), WvcmException.ReasonCode.NOT_FOUND);
                }
            } else {
                lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, lbtypeSel);
            }
            CTLocation branchLocation = CTLocation.createBranchLocation(brtypeLocation, lbtypeLocation);
            CTBranch branch = (CTBranch)this.lookup((Location)branchLocation, feedback);
            result.add(branch);
            return result;
        }
        throw new WvcmException(Messages.CTProvider_INVALID_BASECC_STREAM_FMT_ERROR, WvcmException.ReasonCode.FORBIDDEN);
    }

    private CTWvcmConfiguration doFindConfigurationInView(Configuration query, SrvcFeedback feedback) throws WvcmException {
        if (!query.location().equals((Object)CTLocation._rootLoc)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        Workspace queryWs = query.getWorkspace();
        CTLocation viewLoc = (CTLocation)queryWs.getPathnameLocation();
        VersionHistory queryComp = query.getVersionHistory();
        CTLocation compLoc = (CTLocation)queryComp.getPathnameLocation();
        CTLocation configLoc = null;
        if (viewLoc.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, compLoc.getDisplayName());
            configLoc = CTLocation.createBaseConfigurationLoc(viewLoc, compLoc);
        } else {
            compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compLoc.getDisplayName());
            configLoc = CTLocation.createConfigurationLoc(viewLoc, compLoc);
        }
        CTWvcmConfiguration result = null;
        if (configLoc != null) {
            result = (CTWvcmConfiguration)this.lookup((Location)configLoc, feedback);
        }
        return result;
    }

    private CTComponent doFindUCMComponent(Component query, SrvcFeedback feedback) throws WvcmException {
        Object compNameVal = query.lookupProperty(Component.DISPLAY_NAME);
        if (!(compNameVal instanceof String)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        String pVobTag = this.getDefaultPvobTag();
        if (pVobTag == null) {
            return null;
        }
        String compName = (String)compNameVal;
        String compSel = ObjSelUtils.formatSelector("component", compName, pVobTag);
        CCaseObjInfo info = CCaseObjInfo.lookupObjInfo(this._cc, compSel, feedback);
        if (info == null) {
            return null;
        }
        CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, info.getUniversalSelector());
        CTComponent result = (CTComponent)this.lookup((Location)compLoc, feedback);
        return result;
    }

    public SrvcResource doCreateVersionControlledResource(Location location, Location versionLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTControllableResource result = CTControllableResource.doCreateVersionControlledResource(this, (CTLocation)location, (CTLocation)versionLoc, updates, updated, feedback);
        return result;
    }

    public SrvcResource doCreateGeneratedWorkspace(Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        PropValue streamValue;
        PropValue propValue = streamValue = updates != null ? updates.get(Workspace.TARGET) : null;
        if (streamValue == null) {
            streamValue = updates != null ? updates.get(Workspace.ISOLATED_TARGET) : null;
        }
        CTLocation streamLoc = streamValue != null ? (CTLocation)((Object)streamValue.get_value()) : null;
        CTView result = null;
        result = streamLoc != null && streamLoc.hasKind(CTLocation.Kind.BRANCH) ? CTBaseCCView.doCreateGeneratedResource(this, location, updates, updated, feedback) : CTUcmView.doCreateGeneratedResource(this, location, updates, updated, feedback);
        return result;
    }

    public SrvcResource doBaselineControl(Location location, SrvcFeedback feedback) throws WvcmException {
        CTLocation lastLocation = (CTLocation)location;
        if (lastLocation.hasKind(CTLocation.Kind.CONTROLLABLE_RESOURCE)) {
            CTLocation parentLocation = lastLocation.parent();
            while (parentLocation != null && !parentLocation.equals((Object)CTLocation._rootLoc)) {
                lastLocation = parentLocation;
                parentLocation = parentLocation.parent();
            }
            if (lastLocation.hasKind(CTLocation.Kind.WORKSPACE)) {
                String viewTag = lastLocation.getDisplayName();
                if (this._cc.isBaseCCView(viewTag, feedback)) {
                    throw new WvcmException(Messages.CTProvider_UNSUPPORTED_MKCOMP_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
                }
                return CTControllableFolder.doCreateComponentAndRoot(this, location, feedback);
            }
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.CTProvider_UNSUPPORTED_FOR_LOCATION, (Object)location));
    }

    public String getDefaultPvobTag() {
        String pVobTag = CTInitArgUtils.getPvobTag(this._initArgs);
        return pVobTag;
    }

    public String getDefaultCompVobTag(SrvcFeedback feedback) throws WvcmException {
        String compVobTag = CTInitArgUtils.getCompVobTag(this._initArgs).trim();
        if (compVobTag == null) {
            throw new IllegalStateException("CTProvider's compVob tag initial argument is null");
        }
        if (compVobTag.length() == 0) {
            String msg = feedback.format(Messages.CTProvider_MUST_DEFINE_COMPVOBTAG, new Object[]{"COMPONENT_VOB_TAG"});
            throw new WvcmException(msg, WvcmException.ReasonCode.CONFLICT);
        }
        return compVobTag;
    }

    private String getDefaultStreamFilter() {
        String streamFilter = CTInitArgUtils.getStreamFilter(this._initArgs);
        return streamFilter;
    }

    public String getLineSeparator() {
        return (String)this._initArgs.get(InteropStream.IA_WORKSPACE_LINE_SEPARATOR);
    }

    private boolean isCachingEnabled() {
        return IS_CACHING_ENABLED;
    }

    public List<CTResource> getResources(List<CTLocation> locations, SrvcFeedback feedback) throws WvcmException {
        ArrayList<CTResource> result = new ArrayList<CTResource>();
        for (CTLocation loc : locations) {
            CTResource r = this.lookup((Location)loc, feedback);
            result.add(r);
        }
        return result;
    }

    private synchronized void persistProxyIfImmutable(CTResource resource, SrvcFeedback feedback) {
        try {
            if (this.isCachingEnabled() && resource.isImmutable()) {
                if (this.persistentObjectCache == null) {
                    this.persistentObjectCache = new HashMap<String, CTResource>();
                }
                this.persistentObjectCache.put(resource.getUniversalSelector(feedback), resource);
            }
        }
        catch (WvcmException e) {
            this.getCCaseLib().logIgnoredExceptionAsAlwaysVisible("CTProvider.persistProxyIfImmutable", Messages.CCaseLib_IGNORED_EXCEPTION_PERFORM_MAP_WRITE, (Exception)((Object)e));
        }
    }

    private synchronized CTResource lookupLocationInPersistentProxyCache(CTLocation loc) {
        CTResource result = null;
        String dn = loc.getDisplayName();
        if (dn != null && ObjSelUtils.isUniversalSelector(dn) && this.persistentObjectCache != null) {
            result = this.persistentObjectCache.get(dn);
        }
        return result;
    }

    public void flushPathnameCacheEntries(SrvcFeedback feedback) {
        this.persistentObjectCache = null;
        ((CTFeedback)feedback).flushCache();
    }

    public void validate(SrvcFeedback feedback) throws WvcmException {
        feedback.notifyActive(Messages.CTProvider_REPORT_MVFS_CASE_CHECK);
        boolean casePreservingNature = this._cc.isCasePreservingNature(feedback);
        if (!casePreservingNature) {
            feedback.notifyWarning(Messages.CTProvider_WARN_MUST_PRESERVE_CASE);
        }
    }

    public String getDefaultCharacterSet() {
        return (String)this._initArgs.get(InteropStream.IA_CHARACTER_SET);
    }

    private List<SrvcResource> doFindBaselines(Baseline query, SrvcFeedback feedback) throws WvcmException {
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        Component component = (Component)query.getProperty(Baseline.VERSION_HISTORY);
        Stream stream = (Stream)query.getProperty(Baseline.ACTIVITY);
        Location streamLocation = stream.getPathnameLocation();
        CTResource resource = this.lookup(streamLocation, feedback);
        String componentSelector = ((CTLocation)component.getPathnameLocation()).getDisplayName();
        if (resource instanceof CTBranch) {
            List<String> labelTypes = this._cc.getAllLabelTypes(componentSelector, feedback);
            if (!labelTypes.isEmpty()) {
                for (String labelType : labelTypes) {
                    CTLocation branchLocation = (CTLocation)streamLocation;
                    CTLocation brtypeLocation = branchLocation.lookupContextLocation(CTLocation.Kind.BRTYPE);
                    CTLocation lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, labelType);
                    CTLocation vobLocation = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, componentSelector);
                    CTLocation blLocation = CTLocation.createBaseCCImporterBaselineLocation(brtypeLocation, lbtypeLocation, vobLocation);
                    CTBranchBaseline baseline = (CTBranchBaseline)this.lookup((Location)blLocation, feedback);
                    result.add(baseline);
                }
            }
        } else {
            String streamSelector = ((CTLocation)streamLocation).getDisplayName();
            List<String> baselines = this._cc.getAllBaselines(streamSelector, componentSelector, feedback);
            if (!baselines.isEmpty()) {
                for (String bl : baselines) {
                    CTLocation blLocation = CTLocation.valueOf(CTLocation.Kind.BASELINE, bl);
                    CTBaseline baseline = (CTBaseline)this.lookup((Location)blLocation, feedback);
                    result.add(baseline);
                }
            } else {
                String foundBlSelector = this._cc.getBaselineInFoundation(null, streamSelector, componentSelector, feedback);
                if (foundBlSelector != null) {
                    CTLocation blLocation = CTLocation.valueOf(CTLocation.Kind.BASELINE, foundBlSelector);
                    CTBaseline baseline = (CTBaseline)this.lookup((Location)blLocation, feedback);
                    result.add(baseline);
                }
            }
        }
        return result;
    }

    public List<Object> doFind(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        BatchedQueryKind queryKind = BatchedQueryKind.UNOPTIMIZED;
        ArrayList<ControllableResource> findCrQueries = new ArrayList<ControllableResource>(queries.size());
        for (Resource query : queries) {
            if (query instanceof ControllableResource) {
                if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind) || BatchedQueryKind.FIND_CR_IN_WORKSPACE.equals((Object)queryKind)) {
                    queryKind = BatchedQueryKind.FIND_CR_IN_WORKSPACE;
                    findCrQueries.add((ControllableResource)query);
                    continue;
                }
                throw new IllegalStateException("found ControllableResource query after finding query kind : " + queryKind.name());
            }
            if (BatchedQueryKind.UNOPTIMIZED.equals((Object)queryKind)) continue;
            throw new IllegalStateException("found unoptimized query after finding query kind : " + queryKind.name());
        }
        List results = null;
        switch (queryKind) {
            case FIND_CR_IN_WORKSPACE: {
                results = this.doFindCrsInView(queries, feedback);
                break;
            }
            default: {
                results = super.doFind(queries, feedback);
            }
        }
        return results;
    }

    private SrvcResource doFindCRInView(ControllableResource query, SrvcFeedback feedback) throws WvcmException {
        if (!query.location().equals((Object)CTLocation._rootLoc)) {
            throw new WvcmException(Messages.CTProvider_UNSUPPORTED_DO_FIND_ERROR, WvcmException.ReasonCode.METHOD_NOT_SUPPORTED);
        }
        Workspace queryWs = query.getWorkspace();
        Location viewLoc = queryWs.getPathnameLocation();
        CTView view = new CTView(viewLoc, this);
        VersionHistory vh = query.getVersionHistory();
        Location elemLoc = vh.getPathnameLocation();
        CTElement element = new CTElement(elemLoc, this);
        CTLocation myCRLoc = element.lookupMyControllableResourceLoc(view, feedback);
        CTResource result = null;
        if (myCRLoc != null) {
            result = this.lookup((Location)myCRLoc, feedback);
        }
        return result;
    }

    private List<Object> doFindCrsInView(ResourceList<?> queries, SrvcFeedback feedback) throws WvcmException {
        boolean runUnoptimized = false;
        String firstViewLocString = null;
        Location viewLoc = null;
        ArrayList<Location> elementLocations = new ArrayList<Location>(queries.size());
        for (Object genericQuery : queries) {
            if (genericQuery instanceof ControllableResource) {
                ControllableResource query = (ControllableResource)genericQuery;
                viewLoc = query.getWorkspace().getPathnameLocation();
                String viewLocString = viewLoc.string();
                if (firstViewLocString == null) {
                    firstViewLocString = viewLocString;
                } else if (!firstViewLocString.equals(viewLocString)) {
                    runUnoptimized = true;
                    break;
                }
                VersionHistory vh = query.getVersionHistory();
                Location elemLoc = vh.getPathnameLocation();
                elementLocations.add(elemLoc);
                continue;
            }
            runUnoptimized = true;
            break;
        }
        CTView view = (CTView)this.getSrvcRes(viewLoc, feedback);
        if (runUnoptimized) {
            return super.doFind(queries, feedback);
        }
        List<Object> crLocs = CTElement.lookupControlledResourceLocs(view, elementLocations, feedback);
        ArrayList<Object> results = new ArrayList<Object>(crLocs.size());
        for (Object entry : crLocs) {
            if (entry == null || entry instanceof Exception) {
                results.add(entry);
                continue;
            }
            if (entry instanceof Location) {
                results.add((Object)this.lookup((Location)entry, feedback));
                continue;
            }
            IllegalStateException result = new IllegalStateException("unknown resource type found in computed resourceList: " + entry.getClass().getName());
            results.add(result);
        }
        return results;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BatchedQueryKind {
        UNOPTIMIZED,
        FIND_CR_IN_WORKSPACE;

    }

    public static class CTFeedback
    extends SrvcFeedback {
        private Map<Location, CTResource> _CTResourceCache;

        public CTFeedback(Feedback feedback) {
            super(feedback);
            this._CTResourceCache = new HashMap<Location, CTResource>();
        }

        protected CTFeedback(CTFeedback ctFeedback, Feedback feedback) {
            super((SrvcFeedback)ctFeedback, feedback);
            this._CTResourceCache = ctFeedback._CTResourceCache;
        }

        public CTFeedback nest(int percentCompleted) {
            Feedback f = this.get_feedback();
            Feedback nestedFeedback = f.nest(this.get_feedback().getPropertyRequestForResult(), percentCompleted);
            if (nestedFeedback == f) {
                return this;
            }
            return new CTFeedback(this, nestedFeedback);
        }

        public void setCTResourceCache(Location key, CTResource value) {
            this._CTResourceCache.put(key, value);
        }

        public CTResource lookupCTResourceCache(Location key) {
            return this._CTResourceCache.get(key);
        }

        public void flushCache() {
            this._CTResourceCache.clear();
        }
    }
}

