/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseElemInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropStream;
import com.ibm.rational.wvcm.ri.impl.VersionHistoryImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.VersionHistory;
import javax.wvcm.WvcmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTElement
extends CTFolder {
    private static final String FILE_ENCODING = "file.encoding";
    private String _contentTypeCache = null;

    CTElement(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return VersionHistoryImpl.class;
    }

    @Override
    public boolean isImmutable() throws WvcmException {
        return !this.getObjInfo(null).getMtype().equals("symbolic link");
    }

    @Override
    protected Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)VersionHistory.ROOT_VERSION)) {
            return this.getRootVersion(feedback);
        }
        if (propertyName.equals((Object)Resource.CONTENT_TYPE)) {
            return this.getContentType(feedback);
        }
        if (propertyName.equals((Object)Resource.CONTENT_CHARACTER_SET)) {
            return this.lookupCharacterSet(feedback);
        }
        if (propertyName.equals((Object)InteropStream.PN_LINE_SEPARATOR)) {
            return this.lookupLineSeparator(feedback);
        }
        if (propertyName.equals((Object)ControllableResource.IS_EXECUTABLE)) {
            return this.getIsExecutable(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private boolean getIsExecutable(SrvcFeedback feedback) throws WvcmException {
        boolean result;
        CCaseLib cc = this.provider().getCCaseLib();
        CCaseObjInfo info = this.getObjInfo(feedback);
        if (info instanceof CCaseElemInfo) {
            CCaseElemInfo elemInfo = (CCaseElemInfo)info;
            result = CCaseLib.isExecutable(elemInfo.getPermissions());
        } else {
            result = cc.getExecutePermission(info.getPathName(), feedback);
        }
        return result;
    }

    public CTLocation lookupMyControllableResourceLoc(CTView view, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String myID = this.location().getDisplayName();
        String gpath = cc.gpath(myID, view.getViewTag(), feedback);
        return CTElement.gpathToCrLoc(gpath);
    }

    public static CTLocation gpathToCrLoc(String gpath) {
        if (gpath == null) {
            return null;
        }
        String versionPath = ObjSelUtils.stripTrailingElementSuffix(gpath);
        String[] gpathSegments = gpath.split(CommonUtils.FWDSLASH);
        if (gpathSegments.length < 4 || gpathSegments[gpathSegments.length - 2].equals("lost+found")) {
            return null;
        }
        CTLocation result = null;
        if (!versionPath.contains("@@")) {
            result = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, versionPath);
        }
        return result;
    }

    public CTVersion getRootVersion(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String elementSel = this.location().getDisplayName();
        String elementGpath = cc.gpath(elementSel, null, feedback);
        CTVersion ver = null;
        CTLocation rootVerLoc = null;
        if (!ObjSelUtils.getObjSelKind(elementSel).equals("oid") || !elementGpath.equals(ObjSelUtils.getObjSelName(elementSel))) {
            String vobTag = cc.getVobTagFromGpath(elementGpath, feedback);
            String mainZeroSuffix = String.valueOf(CommonUtils.FWDSLASH) + cc.getMainBranchName(vobTag, feedback) + "/0";
            rootVerLoc = CTLocation.valueOf(CTLocation.Kind.VERSION, String.valueOf(elementGpath) + mainZeroSuffix);
            ver = (CTVersion)this.provider().lookup((Location)rootVerLoc, feedback);
        }
        if (ver == null && this.getObjInfo(feedback).getMtype().equals("symbolic link")) {
            rootVerLoc = CTLocation.valueOf(CTLocation.Kind.SYMBOLIC_LINK_VERSION, this.location().getDisplayName());
            ver = (CTVersion)this.provider().lookup((Location)rootVerLoc, feedback);
        }
        if (ver == null) {
            throw new IllegalStateException("Root version is null");
        }
        return ver;
    }

    public synchronized String getContentType(SrvcFeedback feedback) throws WvcmException {
        if (this._contentTypeCache == null) {
            CCaseLib cc = this.provider().getCCaseLib();
            if (this.getObjInfo(feedback).isDirectory()) {
                this._contentTypeCache = "text/directory";
            } else {
                CCaseObjInfo objInfo = this.getObjInfo(feedback);
                if (objInfo instanceof CCaseElemInfo) {
                    CCaseElemInfo elemInfo = (CCaseElemInfo)objInfo;
                    String uSel = objInfo.getUniversalSelector();
                    this._contentTypeCache = cc.elementTypeToMimeContentType(ObjSelUtils.getObjSelVobSel(uSel), elemInfo.getElemType(), feedback);
                } else {
                    this._contentTypeCache = cc.getContentType(this.location().getDisplayName(), feedback);
                }
            }
        }
        return this._contentTypeCache;
    }

    public String lookupCharacterSet(SrvcFeedback feedback) throws WvcmException {
        String plainTextResult = this.provider().getDefaultCharacterSet();
        if (plainTextResult.length() == 0) {
            plainTextResult = System.getProperty(FILE_ENCODING);
        }
        String result = this.isPlainText(this.getContentType(feedback)) ? plainTextResult : null;
        return result;
    }

    public String lookupLineSeparator(SrvcFeedback feedback) throws WvcmException {
        String result = this.isPlainText(this.getContentType(feedback)) ? this.provider().getLineSeparator() : null;
        return result;
    }

    private boolean isPlainText(String contentType) {
        return "text/plain".equals(contentType);
    }

    public static List<Object> lookupControlledResourceLocs(CTView view, List<Location> locations, SrvcFeedback feedback) throws WvcmException {
        if (locations == null || locations.size() < 1) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>(locations.size());
        for (Location loc : locations) {
            ids.add(((CTLocation)loc).getDisplayName());
        }
        CTProvider provider = view.provider();
        CCaseLib cc = provider.getCCaseLib();
        List<String> gpaths = cc.gpath(ids, view.getViewTag(), feedback);
        ArrayList<Object> results = new ArrayList<Object>(gpaths.size());
        ArrayList<String> pathnames = new ArrayList<String>(gpaths.size());
        boolean okToCache = true;
        for (String gpath : gpaths) {
            CTLocation cTLocation = CTElement.gpathToCrLoc(gpath);
            results.add((Object)cTLocation);
            if (cTLocation == null) {
                okToCache = false;
                continue;
            }
            pathnames.add(cTLocation.getDisplayName());
        }
        if (okToCache) {
            List<CCaseObjInfo> infos = CCaseObjInfo.lookupObjInfos(cc, pathnames, feedback);
            Iterator<CCaseObjInfo> infoIterator = infos.iterator();
            for (Object e : results) {
                if (!(e instanceof CTLocation)) continue;
                provider.createAndCacheCTResource((CTLocation)((Object)e), infoIterator.next(), feedback);
            }
        }
        return results;
    }
}

