/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseElemInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTFolderVersion;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTResource;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.ControllableFolderImpl;
import com.ibm.rational.wvcm.ri.impl.ResourceImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTControllableFolder
extends CTControllableResource {
    public static final String VOB_COLON = "vob:";

    CTControllableFolder(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Class<?> get_proxyClass() {
        return ControllableFolderImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Folder.CHILD_MAP)) {
            return this.getChildMap(feedback);
        }
        if (propertyName.equals((Object)Folder.CHILD_LIST)) {
            return this.getChildList(feedback);
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            String compPath;
            CTProvider p = this.provider();
            CCaseLib cc = p.getCCaseLib();
            CTLocation configLoc = null;
            CTLocation viewLocation = this.getViewLocation(feedback);
            String crPath = this.getPathname(feedback);
            if (viewLocation.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
                compPath = cc.getComponentSelectorFromGPath(crPath, true, feedback);
                CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, compPath);
                configLoc = CTLocation.createBaseConfigurationLoc(viewLocation, compLoc);
            } else {
                compPath = cc.getComponentSelectorFromComponentRoot(crPath, feedback);
                if (compPath == null) {
                    return null;
                }
                CTLocation compLoc = CTLocation.valueOf(CTLocation.Kind.COMPONENT, compPath);
                configLoc = CTLocation.createConfigurationLoc(viewLocation, compLoc);
            }
            CTWvcmConfiguration result = (CTWvcmConfiguration)p.lookup((Location)configLoc, feedback);
            if (result == null) {
                result = new CTWvcmConfiguration((Location)configLoc, this.provider());
            }
            return result;
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    protected List<SrvcResource> getChildList(SrvcFeedback feedback) throws WvcmException {
        Map<String, SrvcResource> childBindings = null;
        String pathName = this.getPathname(feedback);
        pathName = pathName.startsWith(VOB_COLON) ? pathName.substring(VOB_COLON.length()) : pathName;
        try {
            childBindings = this.processCCDirectory(pathName, feedback);
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.METHOD_NOT_SUPPORTED)) {
                childBindings = this.processFSDirectory(pathName, feedback);
            }
            throw e;
        }
        ArrayList<SrvcResource> results = new ArrayList<SrvcResource>(childBindings.values());
        return results;
    }

    private Map<String, SrvcResource> processCCDirectory(String pathName, SrvcFeedback feedback) throws WvcmException {
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        Map<String, String> dir = cc.getCCDirectory(pathName, feedback);
        return this.processCCDirectory(provider, dir);
    }

    private Map<String, SrvcResource> processCCDirectory(CTProvider provider, Map<String, String> dir) throws WvcmException {
        HashMap<String, SrvcResource> childBindings = new HashMap<String, SrvcResource>();
        for (String leafname : dir.keySet()) {
            Location loc = this.location().child(leafname);
            String dumpMType = dir.get(leafname);
            CTControllableResource cr = dumpMType.equals("2") ? new CTControllableFolder(loc, provider) : new CTControllableResource(loc, provider);
            childBindings.put(leafname, cr);
        }
        return childBindings;
    }

    protected Map<String, SrvcResource> getChildMap(SrvcFeedback feedback) throws WvcmException {
        Map<Object, Object> results = new HashMap();
        String pathName = this.getPathname(feedback);
        pathName = pathName.startsWith(VOB_COLON) ? pathName.substring(VOB_COLON.length()) : pathName;
        try {
            CTProvider provider = this.provider();
            CTLocation myLoc = this.location();
            CCaseLib cc = provider.getCCaseLib();
            Map<String, String> dir = cc.getCCDirectory(pathName, feedback);
            Set<String> childLeafNames = dir.keySet();
            try {
                ArrayList<String> childPathnames = new ArrayList<String>(dir.size());
                for (String leafname : childLeafNames) {
                    childPathnames.add(String.valueOf(pathName) + CommonUtils.FWDSLASH + leafname);
                }
                List<FileSystemObjectInfo> infos = CTControllableFolder.getInfos(provider, childPathnames, feedback);
                Iterator<String> childLeafNameIt = childLeafNames.iterator();
                for (FileSystemObjectInfo info : infos) {
                    String childLeafName = childLeafNameIt.next();
                    CTLocation resultLocation = (CTLocation)myLoc.child(childLeafName);
                    CTControllableResource child = (CTControllableResource)provider.createAndCacheCTResource(resultLocation, info.verInfo, feedback);
                    results.put(childLeafName, (Object)child);
                }
            }
            catch (Exception exception) {
                results = this.processCCDirectory(provider, dir);
            }
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.METHOD_NOT_SUPPORTED)) {
                results = this.processFSDirectory(pathName, feedback);
            }
            throw e;
        }
        return results;
    }

    public static CTControllableFolder doCreate(CTProvider provider, Location loc, SrvcFeedback feedback) throws WvcmException {
        CTLocation location = (CTLocation)loc;
        CTLocation parentLoc = location.parent();
        CTControllableFolder parentFolder = CTControllableFolder.getParentFolder(provider, parentLoc, feedback);
        parentFolder.prepareToWrite(feedback);
        String pathname = location.getDisplayName();
        CCaseLib cc = provider.getCCaseLib();
        cc.makeElement(true, pathname, feedback);
        CTControllableFolder result = (CTControllableFolder)provider.lookup(loc, feedback);
        return result;
    }

    public static CTControllableFolder getParentFolder(CTProvider provider, CTLocation parentLoc, SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder parentFolder = (CTControllableFolder)provider.lookup((Location)parentLoc, feedback);
        if (parentFolder == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_PARENT_NOT_FOUND, (Object)parentLoc.toString()), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        return parentFolder;
    }

    public static CTControllableFolder doCreateComponentAndRoot(CTProvider provider, Location loc, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        CTLocation location = (CTLocation)loc;
        String viewTag = location.getViewTag();
        String streamSel = cc.getStreamUniversalSelector(viewTag, feedback);
        String pVobSel = ObjSelUtils.getObjSelVobSel(streamSel);
        String compRootPath = location.getDisplayName();
        String compName = location.lastSegment();
        try {
            cc.makeComponent(compRootPath, ObjSelUtils.formatSelector("component", compName, pVobSel), streamSel, true, feedback);
        }
        catch (WvcmException ex) {
            File vobRoot;
            String compVobTag = CTInitArgUtils.getCompVobTag(provider.initArgs()).trim();
            if ((compVobTag.length() != 0 || location.parent().getDisplayName().contains(CommonUtils.canonicalizePathname(compVobTag))) && !(vobRoot = new File(location.parent().getDisplayName())).exists()) {
                throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_CREATE_COMPONENT_IN_VOB, (Object)compVobTag), null, WvcmException.ReasonCode.NOT_FOUND, (Throwable)ex);
            }
            throw ex;
        }
        CTControllableFolder result = new CTControllableFolder(loc, provider);
        return result;
    }

    public void doUnbindChild(String bindingName, SrvcFeedback feedback) throws WvcmException {
        CTLocation myLoc;
        Location childLocation;
        CTProvider provider = this.provider();
        CTControllableResource child = (CTControllableResource)provider.lookup(childLocation = (myLoc = this.location()).child(bindingName), feedback);
        if (child == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_FIND_CHILD, (Object)childLocation.string()), WvcmException.ReasonCode.NOT_FOUND);
        }
        boolean isUncontrolledResource = this.isUncontrolledResource(child, feedback);
        if (isUncontrolledResource) {
            String pathname = child.getPathname(feedback);
            File goner = new File(pathname);
            boolean success = goner.delete();
            if (!success) {
                throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_FILE_DELETE_FAILE_WITH_PATHNAME, (Object)pathname), WvcmException.ReasonCode.FORBIDDEN);
            }
            return;
        }
        this.prepareToWrite(feedback);
        String myPathname = this.getPathname(feedback);
        CCaseLib cc = provider.getCCaseLib();
        cc.removeName(myPathname, bindingName, feedback);
        this.flush(feedback);
    }

    @Override
    public void doVersionControl(SrvcFeedback feedback) throws WvcmException {
    }

    public void doRebindChild(String bindingName, Location sourceFolderLocation, String sourceBindingName, Folder.RebindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CTControllableFolder sourceFolder = new CTControllableFolder(sourceFolderLocation, p);
        Location sourceChildLoc = sourceFolderLocation.child(sourceBindingName);
        CTControllableResource sourceCR = (CTControllableResource)p.lookup(sourceChildLoc, feedback);
        if (sourceCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_FIND_CHILD, (Object)sourceChildLoc.string()), WvcmException.ReasonCode.NOT_FOUND);
        }
        String newFolderPathname = this.getPathname(feedback);
        String newPathname = String.valueOf(newFolderPathname) + '/' + bindingName;
        String oldFolderPathname = sourceFolder.getPathname(feedback);
        String oldPathname = String.valueOf(oldFolderPathname) + '/' + sourceBindingName;
        boolean isUncontrolledResource = this.isUncontrolledResource(sourceCR, feedback);
        if (isUncontrolledResource) {
            File source = new File(oldPathname);
            File destination = new File(newPathname);
            boolean result = source.renameTo(destination);
            if (!result) {
                throw new WvcmException(NLS.bind((String)Messages.CCaseLib_ERROR_RENAME_FAILED, (Object)oldPathname, (Object)newPathname), WvcmException.ReasonCode.FORBIDDEN);
            }
            return;
        }
        sourceFolder.prepareToWrite(feedback);
        this.prepareToWrite(feedback);
        CCaseLib cc = p.getCCaseLib();
        cc.moveName(oldPathname, newPathname, feedback);
        this.flush(feedback);
    }

    private boolean isUncontrolledResource(CTControllableResource sourceCR, SrvcFeedback feedback) throws WvcmException {
        return "view private object".equals(sourceCR.getObjInfo(feedback).getMtype());
    }

    public void doBindChild(String bindingName, Location childLocation, Folder.BindFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        this.prepareToWrite(feedback);
        CTControllableResource childCR = (CTControllableResource)p.lookup(childLocation, feedback);
        if (childCR == null) {
            throw new WvcmException(NLS.bind((String)Messages.CTControllableFolder_ERROR_COULD_NOT_FIND_CHILD, (Object)childLocation.toString()), null, WvcmException.ReasonCode.NOT_FOUND);
        }
        String oldPathname = childCR.getPathname(feedback);
        String myPathname = this.getPathname(feedback);
        String newPathname = String.valueOf(myPathname) + '/' + bindingName;
        CCaseLib cc = p.getCCaseLib();
        cc.link(oldPathname, newPathname, feedback);
        this.flush(feedback);
    }

    private Map<String, SrvcResource> processFSDirectory(String pathName, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, SrvcResource> childBindings = new HashMap<String, SrvcResource>();
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        Map<String, Boolean> dir = cc.getFSDirectory(pathName, feedback);
        for (String leafname : dir.keySet()) {
            Location loc = this.location().child(leafname);
            Boolean isDirectory = dir.get(leafname);
            CTControllableResource cr = isDirectory != false ? new CTControllableFolder(loc, provider) : new CTControllableResource(loc, provider);
            childBindings.put(leafname, cr);
        }
        return childBindings;
    }

    public List<SrvcResource> doReadMemberList(Location unusedLocation, boolean deep, SrvcFeedback feedback) throws WvcmException {
        if (!deep) {
            throw new IllegalArgumentException("'deep=true' required when calling doReadMemberList");
        }
        CTProvider provider = this.provider();
        String pathname = this.getPathname(feedback);
        CCaseLib cc = provider.getCCaseLib();
        List<String> verNames = cc.listDirectoryTree(pathname, feedback);
        ArrayList<String> versionlessNames = new ArrayList<String>();
        for (String name : verNames) {
            if (!name.endsWith("@@")) continue;
            versionlessNames.add(name);
        }
        int count = versionlessNames.size();
        if (count > 0) {
            String msg = NLS.bind((String)Messages.CTControllableFolder_ERROR_TREE_HAS_ENTRIES_WITH_NO_SELECTED_VERSION, (Object[])new Object[]{count, pathname, versionlessNames.get(0)});
            throw new WvcmException(msg, WvcmException.ReasonCode.FORBIDDEN);
        }
        return CTControllableFolder.memberListHelper(provider, verNames, feedback);
    }

    public static List<FileSystemObjectInfo> getInfos(CTProvider provider, List<String> names, SrvcFeedback feedback) throws WvcmException {
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FileSystemObjectInfo> results = new ArrayList<FileSystemObjectInfo>(names.size());
        CCaseLib cc = provider.getCCaseLib();
        List<CCaseVerInfo> verInfos = CCaseVerInfo.getVerInfos(cc, names, feedback);
        ArrayList<String> elemStrings = new ArrayList<String>(verInfos.size());
        for (CCaseVerInfo verInfo : verInfos) {
            String elemPathName = verInfo.getElemPathName();
            elemStrings.add(CommonUtils.canonicalizePathname(elemPathName));
        }
        List<CCaseElemInfo> elemInfos = CCaseElemInfo.getElemInfos(cc, elemStrings, feedback);
        int expectedSize = names.size();
        if (verInfos.size() != expectedSize || elemInfos.size() != expectedSize) {
            throw new IllegalStateException("Unexpected size mismatch in info computed from listDirTree output");
        }
        Iterator<CCaseVerInfo> verIt = verInfos.iterator();
        Iterator<CCaseElemInfo> elemIt = elemInfos.iterator();
        for (String name : names) {
            CCaseElemInfo elemInfo = elemIt.next();
            String elemPathName = elemInfo.getPathName();
            if (!elemPathName.endsWith("@@")) {
                throw new IllegalStateException(NLS.bind((String)"element pathname does not end with the extended naming symbol {0} {1}", (Object)elemPathName, (Object)"@@"));
            }
            String elemUSel = elemInfo.getUniversalSelector();
            CTElement elem = (CTElement)provider.createAndCacheCTResource(CTLocation.valueOf(elemUSel), elemInfo, feedback);
            CCaseVerInfo verInfo = verIt.next();
            String verUSel = verInfo.getUniversalSelector();
            CTLocation verLoc = CTLocation.valueOf(CTLocation.Kind.VERSION, verUSel);
            CTResource res = provider.createAndCacheCTResource(verLoc, verInfo, feedback);
            CTVersion ver = null;
            if (res instanceof CTVersion) {
                ver = (CTVersion)res;
                ver.setElemUSel(elemUSel);
            }
            results.add(new FileSystemObjectInfo(name, verInfo, ver, elemInfo, elem));
        }
        return results;
    }

    private static List<SrvcResource> memberListHelper(CTProvider provider, List<String> verNames, SrvcFeedback feedback) throws WvcmException {
        if (verNames == null || verNames.size() == 0) {
            return Collections.emptyList();
        }
        List<FileSystemObjectInfo> infos = CTControllableFolder.getInfos(provider, verNames, feedback);
        HashMap<String, CTFolderVersion> pathnamesToFolderVersions = new HashMap<String, CTFolderVersion>();
        ArrayList<SrvcResource> entries = new ArrayList<SrvcResource>(infos.size());
        for (FileSystemObjectInfo info : infos) {
            String bindingName;
            Map<String, Object> parentChildMap;
            Object previous;
            int sep;
            String parentName;
            CTFolderVersion parentFolderVersion;
            CCaseElemInfo elemInfo = info.elemInfo;
            CCaseVerInfo verInfo = info.verInfo;
            String elemPathName = elemInfo.getPathName();
            if (!elemPathName.endsWith("@@")) {
                throw new IllegalStateException(NLS.bind((String)"element pathname does not end with the extended naming symbol {0} {1}", (Object)elemPathName, (Object)"@@"));
            }
            int end = elemPathName.length() - "@@".length();
            String name = elemPathName.substring(0, end);
            CTLocation resultLocation = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, name);
            CTControllableResource ctcr = (CTControllableResource)provider.createAndCacheCTResource(resultLocation, verInfo, feedback);
            if (info.ver != null && info.ver instanceof CTFolderVersion) {
                pathnamesToFolderVersions.put(name, (CTFolderVersion)info.ver);
            }
            if ((parentFolderVersion = (CTFolderVersion)((Object)pathnamesToFolderVersions.get(parentName = name.substring(0, sep = name.lastIndexOf(47))))) != null && (previous = (parentChildMap = parentFolderVersion.getRawMap()).put(bindingName = name.substring(sep + 1), (Object)info.elem)) != null) {
                throw new IllegalStateException(NLS.bind((String)"folder version {0} child map already contains binding name {1}", (Object)parentFolderVersion.location().string(), (Object)bindingName));
            }
            entries.add(ctcr);
        }
        for (SrvcResource cr : entries) {
            ResourceImpl ctcr = cr.buildProxy(feedback.getPropertyRequestForResult(), feedback);
            feedback.setResourceCache((Location)cr.location(), (Resource)ctcr);
        }
        return entries;
    }

    public static /* bridge */ /* synthetic */ CTControllableResource doCreate(CTProvider cTProvider, Location location, SrvcFeedback srvcFeedback) throws WvcmException {
        return CTControllableFolder.doCreate(cTProvider, location, srvcFeedback);
    }

    static class FileSystemObjectInfo {
        String name;
        CCaseVerInfo verInfo;
        CTVersion ver;
        CCaseElemInfo elemInfo;
        CTElement elem;

        public FileSystemObjectInfo(String name, CCaseVerInfo verInfo, CTVersion ver, CCaseElemInfo elemInfo, CTElement elem) {
            this.name = name;
            this.verInfo = verInfo;
            this.ver = ver;
            this.elemInfo = elemInfo;
            this.elem = elem;
        }
    }
}

