/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.DiffBLInfo;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTBranchBaseline
extends CTBaseline {
    private CCaseLib cc = null;
    private static final String TOKEN_SEP = ";";
    private static final String DIRECTORY = "directory";

    public CTBranchBaseline(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource newBaseline, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        List<Object> versionList = new ArrayList();
        CTLocation oldBlLocation = this.location();
        String compOid = oldBlLocation.getContextLocation(CTLocation.Kind.VOBCOMPONENT).getDisplayName();
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.cc, compOid, feedback);
        String mtype = compObjInfo.getMtype();
        String searchRoot = null;
        if (mtype.equals("versioned object base")) {
            searchRoot = String.valueOf('.') + this.cc.computeVobTagFromVobSelector(compObjInfo.getPathName(), feedback);
        } else if (mtype.equals("component")) {
            searchRoot = String.valueOf('.') + this.cc.getComponentRootDir(compObjInfo.getUniversalSelector(), feedback);
        }
        if (!CTInitArgUtils.importOnly(this.provider().initArgs())) {
            CTLocation oldTimeLocation = oldBlLocation.getContextLocation(CTLocation.Kind.TIMESTAMP);
            String oldTime = oldTimeLocation.getDisplayName();
            String string = oldBlLocation.getContextLocation(CTLocation.Kind.BRTYPE).getDisplayName();
            String branch = this.cc.getDisplayName(string, feedback);
            versionList = this.cc.findNewVersions(searchRoot, oldTime, branch, feedback);
        } else {
            CTBranchBaseline newbl = (CTBranchBaseline)newBaseline;
            String oldLabelType = oldBlLocation.getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
            String string = newbl.location().getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
            versionList = this.cc.findNewVersionsForImporter(searchRoot, oldLabelType, string, feedback);
        }
        ArrayList<SrvcResource.SrvcCompareReport> blReports = new ArrayList<SrvcResource.SrvcCompareReport>(versionList.size());
        if (versionList.isEmpty()) {
            return blReports;
        }
        ArrayList<CTVersion> versions = new ArrayList<CTVersion>(versionList.size());
        for (String string : versionList) {
            String[] tokens = string.split(TOKEN_SEP);
            if (tokens == null) {
                throw new IllegalStateException("Could not get version");
            }
            CCaseObjInfo ccObj = new CCaseObjInfo(this.cc, tokens[1], tokens[0].startsWith(DIRECTORY), tokens[2], tokens[0]);
            versions.add(CTVersion.valueOf(this.provider(), ccObj, feedback));
        }
        for (CTVersion cTVersion : versions) {
            DiffBLInfo diffBLInfo = new DiffBLInfo(null, cTVersion, this.provider());
            SrvcResource.SrvcCompareReport baselineReport = this.computeBlReport(diffBLInfo);
            blReports.add(baselineReport);
        }
        return blReports;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        Object propertyValue = null;
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            propertyValue = this.location().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            propertyValue = new CTVOB((Location)this.location().getContextLocation(CTLocation.Kind.VOBCOMPONENT), this.provider());
        }
        if ("com.ibm.team.importer".equals(propertyName.getNamespace())) {
            return this.getLabelAttribute(propertyName.getName(), feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        if (propertyValue == null) {
            propertyValue = super.getThisProperty(propertyName, configuration, feedback);
        }
        return propertyValue;
    }

    private String getLabelAttribute(String attribute, SrvcFeedback feedback) throws WvcmException {
        return this.cc.getAttributeOnBaseline(this.location().getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName(), attribute, feedback);
    }

    @Override
    protected String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        String displayName = null;
        CTLocation myLocation = this.location();
        String vobComponent = myLocation.getContextLocation(CTLocation.Kind.VOBCOMPONENT).getDisplayName();
        if (ObjSelUtils.isUniversalSelector(vobComponent)) {
            CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.cc, vobComponent, feedback);
            String mtype = compObjInfo.getMtype();
            if (mtype.equals("versioned object base")) {
                String vobTag = this.cc.computeVobTagFromVobSelector(compObjInfo.getPathName(), feedback);
                vobComponent = ObjSelUtils.formatSelector("vob", vobTag);
            } else if (mtype.equals("component")) {
                vobComponent = this.cc.getExtendedName(null, compObjInfo.getUniversalSelector(), feedback);
            }
        }
        if (!CTInitArgUtils.importOnly(this.provider().initArgs())) {
            String time = myLocation.getContextLocation(CTLocation.Kind.TIMESTAMP).getDisplayName();
            displayName = NLS.bind((String)Messages.CTBranchBaseline_SYNCHRONIZER_BASELINE_DISPLAY_NAME, (Object)time, (Object)vobComponent);
        } else {
            String labelType = myLocation.getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
            displayName = NLS.bind((String)Messages.CTBranchBaseline_IMPORTER_BASELINE_DISPLAY_NAME, (Object)labelType, (Object)vobComponent);
        }
        return displayName;
    }
}

