/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTInitArgUtils;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTStream;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CTWvcmConfiguration;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.impl.StreamImpl;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTBranch
extends CTStream {
    private CCaseLib cc = null;
    public static final String TOKEN_SEP = "_";
    private static final String COMMENT_CHAR = "#";
    public static final String BRANCH_INFO = "#BRANCH=";
    public static final String LABEL_INFO = "#LABEL=";
    private static final String NEWLINE = "\n";
    private static final String BASECC_CS = "#BaseCCIntegration";
    private static final String ELEMENT_STAR_SPACE = "element * ";
    private static final String ELEMENT_SPACE_OPEN_SQBRCKT = "element \"[";
    private static final String EQUAL = "=";
    private static final String CLOSE_SQBRCKT = "]/...\"";
    private static final String ELEMENT_STAR_SPACE_3DOT = "element * ...";
    private static final String MKBRANCH = " -mkbranch ";
    private static final String ZERO_MKBRANCH = "0 -mkbranch ";
    private static final String NOCHECKOUT = " -nocheckout";
    private static final String BRANCH_PREFIX = "BR";
    private static final String LABEL_PREFIX = "BL";
    private List<String> configSpec = null;

    public CTBranch(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public Class<?> get_proxyClass() {
        return StreamImpl.class;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        Object propertyValue = null;
        propertyValue = propertyName.equals(CTProvider.FULLY_QUALIFIED_DISPLAY_NAME) ? this.getFQName(feedback) : (propertyName.getNamespace() != null ? this.cc.getAttr(CTBranch.getCustomAttName(propertyName), this.getBrtypeSelector(), feedback) : (propertyName.equals((Object)Resource.DISPLAY_NAME) ? this.getDisplayName(false, feedback) : (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER) ? this.location().string() : (propertyName.equals((Object)Resource.PATHNAME_LOCATION) ? this.location() : (propertyName.equals((Object)Activity.LATEST_VERSION_LIST) ? this.doGetBaselines(feedback) : super.getThisProperty(propertyName, configuration, feedback))))));
        return propertyValue;
    }

    @Override
    protected String getSelectorToLock(SrvcFeedback feedback) throws WvcmException {
        return this.getBrtypeSelector();
    }

    @Override
    protected String getObjectSelectorHoldingAttr() throws WvcmException {
        return this.getBrtypeSelector();
    }

    @Override
    public void doUnbindAll(SrvcFeedback feedback) throws WvcmException {
        String brtype = this.getBrtypeSelector();
        String lbtype = this.getLbtypeSelector();
        this.cc.removeType(brtype, feedback);
        if (lbtype != null) {
            this.cc.removeType(lbtype, feedback);
        }
        this.flush(feedback);
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        for (T source : sourceList) {
            if (source instanceof CTView) {
                String viewCS = ((CTView)((Object)source)).getConfigSpec(feedback);
                String[] branchCS = this.getConfigSpec(feedback);
                String[] tokens = viewCS.split(NEWLINE);
                if (tokens == null) {
                    throw new WvcmException(NLS.bind((String)Messages.CTBranch_INVALID_VIEW_CS_ERROR, (Object)viewCS), WvcmException.ReasonCode.FORBIDDEN);
                }
                int i = 0;
                while (i < tokens.length) {
                    String token = tokens[i];
                    if (branchCS.length <= i) {
                        throw new WvcmException(NLS.bind((String)Messages.CTBranch_BRANCH_CS_ERROR, (Object)token), WvcmException.ReasonCode.FORBIDDEN);
                    }
                    if (!token.equalsIgnoreCase(branchCS[i])) {
                        throw new WvcmException(NLS.bind((String)Messages.CTBranch_MISMATCH_CS_ERROR, (Object)token, (Object)branchCS[i]), WvcmException.ReasonCode.FORBIDDEN);
                    }
                    ++i;
                }
            }
            this.flush(feedback);
        }
    }

    private String getFQName(SrvcFeedback feedback) throws WvcmException {
        String brtype = "";
        String brtypeSel = this.getBrtypeSelector();
        if (brtypeSel == null) {
            brtypeSel = "";
        } else {
            brtype = ObjSelUtils.formatSelectorNoKind(brtypeSel);
        }
        String lbtype = this.getLbtypeSelector();
        String fqName = new String(String.valueOf(brtype) + CTProvider.BASECC_CHAR);
        if (lbtype != null) {
            lbtype = ObjSelUtils.formatSelectorNoKind(lbtype);
            fqName = String.valueOf(fqName) + lbtype;
        }
        return fqName;
    }

    public String getDisplayName(boolean fullName, SrvcFeedback feedback) throws WvcmException {
        String displayName = null;
        if (fullName) {
            String brtype = this.getBrtypeSelector();
            String lbtype = this.getLbtypeSelector();
            displayName = brtype;
            if (lbtype != null) {
                displayName = String.valueOf(displayName) + TOKEN_SEP + lbtype;
            }
        } else {
            String brtype = this.lookupType(CTLocation.Kind.BRTYPE, feedback);
            String lbtype = this.lookupType(CTLocation.Kind.LBTYPE, feedback);
            displayName = brtype;
            if (lbtype != null) {
                displayName = String.valueOf(displayName) + TOKEN_SEP + lbtype;
            }
        }
        return displayName;
    }

    private List<String> createConfigSpec(SrvcFeedback feedback) throws WvcmException {
        String brtype = this.lookupType(CTLocation.Kind.BRTYPE, feedback);
        String lbtype = this.lookupType(CTLocation.Kind.LBTYPE, feedback);
        String brtypeSelector = brtype == null ? null : this.getBrtypeSelector();
        String lbtypeSelector = lbtype == null ? null : this.getLbtypeSelector();
        this.configSpec = new ArrayList<String>();
        this.configSpec.add(BASECC_CS);
        if (brtypeSelector != null) {
            this.configSpec.add(BRANCH_INFO + brtypeSelector + BRANCH_INFO);
        }
        if (lbtypeSelector != null) {
            this.configSpec.add(LABEL_INFO + lbtypeSelector + LABEL_INFO);
        }
        if (CTInitArgUtils.importOnly(this.provider().initArgs())) {
            this.configSpec.add(ELEMENT_STAR_SPACE + lbtype + NOCHECKOUT);
        } else {
            this.configSpec.add("element * CHECKEDOUT");
            this.configSpec.add(ELEMENT_STAR_SPACE_3DOT + CommonUtils.FWDSLASH + brtype + CommonUtils.FWDSLASH + "LATEST");
            if (lbtype != null) {
                this.configSpec.add(ELEMENT_STAR_SPACE + lbtype + MKBRANCH + brtype);
            }
            this.configSpec.add(ELEMENT_STAR_SPACE + CommonUtils.FWDSLASH + this.cc.getMainBranchName(ObjSelUtils.getObjSelVobSel(brtypeSelector), feedback) + CommonUtils.FWDSLASH + ZERO_MKBRANCH + brtype);
        }
        return this.configSpec;
    }

    public String[] getConfigSpec(SrvcFeedback feedback) throws WvcmException {
        if (this.configSpec == null) {
            this.createConfigSpec(feedback);
        }
        String[] csArray = new String[]{};
        csArray = this.configSpec.toArray(csArray);
        return csArray;
    }

    public List<String> updateConfigSpec(Map<String, String> vobLabelMap, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        List<String> defaultCS = this.createConfigSpec(feedback);
        ArrayList<String> csList = new ArrayList<String>();
        csList.add(defaultCS.get(0));
        csList.add(defaultCS.get(1));
        csList.add(defaultCS.get(2));
        for (String vobSelector : vobLabelMap.keySet()) {
            String labelSelector = vobLabelMap.get(vobSelector);
            String vobOid = ObjSelUtils.getObjSelName(vobSelector);
            String labelName = ObjSelUtils.getObjSelName(labelSelector);
            String oidStripped = vobOid.replaceAll("\\.", CTProvider.EMPTY_STRING).replaceAll("\\:", CTProvider.EMPTY_STRING);
            String vobTag = cc.computeVobTagFromVobSelector(vobOid, feedback);
            String labelSelectorLine = ELEMENT_SPACE_OPEN_SQBRCKT + oidStripped + EQUAL + vobTag + CLOSE_SQBRCKT + " " + labelName + " " + NOCHECKOUT;
            csList.add(labelSelectorLine);
        }
        csList.add(defaultCS.get(3));
        this.configSpec = csList;
        return this.configSpec;
    }

    public static CTBranch doCreateGeneratedResource(CTProvider provider, CTLocation location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = provider.getCCaseLib();
        String compVobTag = CTInitArgUtils.getCompVobTag(provider.initArgs());
        String adminVobTag = cc.getAdminVobTag(compVobTag, feedback);
        String branchType = cc.mkBrType(BRANCH_PREFIX, adminVobTag, feedback);
        String labelType = cc.mkLbType(LABEL_PREFIX, adminVobTag, feedback);
        CTLocation brtypeLocation = CTLocation.valueOf(CTLocation.Kind.BRTYPE, branchType);
        CTLocation lbtypeLocation = CTLocation.valueOf(CTLocation.Kind.LBTYPE, labelType);
        CTLocation branchLocation = CTLocation.createBranchLocation(brtypeLocation, lbtypeLocation);
        return new CTBranch((Location)branchLocation, provider);
    }

    private String lookupType(CTLocation.Kind kind, SrvcFeedback feedback) throws WvcmException {
        String type = null;
        CTLocation typeLocation = this.location().lookupContextLocation(kind);
        if (typeLocation != null) {
            type = this.cc.getDisplayName(typeLocation.getDisplayName(), feedback);
        }
        return type;
    }

    private String getTypeSelector(CTLocation.Kind kind) throws WvcmException {
        String selector = null;
        CTLocation typeLocation = this.location().lookupContextLocation(kind);
        if (typeLocation != null) {
            selector = typeLocation.getDisplayName();
        }
        return selector;
    }

    private String getBrtypeSelector() throws WvcmException {
        return this.getTypeSelector(CTLocation.Kind.BRTYPE);
    }

    private String getLbtypeSelector() throws WvcmException {
        return this.getTypeSelector(CTLocation.Kind.LBTYPE);
    }

    @Override
    public List<CTBaseline> doGetBaselines(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        List<String> vobComps = this.getVobComponentList(feedback);
        ArrayList<CTBaseline> latestBaselines = new ArrayList<CTBaseline>();
        CTLocation timeStampLoc = CTLocation.valueOf(CTLocation.Kind.TIMESTAMP, CTWvcmConfiguration.timeNow());
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        CTLocation lbtypeLoc = this.location().lookupContextLocation(CTLocation.Kind.LBTYPE);
        for (String component : vobComps) {
            CTLocation vobCompLoc = CTLocation.valueOf(CTLocation.Kind.VOBCOMPONENT, component);
            CTLocation baselineLoc = CTLocation.createBaseCCBaselineLocation(brtypeLoc, lbtypeLoc, vobCompLoc, timeStampLoc);
            CTBaseline baseline = (CTBaseline)p.lookup((Location)baselineLoc, feedback);
            if (baseline == null) continue;
            latestBaselines.add(baseline);
        }
        return latestBaselines;
    }

    private List<String> getVobComponentList(SrvcFeedback feedback) throws WvcmException {
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        String vobComps = this.cc.getAttr("com.ibm.team.interop_VobComponent", brtypeLoc.getDisplayName(), feedback);
        ArrayList<String> tokens = new ArrayList<String>();
        if (vobComps != null) {
            int index = vobComps.indexOf(CTLocation.INFO_SEPARATOR_STRING);
            if (index != -1) {
                tokens.add(vobComps.substring(0, index));
                boolean done = false;
                while (!done) {
                    int previousIndex = index + 1;
                    if ((index = vobComps.indexOf(CTLocation.INFO_SEPARATOR_STRING, previousIndex)) != -1) {
                        tokens.add(vobComps.substring(previousIndex, index));
                        continue;
                    }
                    tokens.add(vobComps.substring(previousIndex));
                    done = true;
                }
            } else {
                tokens.add(vobComps);
            }
        }
        return tokens;
    }

    public List<String> getVobComponentRoots(SrvcFeedback feedback) throws WvcmException {
        List<String> vobCompsOids = this.getVobComponentList(feedback);
        ArrayList<String> vobComponentRoots = new ArrayList<String>(vobCompsOids.size());
        if (!vobCompsOids.isEmpty()) {
            List<CCaseObjInfo> compObjInfos = CCaseObjInfo.getObjInfos(this.cc, vobCompsOids, feedback);
            for (CCaseObjInfo compObjInfo : compObjInfos) {
                String mtype = compObjInfo.getMtype();
                if (mtype.equals("versioned object base")) {
                    String vobTag = this.cc.computeVobTagFromVobSelector(compObjInfo.getPathName(), feedback);
                    vobComponentRoots.add(String.valueOf('.') + vobTag);
                    continue;
                }
                if (!mtype.equals("component")) continue;
                String compRootDir = this.cc.getComponentRootDir(compObjInfo.getUniversalSelector(), feedback);
                vobComponentRoots.add(String.valueOf('.') + compRootDir);
            }
        }
        return vobComponentRoots;
    }

    @Override
    public synchronized CCaseObjInfo getObjInfo(SrvcFeedback feedback) throws WvcmException {
        throw new IllegalArgumentException("getObjInfo() is not suported for CTBranch");
    }
}

