/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CTBranch;
import com.ibm.rational.wvcm.ct.CTBranchBaseline;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CTBaseCCView
extends CTView {
    CTBaseCCView(Location location, CTProvider provider) {
        super(location, provider);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CONFIGURATION_ROOT_FOLDER_HOME)) {
            return this;
        }
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            return null;
        }
        if (propertyName.equals((Object)Workspace.ACTIVITY_FOLDER_LIST)) {
            return null;
        }
        if (propertyName.equals((Object)Workspace.BASELINE_CONTROLLED_FOLDER_LIST)) {
            return this.getBaselineControlledFolderList(feedback);
        }
        if (propertyName.equals((Object)Workspace.CONTROLLABLE_RESOURCE_HOME)) {
            return this.getControllableResourceHome(feedback);
        }
        if (propertyName.equals((Object)Workspace.STREAM)) {
            return this.getBranch();
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    public void doCheckinAll(String comment, ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        CTLocation brtypeLoc;
        CTProvider provider = this.provider();
        CCaseLib cc = provider.getCCaseLib();
        List<String> vobPaths = cc.getCheckoutVobPathList((brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE)).getDisplayName(), feedback);
        if (!vobPaths.isEmpty()) {
            this.checkinAllHelper(comment, flags, vobPaths, this.getViewTag(), feedback);
        }
    }

    @Override
    public synchronized String getStreamSelector(SrvcFeedback feedback) throws WvcmException {
        CTLocation location = this.location();
        CTLocation brtypeLoc = location.getContextLocation(CTLocation.Kind.BRTYPE);
        CTLocation lbtypeLoc = location.lookupContextLocation(CTLocation.Kind.LBTYPE);
        String brtype = brtypeLoc.getDisplayName();
        String lbtype = null;
        if (lbtypeLoc != null) {
            lbtype = lbtypeLoc.getDisplayName();
        }
        if (brtype == null) {
            throw new IllegalStateException("Context location for base CC view is missing branch type");
        }
        String selector = brtype;
        if (lbtype != null) {
            selector = String.valueOf(selector) + "_" + lbtype;
        }
        return selector;
    }

    public static CTBaseCCView doCreateGeneratedResource(CTProvider provider, Location location, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTLocation loc = (CTLocation)location;
        String cleanName = CCaseLib.cleanName(loc.getDisplayName());
        PropValue streamValue = updates != null ? updates.get(Workspace.TARGET) : null;
        boolean isolatedTarget = false;
        if (streamValue == null) {
            PropValue propValue = streamValue = updates != null ? updates.get(Workspace.ISOLATED_TARGET) : null;
            if (streamValue != null) {
                isolatedTarget = true;
                updated.add(Workspace.ISOLATED_TARGET);
            }
        } else {
            updated.add(Workspace.TARGET);
        }
        CTLocation streamLoc = streamValue != null ? (CTLocation)((Object)streamValue.get_value()) : null;
        CTBranch branch = new CTBranch((Location)streamLoc, provider);
        CCaseLib cc = provider.getCCaseLib();
        String viewTag = cc.makeView(cleanName, null, feedback);
        CTLocation resultLoc = null;
        resultLoc = isolatedTarget && streamLoc != null ? CTLocation.createBaseViewLocation(viewTag, streamLoc.getContextLocation(CTLocation.Kind.BRTYPE), streamLoc.getContextLocation(CTLocation.Kind.LBTYPE)) : CTLocation.createBaseViewLocation(viewTag, streamLoc.getContextLocation(CTLocation.Kind.BRTYPE), streamLoc.lookupContextLocation(CTLocation.Kind.LBTYPE));
        CTBaseCCView result = new CTBaseCCView((Location)resultLoc, provider);
        result.setConfigSpec(branch.getConfigSpec(feedback), feedback);
        return result;
    }

    public <T extends SrvcResource> void doMerge(List<T> sourceLocations, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        for (SrvcResource o : sourceLocations) {
            if (o instanceof CTBranch) {
                String wsStreamSel;
                CTBranch source = (CTBranch)o;
                String streamSel = source.getDisplayName(true, feedback);
                if (!streamSel.equals(wsStreamSel = this.getStreamSelector(feedback))) {
                    throw new IllegalArgumentException("Branch/view mismatch");
                }
                CTProvider p = this.provider();
                p.getCCaseLib().setcsCurrent(this.getViewTag(), feedback);
                this.flush(feedback);
                continue;
            }
            throw new IllegalArgumentException("Can't merge non-branch into base ClearCase view");
        }
    }

    private CTBranch getBranch() throws WvcmException {
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        CTLocation lbtypeLoc = this.location().lookupContextLocation(CTLocation.Kind.LBTYPE);
        CTLocation branchLoc = CTLocation.createBranchLocation(brtypeLoc, lbtypeLoc);
        CTBranch branch = new CTBranch((Location)branchLoc, this.provider());
        return branch;
    }

    private List<CTControllableFolder> getBaselineControlledFolderList(SrvcFeedback feedback) throws WvcmException {
        List<String> tokens = this.getVobComponentList(feedback);
        ArrayList<CTControllableFolder> result = new ArrayList<CTControllableFolder>();
        for (String comp : tokens) {
            CTControllableFolder bcf = this.createBcfFromVobComponent(comp, feedback);
            result.add(bcf);
        }
        return result;
    }

    private CTControllableFolder createBcfFromVobComponent(String compUsel, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        String familyUUID = ObjSelUtils.getObjSelName(compUsel);
        String path = null;
        try {
            String vobTag = cc.computeVobTagFromVobSelector(familyUUID, feedback);
            path = CommonUtils.canonicalizePathname(String.valueOf(CCaseLib.getPathIntoView(this.getViewTag())) + vobTag);
        }
        catch (WvcmException e) {
            if (e.getMessage().contains("cleartool: Error: No matching entries found for uuid")) {
                path = cc.getComponentRootDirPathname(compUsel, this.getViewTag(), feedback);
            }
            throw e;
        }
        CTLocation bcfLoc = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, path);
        return new CTControllableFolder((Location)bcfLoc, p);
    }

    private CTControllableFolder getControllableResourceHome(SrvcFeedback feedback) throws WvcmException {
        CTControllableFolder bcf = null;
        List<CTControllableFolder> bcfs = this.getBaselineControlledFolderList(feedback);
        if (bcfs.size() >= 1) {
            bcf = bcfs.get(0);
        }
        return bcf;
    }

    private List<String> getVobComponentList(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CCaseLib cc = p.getCCaseLib();
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        String vobComps = cc.getAttr("com.ibm.team.interop_VobComponent", brtypeLoc.getDisplayName(), feedback);
        ArrayList<String> tokens = new ArrayList<String>();
        if (vobComps != null) {
            int index = vobComps.indexOf(CTLocation.INFO_SEPARATOR_STRING);
            if (index != -1) {
                tokens.add(vobComps.substring(0, index));
                boolean done = false;
                while (!done) {
                    int previousIndex = index + 1;
                    if ((index = vobComps.indexOf(CTLocation.INFO_SEPARATOR_STRING, previousIndex)) != -1) {
                        tokens.add(vobComps.substring(previousIndex, index));
                        continue;
                    }
                    tokens.add(vobComps.substring(previousIndex));
                    done = true;
                }
            } else {
                tokens.add(vobComps);
            }
        }
        return tokens;
    }

    @Override
    public void setPropertyFromClient(PropertyNameList.PropertyName<?> propertyName, Object value, boolean initialize, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Workspace.CURRENT_ACTIVITY)) {
            return;
        }
        super.setPropertyFromClient(propertyName, value, initialize, feedback);
    }

    @Override
    public void prepareToWrite(String pathname, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        String viewTag = this.getViewTag();
        cc.checkoutIgnoreExpectedFailures(viewTag, pathname, null, feedback);
        CTLocation brtypeLoc = this.location().getContextLocation(CTLocation.Kind.BRTYPE);
        cc.setCheckoutVOBList(brtypeLoc.getDisplayName(), pathname, feedback);
    }

    @Override
    public <T extends SrvcResource> void doUpdate(List<T> sourceList, SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        if (sourceList != null && !sourceList.isEmpty()) {
            HashMap<String, String> updateLabelMap = new HashMap<String, String>();
            ArrayList<String> updateLabels = new ArrayList<String>();
            for (T source : sourceList) {
                if (!(source instanceof CTBranchBaseline)) continue;
                CTBranchBaseline baseline = (CTBranchBaseline)((Object)source);
                CTLocation blLoc = baseline.location();
                String vobSelector = blLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT).getDisplayName();
                String labelSelector = blLoc.getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
                updateLabelMap.put(vobSelector, labelSelector);
                updateLabels.add(labelSelector);
            }
            if (!updateLabelMap.isEmpty()) {
                Map<String, Boolean> lockStatuses = cc.getLockStatus(updateLabels, feedback);
                ArrayList<String> unlockedLabels = new ArrayList<String>();
                for (String labelSel : lockStatuses.keySet()) {
                    boolean status = lockStatuses.get(labelSel);
                    if (status) continue;
                    unlockedLabels.add(labelSel);
                }
                if (unlockedLabels.isEmpty()) {
                    CTBranch branch = this.getBranch();
                    List<String> configSpec = branch.updateConfigSpec(updateLabelMap, feedback);
                    String[] csArray = new String[]{};
                    csArray = configSpec.toArray(csArray);
                    this.setConfigSpec(csArray, feedback);
                } else {
                    StringBuffer labels = new StringBuffer();
                    for (String labelType : unlockedLabels) {
                        labels.append(String.valueOf(labelType) + "\n");
                    }
                    String exceptionMessage = NLS.bind((String)Messages.CCaseLib_ERROR_UNLOCKED_LABELS, (Object)labels.toString());
                    throw new WvcmException(exceptionMessage, WvcmException.ReasonCode.FORBIDDEN);
                }
            }
        }
    }
}

